/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

class NameNavigator
extends KeyAdapter {
    private static final long KEY_TRESHOLD = 500L;
    ExplorerManager manager;
    private String nodeName = null;
    private long lastEvent = 0L;

    public NameNavigator(ExplorerManager manager) {
        this.manager = manager;
    }

    public void keyTyped(KeyEvent ke) {
        long eventWhen = ke.getWhen();
        if (this.lastEvent > 0L && eventWhen - this.lastEvent > 500L) {
            this.resetNameBuffer();
        }
        this.lastEvent = eventWhen;
        this.navigateBy(ke.getKeyChar());
    }

    protected void checkTimeout() {
        if (System.currentTimeMillis() - this.lastEvent > 500L) {
            this.resetNameBuffer();
        }
    }

    protected void resetNameBuffer() {
        this.nodeName = null;
    }

    public String getPartialName() {
        return this.nodeName != null ? this.nodeName : "";
    }

    public void navigateBy(char ch) {
        Node[] selNodes = this.manager.getSelectedNodes();
        Node currentContext = selNodes == null || selNodes.length == 0 ? null : selNodes[selNodes.length - 1];
        this.navigate(currentContext, ch);
    }

    public Node navigate(Node context, char ch) {
        boolean start = this.nodeName == null;
        this.nodeName = start ? new String(new char[]{ch}) : this.nodeName + ch;
        Node found = this.findNode(start, context, this.nodeName);
        return found;
    }

    protected Node findNode(boolean start, Node context, String namePrefix) {
        Node found = null;
        if (context != null) {
            if (!start) {
                found = this.findSibling(context, this.nodeName);
            }
            if (found == null) {
                this.findChild(context, namePrefix, null);
            }
        }
        if (found == null) {
            Node exclude = context;
            if (context != null) {
                context = context.getParentNode();
            }
            if (context == null) {
                context = this.manager.getExploredContext();
            }
            found = this.findChild(context, this.nodeName, exclude);
        }
        return found;
    }

    protected Node findNodeStartingWith(Node parent, Node exclude, String prefix) {
        Children children = parent.getChildren();
        if (children == null || children == Children.LEAF) {
            return null;
        }
        Node[] childNodes = children.getNodes();
        if (childNodes == null) {
            return null;
        }
        if (childNodes.length == 0) {
            return null;
        }
        int i = 0;
        while (i < childNodes.length) {
            if (this.getNodeName(childNodes[i]).startsWith(this.nodeName) && childNodes[i] != exclude) {
                return childNodes[i];
            }
            ++i;
        }
        return null;
    }

    protected String getNodeName(Node n) {
        return n.getName();
    }

    private Node findChild(Node parent, String prefix, Node exclude) {
        return this.findNodeStartingWith(parent, exclude, prefix);
    }

    private Node findSibling(Node ref, String namePrefix) {
        return this.findNodeStartingWith(ref.getParentNode(), null, namePrefix);
    }
}

