/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.ui.wizard.Util;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;

class JavaPackageIterator
implements TemplateWizard.Iterator {
    WizardDescriptor.Panel targetChooser;
    TemplateWizard wizardInstance;

    JavaPackageIterator() {
    }

    static TemplateWizard.Iterator create() {
        return new JavaPackageIterator();
    }

    public boolean hasNext() {
        return false;
    }

    public void previousPanel() {
        throw new NoSuchElementException();
    }

    public void removeChangeListener(ChangeListener l) {
    }

    public void addChangeListener(ChangeListener l) {
    }

    public String name() {
        return Util.getString("TIT_PackageName");
    }

    public void nextPanel() {
        throw new NoSuchElementException();
    }

    public boolean hasPrevious() {
        return false;
    }

    public WizardDescriptor.Panel current() {
        return this.wizardInstance.targetChooser();
    }

    public void initialize(TemplateWizard wiz) {
        this.wizardInstance = wiz;
    }

    public void uninitialize(TemplateWizard wiz) {
    }

    private void throwIllegalName(String key, String offending) throws IllegalStateException {
        String msg = MessageFormat.format(Util.getString(key), offending);
        IllegalStateException x = (IllegalStateException)ErrorManager.getDefault().annotate((Throwable)new IllegalStateException(msg), 256, null, msg, null, null);
        throw x;
    }

    public Set instantiate(TemplateWizard wiz) throws IOException {
        DataFolder fld = wiz.getTargetFolder();
        String s = fld.getPrimaryFile().getPackageNameExt('.', '.');
        if (!Util.isValidPackageName(s)) {
            this.throwIllegalName("FMTERR_InvalidPackage", s);
        }
        if ((s = wiz.getTargetName()) == null) {
            FileObject f = wiz.getTemplate().getPrimaryFile();
            s = FileUtil.findFreeFileName((FileObject)fld.getPrimaryFile(), (String)f.getName(), (String)f.getExt());
        } else if (!Util.isValidPackageName(s)) {
            this.throwIllegalName("FMTERR_InvalidPackage", s);
        }
        DataObject d = DataObject.find((FileObject)FileUtil.createFolder((FileObject)fld.getPrimaryFile(), (String)s.replace('.', '/')));
        s = d.getName();
        fld = d.getFolder();
        d = d.createFromTemplate(fld, s);
        return Collections.singleton(d);
    }
}

