/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.util.ArrayList;
import org.netbeans.modules.java.tools.InheritanceSupport;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.Type;

public class JavaWizardData {
    public static final String PROP_ORIGINAL_CLASS = "originalClass";
    public static final String PROP_TARGET_PACKAGE = "targetPackage";
    public static final String PROP_CUSTOMIZED_CLASS = "customizedClass";
    public static final String PROP_OVERRIDEN_METHODS = "overridenMethods";
    private DataObject obj;
    private ClassElement originalClass;
    private ClassElement customizedClass;
    private InheritanceSupport InheritanceSupport;
    private transient ArrayList propertyChangeListenerList;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie;

    void setTemplate(DataObject obj) {
        if (obj.equals(this.obj)) {
            return;
        }
        this.obj = obj;
        SourceCookie cookie = (SourceCookie)obj.getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = JavaWizardData.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie);
        ClassElement orig = null;
        if (cookie != null) {
            SourceElement el = cookie.getSource();
            el.prepare().waitFinished();
            ClassElement[] classes = el.getClasses();
            if (classes != null && classes.length > 0) {
                orig = classes[0];
            }
        }
        if (orig == null) {
            orig = new ClassElement();
        }
        ClassElement oldOriginal = this.originalClass;
        ClassElement oldCustomized = this.customizedClass;
        this.originalClass = orig;
        this.cloneCustomizedClass();
    }

    private void cloneCustomizedClass() {
        this.customizedClass = new ClassElement();
        this.customizedClass = (ClassElement)this.originalClass.clone();
        this.InheritanceSupport = new InheritanceSupport(this.customizedClass);
    }

    void applyChanges(ClassElement target) throws SourceException {
        if (target == null || this.customizedClass == null) {
            return;
        }
        target.setSuperclass(this.customizedClass.getSuperclass());
        target.setInterfaces(this.customizedClass.getInterfaces());
        target.setModifiers(this.customizedClass.getModifiers());
        this.copyFields(target, this.customizedClass.getFields());
        this.copyConstructors(target, this.customizedClass.getConstructors());
        this.copyMethods(target, this.customizedClass.getMethods());
    }

    Type[] getParameterTypes(ConstructorElement el) {
        MethodParameter[] params = el.getParameters();
        Type[] types = new Type[params.length];
        int i = 0;
        while (i < params.length) {
            types[i] = params[i].getType();
            ++i;
        }
        return types;
    }

    void copyConstructors(ClassElement container, ConstructorElement[] els) throws SourceException {
        int i = 0;
        while (i < els.length) {
            ConstructorElement el = els[i];
            if (container.getConstructor(this.getParameterTypes(el)) == null) {
                el.setBody("\n");
                container.addConstructor(el);
            }
            ++i;
        }
    }

    void copyMethods(ClassElement container, MethodElement[] els) throws SourceException {
        int i = 0;
        while (i < els.length) {
            MethodElement el = els[i];
            if (container.getMethod(el.getName(), this.getParameterTypes((ConstructorElement)el)) == null) {
                if ((el.getModifiers() & 0x400) == 0 && el.getBody() != null && el.getBody().length() == 0) {
                    el.setBody("\n");
                }
                container.addMethod(el);
            }
            ++i;
        }
    }

    void copyFields(ClassElement container, FieldElement[] fields) throws SourceException {
        int i = 0;
        while (i < fields.length) {
            FieldElement f = fields[i];
            if (container.getField(f.getName()) == null) {
                container.addField(f);
            }
            ++i;
        }
    }

    void setTarget(FileObject folder, String name) {
        StringBuffer fullName = new StringBuffer();
        if (!folder.isRoot()) {
            fullName.append(folder.getPackageName('.'));
            fullName.append('.');
        }
        fullName.append(name);
        try {
            this.customizedClass.setName(Identifier.create((String)fullName.toString(), (String)name));
        }
        catch (SourceException e) {
            // empty catch block
        }
    }

    public InheritanceSupport getInheritance() {
        return this.InheritanceSupport;
    }

    public ClassElement getOriginalClass() {
        return this.originalClass;
    }

    public ClassElement getCustomizedClass() {
        return this.customizedClass;
    }

    void setCustomizedClass(ClassElement cls) {
        this.customizedClass = cls;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

