/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.ui.wizard.JavaPanel;
import org.netbeans.modules.java.ui.wizard.JavaWizardData;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class JavaWizardIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = -1987345873459L;
    private transient WizardDescriptor.Panel[] panels;
    private static String[] panelNames;
    private static final int PANEL_COUNT = 5;
    private static final int METHODS_PANEL = 4;
    private static final int FIELDS_PANEL = 2;
    private static JavaWizardIterator instance;
    private transient int panelIndex = 0;
    private transient JavaWizardData myData;
    private transient TemplateWizard wizardInstance;
    private transient Dimension prefSize;
    private transient boolean initialized;
    private static ResourceBundle bundle;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie;
    static /* synthetic */ Class class$org$netbeans$modules$java$ui$wizard$ClassPanel;
    static /* synthetic */ Class class$org$netbeans$modules$java$ui$wizard$FieldsPanel;
    static /* synthetic */ Class class$org$netbeans$modules$java$ui$wizard$OverridePanel;
    static /* synthetic */ Class class$org$netbeans$modules$java$ui$wizard$MethodsPanel;
    static /* synthetic */ Class class$org$netbeans$modules$java$ui$wizard$JavaWizardIterator;

    public static synchronized JavaWizardIterator singleton() {
        if (instance == null) {
            instance = new JavaWizardIterator();
        }
        JavaWizardIterator.instance.initialized = false;
        return instance;
    }

    public Set instantiate(TemplateWizard wiz) throws IOException, IllegalArgumentException {
        if (!this.initialized) {
            this.initializeTemplateData(wiz.getTemplate());
            this.initializeTargetData(wiz.getTemplate(), wiz.getTargetFolder(), wiz.getTargetName());
        } else {
            this.updateTargetData(wiz.getTemplate(), wiz.getTargetFolder(), wiz.getTargetName());
        }
        DataObject obj = this.instantiateTemplate(wiz.getTemplate(), wiz.getTargetFolder());
        SourceCookie src = (SourceCookie)obj.getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = JavaWizardIterator.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie);
        if (src == null) {
            return Collections.singleton(obj);
        }
        ClassElement[] classes = src.getSource().getClasses();
        try {
            ClassElement targetClass;
            if (classes == null || classes.length == 0) {
                ClassElement el = new ClassElement();
                el.setName(this.myData.getCustomizedClass().getName());
                src.getSource().addClass(el);
                targetClass = src.getSource().getClasses()[0];
            } else {
                targetClass = classes[0];
            }
            this.myData.applyChanges(targetClass);
        }
        catch (SourceException e) {
            obj.delete();
            throw new IOException(e.getLocalizedMessage());
        }
        Node node = obj.getNodeDelegate();
        SystemAction sa = node.getDefaultAction();
        if (sa != null) {
            sa.actionPerformed(new ActionEvent(node, 1001, ""));
        }
        return Collections.singleton(obj);
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.panelIndex];
    }

    public String name() {
        return "";
    }

    public boolean hasNext() {
        return this.panelIndex < 4;
    }

    public boolean hasPrevious() {
        return this.panelIndex > 0;
    }

    public void nextPanel() {
        this.panelIndex = this.panelIndex == 2 && !this.myData.getCustomizedClass().isClassOrInterface() ? (this.panelIndex += 2) : ++this.panelIndex;
    }

    public void previousPanel() {
        this.panelIndex = this.panelIndex == 4 && !this.myData.getCustomizedClass().isClassOrInterface() ? (this.panelIndex -= 2) : --this.panelIndex;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    public void initialize(TemplateWizard wizard) {
        this.wizardInstance = wizard;
        if (this.panels == null) {
            this.myData = new JavaWizardData();
            this.initializeTemplateData(wizard.getTemplate());
            this.initialize();
            Component panel = wizard.targetChooser().getComponent();
            JavaWizardIterator.panelNames[0] = panel.getName();
            if (panel instanceof JComponent) {
                ((JComponent)panel).putClientProperty("WizardPanel_contentData", panelNames);
            }
            this.panels = new WizardDescriptor.Panel[]{this.wizardInstance.targetChooser(), new DelegatingPanel(class$org$netbeans$modules$java$ui$wizard$ClassPanel == null ? (class$org$netbeans$modules$java$ui$wizard$ClassPanel = JavaWizardIterator.class$("org.netbeans.modules.java.ui.wizard.ClassPanel")) : class$org$netbeans$modules$java$ui$wizard$ClassPanel, true), new DelegatingPanel(class$org$netbeans$modules$java$ui$wizard$FieldsPanel == null ? (class$org$netbeans$modules$java$ui$wizard$FieldsPanel = JavaWizardIterator.class$("org.netbeans.modules.java.ui.wizard.FieldsPanel")) : class$org$netbeans$modules$java$ui$wizard$FieldsPanel, false), new DelegatingPanel(class$org$netbeans$modules$java$ui$wizard$OverridePanel == null ? (class$org$netbeans$modules$java$ui$wizard$OverridePanel = JavaWizardIterator.class$("org.netbeans.modules.java.ui.wizard.OverridePanel")) : class$org$netbeans$modules$java$ui$wizard$OverridePanel, false), new DelegatingPanel(class$org$netbeans$modules$java$ui$wizard$MethodsPanel == null ? (class$org$netbeans$modules$java$ui$wizard$MethodsPanel = JavaWizardIterator.class$("org.netbeans.modules.java.ui.wizard.MethodsPanel")) : class$org$netbeans$modules$java$ui$wizard$MethodsPanel, false)};
        }
        this.reset();
    }

    public void uninitialize(TemplateWizard wiz) {
        this.panels = null;
        this.myData = null;
        this.initialized = false;
    }

    private Object readResolve() {
        this.initialize();
        this.reset();
        return this;
    }

    private DataObject instantiateTemplate(DataObject tpl, DataFolder target) throws IOException {
        String name = this.myData.getCustomizedClass().getName().getName();
        String packName = target.getPrimaryFile().getPackageNameExt('.', '.');
        this.checkValidPackageName(target);
        this.checkTargetName(target, name);
        return tpl.createFromTemplate(target, name);
    }

    protected void reset() {
        this.panelIndex = 0;
    }

    protected void initialize() {
        if (this.myData.getCustomizedClass().isClassOrInterface()) {
            panelNames = new String[5];
            JavaWizardIterator.panelNames[3] = JavaWizardIterator.getString("TIT_OverrideWizardPanel");
            JavaWizardIterator.panelNames[4] = JavaWizardIterator.getString("TIT_AddMethodsWizardPanel");
        } else {
            panelNames = new String[4];
            JavaWizardIterator.panelNames[3] = JavaWizardIterator.getString("TIT_AddMethodsWizardPanel");
        }
        JavaWizardIterator.panelNames[0] = "";
        JavaWizardIterator.panelNames[1] = JavaWizardIterator.getString("TIT_InheritanceWizardPanel");
        JavaWizardIterator.panelNames[2] = JavaWizardIterator.getString("TIT_AddFieldsWizardPanel");
    }

    private boolean isValidPackageName(String s) {
        if ("".equals(s)) {
            return true;
        }
        try {
            Type t = Type.parse((String)s);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    private void checkValidPackageName(DataFolder targetFolder) throws IllegalStateException {
        FileObject folder = targetFolder.getPrimaryFile();
        String fullTarget = folder.getPackageNameExt('.', '.');
        if (!this.isValidPackageName(fullTarget)) {
            String msg = MessageFormat.format(JavaWizardIterator.getString("FMTERR_IllegalFolderName"), folder.getPackageNameExt('/', '.'), fullTarget);
            throw (IllegalStateException)ErrorManager.getDefault().annotate((Throwable)new IllegalStateException(msg), 256, null, msg, null, null);
        }
    }

    private void checkTargetName(DataFolder folder, String desiredName) {
        if (!Utilities.isJavaIdentifier((String)desiredName)) {
            String msg = MessageFormat.format(JavaWizardIterator.getString("FMTERR_IllegalTargetName"), desiredName);
            IllegalStateException x = (IllegalStateException)ErrorManager.getDefault().annotate((Throwable)new IllegalStateException(msg), 256, null, msg, null, null);
            throw x;
        }
        FileObject f = folder.getPrimaryFile();
        if (f.getFileObject(desiredName, "java") != null) {
            String msg = MessageFormat.format(JavaWizardIterator.getString("FMTERR_TargetExists"), desiredName);
            throw new IllegalStateException(msg);
        }
    }

    private void initializeTemplateData(DataObject template) throws IllegalStateException {
        if (template == null) {
            throw new IllegalStateException("Expected template, got null");
        }
        this.myData.setTemplate(template);
    }

    private void initializeTargetData(DataObject template, DataFolder targetFolder, String desiredName) throws IllegalStateException {
        if (template == null || targetFolder == null) {
            throw new IllegalStateException("Expected template & target folder, got null(s)");
        }
        this.updateTargetData(template, targetFolder, desiredName);
        this.prefSize = this.panels[4].getComponent().getPreferredSize();
        this.initialized = true;
    }

    private void updateTargetData(DataObject template, DataFolder targetFolder, String desiredName) throws IllegalStateException {
        FileObject folder = targetFolder.getPrimaryFile();
        this.checkValidPackageName(targetFolder);
        if (desiredName == null) {
            String fullTarget = folder.getPackageNameExt('.', '.');
            desiredName = FileUtil.findFreeFileName((FileObject)folder, (String)template.getName(), (String)"java");
        } else {
            this.checkTargetName(targetFolder, desiredName);
        }
        this.myData.setTarget(folder, desiredName);
    }

    static String getString(String key) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$java$ui$wizard$JavaWizardIterator == null ? (class$org$netbeans$modules$java$ui$wizard$JavaWizardIterator = JavaWizardIterator.class$("org.netbeans.modules.java.ui.wizard.JavaWizardIterator")) : class$org$netbeans$modules$java$ui$wizard$JavaWizardIterator));
        }
        return bundle.getString(key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DelegatingPanel
    implements WizardDescriptor.Panel,
    WizardDescriptor.FinishPanel {
        private Class panelClass;
        private boolean init;
        private WizardDescriptor.Panel instance;

        DelegatingPanel(Class c, boolean initData) {
            this.panelClass = c;
            this.init = initData;
        }

        private WizardDescriptor.Panel getInstance() {
            if (this.instance != null) {
                return this.instance;
            }
            try {
                this.instance = (WizardDescriptor.Panel)this.panelClass.newInstance();
                if (this.instance instanceof JavaPanel) {
                    ((JavaPanel)this.instance).initialize(JavaWizardIterator.this.myData);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return this.instance;
        }

        public HelpCtx getHelp() {
            return this.getInstance().getHelp();
        }

        public void storeSettings(Object s) {
            this.getInstance().storeSettings(s);
        }

        public void addChangeListener(ChangeListener l) {
            this.getInstance().addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.getInstance().removeChangeListener(l);
        }

        public boolean isValid() {
            return this.getInstance().isValid();
        }

        public Component getComponent() {
            ((JComponent)this.getInstance()).setPreferredSize(JavaWizardIterator.this.prefSize);
            if (JavaWizardIterator.this.panelIndex == panelNames.length) {
                ((JComponent)this.getInstance()).putClientProperty("WizardPanel_contentSelectedIndex", new Integer(panelNames.length - 1));
            }
            return this.getInstance().getComponent();
        }

        public void readSettings(Object settings) {
            if (!this.init || !(settings instanceof TemplateWizard)) {
                return;
            }
            TemplateWizard wizardInstance = (TemplateWizard)settings;
            DataFolder target = null;
            DataObject template = null;
            try {
                target = wizardInstance.getTargetFolder();
                template = wizardInstance.getTemplate();
            }
            catch (IOException ex) {
                throw new IllegalStateException("Illegal settings");
            }
            JavaWizardIterator.this.initializeTargetData(template, target, wizardInstance.getTargetName());
            this.getInstance().readSettings(settings);
        }
    }
}

