/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.java.ui.wizard.JavaWizardIterator;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ListView;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.src.MemberElement;
import org.openide.src.SourceException;

class MemberListPanel
extends JPanel {
    private ElementCreator elementCreator;
    private ExplorerManager manager;
    private PropertyChangeListener managerListener;
    private Index indexableParent;
    private static final Node[] EMPTY_SELECTION = new Node[0];
    private ListView listView;
    protected JButton newButton;
    protected JButton duplicateButton;
    protected JButton downButton;
    protected JButton deleteButton;
    protected JButton upButton;
    static /* synthetic */ Class class$org$openide$src$MemberElement;
    static /* synthetic */ Class class$org$openide$nodes$Index;

    public MemberListPanel(ElementCreator creator) {
        this.initComponents();
        this.initAccessibility();
        this.elementCreator = creator;
        this.newButton.setMnemonic(JavaWizardIterator.getString("LBL_New_Mnemonic").charAt(0));
        this.duplicateButton.setMnemonic(JavaWizardIterator.getString("LBL_Duplicate_Mnemonic").charAt(0));
        this.deleteButton.setMnemonic(JavaWizardIterator.getString("LBL_Delete_Mnemonic").charAt(0));
        this.upButton.setMnemonic(JavaWizardIterator.getString("LBL_Up_Mnemonic").charAt(0));
        this.downButton.setMnemonic(JavaWizardIterator.getString("LBL_Down_Mnemonic").charAt(0));
        this.listView.setPopupAllowed(false);
    }

    private void initAccessibility() {
        this.listView.getAccessibleContext().setAccessibleName(JavaWizardIterator.getString("ACS_FieldListViewA11yName"));
    }

    public void requestFocus() {
        this.listView.requestFocus();
    }

    private void initComponents() {
        this.newButton = new JButton();
        this.duplicateButton = new JButton();
        this.deleteButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.listView = new ListView();
        this.setLayout(new GridBagLayout());
        this.newButton.setToolTipText(JavaWizardIterator.getString("ACS_NewFieldA11yDesc"));
        this.newButton.setText(JavaWizardIterator.getString("LBL_New"));
        this.newButton.setMargin(new Insets(2, 8, 2, 8));
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MemberListPanel.this.newButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.newButton, gridBagConstraints);
        this.duplicateButton.setToolTipText(JavaWizardIterator.getString("ACS_DuplicateFieldA11yDesc"));
        this.duplicateButton.setText(JavaWizardIterator.getString("LBL_Duplicate"));
        this.duplicateButton.setMargin(new Insets(2, 8, 2, 8));
        this.duplicateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MemberListPanel.this.duplicateButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.duplicateButton, gridBagConstraints);
        this.deleteButton.setToolTipText(JavaWizardIterator.getString("ACS_DeleteFieldA11yDesc"));
        this.deleteButton.setText(JavaWizardIterator.getString("LBL_Delete"));
        this.deleteButton.setMargin(new Insets(2, 8, 2, 8));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MemberListPanel.this.deleteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.deleteButton, gridBagConstraints);
        this.upButton.setToolTipText(JavaWizardIterator.getString("ACS_UpFieldA11yDesc"));
        this.upButton.setText(JavaWizardIterator.getString("LBL_Up"));
        this.upButton.setMargin(new Insets(2, 8, 2, 8));
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MemberListPanel.this.upButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.upButton, gridBagConstraints);
        this.downButton.setToolTipText(JavaWizardIterator.getString("ACS_DownFieldA11yDesc"));
        this.downButton.setText(JavaWizardIterator.getString("LBL_Down"));
        this.downButton.setMargin(new Insets(2, 8, 2, 8));
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MemberListPanel.this.downButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.downButton, gridBagConstraints);
        this.listView.setToolTipText(JavaWizardIterator.getString("ACS_FieldListViewA11yDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.listView, gridBagConstraints);
    }

    private void duplicateButtonActionPerformed(ActionEvent evt) {
        Node[] n = this.manager.getSelectedNodes();
        try {
            if (n.length > 0) {
                this.updateSelection(new Node[]{this.manager.getExploredContext().getChildren().findChild(this.elementCreator.duplicateElement((MemberElement)n[0].getCookie(class$org$openide$src$MemberElement == null ? (class$org$openide$src$MemberElement = MemberListPanel.class$("org.openide.src.MemberElement")) : class$org$openide$src$MemberElement)).getName().getSourceName())});
            }
        }
        catch (SourceException sourceException) {
            // empty catch block
        }
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        Node[] n = this.manager.getSelectedNodes();
        try {
            int i = 0;
            while (i < n.length) {
                MemberElement el = (MemberElement)n[i].getCookie(class$org$openide$src$MemberElement == null ? MemberListPanel.class$("org.openide.src.MemberElement") : class$org$openide$src$MemberElement);
                if (this.elementCreator.canDelete(el)) {
                    this.elementCreator.deleteElement(el);
                }
                ++i;
            }
        }
        catch (SourceException sourceException) {
            // empty catch block
        }
        this.updateSelection(EMPTY_SELECTION);
        this.updateButtons();
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        Node[] n = this.manager.getSelectedNodes();
        this.indexableParent.moveDown(this.indexableParent.indexOf(n[0]));
        this.updateSelection(EMPTY_SELECTION);
        this.updateSelection(new Node[]{n[0]});
        this.updateButtons();
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        Node[] n = this.manager.getSelectedNodes();
        this.indexableParent.moveUp(this.indexableParent.indexOf(n[0]));
        this.updateSelection(EMPTY_SELECTION);
        this.updateSelection(new Node[]{n[0]});
        this.updateButtons();
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        try {
            this.updateSelection(new Node[]{this.manager.getExploredContext().getChildren().findChild(this.elementCreator.createElement().getName().getSourceName())});
        }
        catch (SourceException sourceException) {
            // empty catch block
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.manager == null) {
            this.manager = ExplorerManager.find((Component)this);
        }
        if (this.managerListener == null) {
            this.managerListener = new PropertyChangeListener(){
                static /* synthetic */ Class class$org$openide$nodes$Index;

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("selectedNodes".equals(evt.getPropertyName())) {
                        MemberListPanel.this.updateButtons();
                    }
                    if ("exploredContext".equals(evt.getPropertyName())) {
                        MemberListPanel.this.indexableParent = (Index)((Node)evt.getNewValue()).getCookie(6.class$org$openide$nodes$Index == null ? (6.class$org$openide$nodes$Index = 6.class$("org.openide.nodes.Index")) : 6.class$org$openide$nodes$Index);
                        MemberListPanel.this.updateButtons();
                    }
                }

                static /* synthetic */ Class class$(String x0) {
                    try {
                        return Class.forName(x0);
                    }
                    catch (ClassNotFoundException x1) {
                        throw new NoClassDefFoundError(x1.getMessage());
                    }
                }
            };
        }
        this.manager.addPropertyChangeListener(this.managerListener);
        Node n = this.manager.getExploredContext();
        if (n != null) {
            this.indexableParent = (Index)n.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = MemberListPanel.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index);
        }
        this.updateButtons();
    }

    public void removeNotify() {
        super.removeNotify();
        this.manager.removePropertyChangeListener(this.managerListener);
    }

    private void updateSelection(final Node[] node) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    MemberListPanel.this.manager.setSelectedNodes(node);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        });
    }

    private void updateButtons() {
        boolean singleSel;
        ExplorerManager m = this.manager;
        Node[] nodes = m.getSelectedNodes();
        boolean bl = singleSel = nodes.length == 1;
        if (this.indexableParent != null && singleSel) {
            this.upButton.setEnabled(!this.isFirst(nodes[0]));
            this.downButton.setEnabled(!this.isLast(nodes[0]));
        } else {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
        boolean canRemove = false;
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i].canDestroy() && this.elementCreator.canDelete((MemberElement)nodes[i].getCookie(class$org$openide$src$MemberElement == null ? MemberListPanel.class$("org.openide.src.MemberElement") : class$org$openide$src$MemberElement))) {
                canRemove = true;
                break;
            }
            ++i;
        }
        this.deleteButton.setEnabled(canRemove);
        this.duplicateButton.setEnabled(singleSel);
    }

    protected boolean isFirst(Node n) {
        return this.indexableParent.indexOf(n) == 0;
    }

    protected boolean isLast(Node n) {
        return this.indexableParent.indexOf(n) == this.indexableParent.getNodesCount() - 1;
    }

    protected void removeNode(Node n) {
        try {
            n.destroy();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void createNewNode(Node parent) {
        try {
            parent.getNewTypes()[0].create();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static interface ElementCreator {
        public MemberElement createElement() throws SourceException;

        public MemberElement duplicateElement(MemberElement var1) throws SourceException;

        public void deleteElement(MemberElement var1) throws SourceException;

        public boolean canDelete(MemberElement var1);
    }
}

