/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.ui.wizard.AccessLevelPanel;
import org.netbeans.modules.java.ui.wizard.JavaWizardIterator;
import org.netbeans.modules.java.ui.wizard.MethodTypePanel;
import org.netbeans.modules.java.ui.wizard.ModifierEditor;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.DefaultPropertyModel;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.SourceException;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;

public class MethodCustomizer
extends JPanel
implements Runnable {
    private static final MethodElement EMPTY_ELEMENT = new MethodElement();
    private MethodElement method;
    private JLabel nameLabel;
    private JTextField nameField;
    private JLabel exceptionsLabel;
    private JPanel leftPanel;
    private JLabel returnTypeLabel;
    private JLabel parametersLabel;
    private PropertyPanel modifPanel;
    private PropertyPanel paramPanel;
    private PropertyPanel typePanel;
    private PropertyPanel exceptPanel;

    public MethodCustomizer(MethodElement method) {
        this.method = method != null ? method : EMPTY_ELEMENT;
        this.initComponents();
        this.nameField.setText(this.method.getName().toString());
        this.typePanel = new PropertyPanel((Object)this.method, "return", 4);
        this.returnTypeLabel.setLabelFor((Component)this.typePanel);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(0, 0, 11, 0);
        gridBagConstraints1.weightx = 1.0;
        this.leftPanel.add((Component)this.typePanel, gridBagConstraints1);
        this.paramPanel = new PropertyPanel((Object)this.method, "parameters", 4);
        this.parametersLabel.setLabelFor((Component)this.paramPanel);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(0, 0, 11, 0);
        gridBagConstraints1.weightx = 1.0;
        this.leftPanel.add((Component)this.paramPanel, gridBagConstraints1);
        this.exceptPanel = new PropertyPanel((Object)this.method, "exceptions", 4);
        this.exceptionsLabel.setLabelFor((Component)this.exceptPanel);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 7;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints1.weightx = 1.0;
        this.leftPanel.add((Component)this.exceptPanel, gridBagConstraints1);
        this.modifPanel = new PropertyPanel((PropertyModel)new TempPropertyModel(this.method, "modifiers"), 2);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.gridheight = 1;
        gridBagConstraints1.fill = 1;
        this.add((Component)this.modifPanel, gridBagConstraints1);
        this.nameLabel.setDisplayedMnemonic(JavaWizardIterator.getString("LBL_Method_Name_Mnemonic").charAt(0));
        this.exceptionsLabel.setDisplayedMnemonic(JavaWizardIterator.getString("LBL_Exceptions_Mnemonic").charAt(0));
        this.parametersLabel.setDisplayedMnemonic(JavaWizardIterator.getString("LBL_Parameters_Mnemonic").charAt(0));
        this.returnTypeLabel.setDisplayedMnemonic(JavaWizardIterator.getString("LBL_Return_Type_Mnemonic").charAt(0));
        this.initAccessibility();
    }

    private void initAccessibility() {
        this.nameLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_MethodNameA11yDesc"));
        this.nameField.getAccessibleContext().setAccessibleName(JavaWizardIterator.getString("ACS_MethodNameTextFieldA11yName"));
        this.exceptionsLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_Return_TypeA11yDesc"));
        this.parametersLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_ParametersA11yDesc"));
        this.returnTypeLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_ExceptionsA11yDesc"));
    }

    private void initComponents() {
        this.leftPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.returnTypeLabel = new JLabel();
        this.parametersLabel = new JLabel();
        this.exceptionsLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.leftPanel.setLayout(new GridBagLayout());
        this.nameLabel.setText(JavaWizardIterator.getString("LBL_Name"));
        this.nameLabel.setLabelFor(this.nameField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.leftPanel.add((Component)this.nameLabel, gridBagConstraints);
        this.nameField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MethodCustomizer.this.nameFieldActionPerformed(evt);
            }
        });
        this.nameField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                MethodCustomizer.this.nameFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.leftPanel.add((Component)this.nameField, gridBagConstraints);
        this.returnTypeLabel.setText(JavaWizardIterator.getString("LBL_Return_Type"));
        this.returnTypeLabel.setLabelFor((Component)this.typePanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.leftPanel.add((Component)this.returnTypeLabel, gridBagConstraints);
        this.parametersLabel.setText(JavaWizardIterator.getString("LBL_Parameters"));
        this.parametersLabel.setLabelFor((Component)this.paramPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.leftPanel.add((Component)this.parametersLabel, gridBagConstraints);
        this.exceptionsLabel.setText(JavaWizardIterator.getString("LBL_Exceptions"));
        this.exceptionsLabel.setLabelFor((Component)this.exceptPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.leftPanel.add((Component)this.exceptionsLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        this.add((Component)this.leftPanel, gridBagConstraints);
    }

    private void nameFieldActionPerformed(ActionEvent evt) {
        this.changeName();
    }

    private void nameFieldFocusLost(FocusEvent evt) {
        if (!evt.isTemporary()) {
            this.changeName();
        }
    }

    private void changeName() {
        if (this.method == EMPTY_ELEMENT) {
            return;
        }
        String newName = this.nameField.getText();
        String oldName = this.method.getName().toString();
        Throwable x = null;
        boolean ok = false;
        if (Utilities.isJavaIdentifier((String)newName)) {
            if (!oldName.equals(newName)) {
                Identifier id = Identifier.create((String)newName);
                try {
                    this.method.setName(id);
                    ok = true;
                }
                catch (SourceException e) {
                    x = e;
                }
            }
        } else {
            x = new IllegalArgumentException("Invalid name");
            ErrorManager.getDefault().annotate(x, 256, null, JavaWizardIterator.getString("MSG_Not_Valid_Identifier"), null, null);
        }
        if (x != null) {
            ErrorManager.getDefault().notify(x);
        }
        if (!ok) {
            this.nameField.setText(oldName);
        }
    }

    public void setEnabled(boolean enable) {
        this.nameField.setEnabled(enable);
        this.modifPanel.setEnabled(enable);
        this.paramPanel.setEnabled(enable);
        this.typePanel.setEnabled(enable);
        this.exceptPanel.setEnabled(enable);
        super.setEnabled(enable);
    }

    public void setObject(MethodElement method) {
        this.method = method != null ? method : EMPTY_ELEMENT;
        this.resetPanels();
        this.revalidate();
    }

    private void resetPanels() {
        this.nameField.setText(this.method.getName().toString());
        this.typePanel.setModel((PropertyModel)new DefaultPropertyModel((Object)this.method, "return"));
        this.paramPanel.setModel((PropertyModel)new DefaultPropertyModel((Object)this.method, "parameters"));
        this.paramPanel.setChangeImmediate(false);
        this.exceptPanel.setModel((PropertyModel)new DefaultPropertyModel((Object)this.method, "exceptions"));
        this.exceptPanel.setChangeImmediate(false);
        this.modifPanel.setModel((PropertyModel)new TempPropertyModel(this.method, "modifiers"));
    }

    public void addNotify() {
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
    }

    void requestNameFocus() {
        int len = this.nameField.getText().length();
        this.nameField.setCaretPosition(0);
        this.nameField.moveCaretPosition(len);
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        this.nameField.requestFocus();
    }

    public HelpCtx getHelp() {
        return null;
    }

    public void readSettings(Object settings) {
    }

    public void storeSettings(Object settings) {
    }

    public boolean isValid() {
        return true;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    public Component getComponent() {
        return this;
    }

    public static class MethodModifierEditor
    extends ModifierEditor {
        public MethodModifierEditor() {
            super(new AccessLevelPanel(7, 0), new MethodTypePanel());
        }
    }

    static class TempPropertyModel
    extends DefaultPropertyModel {
        static /* synthetic */ Class class$org$netbeans$modules$java$ui$wizard$MethodCustomizer$MethodModifierEditor;

        public TempPropertyModel(Object bean, String propertyName) throws IllegalArgumentException {
            super(bean, propertyName);
        }

        public Class getPropertyEditorClass() {
            return class$org$netbeans$modules$java$ui$wizard$MethodCustomizer$MethodModifierEditor == null ? (class$org$netbeans$modules$java$ui$wizard$MethodCustomizer$MethodModifierEditor = TempPropertyModel.class$("org.netbeans.modules.java.ui.wizard.MethodCustomizer$MethodModifierEditor")) : class$org$netbeans$modules$java$ui$wizard$MethodCustomizer$MethodModifierEditor;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

