/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.Action;
import org.gjt.jclasslib.browser.BrowserComponent;
import org.gjt.jclasslib.browser.BrowserMDIFrame;
import org.gjt.jclasslib.browser.BrowserServices;
import org.gjt.jclasslib.browser.config.classpath.FindResult;
import org.gjt.jclasslib.browser.config.window.BrowserPath;
import org.gjt.jclasslib.browser.config.window.WindowState;
import org.gjt.jclasslib.io.ClassFileReader;
import org.gjt.jclasslib.mdi.BasicDesktopManager;
import org.gjt.jclasslib.mdi.BasicInternalFrame;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.util.GUIHelper;

public class BrowserInternalFrame
extends BasicInternalFrame
implements BrowserServices {
    public static final Class[] CONSTRUCTOR_ARGUMENTS = new Class[]{class$org$gjt$jclasslib$mdi$BasicDesktopManager == null ? (class$org$gjt$jclasslib$mdi$BasicDesktopManager = BrowserInternalFrame.class$("org.gjt.jclasslib.mdi.BasicDesktopManager")) : class$org$gjt$jclasslib$mdi$BasicDesktopManager, class$org$gjt$jclasslib$browser$config$window$WindowState == null ? (class$org$gjt$jclasslib$browser$config$window$WindowState = BrowserInternalFrame.class$("org.gjt.jclasslib.browser.config.window.WindowState")) : class$org$gjt$jclasslib$browser$config$window$WindowState};
    private String fileName;
    private ClassFile classFile;
    private BrowserComponent browserComponent;
    static /* synthetic */ Class class$org$gjt$jclasslib$mdi$BasicDesktopManager;
    static /* synthetic */ Class class$org$gjt$jclasslib$browser$config$window$WindowState;

    public BrowserInternalFrame(BasicDesktopManager basicDesktopManager, WindowState windowState) {
        super(basicDesktopManager, windowState.getFileName());
        this.fileName = windowState.getFileName();
        this.setFrameIcon(BrowserMDIFrame.ICON_APPLICATION);
        this.readClassFile();
        this.setupInternalFrame(windowState.getBrowserPath());
    }

    public Object getInitParam() {
        WindowState windowState = new WindowState(this.fileName, this.browserComponent.getBrowserPath());
        return windowState;
    }

    public ClassFile getClassFile() {
        return this.classFile;
    }

    public void activate() {
        this.desktopManager.getDesktopPane().setSelectedFrame(this);
    }

    public BrowserComponent getBrowserComponent() {
        return this.browserComponent;
    }

    public Action getActionBackward() {
        return this.getParentFrame().getActionBackward();
    }

    public Action getActionForward() {
        return this.getParentFrame().getActionForward();
    }

    public void openClassFile(String string, BrowserPath browserPath) {
        FindResult findResult = this.getParentFrame().getConfig().findClass(string);
        while (findResult == null) {
            int n = GUIHelper.showOptionDialog(this.getParentFrame(), "The class " + string + " could not be found.\n" + "You can check your classpath configuration and try again.", new String[]{"Setup classpath", "Cancel"}, 2);
            if (n == 0) {
                this.getParentFrame().getActionSetupClasspath().actionPerformed(new ActionEvent(this, 0, null));
                findResult = this.getParentFrame().getConfig().findClass(string);
                continue;
            }
            return;
        }
        BrowserInternalFrame browserInternalFrame = (BrowserInternalFrame)this.desktopManager.getOpenFrame(new WindowState(findResult.getFileName()));
        if (browserInternalFrame != null) {
            try {
                browserInternalFrame.setSelected(true);
                browserInternalFrame.browserComponent.setBrowserPath(browserPath);
                this.desktopManager.scrollToVisible(browserInternalFrame);
            }
            catch (PropertyVetoException propertyVetoException) {}
        } else {
            WindowState windowState = new WindowState(findResult.getFileName(), browserPath);
            browserInternalFrame = new BrowserInternalFrame(this.desktopManager, windowState);
            if (this.isMaximum()) {
                try {
                    browserInternalFrame.setMaximum(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else {
                this.desktopManager.scrollToVisible(browserInternalFrame);
            }
        }
    }

    public boolean canOpenClassFiles() {
        return true;
    }

    public void showURL(String string) {
        GUIHelper.showURL(string);
    }

    public void reload() {
        this.readClassFile();
        this.browserComponent.rebuild();
    }

    public String getFileName() {
        return this.fileName;
    }

    private void setupInternalFrame(BrowserPath browserPath) {
        this.setTitle(this.fileName);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.browserComponent = new BrowserComponent(this);
        container.add((Component)this.browserComponent, "Center");
        this.setupInternalFrame();
        this.browserComponent.setBrowserPath(browserPath);
    }

    private BrowserMDIFrame getParentFrame() {
        return (BrowserMDIFrame)this.desktopManager.getParentFrame();
    }

    private void readClassFile() {
        try {
            int n = this.fileName.indexOf(33);
            if (n > -1) {
                String string;
                String string2 = this.fileName.substring(0, n);
                JarFile jarFile = new JarFile(string2);
                JarEntry jarEntry = jarFile.getJarEntry(string = this.fileName.substring(n + 1));
                if (jarEntry != null) {
                    this.classFile = ClassFileReader.readFromInputStream(jarFile.getInputStream(jarEntry));
                }
            } else {
                this.classFile = ClassFileReader.readFromFile(new File(this.fileName));
            }
        }
        catch (InvalidByteCodeException invalidByteCodeException) {
            invalidByteCodeException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

