/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gjt.jclasslib.browser.BrowserServices;
import org.gjt.jclasslib.browser.BrowserTreeNode;
import org.gjt.jclasslib.structures.AbstractStructureWithAttributes;
import org.gjt.jclasslib.structures.AttributeInfo;
import org.gjt.jclasslib.structures.CPInfo;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.ClassMember;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.MethodInfo;
import org.gjt.jclasslib.structures.attributes.AnnotationDefaultAttribute;
import org.gjt.jclasslib.structures.attributes.CodeAttribute;
import org.gjt.jclasslib.structures.attributes.RuntimeAnnotationsAttribute;
import org.gjt.jclasslib.structures.constants.ConstantLargeNumeric;
import org.gjt.jclasslib.structures.elementvalues.AnnotationElementValue;
import org.gjt.jclasslib.structures.elementvalues.ArrayElementValue;
import org.gjt.jclasslib.structures.elementvalues.ElementValue;
import org.gjt.jclasslib.structures.elementvalues.ElementValuePair;

public class BrowserTreePane
extends JPanel {
    private static final Dimension treeMinimumSize = new Dimension(100, 150);
    private static final Dimension treePreferredSize = new Dimension(250, 150);
    private BrowserServices services;
    private JTree tree;
    private Map categoryToPath = new HashMap();

    public BrowserTreePane(BrowserServices browserServices) {
        this.services = browserServices;
        this.setLayout(new BorderLayout());
        this.setupComponent();
    }

    public JTree getTree() {
        return this.tree;
    }

    public TreePath getPathForCategory(String string) {
        return (TreePath)this.categoryToPath.get(string);
    }

    public void showMethod(String string, String string2) {
        TreePath treePath = (TreePath)this.categoryToPath.get("method");
        if (treePath == null) {
            return;
        }
        MethodInfo[] methodInfoArray = this.services.getClassFile().getMethods();
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            BrowserTreeNode browserTreeNode = (BrowserTreeNode)treeNode.getChildAt(i);
            MethodInfo methodInfo = methodInfoArray[browserTreeNode.getIndex()];
            try {
                if (!methodInfo.getName().equals(string) || !methodInfo.getDescriptor().equals(string2)) continue;
                TreePath treePath2 = treePath.pathByAddingChild(browserTreeNode);
                BrowserTreeNode browserTreeNode2 = this.findCodeNode(browserTreeNode, methodInfo);
                if (browserTreeNode2 != null) {
                    treePath2 = treePath2.pathByAddingChild(browserTreeNode2);
                }
                this.tree.makeVisible(treePath2);
                this.tree.scrollPathToVisible(treePath2);
                this.tree.setSelectionPath(treePath2);
                return;
            }
            catch (InvalidByteCodeException invalidByteCodeException) {
                // empty catch block
            }
        }
    }

    public void rebuild() {
        this.categoryToPath.clear();
        this.tree.clearSelection();
        this.tree.setModel(this.buildTreeModel());
    }

    private void setupComponent() {
        JScrollPane jScrollPane = new JScrollPane(this.buildTree());
        jScrollPane.setMinimumSize(treeMinimumSize);
        jScrollPane.setPreferredSize(treePreferredSize);
        this.add((Component)jScrollPane, "Center");
    }

    private JTree buildTree() {
        this.tree = new JTree(this.buildTreeModel());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        return this.tree;
    }

    private TreeModel buildTreeModel() {
        BrowserTreeNode browserTreeNode = this.buildRootNode();
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(browserTreeNode);
        return defaultTreeModel;
    }

    private BrowserTreeNode buildRootNode() {
        BrowserTreeNode browserTreeNode = new BrowserTreeNode("Class file");
        ClassFile classFile = this.services.getClassFile();
        if (classFile != null) {
            BrowserTreeNode browserTreeNode2 = new BrowserTreeNode("General Information", "general");
            BrowserTreeNode browserTreeNode3 = this.buildConstantPoolNode();
            BrowserTreeNode browserTreeNode4 = this.buildInterfacesNode();
            BrowserTreeNode browserTreeNode5 = this.buildFieldsNode();
            BrowserTreeNode browserTreeNode6 = this.buildMethodsNode();
            BrowserTreeNode browserTreeNode7 = this.buildAttributesNode();
            browserTreeNode.add(browserTreeNode2);
            browserTreeNode.add(browserTreeNode3);
            browserTreeNode.add(browserTreeNode4);
            browserTreeNode.add(browserTreeNode5);
            browserTreeNode.add(browserTreeNode6);
            browserTreeNode.add(browserTreeNode7);
            this.categoryToPath.put("general", new TreePath(new Object[]{browserTreeNode, browserTreeNode2}));
            this.categoryToPath.put("constantPool", new TreePath(new Object[]{browserTreeNode, browserTreeNode3}));
            this.categoryToPath.put("interface", new TreePath(new Object[]{browserTreeNode, browserTreeNode4}));
            this.categoryToPath.put("field", new TreePath(new Object[]{browserTreeNode, browserTreeNode5}));
            this.categoryToPath.put("method", new TreePath(new Object[]{browserTreeNode, browserTreeNode6}));
            this.categoryToPath.put("attribute", new TreePath(new Object[]{browserTreeNode, browserTreeNode7}));
        }
        return browserTreeNode;
    }

    private BrowserTreeNode buildConstantPoolNode() {
        BrowserTreeNode browserTreeNode = new BrowserTreeNode("Constant Pool");
        CPInfo[] cPInfoArray = this.services.getClassFile().getConstantPool();
        int n = cPInfoArray.length;
        for (int i = 1; i < n; ++i) {
            i += this.addConstantPoolEntry(cPInfoArray[i], i, n, browserTreeNode);
        }
        return browserTreeNode;
    }

    private int addConstantPoolEntry(CPInfo cPInfo, int n, int n2, BrowserTreeNode browserTreeNode) {
        if (cPInfo == null) {
            browserTreeNode.add(this.buildNullNode());
        } else {
            BrowserTreeNode browserTreeNode2 = new BrowserTreeNode(this.getFormattedIndex(n, n2) + cPInfo.getTagVerbose(), "constantPool", n);
            browserTreeNode.add(browserTreeNode2);
            if (cPInfo instanceof ConstantLargeNumeric) {
                this.addConstantPoolContinuedEntry(n + 1, n2, browserTreeNode);
                return 1;
            }
        }
        return 0;
    }

    private void addConstantPoolContinuedEntry(int n, int n2, BrowserTreeNode browserTreeNode) {
        BrowserTreeNode browserTreeNode2 = new BrowserTreeNode(this.getFormattedIndex(n, n2) + "(large numeric continued)", "noContent");
        browserTreeNode.add(browserTreeNode2);
    }

    private BrowserTreeNode buildInterfacesNode() {
        BrowserTreeNode browserTreeNode = new BrowserTreeNode("Interfaces");
        int[] nArray = this.services.getClassFile().getInterfaces();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            BrowserTreeNode browserTreeNode2 = new BrowserTreeNode("Interface " + i, "interface", i);
            browserTreeNode.add(browserTreeNode2);
        }
        return browserTreeNode;
    }

    private BrowserTreeNode buildFieldsNode() {
        return this.buildClassMembersNode("Fields", "fields", "field", this.services.getClassFile().getFields());
    }

    private BrowserTreeNode buildMethodsNode() {
        return this.buildClassMembersNode("Methods", "methods", "method", this.services.getClassFile().getMethods());
    }

    private BrowserTreeNode buildClassMembersNode(String string, String string2, String string3, ClassMember[] classMemberArray) {
        BrowserTreeNode browserTreeNode = new BrowserTreeNode(string, string2);
        int n = classMemberArray.length;
        for (int i = 0; i < n; ++i) {
            this.addClassMembersNode(classMemberArray[i], i, n, string3, browserTreeNode);
        }
        return browserTreeNode;
    }

    private void addClassMembersNode(ClassMember classMember, int n, int n2, String string, BrowserTreeNode browserTreeNode) {
        if (classMember == null) {
            browserTreeNode.add(this.buildNullNode());
        } else {
            try {
                BrowserTreeNode browserTreeNode2 = new BrowserTreeNode(this.getFormattedIndex(n, n2) + classMember.getName(), string, n);
                browserTreeNode.add(browserTreeNode2);
                this.addAttributeNodes(browserTreeNode2, classMember);
            }
            catch (InvalidByteCodeException invalidByteCodeException) {
                browserTreeNode.add(this.buildNullNode());
            }
        }
    }

    private BrowserTreeNode buildAttributesNode() {
        BrowserTreeNode browserTreeNode = new BrowserTreeNode("Attributes");
        this.addAttributeNodes(browserTreeNode, this.services.getClassFile());
        return browserTreeNode;
    }

    private BrowserTreeNode buildNullNode() {
        return new BrowserTreeNode("[error] null");
    }

    private void addAttributeNodes(BrowserTreeNode browserTreeNode, AbstractStructureWithAttributes abstractStructureWithAttributes) {
        AttributeInfo[] attributeInfoArray = abstractStructureWithAttributes.getAttributes();
        if (attributeInfoArray == null) {
            return;
        }
        int n = attributeInfoArray.length;
        for (int i = 0; i < n; ++i) {
            this.addSingleAttributeNode(attributeInfoArray[i], i, n, browserTreeNode);
        }
    }

    private void addSingleAttributeNode(AttributeInfo attributeInfo, int n, int n2, BrowserTreeNode browserTreeNode) {
        if (attributeInfo == null) {
            browserTreeNode.add(this.buildNullNode());
        } else {
            try {
                BrowserTreeNode browserTreeNode2 = new BrowserTreeNode(this.getFormattedIndex(n, n2) + attributeInfo.getName(), "attribute", n);
                browserTreeNode.add(browserTreeNode2);
                if (attributeInfo instanceof RuntimeAnnotationsAttribute) {
                    this.addRuntimeAnnotation(browserTreeNode2, (RuntimeAnnotationsAttribute)attributeInfo);
                } else if (attributeInfo instanceof AnnotationDefaultAttribute) {
                    this.addSingleElementValueEntryNode(((AnnotationDefaultAttribute)attributeInfo).getDefaultValue(), 0, 1, browserTreeNode2);
                } else {
                    this.addAttributeNodes(browserTreeNode2, attributeInfo);
                }
            }
            catch (InvalidByteCodeException invalidByteCodeException) {
                browserTreeNode.add(this.buildNullNode());
            }
        }
    }

    private String getFormattedIndex(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer("[");
        String string = String.valueOf(n);
        String string2 = String.valueOf(n2 - 1);
        for (int i = 0; i < string2.length() - string.length(); ++i) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string);
        stringBuffer.append("]");
        stringBuffer.append(" ");
        return stringBuffer.toString();
    }

    private BrowserTreeNode findCodeNode(BrowserTreeNode browserTreeNode, MethodInfo methodInfo) {
        AttributeInfo[] attributeInfoArray = methodInfo.getAttributes();
        for (int i = 0; i < attributeInfoArray.length; ++i) {
            if (!(attributeInfoArray[i] instanceof CodeAttribute)) continue;
            return (BrowserTreeNode)browserTreeNode.getChildAt(i);
        }
        return null;
    }

    private void addRuntimeAnnotation(BrowserTreeNode browserTreeNode, RuntimeAnnotationsAttribute runtimeAnnotationsAttribute) {
        AnnotationElementValue[] annotationElementValueArray = runtimeAnnotationsAttribute.getRuntimeAnnotations();
        if (annotationElementValueArray == null) {
            return;
        }
        int n = annotationElementValueArray.length;
        for (int i = 0; i < n; ++i) {
            this.addSingleAnnotationNode(annotationElementValueArray[i], i, n, browserTreeNode);
        }
    }

    private void addSingleAnnotationNode(AnnotationElementValue annotationElementValue, int n, int n2, BrowserTreeNode browserTreeNode) {
        if (annotationElementValue == null) {
            browserTreeNode.add(this.buildNullNode());
        } else {
            BrowserTreeNode browserTreeNode2 = new BrowserTreeNode(this.getFormattedIndex(n, n2) + annotationElementValue.getEntryName(), "annotation", n, annotationElementValue);
            browserTreeNode.add(browserTreeNode2);
            this.addElementValuePairEntry(browserTreeNode2, annotationElementValue);
        }
    }

    private void addElementValuePairEntry(BrowserTreeNode browserTreeNode, AnnotationElementValue annotationElementValue) {
        ElementValuePair[] elementValuePairArray = annotationElementValue.getElementValuePairEntries();
        if (elementValuePairArray == null) {
            return;
        }
        int n = elementValuePairArray.length;
        for (int i = 0; i < n; ++i) {
            this.addSingleElementValuePairEntryNode(elementValuePairArray[i], i, n, browserTreeNode);
        }
    }

    private void addArrayElementValueEntry(BrowserTreeNode browserTreeNode, ArrayElementValue arrayElementValue) {
        ElementValue[] elementValueArray = arrayElementValue.getElementValueEntries();
        if (elementValueArray == null) {
            return;
        }
        int n = elementValueArray.length;
        for (int i = 0; i < n; ++i) {
            this.addSingleElementValueEntryNode(elementValueArray[i], i, n, browserTreeNode);
        }
    }

    private void addSingleElementValuePairEntryNode(ElementValuePair elementValuePair, int n, int n2, BrowserTreeNode browserTreeNode) {
        if (elementValuePair == null) {
            browserTreeNode.add(this.buildNullNode());
        } else {
            BrowserTreeNode browserTreeNode2 = new BrowserTreeNode(this.getFormattedIndex(n, n2) + elementValuePair.getEntryName(), "elementvaluepair", n, elementValuePair);
            browserTreeNode.add(browserTreeNode2);
            this.addSingleElementValueEntryNode(elementValuePair.getElementValue(), 0, 1, browserTreeNode2);
        }
    }

    private void addSingleElementValueEntryNode(ElementValue elementValue, int n, int n2, BrowserTreeNode browserTreeNode) {
        if (elementValue == null) {
            browserTreeNode.add(this.buildNullNode());
        } else {
            String string = n2 > 1 ? this.getFormattedIndex(n, n2) : "";
            String string2 = "elementvalue";
            if (elementValue instanceof AnnotationElementValue) {
                string2 = "annotation";
            } else if (elementValue instanceof ArrayElementValue) {
                string2 = "arrayelementvalue";
            }
            BrowserTreeNode browserTreeNode2 = new BrowserTreeNode(string + elementValue.getEntryName(), string2, n, elementValue);
            browserTreeNode.add(browserTreeNode2);
            if (string2 == "annotation") {
                this.addElementValuePairEntry(browserTreeNode2, (AnnotationElementValue)elementValue);
            } else if (string2 == "arrayelementvalue") {
                this.addArrayElementValueEntry(browserTreeNode2, (ArrayElementValue)elementValue);
            }
        }
    }
}

