/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser.detail;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.tree.TreePath;
import org.gjt.jclasslib.browser.BrowserServices;
import org.gjt.jclasslib.browser.detail.FixedListDetailPane;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.ClassMember;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.util.ExtendedJLabel;
import org.gjt.jclasslib.util.GUIHelper;

public class ClassMemberContainerDetailPane
extends FixedListDetailPane {
    public static final int FIELDS = 1;
    public static final int METHODS = 2;
    private ExtendedJLabel lblMemberCount;
    private int mode;
    private JButton btnCopyToClipboard;

    public ClassMemberContainerDetailPane(BrowserServices browserServices, int n) {
        super(browserServices);
        this.mode = n;
    }

    protected void setupLabels() {
        this.lblMemberCount = this.highlightLabel();
        this.addDetailPaneEntry(this.normalLabel("Member count:"), this.lblMemberCount);
    }

    protected int addSpecial(int n) {
        this.btnCopyToClipboard = new JButton("Copy signatures to clipboard");
        this.btnCopyToClipboard.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassMemberContainerDetailPane.this.copySignaturesToClipboard();
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        this.add((Component)this.btnCopyToClipboard, gridBagConstraints);
        return 1;
    }

    private void copySignaturesToClipboard() {
        ClassFile classFile = this.services.getClassFile();
        ClassMember[] classMemberArray = this.mode == 1 ? classFile.getFields() : classFile.getMethods();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < classMemberArray.length; ++i) {
            ClassMember classMember = classMemberArray[i];
            try {
                if (this.mode == 1) {
                    stringBuffer.append(classMember.getDescriptor());
                    stringBuffer.append(' ');
                    stringBuffer.append(classMember.getName());
                } else {
                    stringBuffer.append(classMember.getName());
                    stringBuffer.append(classMember.getDescriptor());
                }
            }
            catch (InvalidByteCodeException invalidByteCodeException) {
                // empty catch block
            }
            stringBuffer.append('\n');
        }
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
        GUIHelper.showMessage(this, "The output has been copied to the clipboard", 1);
    }

    public void show(TreePath treePath) {
        ClassFile classFile = this.services.getClassFile();
        int n = this.mode == 1 ? classFile.getFields().length : classFile.getMethods().length;
        this.lblMemberCount.setText(n);
        super.show(treePath);
    }
}

