/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser.detail.attributes.code;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;
import org.gjt.jclasslib.browser.AbstractDetailPane;
import org.gjt.jclasslib.browser.BrowserComponent;
import org.gjt.jclasslib.browser.BrowserServices;
import org.gjt.jclasslib.browser.detail.attributes.code.ByteCodeDisplay;
import org.gjt.jclasslib.browser.detail.attributes.code.CounterDisplay;
import org.gjt.jclasslib.bytecode.AbstractInstruction;
import org.gjt.jclasslib.bytecode.OpcodesUtil;
import org.gjt.jclasslib.structures.attributes.CodeAttribute;

public class ByteCodeDetailPane
extends AbstractDetailPane {
    private static final Rectangle RECT_ORIGIN = new Rectangle(0, 0, 0, 0);
    private final Map instructionURL = new HashMap();
    private ByteCodeDisplay byteCodeDisplay;
    private CounterDisplay counterDisplay;
    private JScrollPane scrollPane;
    private JComboBox instructions;
    private JButton btnCopy;

    public ByteCodeDetailPane(BrowserServices browserServices) {
        super(browserServices);
    }

    protected void setupComponent() {
        this.setLayout(new BorderLayout());
        this.btnCopy = new JButton("Copy to clipboard");
        this.btnCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ByteCodeDetailPane.this.byteCodeDisplay.copyToClipboard();
            }
        });
        Box box = Box.createHorizontalBox();
        box.add(this.buildInstructionPanel());
        box.add(Box.createHorizontalGlue());
        box.add(this.btnCopy);
        this.add((Component)box, "South");
        this.add((Component)this.buildByteCodeScrollPane(), "Center");
        DocumentLinkListener documentLinkListener = new DocumentLinkListener(this.byteCodeDisplay);
        this.byteCodeDisplay.addMouseListener(documentLinkListener);
        this.byteCodeDisplay.addMouseMotionListener(documentLinkListener);
    }

    private JPanel buildInstructionPanel() {
        this.instructions = new JComboBox();
        JPanel jPanel = new JPanel(new FlowLayout(0, 6, 0));
        jPanel.add(new JLabel("Used instructions:"));
        jPanel.add((Component)this.instructions, "Center");
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)ByteCodeDetailPane.this.instructions.getSelectedItem();
                if (string != null) {
                    ByteCodeDetailPane.this.services.showURL((String)ByteCodeDetailPane.this.instructionURL.get(string));
                }
            }
        };
        abstractAction.putValue("Name", "Show Description");
        abstractAction.putValue("ShortDescription", "Show detailed information about the selected instruction.");
        jPanel.add(new JButton(abstractAction));
        return jPanel;
    }

    void setCurrentInstructions(ArrayList arrayList) {
        this.instructionURL.clear();
        TreeSet<String> treeSet = new TreeSet<String>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            AbstractInstruction abstractInstruction = (AbstractInstruction)iterator.next();
            if (!treeSet.add(abstractInstruction.getOpcodeVerbose())) continue;
            this.instructionURL.put(abstractInstruction.getOpcodeVerbose(), OpcodesUtil.getURL(abstractInstruction.getOpcode()));
        }
        this.instructions.setModel(new DefaultComboBoxModel<Object>(treeSet.toArray()));
    }

    public void show(TreePath treePath) {
        CodeAttribute codeAttribute = (CodeAttribute)this.findAttribute(treePath);
        if (this.byteCodeDisplay.getCodeAttribute() != codeAttribute) {
            BrowserComponent browserComponent = this.services.getBrowserComponent();
            browserComponent.setCursor(Cursor.getPredefinedCursor(3));
            this.byteCodeDisplay.setCodeAttribute(codeAttribute, this.services.getClassFile());
            this.counterDisplay.init(this.byteCodeDisplay);
            this.byteCodeDisplay.scrollRectToVisible(RECT_ORIGIN);
            this.scrollPane.validate();
            this.scrollPane.repaint();
            browserComponent.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void scrollToOffset(int n) {
        this.byteCodeDisplay.scrollToOffset(n);
    }

    private JScrollPane buildByteCodeScrollPane() {
        this.byteCodeDisplay = new ByteCodeDisplay(this);
        this.scrollPane = new JScrollPane(this.byteCodeDisplay);
        this.scrollPane.getViewport().setBackground(Color.WHITE);
        this.counterDisplay = new CounterDisplay();
        this.scrollPane.setRowHeaderView(this.counterDisplay);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ByteCodeDetailPane.this.scrollPane.requestFocus();
            }
        };
        this.byteCodeDisplay.addMouseListener(mouseAdapter);
        this.scrollPane.getHorizontalScrollBar().addMouseListener(mouseAdapter);
        this.scrollPane.getVerticalScrollBar().addMouseListener(mouseAdapter);
        this.scrollPane.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                ByteCodeDetailPane.this.scrollPane.requestFocus();
            }
        });
        return this.scrollPane;
    }

    private class DocumentLinkListener
    extends MouseAdapter
    implements MouseMotionListener {
        private ByteCodeDisplay byteCodeDisplay;
        private Cursor defaultCursor;
        private int defaultCursorType;
        private Cursor handCursor;

        private DocumentLinkListener(ByteCodeDisplay byteCodeDisplay) {
            this.byteCodeDisplay = byteCodeDisplay;
            this.defaultCursor = Cursor.getDefaultCursor();
            this.defaultCursorType = this.defaultCursor.getType();
            this.handCursor = Cursor.getPredefinedCursor(12);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.byteCodeDisplay.link(mouseEvent.getPoint());
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            boolean bl = this.byteCodeDisplay.isLink(mouseEvent.getPoint());
            if (this.byteCodeDisplay.getCursor().getType() == this.defaultCursorType && bl) {
                this.byteCodeDisplay.setCursor(this.handCursor);
            } else if (!bl) {
                this.byteCodeDisplay.setCursor(this.defaultCursor);
            }
        }
    }
}

