/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.bytecode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gjt.jclasslib.bytecode.AbstractBranchInstruction;
import org.gjt.jclasslib.bytecode.AbstractInstruction;
import org.gjt.jclasslib.bytecode.LookupSwitchInstruction;
import org.gjt.jclasslib.bytecode.MatchOffsetPair;
import org.gjt.jclasslib.bytecode.PaddedInstruction;
import org.gjt.jclasslib.bytecode.TableSwitchInstruction;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.attributes.CodeAttribute;
import org.gjt.jclasslib.structures.attributes.ExceptionTableEntry;
import org.gjt.jclasslib.structures.attributes.LineNumberTableAttribute;
import org.gjt.jclasslib.structures.attributes.LineNumberTableEntry;

public class CodeInsertion {
    private int position;
    private AbstractInstruction[] preInstructions;
    private AbstractInstruction[] postInstructions;
    private boolean shiftTarget;
    static /* synthetic */ Class class$org$gjt$jclasslib$structures$attributes$LineNumberTableAttribute;

    public static CodeInsertion merge(int n, boolean bl, CodeInsertion codeInsertion, CodeInsertion codeInsertion2) {
        if (codeInsertion2 == null) {
            return codeInsertion;
        }
        if (codeInsertion == null) {
            return codeInsertion2;
        }
        AbstractInstruction[] abstractInstructionArray = CodeInsertion.mergeInstructions(codeInsertion2.preInstructions, codeInsertion.preInstructions);
        AbstractInstruction[] abstractInstructionArray2 = CodeInsertion.mergeInstructions(codeInsertion.postInstructions, codeInsertion2.postInstructions);
        CodeInsertion codeInsertion3 = new CodeInsertion(n, abstractInstructionArray, abstractInstructionArray2, bl);
        return codeInsertion3;
    }

    public static AbstractInstruction[] mergeInstructions(AbstractInstruction[] abstractInstructionArray, AbstractInstruction[] abstractInstructionArray2) {
        if (abstractInstructionArray == null) {
            return abstractInstructionArray2;
        }
        if (abstractInstructionArray2 == null) {
            return abstractInstructionArray;
        }
        AbstractInstruction[] abstractInstructionArray3 = new AbstractInstruction[abstractInstructionArray.length + abstractInstructionArray2.length];
        System.arraycopy(abstractInstructionArray, 0, abstractInstructionArray3, 0, abstractInstructionArray.length);
        System.arraycopy(abstractInstructionArray2, 0, abstractInstructionArray3, abstractInstructionArray.length, abstractInstructionArray2.length);
        return abstractInstructionArray3;
    }

    public static List apply(List list, List list2, CodeAttribute codeAttribute) throws InvalidByteCodeException {
        int n = list.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        List list3 = CodeInsertion.insertCode(list, list2, nArray);
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = ((AbstractInstruction)list.get(i)).getOffset();
        }
        int[] nArray3 = new int[list3.size()];
        CodeInsertion.calculateOffsets(list3, nArray3);
        CodeInsertion.adjustOffsets(list, list3, nArray2, nArray3, nArray);
        if (codeAttribute != null) {
            CodeInsertion.adjustExceptionTable(nArray2, nArray3, nArray, codeAttribute);
            CodeInsertion.adjustLineNumberTable(nArray2, nArray3, nArray, codeAttribute);
        }
        CodeInsertion.applyOffsets(list3, nArray3);
        return list3;
    }

    private static List insertCode(List list, List list2, int[] nArray) {
        int n = list.size();
        int n2 = list2.size();
        int n3 = CodeInsertion.calculateNewSize(list, list2);
        ArrayList arrayList = new ArrayList(n3);
        int n4 = 0;
        CodeInsertion codeInsertion = (CodeInsertion)list2.get(0);
        for (int i = 0; i < n; ++i) {
            if (codeInsertion.getPosition() < i && n4 < n2 - 1) {
                codeInsertion = (CodeInsertion)list2.get(++n4);
            }
            int n5 = 0;
            int n6 = 0;
            if (codeInsertion.getPosition() == i) {
                n5 = CodeInsertion.addInstructions(arrayList, codeInsertion.getPreInstructions());
            }
            arrayList.add(list.get(i));
            if (codeInsertion.getPosition() == i) {
                n6 = CodeInsertion.addInstructions(arrayList, codeInsertion.getPostInstructions());
            }
            if (n5 <= 0 && n6 <= 0) continue;
            CodeInsertion.shiftIndices(i, n5, n6, nArray, codeInsertion.isShiftTarget());
        }
        return arrayList;
    }

    private static int calculateNewSize(List list, List list2) {
        int n = list2.size();
        int n2 = list.size();
        for (int i = 0; i < n; ++i) {
            AbstractInstruction[] abstractInstructionArray;
            CodeInsertion codeInsertion = (CodeInsertion)list2.get(i);
            AbstractInstruction[] abstractInstructionArray2 = codeInsertion.getPreInstructions();
            if (abstractInstructionArray2 != null) {
                n2 += abstractInstructionArray2.length;
            }
            if ((abstractInstructionArray = codeInsertion.getPostInstructions()) == null) continue;
            n2 += abstractInstructionArray.length;
        }
        return n2;
    }

    private static void shiftIndices(int n, int n2, int n3, int[] nArray, boolean bl) {
        if (!bl) {
            int n4 = n;
            nArray[n4] = nArray[n4] + n2;
        }
        int n5 = n + 1;
        while (n5 < nArray.length) {
            int n6 = n5++;
            nArray[n6] = nArray[n6] + (n2 + n3);
        }
    }

    private static int addInstructions(List list, AbstractInstruction[] abstractInstructionArray) {
        if (abstractInstructionArray != null) {
            for (int i = 0; i < abstractInstructionArray.length; ++i) {
                list.add(abstractInstructionArray[i]);
            }
            return abstractInstructionArray.length;
        }
        return 0;
    }

    private static void calculateOffsets(List list, int[] nArray) {
        int n = list.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            nArray[i] = n2;
            AbstractInstruction abstractInstruction = (AbstractInstruction)list.get(i);
            int n3 = abstractInstruction instanceof PaddedInstruction ? ((PaddedInstruction)abstractInstruction).getPaddedSize(n2) : abstractInstruction.getSize();
            n2 += n3;
        }
    }

    private static void applyOffsets(List list, int[] nArray) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            AbstractInstruction abstractInstruction = (AbstractInstruction)list.get(i);
            abstractInstruction.setOffset(nArray[i]);
        }
    }

    private static void adjustOffsets(List list, List list2, int[] nArray, int[] nArray2, int[] nArray3) throws InvalidByteCodeException {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            AbstractInstruction abstractInstruction = (AbstractInstruction)list.get(i);
            int n3 = CodeInsertion.getBranchOffset(abstractInstruction);
            if (n3 == 0) continue;
            if (abstractInstruction instanceof TableSwitchInstruction) {
                int[] nArray4 = ((TableSwitchInstruction)abstractInstruction).getJumpOffsets();
                for (n2 = 0; n2 < nArray4.length; ++n2) {
                    int n4 = CodeInsertion.getBranchTargetIndex(list, i, nArray4[n2]);
                    nArray4[n2] = CodeInsertion.calculateNewBranchOffset(list2, i, n4, nArray3, nArray2);
                }
            } else if (abstractInstruction instanceof LookupSwitchInstruction) {
                List list3 = ((LookupSwitchInstruction)abstractInstruction).getMatchOffsetPairs();
                for (n2 = 0; n2 < list3.size(); ++n2) {
                    MatchOffsetPair matchOffsetPair = (MatchOffsetPair)list3.get(n2);
                    int n5 = CodeInsertion.getBranchTargetIndex(list, i, matchOffsetPair.getOffset());
                    matchOffsetPair.setOffset(CodeInsertion.calculateNewBranchOffset(list2, i, n5, nArray3, nArray2));
                }
            }
            int n6 = CodeInsertion.getBranchTargetIndex(list, i, n3);
            CodeInsertion.setBranchOffset(abstractInstruction, CodeInsertion.calculateNewBranchOffset(list2, i, n6, nArray3, nArray2));
        }
    }

    private static int calculateNewBranchOffset(List list, int n, int n2, int[] nArray, int[] nArray2) {
        int n3 = nArray[n];
        int n4 = nArray[n2];
        int n5 = nArray2[n4] - nArray2[n3];
        return n5;
    }

    private static int getBranchOffset(AbstractInstruction abstractInstruction) {
        int n = 0;
        if (abstractInstruction instanceof TableSwitchInstruction) {
            n = ((TableSwitchInstruction)abstractInstruction).getDefaultOffset();
        } else if (abstractInstruction instanceof LookupSwitchInstruction) {
            n = ((LookupSwitchInstruction)abstractInstruction).getDefaultOffset();
        } else if (abstractInstruction instanceof AbstractBranchInstruction) {
            n = ((AbstractBranchInstruction)abstractInstruction).getBranchOffset();
        }
        return n;
    }

    private static void setBranchOffset(AbstractInstruction abstractInstruction, int n) {
        if (abstractInstruction instanceof TableSwitchInstruction) {
            ((TableSwitchInstruction)abstractInstruction).setDefaultOffset(n);
        } else if (abstractInstruction instanceof LookupSwitchInstruction) {
            ((LookupSwitchInstruction)abstractInstruction).setDefaultOffset(n);
        } else if (abstractInstruction instanceof AbstractBranchInstruction) {
            ((AbstractBranchInstruction)abstractInstruction).setBranchOffset(n);
        }
    }

    private static int getBranchTargetIndex(List list, int n, int n2) throws InvalidByteCodeException {
        int n3 = list.size();
        int n4 = ((AbstractInstruction)list.get(n)).getOffset();
        int n5 = n2 > 0 ? 1 : -1;
        for (int i = n + n5; i >= 0 && i < n3; i += n5) {
            int n6 = ((AbstractInstruction)list.get(i)).getOffset();
            if (n6 - n4 != n2) continue;
            return i;
        }
        throw new InvalidByteCodeException("Invalid branch target");
    }

    private static void adjustExceptionTable(int[] nArray, int[] nArray2, int[] nArray3, CodeAttribute codeAttribute) throws InvalidByteCodeException {
        ExceptionTableEntry[] exceptionTableEntryArray = codeAttribute.getExceptionTable();
        if (exceptionTableEntryArray == null) {
            return;
        }
        for (int i = 0; i < exceptionTableEntryArray.length; ++i) {
            ExceptionTableEntry exceptionTableEntry = exceptionTableEntryArray[i];
            int n = Arrays.binarySearch(nArray, exceptionTableEntry.getStartPc());
            int n2 = Arrays.binarySearch(nArray, exceptionTableEntry.getEndPc());
            int n3 = Arrays.binarySearch(nArray, exceptionTableEntry.getHandlerPc());
            if (n < 0 || n2 < 0 || n3 < 0 || n == nArray.length || n2 == nArray.length || n3 == nArray.length) {
                throw new InvalidByteCodeException("Invalid exception table");
            }
            exceptionTableEntry.setStartPc(nArray2[nArray3[n]]);
            exceptionTableEntry.setEndPc(nArray2[nArray3[n2]]);
            exceptionTableEntry.setHandlerPc(nArray2[nArray3[n3]]);
        }
    }

    private static void adjustLineNumberTable(int[] nArray, int[] nArray2, int[] nArray3, CodeAttribute codeAttribute) throws InvalidByteCodeException {
        LineNumberTableAttribute lineNumberTableAttribute = (LineNumberTableAttribute)codeAttribute.findAttribute(class$org$gjt$jclasslib$structures$attributes$LineNumberTableAttribute == null ? (class$org$gjt$jclasslib$structures$attributes$LineNumberTableAttribute = CodeInsertion.class$("org.gjt.jclasslib.structures.attributes.LineNumberTableAttribute")) : class$org$gjt$jclasslib$structures$attributes$LineNumberTableAttribute);
        if (lineNumberTableAttribute == null) {
            return;
        }
        LineNumberTableEntry[] lineNumberTableEntryArray = lineNumberTableAttribute.getLineNumberTable();
        for (int i = 0; i < lineNumberTableEntryArray.length; ++i) {
            LineNumberTableEntry lineNumberTableEntry = lineNumberTableEntryArray[i];
            int n = Arrays.binarySearch(nArray, lineNumberTableEntry.getStartPc());
            if (n < 0 || n == nArray.length) {
                throw new InvalidByteCodeException("Invalid line number table " + lineNumberTableEntry.getStartPc());
            }
            lineNumberTableEntry.setStartPc(nArray2[nArray3[n]]);
        }
    }

    public CodeInsertion(int n, AbstractInstruction[] abstractInstructionArray, AbstractInstruction[] abstractInstructionArray2, boolean bl) {
        this.position = n;
        this.preInstructions = abstractInstructionArray;
        this.postInstructions = abstractInstructionArray2;
        this.shiftTarget = bl;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public AbstractInstruction[] getPreInstructions() {
        return this.preInstructions;
    }

    public void setPreInstructions(AbstractInstruction[] abstractInstructionArray) {
        this.preInstructions = abstractInstructionArray;
    }

    public AbstractInstruction[] getPostInstructions() {
        return this.postInstructions;
    }

    public void setPostInstructions(AbstractInstruction[] abstractInstructionArray) {
        this.postInstructions = abstractInstructionArray;
    }

    public boolean isShiftTarget() {
        return this.shiftTarget;
    }

    public void setShiftTarget(boolean bl) {
        this.shiftTarget = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

