/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.bytecode;

import org.gjt.jclasslib.bytecode.Opcodes;

public class OpcodesUtil
implements Opcodes {
    private static String[] opcodeVerbose = new String[256];
    private static String[] opcodeURL = new String[256];
    private static final String JVM_SPEC_URL = "http://java.sun.com/docs/books/vmspec/2nd-edition/html/";
    private static final String INVALID_OPCODE_URL = "Instructions.doc.html";

    private OpcodesUtil() {
    }

    public static String getVerbose(int n) {
        if (n < 0 || n > 255) {
            return null;
        }
        return opcodeVerbose[n];
    }

    public static String getURL(int n) {
        return JVM_SPEC_URL + (n < 0 || n > 255 ? INVALID_OPCODE_URL : opcodeURL[n]);
    }

    public static String getArrayTypeVerbose(int n) {
        switch (n) {
            case 4: {
                return "boolean";
            }
            case 5: {
                return "char";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "double";
            }
            case 8: {
                return "byte";
            }
            case 9: {
                return "short";
            }
            case 10: {
                return "int";
            }
            case 11: {
                return "long";
            }
        }
        return "invalid array type";
    }

    static {
        OpcodesUtil.opcodeVerbose[0] = "nop";
        OpcodesUtil.opcodeVerbose[1] = "aconst_null";
        OpcodesUtil.opcodeVerbose[2] = "iconst_m1";
        OpcodesUtil.opcodeVerbose[3] = "iconst_0";
        OpcodesUtil.opcodeVerbose[4] = "iconst_1";
        OpcodesUtil.opcodeVerbose[5] = "iconst_2";
        OpcodesUtil.opcodeVerbose[6] = "iconst_3";
        OpcodesUtil.opcodeVerbose[7] = "iconst_4";
        OpcodesUtil.opcodeVerbose[8] = "iconst_5";
        OpcodesUtil.opcodeVerbose[9] = "lconst_0";
        OpcodesUtil.opcodeVerbose[10] = "lconst_1";
        OpcodesUtil.opcodeVerbose[11] = "fconst_0";
        OpcodesUtil.opcodeVerbose[12] = "fconst_1";
        OpcodesUtil.opcodeVerbose[13] = "fconst_2";
        OpcodesUtil.opcodeVerbose[14] = "dconst_0";
        OpcodesUtil.opcodeVerbose[15] = "dconst_1";
        OpcodesUtil.opcodeVerbose[16] = "bipush";
        OpcodesUtil.opcodeVerbose[17] = "sipush";
        OpcodesUtil.opcodeVerbose[18] = "ldc";
        OpcodesUtil.opcodeVerbose[19] = "ldc_w";
        OpcodesUtil.opcodeVerbose[20] = "ldc2_w";
        OpcodesUtil.opcodeVerbose[21] = "iload";
        OpcodesUtil.opcodeVerbose[22] = "lload";
        OpcodesUtil.opcodeVerbose[23] = "fload";
        OpcodesUtil.opcodeVerbose[24] = "dload";
        OpcodesUtil.opcodeVerbose[25] = "aload";
        OpcodesUtil.opcodeVerbose[26] = "iload_0";
        OpcodesUtil.opcodeVerbose[27] = "iload_1";
        OpcodesUtil.opcodeVerbose[28] = "iload_2";
        OpcodesUtil.opcodeVerbose[29] = "iload_3";
        OpcodesUtil.opcodeVerbose[30] = "lload_0";
        OpcodesUtil.opcodeVerbose[31] = "lload_1";
        OpcodesUtil.opcodeVerbose[32] = "lload_2";
        OpcodesUtil.opcodeVerbose[33] = "lload_3";
        OpcodesUtil.opcodeVerbose[34] = "fload_0";
        OpcodesUtil.opcodeVerbose[35] = "fload_1";
        OpcodesUtil.opcodeVerbose[36] = "fload_2";
        OpcodesUtil.opcodeVerbose[37] = "fload_3";
        OpcodesUtil.opcodeVerbose[38] = "dload_0";
        OpcodesUtil.opcodeVerbose[39] = "dload_1";
        OpcodesUtil.opcodeVerbose[40] = "dload_2";
        OpcodesUtil.opcodeVerbose[41] = "dload_3";
        OpcodesUtil.opcodeVerbose[42] = "aload_0";
        OpcodesUtil.opcodeVerbose[43] = "aload_1";
        OpcodesUtil.opcodeVerbose[44] = "aload_2";
        OpcodesUtil.opcodeVerbose[45] = "aload_3";
        OpcodesUtil.opcodeVerbose[46] = "iaload";
        OpcodesUtil.opcodeVerbose[47] = "laload";
        OpcodesUtil.opcodeVerbose[48] = "faload";
        OpcodesUtil.opcodeVerbose[49] = "daload";
        OpcodesUtil.opcodeVerbose[50] = "aaload";
        OpcodesUtil.opcodeVerbose[51] = "baload";
        OpcodesUtil.opcodeVerbose[52] = "caload";
        OpcodesUtil.opcodeVerbose[53] = "saload";
        OpcodesUtil.opcodeVerbose[54] = "istore";
        OpcodesUtil.opcodeVerbose[55] = "lstore";
        OpcodesUtil.opcodeVerbose[56] = "fstore";
        OpcodesUtil.opcodeVerbose[57] = "dstore";
        OpcodesUtil.opcodeVerbose[58] = "astore";
        OpcodesUtil.opcodeVerbose[59] = "istore_0";
        OpcodesUtil.opcodeVerbose[60] = "istore_1";
        OpcodesUtil.opcodeVerbose[61] = "istore_2";
        OpcodesUtil.opcodeVerbose[62] = "istore_3";
        OpcodesUtil.opcodeVerbose[63] = "lstore_0";
        OpcodesUtil.opcodeVerbose[64] = "lstore_1";
        OpcodesUtil.opcodeVerbose[65] = "lstore_2";
        OpcodesUtil.opcodeVerbose[66] = "lstore_3";
        OpcodesUtil.opcodeVerbose[67] = "fstore_0";
        OpcodesUtil.opcodeVerbose[68] = "fstore_1";
        OpcodesUtil.opcodeVerbose[69] = "fstore_2";
        OpcodesUtil.opcodeVerbose[70] = "fstore_3";
        OpcodesUtil.opcodeVerbose[71] = "dstore_0";
        OpcodesUtil.opcodeVerbose[72] = "dstore_1";
        OpcodesUtil.opcodeVerbose[73] = "dstore_2";
        OpcodesUtil.opcodeVerbose[74] = "dstore_3";
        OpcodesUtil.opcodeVerbose[75] = "astore_0";
        OpcodesUtil.opcodeVerbose[76] = "astore_1";
        OpcodesUtil.opcodeVerbose[77] = "astore_2";
        OpcodesUtil.opcodeVerbose[78] = "astore_3";
        OpcodesUtil.opcodeVerbose[79] = "iastore";
        OpcodesUtil.opcodeVerbose[80] = "lastore";
        OpcodesUtil.opcodeVerbose[81] = "fastore";
        OpcodesUtil.opcodeVerbose[82] = "dastore";
        OpcodesUtil.opcodeVerbose[83] = "aastore";
        OpcodesUtil.opcodeVerbose[84] = "bastore";
        OpcodesUtil.opcodeVerbose[85] = "castore";
        OpcodesUtil.opcodeVerbose[86] = "sastore";
        OpcodesUtil.opcodeVerbose[87] = "pop";
        OpcodesUtil.opcodeVerbose[88] = "pop2";
        OpcodesUtil.opcodeVerbose[89] = "dup";
        OpcodesUtil.opcodeVerbose[90] = "dup_x1";
        OpcodesUtil.opcodeVerbose[91] = "dup_x2";
        OpcodesUtil.opcodeVerbose[92] = "dup2";
        OpcodesUtil.opcodeVerbose[93] = "dup2_x1";
        OpcodesUtil.opcodeVerbose[94] = "dup2_x2";
        OpcodesUtil.opcodeVerbose[95] = "swap";
        OpcodesUtil.opcodeVerbose[96] = "iadd";
        OpcodesUtil.opcodeVerbose[97] = "ladd";
        OpcodesUtil.opcodeVerbose[98] = "fadd";
        OpcodesUtil.opcodeVerbose[99] = "dadd";
        OpcodesUtil.opcodeVerbose[100] = "isub";
        OpcodesUtil.opcodeVerbose[101] = "lsub";
        OpcodesUtil.opcodeVerbose[102] = "fsub";
        OpcodesUtil.opcodeVerbose[103] = "dsub";
        OpcodesUtil.opcodeVerbose[104] = "imul";
        OpcodesUtil.opcodeVerbose[105] = "lmul";
        OpcodesUtil.opcodeVerbose[106] = "fmul";
        OpcodesUtil.opcodeVerbose[107] = "dmul";
        OpcodesUtil.opcodeVerbose[108] = "idiv";
        OpcodesUtil.opcodeVerbose[109] = "ldiv";
        OpcodesUtil.opcodeVerbose[110] = "fdiv";
        OpcodesUtil.opcodeVerbose[111] = "ddiv";
        OpcodesUtil.opcodeVerbose[112] = "irem";
        OpcodesUtil.opcodeVerbose[113] = "lrem";
        OpcodesUtil.opcodeVerbose[114] = "frem";
        OpcodesUtil.opcodeVerbose[115] = "drem";
        OpcodesUtil.opcodeVerbose[116] = "ineg";
        OpcodesUtil.opcodeVerbose[117] = "lneg";
        OpcodesUtil.opcodeVerbose[118] = "fneg";
        OpcodesUtil.opcodeVerbose[119] = "dneg";
        OpcodesUtil.opcodeVerbose[120] = "ishl";
        OpcodesUtil.opcodeVerbose[121] = "lshl";
        OpcodesUtil.opcodeVerbose[122] = "ishr";
        OpcodesUtil.opcodeVerbose[123] = "lshr";
        OpcodesUtil.opcodeVerbose[124] = "iushr";
        OpcodesUtil.opcodeVerbose[125] = "lushr";
        OpcodesUtil.opcodeVerbose[126] = "iand";
        OpcodesUtil.opcodeVerbose[127] = "land";
        OpcodesUtil.opcodeVerbose[128] = "ior";
        OpcodesUtil.opcodeVerbose[129] = "lor";
        OpcodesUtil.opcodeVerbose[130] = "ixor";
        OpcodesUtil.opcodeVerbose[131] = "lxor";
        OpcodesUtil.opcodeVerbose[132] = "iinc";
        OpcodesUtil.opcodeVerbose[133] = "i2l";
        OpcodesUtil.opcodeVerbose[134] = "i2f";
        OpcodesUtil.opcodeVerbose[135] = "i2d";
        OpcodesUtil.opcodeVerbose[136] = "l2i";
        OpcodesUtil.opcodeVerbose[137] = "l2f";
        OpcodesUtil.opcodeVerbose[138] = "l2d";
        OpcodesUtil.opcodeVerbose[139] = "f2i";
        OpcodesUtil.opcodeVerbose[140] = "f2l";
        OpcodesUtil.opcodeVerbose[141] = "f2d";
        OpcodesUtil.opcodeVerbose[142] = "d2i";
        OpcodesUtil.opcodeVerbose[143] = "d2l";
        OpcodesUtil.opcodeVerbose[144] = "d2f";
        OpcodesUtil.opcodeVerbose[145] = "i2b";
        OpcodesUtil.opcodeVerbose[146] = "i2c";
        OpcodesUtil.opcodeVerbose[147] = "i2s";
        OpcodesUtil.opcodeVerbose[148] = "lcmp";
        OpcodesUtil.opcodeVerbose[149] = "fcmpl";
        OpcodesUtil.opcodeVerbose[150] = "fcmpg";
        OpcodesUtil.opcodeVerbose[151] = "dcmpl";
        OpcodesUtil.opcodeVerbose[152] = "dcmpg";
        OpcodesUtil.opcodeVerbose[153] = "ifeq";
        OpcodesUtil.opcodeVerbose[154] = "ifne";
        OpcodesUtil.opcodeVerbose[155] = "iflt";
        OpcodesUtil.opcodeVerbose[156] = "ifge";
        OpcodesUtil.opcodeVerbose[157] = "ifgt";
        OpcodesUtil.opcodeVerbose[158] = "ifle";
        OpcodesUtil.opcodeVerbose[159] = "if_icmpeq";
        OpcodesUtil.opcodeVerbose[160] = "if_icmpne";
        OpcodesUtil.opcodeVerbose[161] = "if_icmplt";
        OpcodesUtil.opcodeVerbose[162] = "if_icmpge";
        OpcodesUtil.opcodeVerbose[163] = "if_icmpgt";
        OpcodesUtil.opcodeVerbose[164] = "if_icmple";
        OpcodesUtil.opcodeVerbose[165] = "if_acmpeq";
        OpcodesUtil.opcodeVerbose[166] = "if_acmpne";
        OpcodesUtil.opcodeVerbose[167] = "goto";
        OpcodesUtil.opcodeVerbose[168] = "jsr";
        OpcodesUtil.opcodeVerbose[169] = "ret";
        OpcodesUtil.opcodeVerbose[170] = "tableswitch";
        OpcodesUtil.opcodeVerbose[171] = "lookupswitch";
        OpcodesUtil.opcodeVerbose[172] = "ireturn";
        OpcodesUtil.opcodeVerbose[173] = "lreturn";
        OpcodesUtil.opcodeVerbose[174] = "freturn";
        OpcodesUtil.opcodeVerbose[175] = "dreturn";
        OpcodesUtil.opcodeVerbose[176] = "areturn";
        OpcodesUtil.opcodeVerbose[177] = "return";
        OpcodesUtil.opcodeVerbose[178] = "getstatic";
        OpcodesUtil.opcodeVerbose[179] = "putstatic";
        OpcodesUtil.opcodeVerbose[180] = "getfield";
        OpcodesUtil.opcodeVerbose[181] = "putfield";
        OpcodesUtil.opcodeVerbose[182] = "invokevirtual";
        OpcodesUtil.opcodeVerbose[183] = "invokespecial";
        OpcodesUtil.opcodeVerbose[184] = "invokestatic";
        OpcodesUtil.opcodeVerbose[185] = "invokeinterface";
        OpcodesUtil.opcodeVerbose[186] = "xxxunusedxxx";
        OpcodesUtil.opcodeVerbose[187] = "new";
        OpcodesUtil.opcodeVerbose[188] = "newarray";
        OpcodesUtil.opcodeVerbose[189] = "anewarray";
        OpcodesUtil.opcodeVerbose[190] = "arraylength";
        OpcodesUtil.opcodeVerbose[191] = "athrow";
        OpcodesUtil.opcodeVerbose[192] = "checkcast";
        OpcodesUtil.opcodeVerbose[193] = "instanceof";
        OpcodesUtil.opcodeVerbose[194] = "monitorenter";
        OpcodesUtil.opcodeVerbose[195] = "monitorexit";
        OpcodesUtil.opcodeVerbose[196] = "wide";
        OpcodesUtil.opcodeVerbose[197] = "multianewarray";
        OpcodesUtil.opcodeVerbose[198] = "ifnull";
        OpcodesUtil.opcodeVerbose[199] = "ifnonnull";
        OpcodesUtil.opcodeVerbose[200] = "goto_w";
        OpcodesUtil.opcodeVerbose[201] = "jsr_w";
        OpcodesUtil.opcodeVerbose[202] = "breakpoint";
        OpcodesUtil.opcodeVerbose[254] = "impdep1";
        OpcodesUtil.opcodeVerbose[255] = "impdep2";
        OpcodesUtil.opcodeURL[50] = "Instructions2.doc.html#aaload";
        OpcodesUtil.opcodeURL[83] = "Instructions2.doc.html#aastore";
        OpcodesUtil.opcodeURL[1] = "Instructions2.doc.html#aconst_null";
        OpcodesUtil.opcodeURL[25] = "Instructions2.doc.html#aload";
        OpcodesUtil.opcodeURL[42] = "Instructions2.doc.html#aload_n";
        OpcodesUtil.opcodeURL[43] = opcodeURL[42];
        OpcodesUtil.opcodeURL[44] = opcodeURL[42];
        OpcodesUtil.opcodeURL[45] = "Instructions2.doc.html#aload_n";
        OpcodesUtil.opcodeURL[189] = "Instructions2.doc.html#anewarray";
        OpcodesUtil.opcodeURL[176] = "Instructions2.doc.html#areturn";
        OpcodesUtil.opcodeURL[190] = "Instructions2.doc.html#arraylength";
        OpcodesUtil.opcodeURL[58] = "Instructions2.doc.html#astore";
        OpcodesUtil.opcodeURL[75] = "Instructions2.doc.html#astore_n";
        OpcodesUtil.opcodeURL[76] = opcodeURL[75];
        OpcodesUtil.opcodeURL[77] = opcodeURL[75];
        OpcodesUtil.opcodeURL[78] = "Instructions2.doc.html#astore_n";
        OpcodesUtil.opcodeURL[191] = "Instructions2.doc.html#athrow";
        OpcodesUtil.opcodeURL[51] = "Instructions2.doc1.html#baload";
        OpcodesUtil.opcodeURL[84] = "Instructions2.doc1.html#bastore";
        OpcodesUtil.opcodeURL[16] = "Instructions2.doc1.html#bipush";
        OpcodesUtil.opcodeURL[187] = "Instructions2.doc10.html#new";
        OpcodesUtil.opcodeURL[188] = "Instructions2.doc10.html#newarray";
        OpcodesUtil.opcodeURL[0] = "Instructions2.doc10.html#nop";
        OpcodesUtil.opcodeURL[87] = "Instructions2.doc11.html#pop";
        OpcodesUtil.opcodeURL[88] = "Instructions2.doc11.html#pop2";
        OpcodesUtil.opcodeURL[181] = "Instructions2.doc11.html#putfield";
        OpcodesUtil.opcodeURL[179] = "Instructions2.doc11.html#putstatic";
        OpcodesUtil.opcodeURL[169] = "Instructions2.doc12.html#ret";
        OpcodesUtil.opcodeURL[177] = "Instructions2.doc12.html#return";
        OpcodesUtil.opcodeURL[53] = "Instructions2.doc13.html#saload";
        OpcodesUtil.opcodeURL[86] = "Instructions2.doc13.html#sastore";
        OpcodesUtil.opcodeURL[17] = "Instructions2.doc13.html#sipush";
        OpcodesUtil.opcodeURL[95] = "Instructions2.doc13.html#swap";
        OpcodesUtil.opcodeURL[170] = "Instructions2.doc14.html#tableswitch";
        OpcodesUtil.opcodeURL[196] = "Instructions2.doc15.html#wide";
        OpcodesUtil.opcodeURL[52] = "Instructions2.doc2.html#caload";
        OpcodesUtil.opcodeURL[85] = "Instructions2.doc2.html#castore";
        OpcodesUtil.opcodeURL[192] = "Instructions2.doc2.html#checkcast";
        OpcodesUtil.opcodeURL[144] = "Instructions2.doc3.html#d2f";
        OpcodesUtil.opcodeURL[142] = "Instructions2.doc3.html#d2i";
        OpcodesUtil.opcodeURL[143] = "Instructions2.doc3.html#d2l";
        OpcodesUtil.opcodeURL[99] = "Instructions2.doc3.html#dadd";
        OpcodesUtil.opcodeURL[49] = "Instructions2.doc3.html#daload";
        OpcodesUtil.opcodeURL[82] = "Instructions2.doc3.html#dastore";
        OpcodesUtil.opcodeURL[152] = "Instructions2.doc3.html#dcmpop";
        OpcodesUtil.opcodeURL[151] = opcodeURL[152];
        OpcodesUtil.opcodeURL[14] = "Instructions2.doc3.html#dconst_d";
        OpcodesUtil.opcodeURL[15] = opcodeURL[14];
        OpcodesUtil.opcodeURL[111] = "Instructions2.doc3.html#ddiv";
        OpcodesUtil.opcodeURL[24] = "Instructions2.doc3.html#dload";
        OpcodesUtil.opcodeURL[38] = "Instructions2.doc3.html#dload_n";
        OpcodesUtil.opcodeURL[39] = opcodeURL[38];
        OpcodesUtil.opcodeURL[40] = opcodeURL[38];
        OpcodesUtil.opcodeURL[41] = opcodeURL[38];
        OpcodesUtil.opcodeURL[107] = "Instructions2.doc3.html#dmul";
        OpcodesUtil.opcodeURL[119] = "Instructions2.doc3.html#dneg";
        OpcodesUtil.opcodeURL[115] = "Instructions2.doc3.html#drem";
        OpcodesUtil.opcodeURL[175] = "Instructions2.doc3.html#dreturn";
        OpcodesUtil.opcodeURL[57] = "Instructions2.doc3.html#dstore";
        OpcodesUtil.opcodeURL[71] = "Instructions2.doc3.html#dstore_n";
        OpcodesUtil.opcodeURL[72] = opcodeURL[71];
        OpcodesUtil.opcodeURL[73] = opcodeURL[71];
        OpcodesUtil.opcodeURL[74] = opcodeURL[71];
        OpcodesUtil.opcodeURL[103] = "Instructions2.doc3.html#dsub";
        OpcodesUtil.opcodeURL[89] = "Instructions2.doc3.html#dup";
        OpcodesUtil.opcodeURL[92] = "Instructions2.doc3.html#dup2";
        OpcodesUtil.opcodeURL[93] = "Instructions2.doc3.html#dup2_x1";
        OpcodesUtil.opcodeURL[94] = "Instructions2.doc3.html#dup2_x2";
        OpcodesUtil.opcodeURL[90] = "Instructions2.doc3.html#dup_x1";
        OpcodesUtil.opcodeURL[91] = "Instructions2.doc3.html#dup_x2";
        OpcodesUtil.opcodeURL[141] = "Instructions2.doc4.html#f2d";
        OpcodesUtil.opcodeURL[139] = "Instructions2.doc4.html#f2i";
        OpcodesUtil.opcodeURL[140] = "Instructions2.doc4.html#f2l";
        OpcodesUtil.opcodeURL[98] = "Instructions2.doc4.html#fadd";
        OpcodesUtil.opcodeURL[48] = "Instructions2.doc4.html#faload";
        OpcodesUtil.opcodeURL[81] = "Instructions2.doc4.html#fastore";
        OpcodesUtil.opcodeURL[150] = "Instructions2.doc4.html#fcmpop";
        OpcodesUtil.opcodeURL[149] = opcodeURL[150];
        OpcodesUtil.opcodeURL[11] = "Instructions2.doc4.html#fconst_f";
        OpcodesUtil.opcodeURL[12] = opcodeURL[11];
        OpcodesUtil.opcodeURL[13] = "Instructions2.doc4.html#fconst_f";
        OpcodesUtil.opcodeURL[110] = "Instructions2.doc4.html#fdiv";
        OpcodesUtil.opcodeURL[23] = "Instructions2.doc4.html#fload";
        OpcodesUtil.opcodeURL[34] = "Instructions2.doc4.html#fload_n";
        OpcodesUtil.opcodeURL[35] = opcodeURL[34];
        OpcodesUtil.opcodeURL[36] = opcodeURL[34];
        OpcodesUtil.opcodeURL[37] = opcodeURL[34];
        OpcodesUtil.opcodeURL[106] = "Instructions2.doc4.html#fmul";
        OpcodesUtil.opcodeURL[118] = "Instructions2.doc4.html#fneg";
        OpcodesUtil.opcodeURL[114] = "Instructions2.doc4.html#frem";
        OpcodesUtil.opcodeURL[174] = "Instructions2.doc4.html#freturn";
        OpcodesUtil.opcodeURL[56] = "Instructions2.doc4.html#fstore";
        OpcodesUtil.opcodeURL[67] = "Instructions2.doc4.html#fstore_n";
        OpcodesUtil.opcodeURL[68] = opcodeURL[67];
        OpcodesUtil.opcodeURL[69] = opcodeURL[67];
        OpcodesUtil.opcodeURL[70] = opcodeURL[67];
        OpcodesUtil.opcodeURL[102] = "Instructions2.doc4.html#fsub";
        OpcodesUtil.opcodeURL[180] = "Instructions2.doc5.html#getfield";
        OpcodesUtil.opcodeURL[178] = "Instructions2.doc5.html#getstatic";
        OpcodesUtil.opcodeURL[167] = "Instructions2.doc5.html#goto";
        OpcodesUtil.opcodeURL[200] = "Instructions2.doc5.html#goto_w";
        OpcodesUtil.opcodeURL[145] = "Instructions2.doc6.html#i2b";
        OpcodesUtil.opcodeURL[146] = "Instructions2.doc6.html#i2c";
        OpcodesUtil.opcodeURL[135] = "Instructions2.doc6.html#i2d";
        OpcodesUtil.opcodeURL[134] = "Instructions2.doc6.html#i2f";
        OpcodesUtil.opcodeURL[133] = "Instructions2.doc6.html#i2l";
        OpcodesUtil.opcodeURL[147] = "Instructions2.doc6.html#i2s";
        OpcodesUtil.opcodeURL[96] = "Instructions2.doc6.html#iadd";
        OpcodesUtil.opcodeURL[46] = "Instructions2.doc6.html#iaload";
        OpcodesUtil.opcodeURL[126] = "Instructions2.doc6.html#iand";
        OpcodesUtil.opcodeURL[79] = "Instructions2.doc6.html#iastore";
        OpcodesUtil.opcodeURL[2] = "Instructions2.doc6.html#iconst_i";
        OpcodesUtil.opcodeURL[3] = opcodeURL[2];
        OpcodesUtil.opcodeURL[4] = opcodeURL[2];
        OpcodesUtil.opcodeURL[5] = opcodeURL[2];
        OpcodesUtil.opcodeURL[6] = opcodeURL[2];
        OpcodesUtil.opcodeURL[7] = opcodeURL[2];
        OpcodesUtil.opcodeURL[8] = opcodeURL[2];
        OpcodesUtil.opcodeURL[108] = "Instructions2.doc6.html#idiv";
        OpcodesUtil.opcodeURL[165] = "Instructions2.doc6.html#if_acmpcond";
        OpcodesUtil.opcodeURL[166] = opcodeURL[165];
        OpcodesUtil.opcodeURL[159] = "Instructions2.doc6.html#if_icmpcond";
        OpcodesUtil.opcodeURL[162] = opcodeURL[165];
        OpcodesUtil.opcodeURL[163] = opcodeURL[165];
        OpcodesUtil.opcodeURL[164] = opcodeURL[165];
        OpcodesUtil.opcodeURL[161] = opcodeURL[165];
        OpcodesUtil.opcodeURL[160] = opcodeURL[165];
        OpcodesUtil.opcodeURL[153] = "Instructions2.doc6.html#ifcond";
        OpcodesUtil.opcodeURL[156] = opcodeURL[153];
        OpcodesUtil.opcodeURL[157] = opcodeURL[153];
        OpcodesUtil.opcodeURL[158] = opcodeURL[153];
        OpcodesUtil.opcodeURL[155] = opcodeURL[153];
        OpcodesUtil.opcodeURL[154] = opcodeURL[153];
        OpcodesUtil.opcodeURL[199] = "Instructions2.doc6.html#ifnonnull";
        OpcodesUtil.opcodeURL[198] = "Instructions2.doc6.html#ifnull";
        OpcodesUtil.opcodeURL[132] = "Instructions2.doc6.html#iinc";
        OpcodesUtil.opcodeURL[21] = "Instructions2.doc6.html#iload";
        OpcodesUtil.opcodeURL[26] = "Instructions2.doc6.html#iload_n";
        OpcodesUtil.opcodeURL[27] = opcodeURL[26];
        OpcodesUtil.opcodeURL[28] = opcodeURL[26];
        OpcodesUtil.opcodeURL[29] = opcodeURL[26];
        OpcodesUtil.opcodeURL[104] = "Instructions2.doc6.html#imul";
        OpcodesUtil.opcodeURL[116] = "Instructions2.doc6.html#ineg";
        OpcodesUtil.opcodeURL[193] = "Instructions2.doc6.html#instanceof";
        OpcodesUtil.opcodeURL[185] = "Instructions2.doc6.html#invokeinterface";
        OpcodesUtil.opcodeURL[183] = "Instructions2.doc6.html#invokespecial";
        OpcodesUtil.opcodeURL[184] = "Instructions2.doc6.html#invokestatic";
        OpcodesUtil.opcodeURL[182] = "Instructions2.doc6.html#invokevirtual";
        OpcodesUtil.opcodeURL[128] = "Instructions2.doc6.html#ior";
        OpcodesUtil.opcodeURL[112] = "Instructions2.doc6.html#irem";
        OpcodesUtil.opcodeURL[172] = "Instructions2.doc6.html#ireturn";
        OpcodesUtil.opcodeURL[120] = "Instructions2.doc6.html#ishl";
        OpcodesUtil.opcodeURL[122] = "Instructions2.doc6.html#ishr";
        OpcodesUtil.opcodeURL[54] = "Instructions2.doc6.html#istore";
        OpcodesUtil.opcodeURL[59] = "Instructions2.doc6.html#istore_n";
        OpcodesUtil.opcodeURL[60] = opcodeURL[59];
        OpcodesUtil.opcodeURL[61] = opcodeURL[59];
        OpcodesUtil.opcodeURL[62] = opcodeURL[59];
        OpcodesUtil.opcodeURL[100] = "Instructions2.doc6.html#isub";
        OpcodesUtil.opcodeURL[124] = "Instructions2.doc6.html#iushr";
        OpcodesUtil.opcodeURL[130] = "Instructions2.doc6.html#ixor";
        OpcodesUtil.opcodeURL[168] = "Instructions2.doc7.html#jsr";
        OpcodesUtil.opcodeURL[201] = "Instructions2.doc7.html#jsr_w";
        OpcodesUtil.opcodeURL[138] = "Instructions2.doc8.html#l2d";
        OpcodesUtil.opcodeURL[137] = "Instructions2.doc8.html#l2f";
        OpcodesUtil.opcodeURL[136] = "Instructions2.doc8.html#l2i";
        OpcodesUtil.opcodeURL[97] = "Instructions2.doc8.html#ladd";
        OpcodesUtil.opcodeURL[47] = "Instructions2.doc8.html#laload";
        OpcodesUtil.opcodeURL[127] = "Instructions2.doc8.html#land";
        OpcodesUtil.opcodeURL[80] = "Instructions2.doc8.html#lastore";
        OpcodesUtil.opcodeURL[148] = "Instructions2.doc8.html#lcmp";
        OpcodesUtil.opcodeURL[9] = "Instructions2.doc8.html#lconst_l";
        OpcodesUtil.opcodeURL[10] = opcodeURL[9];
        OpcodesUtil.opcodeURL[18] = "Instructions2.doc8.html#ldc";
        OpcodesUtil.opcodeURL[20] = "Instructions2.doc8.html#ldc2_w";
        OpcodesUtil.opcodeURL[19] = "Instructions2.doc8.html#ldc_w";
        OpcodesUtil.opcodeURL[109] = "Instructions2.doc8.html#ldiv";
        OpcodesUtil.opcodeURL[22] = "Instructions2.doc8.html#lload";
        OpcodesUtil.opcodeURL[30] = "Instructions2.doc8.html#lload_n";
        OpcodesUtil.opcodeURL[31] = opcodeURL[30];
        OpcodesUtil.opcodeURL[32] = opcodeURL[30];
        OpcodesUtil.opcodeURL[33] = opcodeURL[30];
        OpcodesUtil.opcodeURL[105] = "Instructions2.doc8.html#lmul";
        OpcodesUtil.opcodeURL[117] = "Instructions2.doc8.html#lneg";
        OpcodesUtil.opcodeURL[171] = "Instructions2.doc8.html#lookupswitch";
        OpcodesUtil.opcodeURL[129] = "Instructions2.doc8.html#lor";
        OpcodesUtil.opcodeURL[113] = "Instructions2.doc8.html#lrem";
        OpcodesUtil.opcodeURL[173] = "Instructions2.doc8.html#lreturn";
        OpcodesUtil.opcodeURL[121] = "Instructions2.doc8.html#lshl";
        OpcodesUtil.opcodeURL[123] = "Instructions2.doc8.html#lshr";
        OpcodesUtil.opcodeURL[55] = "Instructions2.doc8.html#lstore";
        OpcodesUtil.opcodeURL[63] = "Instructions2.doc8.html#lstore_n";
        OpcodesUtil.opcodeURL[64] = opcodeURL[63];
        OpcodesUtil.opcodeURL[65] = opcodeURL[63];
        OpcodesUtil.opcodeURL[66] = opcodeURL[63];
        OpcodesUtil.opcodeURL[101] = "Instructions2.doc8.html#lsub";
        OpcodesUtil.opcodeURL[125] = "Instructions2.doc8.html#lushr";
        OpcodesUtil.opcodeURL[131] = "Instructions2.doc8.html#lxor";
        OpcodesUtil.opcodeURL[194] = "Instructions2.doc9.html#monitorenter";
        OpcodesUtil.opcodeURL[195] = "Instructions2.doc9.html#monitorexit";
        OpcodesUtil.opcodeURL[197] = "Instructions2.doc9.html#multianewarray";
    }
}

