/*
 * Decompiled with CFR 0.152.
 */
package org.openide;

import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.List;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.util.enum.FilterEnumeration;
import org.openide.util.io.NbMarshalledObject;

public abstract class ServiceType
implements Serializable {
    private static final long serialVersionUID = -7573598174423654252L;
    public static final String PROP_NAME = "name";
    private String name;
    private transient PropertyChangeSupport supp;

    protected String displayName() {
        try {
            return Introspector.getBeanInfo(this.getClass()).getBeanDescriptor().getDisplayName();
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, e);
            return this.getClass().getName();
        }
    }

    public final ServiceType createClone() {
        Exception anEx;
        block6: {
            if (this instanceof Cloneable) {
                try {
                    return (ServiceType)this.clone();
                }
                catch (CloneNotSupportedException ex) {
                    anEx = ex;
                    break block6;
                }
            }
            try {
                NbMarshalledObject m = new NbMarshalledObject(this);
                return (ServiceType)m.get();
            }
            catch (IOException ex) {
                anEx = ex;
            }
            catch (ClassNotFoundException ex) {
                anEx = ex;
            }
        }
        IllegalStateException ex = new IllegalStateException();
        ErrorManager err = ErrorManager.getDefault();
        err.copyAnnotation(ex, anEx);
        err.annotate((Throwable)ex, "Cannot createClone for " + this);
        throw ex;
    }

    protected Object clone() throws CloneNotSupportedException {
        ServiceType t = (ServiceType)super.clone();
        t.supp = null;
        t.name = null;
        return t;
    }

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        if (this.supp != null) {
            this.supp.firePropertyChange(PROP_NAME, old, name);
        }
    }

    public String getName() {
        return this.name == null ? this.displayName() : this.name;
    }

    public abstract HelpCtx getHelpCtx();

    public final synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.supp == null) {
            this.supp = new PropertyChangeSupport(this);
        }
        this.supp.addPropertyChangeListener(l);
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.supp != null) {
            this.supp.removePropertyChangeListener(l);
        }
    }

    protected final void firePropertyChange(String name, Object o, Object n) {
        if (this.supp != null) {
            this.supp.firePropertyChange(name, o, n);
        }
    }

    public static final class Handle
    implements Serializable {
        static final long serialVersionUID = 7233109534462148872L;
        private String name;
        private String className;
        private transient ServiceType serviceType;
        static /* synthetic */ Class class$org$openide$ServiceType;

        public Handle(ServiceType ex) {
            this.name = ex.getName();
            this.className = ex.getClass().getName();
            this.serviceType = ex;
        }

        public ServiceType getServiceType() {
            if (this.serviceType == null) {
                Class serviceTypeClass;
                Class clazz;
                TopManager tm = TopManager.getDefault();
                try {
                    serviceTypeClass = clazz = Class.forName(this.className, true, tm.systemClassLoader());
                    while (serviceTypeClass.getSuperclass() != (class$org$openide$ServiceType == null ? Handle.class$("org.openide.ServiceType") : class$org$openide$ServiceType)) {
                        serviceTypeClass = serviceTypeClass.getSuperclass();
                    }
                }
                catch (ClassNotFoundException ex) {
                    ErrorManager.getDefault().notify(1, ex);
                    clazz = class$org$openide$ServiceType == null ? (class$org$openide$ServiceType = Handle.class$("org.openide.ServiceType")) : class$org$openide$ServiceType;
                    serviceTypeClass = class$org$openide$ServiceType == null ? (class$org$openide$ServiceType = Handle.class$("org.openide.ServiceType")) : class$org$openide$ServiceType;
                }
                Enumeration en = tm.getServices().services(clazz);
                ServiceType some = tm.getServices().find(clazz);
                while (en.hasMoreElements()) {
                    ServiceType t = (ServiceType)en.nextElement();
                    if (!serviceTypeClass.isInstance(t)) continue;
                    String n = t.getName();
                    if (n != null && n.equals(this.name)) {
                        return t;
                    }
                    if (some != null && (some.getClass() == clazz || t.getClass() != clazz)) continue;
                    some = t;
                }
                if (serviceTypeClass == (class$org$openide$ServiceType == null ? (class$org$openide$ServiceType = Handle.class$("org.openide.ServiceType")) : class$org$openide$ServiceType)) {
                    return null;
                }
                return some;
            }
            return this.serviceType;
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            this.name = (String)ois.readObject();
            String clazz = (String)ois.readObject();
            this.className = clazz == null ? null : Utilities.translate(clazz);
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.writeObject(this.name);
            oos.writeObject(this.className);
        }

        public String toString() {
            return "Handle[" + this.className + ":" + this.name + "]";
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static abstract class Registry
    implements Serializable {
        static final long serialVersionUID = 8721000770371416481L;

        public abstract Enumeration services();

        public Enumeration services(Class clazz) {
            return new FilterEnumeration(this, clazz, this.services()){
                private final /* synthetic */ Class val$clazz;
                private final /* synthetic */ Registry this$0;
                {
                    this.this$0 = this$0;
                    this.val$clazz = val$clazz;
                }

                public boolean accept(Object o) {
                    return this.val$clazz.isInstance(o);
                }
            };
        }

        public abstract List getServiceTypes();

        public abstract void setServiceTypes(List var1);

        public ServiceType find(Class clazz) {
            Enumeration en = this.services();
            while (en.hasMoreElements()) {
                Object o = en.nextElement();
                if (o.getClass() != clazz) continue;
                return (ServiceType)o;
            }
            return null;
        }

        public ServiceType find(String name) {
            Enumeration en = this.services();
            while (en.hasMoreElements()) {
                ServiceType o = (ServiceType)en.nextElement();
                if (!name.equals(o.getName())) continue;
                return o;
            }
            return null;
        }
    }
}

