/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.text.MessageFormat;
import java.util.Enumeration;
import org.openide.TopManager;
import org.openide.actions.ActionConstants;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.compiler.CompilerTask;
import org.openide.cookies.CompilerCookie;
import org.openide.loaders.CompilerSupport;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.actions.NodeAction;
import org.openide.util.enum.ArrayEnumeration;

public abstract class AbstractCompileAction
extends NodeAction {
    static final long serialVersionUID = 5089785814030008824L;
    static /* synthetic */ Class class$org$openide$loaders$DataObject$Container;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie;

    protected void performAction(Node[] activatedNodes) {
        this.compileNodes(activatedNodes);
    }

    protected boolean enable(Node[] arr) {
        if (arr.length == 0) {
            return false;
        }
        Class cookie = this.cookie();
        Compiler.Depth depth = this.depth();
        int i = 0;
        while (i < arr.length) {
            CompilerCookie cc = (CompilerCookie)arr[i].getCookie(cookie);
            if (cc == null ? depth.isLastDepth() || arr[i].getCookie(class$org$openide$loaders$DataObject$Container == null ? AbstractCompileAction.class$("org.openide.loaders.DataObject$Container") : class$org$openide$loaders$DataObject$Container) == null : !cc.isDepthSupported(depth)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected abstract Compiler.Depth depth();

    protected abstract Class cookie();

    protected String message() {
        return ActionConstants.BUNDLE.getString("CTL_CompilationStarted");
    }

    void compileNodes(Node[] nodes) {
        boolean useNodes;
        DataObject[] objects;
        CompilerJob job;
        TopManager.getDefault().setStatusText(this.message());
        try {
            job = new CompilerJob(this.depth());
            CompilerSupport.prepareJob(job, new ArrayEnumeration(nodes), this.cookie(), this.depth());
            objects = new DataObject[nodes.length];
            useNodes = false;
            int i = 0;
            while (i < nodes.length) {
                objects[i] = (DataObject)nodes[i].getCookie(class$org$openide$loaders$DataObject == null ? AbstractCompileAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (objects[i] == null) {
                    useNodes = true;
                    break;
                }
                ++i;
            }
            Object var7_6 = null;
            TopManager.getDefault().setStatusText("");
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            TopManager.getDefault().setStatusText("");
            throw throwable;
        }
        job.setDisplayName(useNodes ? AbstractCompileAction.findName(nodes) : AbstractCompileAction.findName(objects));
        job.start();
    }

    static String findName(Node[] nodes) {
        String name = "";
        if (nodes.length > 0) {
            Node n = nodes[0];
            Node.Cookie ck = null;
            do {
                if ((ck = n.getCookie(class$org$openide$loaders$DataObject == null ? AbstractCompileAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject)) == null) continue;
                DataObject d = (DataObject)ck;
                name = d.isValid() ? d.getNodeDelegate().getDisplayName() : "";
                break;
            } while ((n = n.getParentNode()) != null);
        }
        Object[] args = new Object[]{new Integer(nodes.length), name};
        return MessageFormat.format(ActionConstants.BUNDLE.getString("FMT_Compile"), args);
    }

    static String findName(DataObject[] dataObjects) {
        Object[] args = new Object[]{new Integer(dataObjects.length), dataObjects.length > 0 && dataObjects[0].isValid() ? dataObjects[0].getNodeDelegate().getDisplayName() : ""};
        return MessageFormat.format(ActionConstants.BUNDLE.getString("FMT_Compile"), args);
    }

    public static CompilerJob createJob(Enumeration en, Compiler.Depth depth) {
        CompilerJob job = new CompilerJob(depth);
        CompilerSupport.prepareJob(job, en, class$org$openide$cookies$CompilerCookie == null ? (class$org$openide$cookies$CompilerCookie = AbstractCompileAction.class$("org.openide.cookies.CompilerCookie")) : class$org$openide$cookies$CompilerCookie, depth);
        return job;
    }

    public static boolean compile(Enumeration compileCookies, String name) {
        CompilerJob job = AbstractCompileAction.createJob(compileCookies, Compiler.DEPTH_ZERO);
        job.setDisplayName(name);
        if (!job.isUpToDate()) {
            CompilerTask task = job.start();
            return task.isSuccessful();
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

