/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JEditorPane;
import org.openide.TopManager;
import org.openide.actions.ActionConstants;
import org.openide.actions.DebuggerPerformer;
import org.openide.actions.GoAction;
import org.openide.cookies.EditorCookie;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.HelpCtx;

public class GoToCursorAction
extends GoAction {
    static final long serialVersionUID = -1407195105130821880L;
    private boolean enabled = true;
    static /* synthetic */ Class class$org$openide$actions$GoToCursorAction;
    static /* synthetic */ Class class$org$openide$cookies$DebuggerCookie;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;

    public String getName() {
        return ActionConstants.BUNDLE.getString("GoToCursor");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$actions$GoToCursorAction == null ? (class$org$openide$actions$GoToCursorAction = GoToCursorAction.class$("org.openide.actions.GoToCursorAction")) : class$org$openide$actions$GoToCursorAction);
    }

    protected String iconResource() {
        return "org/openide/resources/actions/goToCursor.gif";
    }

    public void changeEnabled(boolean e) {
        this.enabled = e;
        this.setEnabled(this.enable(this.getActivatedNodes()));
    }

    protected boolean enable(Node[] activatedNodes) {
        if (!this.enabled) {
            return false;
        }
        try {
            EditorCookie edCookie;
            if (activatedNodes == null || activatedNodes.length != 1) {
                return false;
            }
            if (activatedNodes[0].getCookie(class$org$openide$cookies$DebuggerCookie == null ? (class$org$openide$cookies$DebuggerCookie = GoToCursorAction.class$("org.openide.cookies.DebuggerCookie")) : class$org$openide$cookies$DebuggerCookie) == null || (edCookie = (EditorCookie)activatedNodes[0].getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = GoToCursorAction.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie)) == null) {
                return false;
            }
            JEditorPane[] panes = edCookie.getOpenedPanes();
            if (panes == null) {
                return false;
            }
            int state = TopManager.getDefault().getDebugger().getState();
            if (state != 1) {
                return state == 4;
            }
            return true;
        }
        catch (DebuggerNotFoundException e) {
            return false;
        }
    }

    protected void performAction(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length == 0) {
            return;
        }
        EditorCookie edCookie = (EditorCookie)activatedNodes[0].getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = GoToCursorAction.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
        if (edCookie == null) {
            return;
        }
        JEditorPane[] panes = edCookie.getOpenedPanes();
        int index = -1;
        if (panes == null) {
            return;
        }
        int x = 0;
        while (x < panes.length) {
            if (panes[x].isManagingFocus()) {
                index = x;
                break;
            }
            ++x;
        }
        if (index == -1) {
            return;
        }
        int l = NbDocument.findLineNumber(edCookie.getDocument(), panes[index].getCaret().getDot());
        Line ll = edCookie.getLineSet().getCurrent(l);
        if (ll == null) {
            return;
        }
        try {
            final Debugger debugger = TopManager.getDefault().getDebugger();
            final Breakpoint b = debugger.createBreakpoint(ll, true);
            PropertyChangeListener pcl = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent ev) {
                    block2: {
                        block3: {
                            if (!ev.getPropertyName().equals("state")) break block2;
                            if ((Integer)ev.getNewValue() == 4) break block3;
                            if ((Integer)ev.getNewValue() != 1) break block2;
                        }
                        b.remove();
                        debugger.removePropertyChangeListener(this);
                    }
                }
            };
            debugger.addPropertyChangeListener(pcl);
            DebuggerPerformer.getDefault().setDebuggerRunning(true);
            int state = debugger.getState();
            if (state == 1) {
                DebuggerPerformer.StartDebugThread dt = DebuggerPerformer.getDefault().new DebuggerPerformer.StartDebugThread(activatedNodes, false);
                dt.storeGoToCursorInfo(pcl, b);
                dt.start();
            } else if (state == 4) {
                try {
                    TopManager.getDefault().getDebugger().go();
                }
                catch (DebuggerException e) {
                    DebuggerPerformer.getDefault();
                    DebuggerPerformer.notifyDebuggerException(e);
                }
            }
        }
        catch (DebuggerNotFoundException e) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

