/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.actions.ActionConstants;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public final class MoveUpAction
extends NodeAction {
    static final long serialVersionUID = -8201315242813084212L;
    private static final String PROP_ORDER_LISTENER = "sellistener";
    private Reference curIndexCookie;
    private static ErrorManager err = null;
    private static boolean errInited = false;
    static /* synthetic */ Class class$org$openide$actions$MoveUpAction;
    static /* synthetic */ Class class$org$openide$nodes$Index;

    private static final void initErr() {
        if (!errInited) {
            errInited = true;
            ErrorManager master = ErrorManager.getDefault();
            ErrorManager tmp = master.getInstance("org.openide.actions.MoveUpAction");
            if (tmp.isLoggable(0)) {
                err = tmp;
            }
        }
    }

    protected void initialize() {
        MoveUpAction.initErr();
        if (err != null) {
            err.log(0, "initialize");
        }
        super.initialize();
        OrderingListener sl = new OrderingListener();
        this.putProperty(PROP_ORDER_LISTENER, sl);
    }

    private Index getCurIndexCookie() {
        return this.curIndexCookie == null ? null : (Index)this.curIndexCookie.get();
    }

    protected void performAction(Node[] activatedNodes) {
        Index cookie = this.getIndexCookie(activatedNodes);
        if (cookie == null) {
            return;
        }
        int nodeIndex = cookie.indexOf(activatedNodes[0]);
        if (nodeIndex > 0) {
            cookie.moveUp(nodeIndex);
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        Index idx;
        MoveUpAction.initErr();
        if (err != null) {
            err.log(0, "enable; activatedNodes=" + (activatedNodes == null ? null : Arrays.asList(activatedNodes)));
        }
        if ((idx = this.getCurIndexCookie()) != null) {
            idx.removeChangeListener((ChangeListener)this.getProperty(PROP_ORDER_LISTENER));
        }
        Index cookie = this.getIndexCookie(activatedNodes);
        if (err != null) {
            err.log(0, "enable; cookie=" + cookie);
        }
        if (cookie == null) {
            return false;
        }
        cookie.addChangeListener((OrderingListener)this.getProperty(PROP_ORDER_LISTENER));
        this.curIndexCookie = new WeakReference<Index>(cookie);
        int index = cookie.indexOf(activatedNodes[0]);
        if (err != null) {
            err.log(0, "enable; index=" + index);
            if (index == -1) {
                Node parent = activatedNodes[0].getParentNode();
                err.log(0, "enable; parent=" + parent + "; parent.children=" + Arrays.asList(parent.getChildren().getNodes()));
            }
        }
        return index > 0;
    }

    public String getName() {
        return ActionConstants.BUNDLE.getString("MoveUp");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$actions$MoveUpAction == null ? (class$org$openide$actions$MoveUpAction = MoveUpAction.class$("org.openide.actions.MoveUpAction")) : class$org$openide$actions$MoveUpAction);
    }

    private Index getIndexCookie(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return null;
        }
        Node parent = activatedNodes[0].getParentNode();
        if (parent == null) {
            return null;
        }
        return (Index)parent.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = MoveUpAction.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class OrderingListener
    implements ChangeListener {
        private OrderingListener() {
        }

        public void stateChanged(ChangeEvent e) {
            MoveUpAction.initErr();
            Node[] activatedNodes = MoveUpAction.this.getActivatedNodes();
            if (err != null) {
                err.log(0, "stateChanged; activatedNodes=" + (activatedNodes == null ? null : Arrays.asList(activatedNodes)));
            }
            Index cookie = MoveUpAction.this.getIndexCookie(activatedNodes);
            if (err != null) {
                err.log(0, "stateChanged; cookie=" + cookie);
            }
            if (cookie == null) {
                MoveUpAction.this.setEnabled(false);
            } else {
                int index = cookie.indexOf(activatedNodes[0]);
                if (err != null) {
                    err.log(0, "stateChanged; index=" + index);
                }
                MoveUpAction.this.setEnabled(index > 0);
            }
        }
    }
}

