/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.openide.ErrorManager;
import org.openide.actions.ActionConstants;
import org.openide.awt.Actions;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.SharedClassObject;
import org.openide.util.UserCancelException;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;

public final class PasteAction
extends CallableSystemAction {
    static final long serialVersionUID = -6620328110138256516L;
    private static ActSubMenuModel model = new ActSubMenuModel();
    private static PasteType[] types;
    private static PasteType type;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$java$awt$datatransfer$Clipboard;
    static /* synthetic */ Class class$javax$swing$Action;
    static /* synthetic */ Class class$java$awt$event$ActionEvent;

    protected void initialize() {
        super.initialize();
        this.setEnabled(false);
    }

    public String getName() {
        return ActionConstants.BUNDLE.getString("Paste");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = PasteAction.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction);
    }

    protected String iconResource() {
        return "org/openide/resources/actions/paste.gif";
    }

    public JMenuItem getMenuPresenter() {
        return new Actions.SubMenu(this, model, false);
    }

    public JMenuItem getPopupPresenter() {
        return new Actions.SubMenu(this, model, true);
    }

    public void performAction() {
        block12: {
            PasteType t = type;
            if (t == null) {
                return;
            }
            NodeSelector sel = null;
            try {
                block11: {
                    try {
                        ExplorerManager em = PasteAction.findExplorerManager();
                        if (em != null) {
                            sel = new NodeSelector(em, null);
                        }
                        Transferable trans = t.paste();
                        Clipboard clipboard = PasteAction.getClipboard();
                        if (trans == null) break block11;
                        ClipboardOwner owner = trans instanceof ClipboardOwner ? (ClipboardOwner)((Object)trans) : new StringSelection("");
                        clipboard.setContents(trans, owner);
                    }
                    catch (UserCancelException exc) {
                        Object var8_10 = null;
                        if (sel != null) {
                            sel.select();
                        }
                        break block12;
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify(e);
                        Object var8_11 = null;
                        if (sel != null) {
                            sel.select();
                        }
                    }
                }
                Object var8_9 = null;
                if (sel != null) {
                    sel.select();
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                if (sel != null) {
                    sel.select();
                }
                throw throwable;
            }
        }
    }

    public void setPasteTypes(PasteType[] types) {
        PasteAction.types = types;
        if (types == null || types.length == 0) {
            this.setEnabled(false);
            type = null;
        } else {
            this.setEnabled(true);
            type = types[0];
        }
        model.fireStateChanged();
    }

    public PasteType[] getPasteTypes() {
        return types;
    }

    int getPasteTypesCount() {
        return types == null ? 0 : types.length;
    }

    void setPasteTypeIndex(int index) {
        if (types == null) {
            return;
        }
        if (index < 0) {
            index = 0;
        }
        if (index >= types.length) {
            index = types.length - 1;
        }
        type = types[index];
    }

    private static Clipboard getClipboard() {
        Clipboard c = (Clipboard)Lookup.getDefault().lookup(class$java$awt$datatransfer$Clipboard == null ? (class$java$awt$datatransfer$Clipboard = PasteAction.class$("java.awt.datatransfer.Clipboard")) : class$java$awt$datatransfer$Clipboard);
        if (c == null) {
            c = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return c;
    }

    static void invokeAction(SystemAction sa, ActionEvent ev) {
        Exception t = null;
        try {
            Class<?> c = Class.forName("org.openide.actions.ActionManager");
            Object o = Lookup.getDefault().lookup(c);
            if (o != null) {
                Method m = c.getMethod("invokeAction", class$javax$swing$Action == null ? (class$javax$swing$Action = PasteAction.class$("javax.swing.Action")) : class$javax$swing$Action, class$java$awt$event$ActionEvent == null ? (class$java$awt$event$ActionEvent = PasteAction.class$("java.awt.event.ActionEvent")) : class$java$awt$event$ActionEvent);
                m.invoke(o, sa, ev);
                return;
            }
        }
        catch (ClassNotFoundException x) {
        }
        catch (ExceptionInInitializerError x) {
        }
        catch (LinkageError x) {
        }
        catch (SecurityException x) {
            t = x;
        }
        catch (NoSuchMethodException x) {
            t = x;
        }
        catch (IllegalAccessException x) {
            t = x;
        }
        catch (IllegalArgumentException x) {
            t = x;
        }
        catch (InvocationTargetException x) {
            t = x;
        }
        if (t != null) {
            ErrorManager.getDefault().notify(1, t);
        }
        sa.actionPerformed(ev);
    }

    static ExplorerManager findExplorerManager() {
        Exception t = null;
        try {
            Class<?> c = Class.forName("org.openide.windows.TopComponent");
            Method m = c.getMethod("getRegistry", new Class[0]);
            Object o = m.invoke(null, new Object[0]);
            c = Class.forName("org.openide.windows.TopComponent$Registry");
            m = c.getMethod("getActivated", new Class[0]);
            o = m.invoke(o, new Object[0]);
            if (o instanceof ExplorerManager.Provider) {
                return ((ExplorerManager.Provider)o).getExplorerManager();
            }
        }
        catch (ClassNotFoundException x) {
        }
        catch (ExceptionInInitializerError x) {
        }
        catch (LinkageError x) {
        }
        catch (SecurityException x) {
            t = x;
        }
        catch (NoSuchMethodException x) {
            t = x;
        }
        catch (IllegalAccessException x) {
            t = x;
        }
        catch (IllegalArgumentException x) {
            t = x;
        }
        catch (InvocationTargetException x) {
            t = x;
        }
        if (t != null) {
            ErrorManager.getDefault().notify(1, t);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class NodeSelector
    implements NodeListener,
    Runnable {
        private ArrayList added;
        private Node node;
        private ExplorerManager em;
        private Node[] children;

        public NodeSelector(ExplorerManager em, Node[] n) {
            this.em = em;
            if (n != null && n.length > 0) {
                this.node = n[0];
            } else {
                Node[] arr = em.getSelectedNodes();
                if (arr.length != 0) {
                    this.node = arr[0];
                } else {
                    return;
                }
            }
            this.children = this.node.getChildren().getNodes();
            this.node.getChildren().findChild(null);
            this.added = new ArrayList();
            this.node.addNodeListener(this);
        }

        public void select() {
            if (this.added != null) {
                this.node.getChildren().findChild(null);
                Children.MUTEX.readAccess(this);
            }
        }

        public void run() {
            this.node.removeNodeListener(this);
            if (this.added.isEmpty()) {
                return;
            }
            Node[] arr = this.added.toArray(new Node[0]);
            int i = 0;
            while (i < arr.length) {
                block7: {
                    Node node = arr[i];
                    while (node != null) {
                        if (!node.equals(this.em.getRootContext())) {
                            node = node.getParentNode();
                            continue;
                        }
                        break block7;
                    }
                    return;
                }
                ++i;
            }
            try {
                this.em.setSelectedNodes(arr);
            }
            catch (PropertyVetoException ex) {
                ErrorManager.getDefault().notify(1, ex);
            }
            catch (IllegalStateException ex) {
                ErrorManager.getDefault().notify(1, ex);
            }
        }

        public void childrenAdded(NodeMemberEvent ev) {
            this.added.addAll(Arrays.asList(ev.getDelta()));
        }

        public void childrenRemoved(NodeMemberEvent ev) {
        }

        public void childrenReordered(NodeReorderEvent ev) {
        }

        public void nodeDestroyed(NodeEvent ev) {
        }

        public void propertyChange(PropertyChangeEvent evt) {
        }
    }

    private static class ActSubMenuModel
    extends EventListenerList
    implements Actions.SubMenuModel {
        static /* synthetic */ Class class$org$openide$actions$PasteAction;
        static /* synthetic */ Class class$javax$swing$event$ChangeListener;

        private ActSubMenuModel() {
        }

        public int getCount() {
            PasteAction a = (PasteAction)SharedClassObject.findObject(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = ActSubMenuModel.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction);
            return a == null ? 0 : a.getPasteTypesCount();
        }

        public String getLabel(int index) {
            PasteAction a = (PasteAction)SharedClassObject.findObject(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = ActSubMenuModel.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction);
            if (a == null) {
                return null;
            }
            PasteType[] t = a.getPasteTypes();
            return t == null ? null : t[index].getName();
        }

        public HelpCtx getHelpCtx(int index) {
            PasteAction a = (PasteAction)SharedClassObject.findObject(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = ActSubMenuModel.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction);
            if (a == null) {
                return null;
            }
            PasteType[] t = a.getPasteTypes();
            return t == null ? null : t[index].getHelpCtx();
        }

        public MenuShortcut getMenuShortcut(int index) {
            return null;
        }

        public void performActionAt(int index) {
            PasteAction a = (PasteAction)SharedClassObject.findObject(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = ActSubMenuModel.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction);
            if (a != null) {
                a.setPasteTypeIndex(index);
                PasteAction.invokeAction(a, new ActionEvent(this, 1001, "Name"));
            }
        }

        public synchronized void addChangeListener(ChangeListener listener) {
            this.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = ActSubMenuModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, listener);
        }

        public synchronized void removeChangeListener(ChangeListener listener) {
            this.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = ActSubMenuModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, listener);
        }

        protected void fireStateChanged() {
            Object[] listeners = this.getListenerList();
            if (listeners.length == 0) {
                return;
            }
            ChangeEvent e = new ChangeEvent(this);
            int i = listeners.length - 1;
            while (i >= 0) {
                ((ChangeListener)listeners[i]).stateChanged(e);
                i -= 2;
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

