/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.io.IOException;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.actions.ActionConstants;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.HelpCtx;
import org.openide.util.UserCancelException;
import org.openide.util.actions.NodeAction;

public final class SaveAsTemplateAction
extends NodeAction {
    static final long serialVersionUID = 5398459720576212987L;
    static /* synthetic */ Class class$org$openide$actions$SaveAsTemplateAction;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$actions$SaveAsTemplateAction == null ? (class$org$openide$actions$SaveAsTemplateAction = SaveAsTemplateAction.class$("org.openide.actions.SaveAsTemplateAction")) : class$org$openide$actions$SaveAsTemplateAction);
    }

    public String getName() {
        return ActionConstants.BUNDLE.getString("SaveAsTemplate");
    }

    public String iconResource() {
        return super.iconResource();
    }

    protected boolean surviveFocusChange() {
        return false;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length == 0) {
            return false;
        }
        int i = 0;
        while (i < activatedNodes.length) {
            DataObject curCookie = (DataObject)activatedNodes[i].getCookie(class$org$openide$loaders$DataObject == null ? SaveAsTemplateAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (curCookie == null || !curCookie.isCopyAllowed()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void performAction(Node[] activatedNodes) {
        Node[] selected;
        FolderNodeAcceptor acceptor = FolderNodeAcceptor.getInstance();
        String title = ActionConstants.BUNDLE.getString("Title_SaveAsTemplate");
        String rootTitle = ActionConstants.BUNDLE.getString("CTL_SaveAsTemplate");
        DataFolder templates = TopManager.getDefault().getPlaces().folders().templates();
        Node templatesNode = templates.getNodeDelegate();
        try {
            selected = TopManager.getDefault().getNodeOperation().select(title, rootTitle, templatesNode, acceptor, null);
        }
        catch (UserCancelException ex) {
            return;
        }
        DataFolder targetFolder = (DataFolder)selected[0].getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = SaveAsTemplateAction.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
        int i = 0;
        while (i < activatedNodes.length) {
            this.createNewTemplate((DataObject)activatedNodes[i].getCookie(class$org$openide$loaders$DataObject == null ? SaveAsTemplateAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject), targetFolder);
            ++i;
        }
    }

    private void createNewTemplate(DataObject source, DataFolder targetFolder) {
        try {
            DataObject newTemplate = source.copy(targetFolder);
            newTemplate.setTemplate(true);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class FolderNodeAcceptor
    implements NodeAcceptor {
        private static FolderNodeAcceptor instance;
        static /* synthetic */ Class class$org$openide$loaders$DataFolder;

        private FolderNodeAcceptor() {
        }

        public final boolean acceptNodes(Node[] nodes) {
            if (nodes == null || nodes.length != 1) {
                return false;
            }
            return nodes[0].getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = FolderNodeAcceptor.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder) != null;
        }

        static FolderNodeAcceptor getInstance() {
            if (instance == null) {
                instance = new FolderNodeAcceptor();
            }
            return instance;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

