/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openide.TopManager;
import org.openide.actions.ActionConstants;
import org.openide.actions.ActionManager;
import org.openide.awt.JInlineMenu;
import org.openide.awt.JMenuPlus;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public class ToolsAction
extends SystemAction
implements Presenter.Menu,
Presenter.Popup {
    static final long serialVersionUID = 4906417339959070129L;
    private static G gl;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;

    private static synchronized G gl() {
        if (gl == null) {
            gl = new G();
        }
        return gl;
    }

    public String getName() {
        return ToolsAction.getActionName();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = ToolsAction.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction);
    }

    public JMenuItem getMenuPresenter() {
        return new Inline();
    }

    public JMenuItem getPopupPresenter() {
        return new Popup();
    }

    public void actionPerformed(ActionEvent ev) {
    }

    private static String getActionName() {
        return ActionConstants.BUNDLE.getString("CTL_Tools");
    }

    private static List generate(boolean forMenu) {
        ActionManager am = TopManager.getDefault().getActionManager();
        SystemAction[] actions = am.getContextActions();
        ArrayList<JMenuItem> list = new ArrayList<JMenuItem>(actions.length);
        boolean separator = false;
        boolean firstItemAdded = false;
        int i = 0;
        while (i < actions.length) {
            JMenuItem mi;
            SystemAction a = actions[i];
            if (a == null) {
                if (firstItemAdded) {
                    separator = true;
                }
            } else if (forMenu) {
                if (a instanceof Presenter.Menu && a.isEnabled()) {
                    if (separator) {
                        list.add(null);
                        separator = false;
                    }
                    mi = ((Presenter.Menu)((Object)a)).getMenuPresenter();
                    list.add(mi);
                    firstItemAdded = true;
                }
            } else if (a instanceof Presenter.Popup && a.isEnabled()) {
                if (separator) {
                    list.add(null);
                    separator = false;
                }
                mi = ((Presenter.Popup)((Object)a)).getPopupPresenter();
                list.add(mi);
                firstItemAdded = true;
            }
            ++i;
        }
        return list;
    }

    public static void setModel(Model m) {
        throw new SecurityException();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class G
    implements PropertyChangeListener {
        private int timestamp = 1;
        private boolean enabled = false;
        private boolean dirty = false;
        private SystemAction[] actions = null;
        private PropertyChangeSupport supp = new PropertyChangeSupport(this);
        public static final String PROP_STATE = "actionsState";

        public G() {
            ActionManager am = TopManager.getDefault().getActionManager();
            am.addPropertyChangeListener(this);
            this.actionsListChanged();
        }

        public final void addPropertyChangeListener(PropertyChangeListener listener) {
            this.supp.addPropertyChangeListener(listener);
        }

        public final void removePropertyChangeListener(PropertyChangeListener listener) {
            this.supp.removePropertyChangeListener(listener);
        }

        protected final void firePropertyChange(String name, Object o, Object n) {
            this.supp.firePropertyChange(name, o, n);
        }

        private void actionsListChanged() {
            ++this.timestamp;
            this.dirty = true;
            SystemAction[] copy = this.actions;
            if (copy != null) {
                int i = 0;
                while (i < copy.length) {
                    SystemAction act = copy[i];
                    if (act != null) {
                        act.removePropertyChangeListener(this);
                    }
                    ++i;
                }
            }
            ActionManager am = TopManager.getDefault().getActionManager();
            copy = am.getContextActions();
            int i = 0;
            while (i < copy.length) {
                SystemAction act = copy[i];
                if (act != null) {
                    act.addPropertyChangeListener(this);
                }
                ++i;
            }
            this.actions = copy;
            this.firePropertyChange(PROP_STATE, null, null);
        }

        private void actionStateChanged() {
            ++this.timestamp;
            this.dirty = true;
            this.firePropertyChange(PROP_STATE, null, null);
        }

        public void propertyChange(PropertyChangeEvent ev) {
            String prop = ev.getPropertyName();
            if (prop == null || prop.equals("contextActions")) {
                this.actionsListChanged();
            } else if (prop.equals("enabled")) {
                this.actionStateChanged();
            }
        }

        private boolean isPopupEnabled() {
            if (!this.dirty) {
                return this.enabled;
            }
            boolean en = false;
            SystemAction[] copy = this.actions;
            int i = 0;
            while (i < copy.length) {
                SystemAction act = copy[i];
                if (act instanceof Presenter.Popup && act.isEnabled()) {
                    en = true;
                    break;
                }
                ++i;
            }
            this.enabled = en;
            this.dirty = false;
            return this.enabled;
        }

        private int getTimestamp() {
            return this.timestamp;
        }
    }

    public static interface Model {
        public SystemAction[] getActions();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }

    private static final class Popup
    extends JInlineMenu
    implements Runnable {
        static final long serialVersionUID = 2269006599727576059L;
        private JMenu menu = new MyMenu();
        private int timestamp = 0;
        private boolean isEmpty = true;
        static /* synthetic */ Class class$org$openide$actions$ToolsAction;

        public Popup() {
            HelpCtx.setHelpIDString(this.menu, (class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = Popup.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction).getName());
            this.putClientProperty("hack.preShowUpdater", this);
        }

        public void addNotify() {
            if (ToolsAction.gl().isPopupEnabled() == this.isEmpty) {
                SwingUtilities.invokeLater(this);
            }
            super.addNotify();
        }

        public void run() {
            if (this.timestamp != ToolsAction.gl().getTimestamp()) {
                this.timestamp = ToolsAction.gl().getTimestamp();
                if (ToolsAction.gl().isPopupEnabled() == this.isEmpty) {
                    JMenuItem[] jMenuItemArray;
                    if (this.isEmpty) {
                        JMenuItem[] jMenuItemArray2 = new JMenuItem[1];
                        jMenuItemArray = jMenuItemArray2;
                        jMenuItemArray2[0] = this.menu;
                    } else {
                        jMenuItemArray = new JMenuItem[]{};
                    }
                    this.setMenuItems(jMenuItemArray);
                    this.isEmpty = !this.isEmpty;
                }
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        private class MyMenu
        extends JMenuPlus
        implements PopupMenuListener {
            private JPopupMenu lastPopup = null;
            static /* synthetic */ Class class$org$openide$actions$ToolsAction;

            MyMenu() {
                super(ToolsAction.getActionName());
            }

            public JPopupMenu getPopupMenu() {
                JPopupMenu popup = super.getPopupMenu();
                this.fillSubmenu(popup);
                return popup;
            }

            private void fillSubmenu(JPopupMenu pop) {
                if (this.lastPopup == null) {
                    pop.addPopupMenuListener(this);
                    this.lastPopup = pop;
                    this.removeAll();
                    Iterator it = ToolsAction.generate(false).iterator();
                    while (it.hasNext()) {
                        Component item = (Component)it.next();
                        if (item == null) {
                            this.addSeparator();
                            continue;
                        }
                        this.add(item);
                    }
                    if (this.getMenuComponentCount() == 0) {
                        JMenuItem empty = new JMenuItem(NbBundle.getMessage(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = MyMenu.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction, "CTL_EmptySubMenu"));
                        empty.setEnabled(false);
                        this.add(empty);
                    }
                }
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                this.lastPopup.removePopupMenuListener(this);
                this.lastPopup = null;
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }
    }

    private static final class Inline
    extends JInlineMenu
    implements PropertyChangeListener,
    Runnable {
        static final long serialVersionUID = 2269006599727576059L;
        private int timestamp = 0;

        Inline() {
            this.putClientProperty("hack.preShowUpdater", this);
        }

        public void addNotify() {
            if (this.timestamp != ToolsAction.gl().getTimestamp()) {
                SwingUtilities.invokeLater(this);
            }
            ToolsAction.gl().addPropertyChangeListener(this);
            super.addNotify();
        }

        public void removeNotify() {
            ToolsAction.gl().removePropertyChangeListener(this);
            super.removeNotify();
        }

        public void propertyChange(PropertyChangeEvent ev) {
            String prop = ev.getPropertyName();
            if (prop == null || prop.equals("actionsState")) {
                SwingUtilities.invokeLater(this);
            }
        }

        public void run() {
            if (this.timestamp == ToolsAction.gl().getTimestamp()) {
                return;
            }
            List l = ToolsAction.generate(true);
            this.setMenuItems(l.toArray(new JMenuItem[l.size()]));
            this.timestamp = ToolsAction.gl().getTimestamp();
        }
    }
}

