/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.CannotUndoException;
import org.openide.ErrorManager;
import org.openide.actions.ActionConstants;
import org.openide.actions.RedoAction;
import org.openide.awt.UndoRedo;
import org.openide.util.HelpCtx;
import org.openide.util.SharedClassObject;
import org.openide.util.WeakListener;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class UndoAction
extends CallableSystemAction {
    static final long serialVersionUID = -2762036372802427913L;
    private static Listener listener;
    private static UndoRedo last;
    private static UndoAction undoAction;
    private static RedoAction redoAction;
    static /* synthetic */ Class class$org$openide$actions$UndoAction;
    static /* synthetic */ Class class$org$openide$actions$RedoAction;

    public boolean isEnabled() {
        UndoAction.initializeUndoRedo();
        return super.isEnabled();
    }

    static synchronized void initializeUndoRedo() {
        if (listener != null) {
            return;
        }
        listener = new Listener();
        TopComponent.Registry r = WindowManager.getDefault().getRegistry();
        r.addPropertyChangeListener(WeakListener.propertyChange(listener, r));
        last = UndoAction.getUndoRedo();
        last.addChangeListener(listener);
        UndoAction.updateStatus();
    }

    static synchronized void updateStatus() {
        if (undoAction == null) {
            undoAction = (UndoAction)SharedClassObject.findObject(class$org$openide$actions$UndoAction == null ? (class$org$openide$actions$UndoAction = UndoAction.class$("org.openide.actions.UndoAction")) : class$org$openide$actions$UndoAction, false);
        }
        if (redoAction == null) {
            redoAction = (RedoAction)SharedClassObject.findObject(class$org$openide$actions$RedoAction == null ? (class$org$openide$actions$RedoAction = UndoAction.class$("org.openide.actions.RedoAction")) : class$org$openide$actions$RedoAction, false);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UndoRedo ur = UndoAction.getUndoRedo();
                if (undoAction != null) {
                    undoAction.setEnabled(ur.canUndo());
                }
                if (redoAction != null) {
                    redoAction.setEnabled(ur.canRedo());
                }
            }
        });
    }

    static UndoRedo getUndoRedo() {
        TopComponent el = WindowManager.getDefault().getRegistry().getActivated();
        return el == null ? UndoRedo.NONE : el.getUndoRedo();
    }

    public String getName() {
        MessageFormat mformat = new MessageFormat(ActionConstants.BUNDLE.getString("Undo"));
        return mformat.format(new String[]{UndoAction.getUndoRedo().getUndoPresentationName()});
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$actions$UndoAction == null ? (class$org$openide$actions$UndoAction = UndoAction.class$("org.openide.actions.UndoAction")) : class$org$openide$actions$UndoAction);
    }

    protected String iconResource() {
        return "org/openide/resources/actions/undo.gif";
    }

    public void performAction() {
        try {
            UndoRedo undoRedo = UndoAction.getUndoRedo();
            if (undoRedo.canUndo()) {
                undoRedo.undo();
            }
        }
        catch (CannotUndoException ex) {
            ErrorManager.getDefault().notify(ex);
        }
        UndoAction.updateStatus();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        last = UndoRedo.NONE;
        undoAction = null;
        redoAction = null;
    }

    private static final class Listener
    implements PropertyChangeListener,
    ChangeListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent ev) {
            UndoAction.updateStatus();
            last.removeChangeListener(this);
            last = UndoAction.getUndoRedo();
            last.addChangeListener(this);
        }

        public void stateChanged(ChangeEvent ev) {
            UndoAction.updateStatus();
        }
    }
}

