/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.MissingResourceException;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Keymap;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.awt.JMenuPlus;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;
import org.openide.util.actions.BooleanStateAction;
import org.openide.util.actions.SystemAction;

public class Actions {
    private static Object GLOBAL_KEYMAP;
    private static Object actions14;
    static /* synthetic */ Class class$javax$swing$text$Keymap;
    static /* synthetic */ Class class$org$openide$awt$Actions;
    static /* synthetic */ Class class$javax$swing$Action;
    static /* synthetic */ Class class$java$awt$event$ActionEvent;

    public static String findKey(SystemAction action) {
        return Actions.findKey((Action)action);
    }

    private static String findKey(Action action) {
        Keymap map = (Keymap)Lookup.getDefault().lookup(class$javax$swing$text$Keymap == null ? (class$javax$swing$text$Keymap = Actions.class$("javax.swing.text.Keymap")) : class$javax$swing$text$Keymap);
        if (map == null) {
            return null;
        }
        KeyStroke[] arr = map.getKeyStrokesForAction(action);
        if (arr.length == 0) {
            return null;
        }
        KeyStroke accelerator = arr[0];
        int modifiers = accelerator.getModifiers();
        String acceleratorText = "";
        if (modifiers > 0) {
            acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
            acceleratorText = acceleratorText + "+";
        } else if (accelerator.getKeyCode() == 0) {
            return "";
        }
        acceleratorText = acceleratorText + KeyEvent.getKeyText(accelerator.getKeyCode());
        return acceleratorText;
    }

    public static void connect(JMenuItem item, SystemAction action, boolean popup) {
        Actions.connect(item, (Action)action, popup);
    }

    static void connect(JMenuItem item, Action action, boolean popup) {
        MenuBridge b = new MenuBridge(item, action, popup);
        ((Bridge)b).updateState(null);
    }

    public static void connect(JCheckBoxMenuItem item, BooleanStateAction action, boolean popup) {
        CheckMenuBridge b = new CheckMenuBridge(item, action, popup);
        ((Bridge)b).updateState(null);
    }

    public static void connect(AbstractButton button, SystemAction action) {
        Actions.connect(button, (Action)action);
    }

    static void connect(AbstractButton button, Action action) {
        ButtonBridge b = new ButtonBridge(button, action);
        ((Bridge)b).updateState(null);
    }

    public static void connect(AbstractButton button, BooleanStateAction action) {
        BooleanButtonBridge b = new BooleanButtonBridge(button, action);
        ((Bridge)b).updateState(null);
    }

    private static void addKeymapListener(PropertyChangeListener l) {
        if (GLOBAL_KEYMAP == null) {
            Class clazz = class$org$openide$awt$Actions == null ? (class$org$openide$awt$Actions = Actions.class$("org.openide.awt.Actions")) : class$org$openide$awt$Actions;
            synchronized (clazz) {
                if (GLOBAL_KEYMAP == null) {
                    try {
                        Class<?> c = Class.forName("org.openide.awt.Actions$GlobalKeymapL");
                        GLOBAL_KEYMAP = (PropertyChangeSupport)c.newInstance();
                    }
                    catch (Exception e) {
                        GLOBAL_KEYMAP = new Object();
                    }
                    catch (LinkageError e) {
                        GLOBAL_KEYMAP = new Object();
                    }
                }
            }
        }
        if (GLOBAL_KEYMAP instanceof PropertyChangeSupport) {
            ((PropertyChangeSupport)GLOBAL_KEYMAP).addPropertyChangeListener(WeakListener.propertyChange(l, GLOBAL_KEYMAP));
        }
    }

    private static KeyStroke[] getKeyStrokesForAction(Action action) {
        Keymap map = (Keymap)Lookup.getDefault().lookup(class$javax$swing$text$Keymap == null ? (class$javax$swing$text$Keymap = Actions.class$("javax.swing.text.Keymap")) : class$javax$swing$text$Keymap);
        if (map != null) {
            return map.getKeyStrokesForAction(action);
        }
        return new KeyStroke[0];
    }

    public static void setMenuText(AbstractButton item, String text, boolean useMnemonic) {
        if (text == null) {
            item.setText(null);
            return;
        }
        int i = text.indexOf(38);
        String newText = text;
        if (i < 0) {
            item.setText(text);
            if (useMnemonic) {
                item.setMnemonic(0);
            }
        } else if (i == text.length() - 1) {
            item.setText(text.substring(0, i));
            if (useMnemonic) {
                item.setMnemonic(0);
            }
        } else {
            item.setText(text.substring(0, i) + text.substring(i + 1));
            if (useMnemonic) {
                char ch = text.charAt(i + 1);
                if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9') {
                    item.setMnemonic(ch);
                } else {
                    char latinChar = Actions.getLatinKeyboardChar(ch);
                    item.setMnemonic(latinChar);
                    Actions.setDisplayedMnemonicIndex(item, i, latinChar);
                }
            }
        }
    }

    private static char getLatinKeyboardChar(char localeChar) {
        try {
            return NbBundle.getBundle(class$org$openide$awt$Actions == null ? (class$org$openide$awt$Actions = Actions.class$("org.openide.awt.Actions")) : class$org$openide$awt$Actions).getString("MNEMONIC_" + localeChar).charAt(0);
        }
        catch (MissingResourceException ex) {
            return localeChar;
        }
    }

    private static void setDisplayedMnemonicIndex(AbstractButton item, int index, char latinChar) {
        if (Dependency.JAVA_SPEC.compareTo(new SpecificationVersion("1.4")) >= 0) {
            if (actions14 == null) {
                try {
                    Class<?> c = Class.forName("org.openide.awt.Actions14");
                    actions14 = c.newInstance();
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(ex);
                    actions14 = ex;
                }
            }
            if (actions14 instanceof Map.Entry) {
                ((Map.Entry)actions14).setValue(new Object[]{item, new Integer(index)});
            }
        } else {
            item.setText(item.getText() + " (" + latinChar + ")");
            item.setMnemonic(latinChar);
        }
    }

    public static String cutAmpersand(String text) {
        String result = text;
        int i = text.indexOf("(&");
        result = i >= 0 ? (i + 4 < text.length() ? text.substring(0, i) + text.substring(i + 4) : text.substring(0, i)) : ((i = text.indexOf(38)) < 0 ? text : (i == text.length() - 1 ? text.substring(0, i) : text.substring(0, i) + text.substring(i + 1)));
        return result;
    }

    private static HelpCtx findHelp(Action a) {
        if (a instanceof SystemAction) {
            return ((SystemAction)a).getHelpCtx();
        }
        return HelpCtx.DEFAULT_HELP;
    }

    static void invokeAction(Action a, ActionEvent ev) {
        Exception t = null;
        try {
            Class<?> c = Class.forName("org.openide.actions.ActionManager");
            Object o = Lookup.getDefault().lookup(c);
            if (o != null) {
                Method m = c.getMethod("invokeAction", class$javax$swing$Action == null ? (class$javax$swing$Action = Actions.class$("javax.swing.Action")) : class$javax$swing$Action, class$java$awt$event$ActionEvent == null ? (class$java$awt$event$ActionEvent = Actions.class$("java.awt.event.ActionEvent")) : class$java$awt$event$ActionEvent);
                m.invoke(o, a, ev);
                return;
            }
        }
        catch (ClassNotFoundException x) {
        }
        catch (ExceptionInInitializerError x) {
        }
        catch (LinkageError x) {
        }
        catch (SecurityException x) {
            t = x;
        }
        catch (NoSuchMethodException x) {
            t = x;
        }
        catch (IllegalAccessException x) {
            t = x;
        }
        catch (IllegalArgumentException x) {
            t = x;
        }
        catch (InvocationTargetException x) {
            t = x;
        }
        if (t != null) {
            ErrorManager.getDefault().notify(1, t);
        }
        a.actionPerformed(ev);
    }

    static void prepareMargins(JMenuItem item, Action action) {
        Insets margin = item.getMargin();
        margin.left = 0;
        item.setMargin(margin);
        item.setHorizontalTextPosition(4);
        item.setHorizontalAlignment(2);
    }

    static void updateKey(JMenuItem item, Action action) {
        if (item instanceof SubMenu || !(item instanceof JMenu)) {
            if (item instanceof SubMenu && !((SubMenu)item).useAccel()) {
                item.setAccelerator(null);
            } else {
                KeyStroke[] arr = Actions.getKeyStrokesForAction(action);
                if (arr.length != 0) {
                    item.setAccelerator(arr[0]);
                } else {
                    item.setAccelerator(null);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class GlobalKeymapL
    extends PropertyChangeSupport
    implements PropertyChangeListener,
    Runnable {
        GlobalKeymapL() {
            super(TopManager.getDefault());
            TopManager.getDefault().addPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if ("globalKeymap" == ev.getPropertyName()) {
                Mutex.EVENT.readAccess(this);
            }
        }

        public void run() {
            this.firePropertyChange("globalKeymap", null, null);
        }
    }

    public static class SubMenu
    extends JMenuPlus {
        int previousCount = -1;
        ActionListener oneItemListener;
        private KeyStroke accelerator;
        private SubMenuModel subModel;
        static final long serialVersionUID = -4446966671302959091L;

        public SubMenu(SystemAction aAction, SubMenuModel model) {
            this(aAction, model, true);
        }

        public SubMenu(SystemAction aAction, SubMenuModel model, boolean popup) {
            this.subModel = model;
            new SubMenuBridge(this, aAction, model, popup).updateState(null);
        }

        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            Component[] cs;
            if (ks.equals(this.accelerator) && (cs = this.getMenuComponents()).length > 0 && cs[0] instanceof JComponent) {
                Action action;
                JComponent comp = (JComponent)cs[0];
                ActionMap am = comp.getActionMap();
                if (am != null && comp.isEnabled() && (action = am.get("doClick")) != null) {
                    return SwingUtilities.notifyAction(action, ks, e, comp, e.getModifiers());
                }
                return false;
            }
            return super.processKeyBinding(ks, e, condition, pressed);
        }

        public void processKeyEvent(KeyEvent e, MenuElement[] path, MenuSelectionManager m) {
            ActionListener ac;
            if (this.getMenuComponentCount() <= 1 && Arrays.equals(path, MenuSelectionManager.defaultManager().getSelectedPath()) && (e.getKeyCode() == 10 || e.getKeyCode() == 32) && (ac = this.oneItemListener) != null) {
                m.setSelectedPath(new MenuElement[0]);
                ac.actionPerformed(new ActionEvent(e.getSource(), 0, null));
                return;
            }
            super.processKeyEvent(e, path, m);
        }

        public String getUIClassID() {
            if (this.previousCount == 0) {
                return "MenuItemUI";
            }
            return this.previousCount == 1 ? "MenuItemUI" : "MenuUI";
        }

        boolean useAccel() {
            return this.subModel.getCount() <= 1;
        }

        public void setAccelerator(KeyStroke keyStroke) {
            KeyStroke oldAccelerator = this.accelerator;
            this.accelerator = keyStroke;
            this.firePropertyChange("accelerator", oldAccelerator, this.accelerator);
        }

        public KeyStroke getAccelerator() {
            return this.accelerator;
        }

        public void menuSelectionChanged(boolean isIncluded) {
            if (this.previousCount <= 1) {
                this.setArmed(isIncluded);
            } else {
                super.menuSelectionChanged(isIncluded);
            }
        }

        public void setSelected(boolean s) {
            if (this.isEnabled() || !s) {
                super.setSelected(s);
            }
        }

        public void setEnabled(boolean e) {
            super.setEnabled(e);
            if (!e) {
                super.setSelected(false);
            }
        }

        public void doClick(int pressTime) {
            if (!this.isEnabled()) {
                return;
            }
            if (this.oneItemListener != null) {
                this.oneItemListener.actionPerformed(null);
            } else {
                super.doClick(pressTime);
            }
        }
    }

    public static interface SubMenuModel {
        public int getCount();

        public String getLabel(int var1);

        public HelpCtx getHelpCtx(int var1);

        public void performActionAt(int var1);

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }

    public static class ToolbarToggleButton
    extends org.openide.awt.ToolbarToggleButton {
        static final long serialVersionUID = -4783163952526348942L;

        public ToolbarToggleButton(BooleanStateAction aAction) {
            super((Icon)null, false);
            Actions.connect((AbstractButton)this, aAction);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    public static class ToolbarButton
    extends org.openide.awt.ToolbarButton {
        static final long serialVersionUID = 6564434578524381134L;

        public ToolbarButton(SystemAction aAction) {
            super((Icon)null);
            Actions.connect((AbstractButton)this, aAction);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    public static class CheckboxMenuItem
    extends JCheckBoxMenuItem {
        static final long serialVersionUID = 6190621106981774043L;

        public CheckboxMenuItem(BooleanStateAction aAction, boolean useMnemonic) {
            Actions.connect(this, aAction, !useMnemonic);
        }
    }

    public static class MenuItem
    extends JMenuItem {
        static final long serialVersionUID = -21757335363267194L;

        public MenuItem(SystemAction aAction, boolean useMnemonic) {
            Actions.connect((JMenuItem)this, aAction, !useMnemonic);
        }
    }

    private static final class SubMenuBridge
    extends MenuBridge
    implements ChangeListener,
    Runnable {
        private SubMenuModel model;
        private SubMenu menu;

        public SubMenuBridge(SubMenu item, SystemAction action, SubMenuModel model, boolean popup) {
            super(item, action, popup);
            Actions.prepareMargins(item, action);
            this.menu = item;
            this.model = model;
        }

        public void addNotify() {
            super.addNotify();
            this.model.addChangeListener(this);
            this.generateSubMenu();
        }

        public void removeNotify() {
            this.model.removeChangeListener(this);
            super.removeNotify();
        }

        public void stateChanged(ChangeEvent ev) {
            Mutex.EVENT.readAccess(this);
        }

        public void run() {
            this.generateSubMenu();
        }

        private void generateSubMenu() {
            boolean shouldUpdate;
            block15: {
                shouldUpdate = false;
                try {
                    this.menu.removeAll();
                    int cnt = this.model.getCount();
                    if (cnt != this.menu.previousCount) {
                        shouldUpdate = true;
                    }
                    this.menu.previousCount = cnt;
                    if (this.menu.oneItemListener != null) {
                        this.menu.removeActionListener(this.menu.oneItemListener);
                    }
                    if (cnt == 0) {
                        this.menu.setEnabled(false);
                        if (this.menu.oneItemListener != null) {
                            this.menu.removeActionListener(this.menu.oneItemListener);
                            this.menu.oneItemListener = null;
                        }
                        Object var10_3 = null;
                        if (shouldUpdate) {
                            this.menu.updateUI();
                        }
                        return;
                    }
                    this.menu.setEnabled(true);
                    if (cnt == 1) {
                        this.menu.oneItemListener = new ISubActionListener(0, this.model);
                        this.menu.addActionListener(this.menu.oneItemListener);
                        HelpCtx help = this.model.getHelpCtx(0);
                        this.associateHelp(this.menu, help == null ? Actions.findHelp(this.action) : help);
                        break block15;
                    }
                    boolean addSeparator = false;
                    int count = this.model.getCount();
                    int i = 0;
                    while (i < count) {
                        String label = this.model.getLabel(i);
                        if (label == null) {
                            addSeparator = this.menu.getComponentCount() > 0;
                        } else {
                            if (addSeparator) {
                                this.menu.addSeparator();
                                addSeparator = false;
                            }
                            JMenuItem item = new JMenuItem();
                            Actions.setMenuText(item, label, true);
                            if (i == 0) {
                                Actions.updateKey(item, this.action);
                            }
                            item.addActionListener(new ISubActionListener(i, this.model));
                            HelpCtx help = this.model.getHelpCtx(i);
                            this.associateHelp(item, help == null ? Actions.findHelp(this.action) : help);
                            this.menu.add(item);
                        }
                        ++i;
                    }
                    this.associateHelp(this.menu, Actions.findHelp(this.action));
                }
                catch (Throwable throwable) {
                    Object var10_5 = null;
                    if (shouldUpdate) {
                        this.menu.updateUI();
                    }
                    throw throwable;
                }
            }
            Object var10_4 = null;
            if (shouldUpdate) {
                this.menu.updateUI();
            }
        }

        private void associateHelp(JComponent comp, HelpCtx help) {
            if (help != null && !help.equals(HelpCtx.DEFAULT_HELP) && help.getHelpID() != null) {
                HelpCtx.setHelpIDString(comp, help.getHelpID());
            } else {
                HelpCtx.setHelpIDString(comp, null);
            }
        }

        private static class ISubActionListener
        implements ActionListener {
            int index;
            SubMenuModel support;

            public ISubActionListener(int index, SubMenuModel support) {
                this.index = index;
                this.support = support;
            }

            public void actionPerformed(ActionEvent e) {
                this.support.performActionAt(this.index);
            }
        }
    }

    private static final class CheckMenuBridge
    extends BooleanButtonBridge {
        private boolean popup;

        public CheckMenuBridge(JCheckBoxMenuItem item, BooleanStateAction action, boolean popup) {
            super((AbstractButton)item, action);
            this.popup = popup;
            if (popup) {
                Actions.prepareMargins(item, action);
            }
        }

        public void updateState(String changedProperty) {
            Object s;
            super.updateState(changedProperty);
            if (changedProperty == null || !changedProperty.equals("accelerator")) {
                Actions.updateKey((JMenuItem)this.comp, this.action);
            }
            if ((changedProperty == null || changedProperty.equals("name")) && (s = this.action.getValue("Name")) instanceof String) {
                Actions.setMenuText((JMenuItem)this.comp, (String)s, !this.popup);
            }
        }

        protected boolean useTextIcons() {
            return false;
        }
    }

    private static class MenuBridge
    extends ButtonBridge {
        private boolean popup;

        public MenuBridge(JMenuItem item, Action action, boolean popup) {
            super(item, action);
            this.popup = popup;
            if (popup) {
                Actions.prepareMargins(item, action);
            }
        }

        public void updateState(String changedProperty) {
            Object s;
            Object i;
            if (changedProperty == null || changedProperty.equals("enabled")) {
                this.button.setEnabled(this.action.isEnabled());
            }
            if (changedProperty == null || !changedProperty.equals("accelerator")) {
                Actions.updateKey((JMenuItem)this.comp, this.action);
            }
            if (!this.popup && (changedProperty == null || changedProperty.equals("icon")) && (i = this.action.getValue("SmallIcon")) instanceof Icon) {
                this.button.setIcon((Icon)i);
            }
            if ((changedProperty == null || changedProperty.equals("name")) && (s = this.action.getValue("Name")) instanceof String) {
                Actions.setMenuText((JMenuItem)this.comp, (String)s, !this.popup);
            }
        }

        protected boolean useTextIcons() {
            return false;
        }
    }

    private static class BooleanButtonBridge
    extends ButtonBridge {
        public BooleanButtonBridge(AbstractButton button, BooleanStateAction action) {
            super(button, (Action)action);
        }

        public void updateState(String changedProperty) {
            super.updateState(changedProperty);
            if (changedProperty == null || changedProperty.equals("booleanState")) {
                this.button.setSelected(((BooleanStateAction)this.action).getBooleanState());
            }
        }
    }

    private static class ButtonBridge
    extends Bridge
    implements ActionListener {
        protected AbstractButton button;
        static /* synthetic */ Class class$org$openide$awt$Actions;

        public ButtonBridge(AbstractButton button, Action action) {
            super(button, action);
            button.addActionListener(this);
            this.button = button;
        }

        public void updateState(String changedProperty) {
            String shortDesc;
            boolean didToolTip = false;
            if (changedProperty == null || changedProperty.equals("enabled")) {
                this.button.setEnabled(this.action.isEnabled());
            }
            if (changedProperty == null || changedProperty.equals("icon")) {
                if (this.action instanceof SystemAction) {
                    SystemAction sa = (SystemAction)this.action;
                    this.button.setIcon(sa.getIcon(this.useTextIcons()));
                } else {
                    Object i = this.action.getValue("SmallIcon");
                    if (i instanceof Icon) {
                        this.button.setIcon((Icon)i);
                    }
                }
            }
            if ((changedProperty == null || changedProperty.equals("ShortDescription")) && (shortDesc = (String)this.action.getValue("ShortDescription")) != null && !shortDesc.equals(this.action.getValue("Name"))) {
                this.button.setToolTipText(shortDesc);
                didToolTip = true;
            }
            if (!didToolTip && (changedProperty == null || changedProperty.equals("globalKeymap"))) {
                String tip = Actions.findKey(this.action);
                String an = Actions.cutAmpersand((String)this.action.getValue("Name"));
                if (tip == null || tip.equals("")) {
                    this.button.setToolTipText(an);
                } else {
                    this.button.setToolTipText(NbBundle.getMessage(class$org$openide$awt$Actions == null ? (class$org$openide$awt$Actions = ButtonBridge.class$("org.openide.awt.Actions")) : class$org$openide$awt$Actions, "FMT_ButtonHint", an, tip));
                }
            }
            if (this.button instanceof Accessible && (changedProperty == null || changedProperty.equals("Name"))) {
                this.button.getAccessibleContext().setAccessibleName((String)this.action.getValue("Name"));
            }
        }

        protected boolean useTextIcons() {
            return true;
        }

        public void actionPerformed(ActionEvent ev) {
            Actions.invokeAction(this.action, ev);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static abstract class Bridge
    implements PropertyChangeListener {
        protected JComponent comp;
        protected Action action;

        public Bridge(JComponent comp, Action action) {
            this.comp = comp;
            this.action = action;
            this.comp.addPropertyChangeListener(new VisL());
            if (this.comp.isShowing()) {
                this.addNotify();
            }
            Actions.addKeymapListener(this);
            HelpCtx help = Actions.findHelp(action);
            if (help != null && !help.equals(HelpCtx.DEFAULT_HELP) && help.getHelpID() != null) {
                HelpCtx.setHelpIDString(comp, help.getHelpID());
            }
        }

        public void addNotify() {
            this.action.addPropertyChangeListener(this);
            this.updateState(null);
        }

        public void removeNotify() {
            this.action.removePropertyChangeListener(this);
        }

        public abstract void updateState(String var1);

        public void propertyChange(PropertyChangeEvent ev) {
            Mutex.EVENT.readAccess(new Runnable(this, ev){
                private final /* synthetic */ PropertyChangeEvent val$ev;
                private final /* synthetic */ Bridge this$0;
                {
                    this.this$0 = this$0;
                    this.val$ev = val$ev;
                }

                public void run() {
                    this.this$0.updateState(this.val$ev.getPropertyName());
                }
            });
        }

        private class VisL
        implements PropertyChangeListener {
            private VisL() {
            }

            public void propertyChange(PropertyChangeEvent ev) {
                if ("ancestor".equals(ev.getPropertyName())) {
                    if (ev.getNewValue() != null) {
                        Bridge.this.addNotify();
                    } else {
                        Bridge.this.removeNotify();
                    }
                }
            }
        }
    }
}

