/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.openide.ErrorManager;
import org.openide.awt.SwingBrowserImpl;
import org.openide.awt.ToolbarButton;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class HtmlBrowser
extends JPanel {
    static final long serialVersionUID = 2912844785502987960L;
    public static final int DEFAULT_WIDTH = 400;
    public static final int DEFAULT_HEIGHT = 600;
    private static Factory browserFactory;
    private static String homePage;
    private static ResourceBundle resourceBundle;
    private static MessageFormat msgFormat;
    private static Icon iBack;
    private static Icon iForward;
    private static Icon iHome;
    private static Icon iReload;
    private static Icon iStop;
    private static Icon iHistory;
    private Impl browserImpl;
    private boolean everythinkIListenInCheckBoxIsUnimportant = false;
    private boolean toolbarVisible = false;
    private boolean statusLineVisible = false;
    private BrowserListener browserListener;
    private JButton bBack;
    private JButton bForward;
    private JButton bHome;
    private JButton bReload;
    private JButton bStop;
    private JButton bHistory;
    private JComboBox cbLocation;
    private JLabel cbLabel;
    private JLabel lStatusLine;
    private Component browserComponent;
    private JPanel head;
    static /* synthetic */ Class class$org$openide$awt$HtmlBrowser;
    static /* synthetic */ Class class$org$openide$awt$HtmlBrowser$Factory;

    public static void setHomePage(String u) {
        homePage = u;
    }

    public static String getHomePage() {
        if (homePage == null) {
            return NbBundle.getMessage(class$org$openide$awt$HtmlBrowser == null ? (class$org$openide$awt$HtmlBrowser = HtmlBrowser.class$("org.openide.awt.HtmlBrowser")) : class$org$openide$awt$HtmlBrowser, "PROP_HomePage");
        }
        return homePage;
    }

    public static void setFactory(Factory brFactory) {
        browserFactory = brFactory;
    }

    public HtmlBrowser() {
        this(true, true);
    }

    public HtmlBrowser(boolean toolbar, boolean statusLine) {
        this(null, toolbar, statusLine);
    }

    public HtmlBrowser(Factory fact, boolean toolbar, boolean statusLine) {
        HtmlBrowser.init();
        try {
            if (fact == null) {
                Impl[] arr = new Impl[1];
                this.browserComponent = HtmlBrowser.findComponent(arr);
                this.browserImpl = arr[0];
            } else {
                try {
                    this.browserImpl = fact.createHtmlBrowserImpl();
                    this.browserComponent = this.browserImpl.getComponent();
                }
                catch (UnsupportedOperationException ex) {
                    ErrorManager.getDefault().notify(ex);
                    this.browserImpl = new SwingBrowserImpl();
                    this.browserComponent = this.browserImpl.getComponent();
                }
            }
        }
        catch (RuntimeException e) {
            ErrorManager em = ErrorManager.getDefault();
            em.annotate((Throwable)e, resourceBundle.getString("EXC_Module"));
            em.notify(e);
        }
        this.setLayout(new BorderLayout(0, 2));
        this.add((Component)(this.browserComponent != null ? new JScrollPane(this.browserComponent) : new JScrollPane()), "Center");
        this.browserListener = new BrowserListener();
        if (toolbar) {
            this.initToolbar();
        }
        if (statusLine) {
            this.initStatusLine();
        }
        this.browserImpl.addPropertyChangeListener(this.browserListener);
        this.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_HtmlBrowser"));
    }

    private static Component findComponent(Impl[] handle) {
        Factory f;
        Lookup.Result r = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$awt$HtmlBrowser$Factory == null ? (class$org$openide$awt$HtmlBrowser$Factory = HtmlBrowser.class$("org.openide.awt.HtmlBrowser$Factory")) : class$org$openide$awt$HtmlBrowser$Factory));
        Iterator it = r.allInstances().iterator();
        while (it.hasNext()) {
            f = (Factory)it.next();
            try {
                Component c;
                Impl impl = f.createHtmlBrowserImpl();
                Component component = c = impl != null ? impl.getComponent() : null;
                if (c == null) continue;
                handle[0] = impl;
                return c;
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
        }
        f = browserFactory;
        if (f != null) {
            try {
                handle[0] = f.createHtmlBrowserImpl();
                return handle[0].getComponent();
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
        }
        handle[0] = new SwingBrowserImpl();
        return handle[0].getComponent();
    }

    private static void init() {
        if (iBack != null) {
            return;
        }
        resourceBundle = NbBundle.getBundle(class$org$openide$awt$HtmlBrowser == null ? (class$org$openide$awt$HtmlBrowser = HtmlBrowser.class$("org.openide.awt.HtmlBrowser")) : class$org$openide$awt$HtmlBrowser);
        iBack = new ImageIcon((class$org$openide$awt$HtmlBrowser == null ? (class$org$openide$awt$HtmlBrowser = HtmlBrowser.class$("org.openide.awt.HtmlBrowser")) : class$org$openide$awt$HtmlBrowser).getResource("/org/openide/resources/html/back.gif"));
        iForward = new ImageIcon((class$org$openide$awt$HtmlBrowser == null ? (class$org$openide$awt$HtmlBrowser = HtmlBrowser.class$("org.openide.awt.HtmlBrowser")) : class$org$openide$awt$HtmlBrowser).getResource("/org/openide/resources/html/forward.gif"));
        iHome = new ImageIcon((class$org$openide$awt$HtmlBrowser == null ? (class$org$openide$awt$HtmlBrowser = HtmlBrowser.class$("org.openide.awt.HtmlBrowser")) : class$org$openide$awt$HtmlBrowser).getResource("/org/openide/resources/html/home.gif"));
        iReload = new ImageIcon((class$org$openide$awt$HtmlBrowser == null ? (class$org$openide$awt$HtmlBrowser = HtmlBrowser.class$("org.openide.awt.HtmlBrowser")) : class$org$openide$awt$HtmlBrowser).getResource("/org/openide/resources/html/refresh.gif"));
        iStop = new ImageIcon((class$org$openide$awt$HtmlBrowser == null ? (class$org$openide$awt$HtmlBrowser = HtmlBrowser.class$("org.openide.awt.HtmlBrowser")) : class$org$openide$awt$HtmlBrowser).getResource("/org/openide/resources/html/stop.gif"));
        iHistory = new ImageIcon((class$org$openide$awt$HtmlBrowser == null ? (class$org$openide$awt$HtmlBrowser = HtmlBrowser.class$("org.openide.awt.HtmlBrowser")) : class$org$openide$awt$HtmlBrowser).getResource("/org/openide/resources/html/history.gif"));
        msgFormat = new MessageFormat(resourceBundle.getString("CTL_Html_viewer_title"));
    }

    private void initToolbar() {
        this.toolbarVisible = true;
        this.head = new JPanel();
        this.head.setLayout(new BorderLayout(11, 0));
        JPanel p = new JPanel(new GridBagLayout());
        this.bBack = new ToolbarButton(iBack);
        p.add(this.bBack);
        this.bBack.setToolTipText(resourceBundle.getString("CTL_Back"));
        this.bBack.setMnemonic(resourceBundle.getString("CTL_Back_Mnemonic").charAt(0));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 5);
        this.bForward = new ToolbarButton(iForward);
        p.add((Component)this.bForward, gbc);
        this.bForward.setToolTipText(resourceBundle.getString("CTL_Forward"));
        this.bForward.setMnemonic(resourceBundle.getString("CTL_Forward_Mnemonic").charAt(0));
        this.bStop = new ToolbarButton(iStop);
        p.add(this.bStop);
        this.bStop.setToolTipText(resourceBundle.getString("CTL_Stop"));
        this.bStop.setMnemonic(resourceBundle.getString("CTL_Stop_Mnemonic").charAt(0));
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 5);
        this.bReload = new ToolbarButton(iReload);
        p.add((Component)this.bReload, gbc);
        this.bReload.setToolTipText(resourceBundle.getString("CTL_Reload"));
        this.bReload.setMnemonic(resourceBundle.getString("CTL_Reload_Mnemonic").charAt(0));
        this.bHome = new ToolbarButton(iHome);
        p.add(this.bHome);
        this.bHome.setToolTipText(resourceBundle.getString("CTL_Home"));
        this.bHome.setMnemonic(resourceBundle.getString("CTL_Home_Mnemonic").charAt(0));
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 5);
        this.bHistory = new ToolbarButton(iHistory);
        p.add((Component)this.bHistory, gbc);
        this.bHistory.setToolTipText(resourceBundle.getString("CTL_History"));
        this.bHistory.setMnemonic(resourceBundle.getString("CTL_History_Mnemonic").charAt(0));
        if (this.browserImpl != null) {
            this.bBack.setEnabled(this.browserImpl.isBackward());
            this.bForward.setEnabled(this.browserImpl.isForward());
            this.bHistory.setEnabled(this.browserImpl.isHistory());
        }
        JToolBar.Separator ts = new JToolBar.Separator();
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 5);
        p.add((Component)ts, gbc);
        ts.updateUI();
        this.cbLabel = new JLabel(resourceBundle.getString("CTL_Location"));
        p.add(this.cbLabel);
        this.cbLabel.setDisplayedMnemonic(resourceBundle.getString("CTL_Location_Mnemonic").charAt(0));
        this.head.add("West", p);
        this.cbLocation = new JComboBox();
        this.head.add("Center", this.cbLocation);
        this.cbLocation.setEditable(true);
        this.cbLabel.setLabelFor(this.cbLocation);
        this.add((Component)this.head, "North");
        this.cbLocation.addActionListener(this.browserListener);
        this.bHistory.addActionListener(this.browserListener);
        this.bBack.addActionListener(this.browserListener);
        this.bForward.addActionListener(this.browserListener);
        this.bReload.addActionListener(this.browserListener);
        this.bHome.addActionListener(this.browserListener);
        this.bStop.addActionListener(this.browserListener);
        this.bHistory.getAccessibleContext().setAccessibleName(this.bHistory.getToolTipText());
        this.bBack.getAccessibleContext().setAccessibleName(this.bBack.getToolTipText());
        this.bForward.getAccessibleContext().setAccessibleName(this.bForward.getToolTipText());
        this.bReload.getAccessibleContext().setAccessibleName(this.bReload.getToolTipText());
        this.bHome.getAccessibleContext().setAccessibleName(this.bHome.getToolTipText());
        this.bStop.getAccessibleContext().setAccessibleName(this.bStop.getToolTipText());
        this.cbLocation.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_HtmlBrowser_Location"));
    }

    private void destroyToolbar() {
        this.remove(this.head);
        this.head = null;
        this.toolbarVisible = false;
    }

    private void initStatusLine() {
        this.statusLineVisible = true;
        this.lStatusLine = new JLabel(resourceBundle.getString("CTL_Loading"));
        this.add((Component)this.lStatusLine, "South");
        this.lStatusLine.setLabelFor(this);
    }

    private void destroyStatusLine() {
        this.remove(this.lStatusLine);
        this.lStatusLine = null;
        this.statusLineVisible = false;
    }

    public void setURL(String str) {
        URL URL2;
        try {
            URL2 = new URL(str);
        }
        catch (MalformedURLException ee) {
            try {
                URL2 = new URL("http://" + str);
            }
            catch (MalformedURLException e) {
                ErrorManager.getDefault().notify(e);
                return;
            }
        }
        this.setURL(URL2);
    }

    public void setURL(final URL url) {
        if (url == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean sameHosts;
                boolean bl = sameHosts = url.getHost() != null && HtmlBrowser.this.browserImpl.getURL() != null && url.getHost().equals(HtmlBrowser.this.browserImpl.getURL().getHost());
                if (url.equals(HtmlBrowser.this.browserImpl.getURL()) && sameHosts) {
                    HtmlBrowser.this.browserImpl.reloadDocument();
                } else {
                    HtmlBrowser.this.browserImpl.setURL(url);
                }
            }
        });
    }

    public final URL getDocumentURL() {
        return this.browserImpl.getURL();
    }

    public final void setEnableHome(boolean b) {
        this.bHome.setEnabled(b);
        this.bHome.setVisible(b);
    }

    public final void setEnableLocation(boolean b) {
        this.cbLocation.setEditable(b);
        this.cbLocation.setVisible(b);
        this.cbLabel.setVisible(b);
    }

    public boolean isStatusLineVisible() {
        return this.statusLineVisible;
    }

    public void setStatusLineVisible(boolean v) {
        if (v == this.statusLineVisible) {
            return;
        }
        if (v) {
            this.initStatusLine();
        } else {
            this.destroyStatusLine();
        }
    }

    public boolean isToolbarVisible() {
        return this.toolbarVisible;
    }

    public void setToolbarVisible(boolean v) {
        if (v == this.toolbarVisible) {
            return;
        }
        if (v) {
            this.initToolbar();
        } else {
            this.destroyToolbar();
        }
    }

    private final void firePropertyChangeAccess(String name, String o, String n) {
        super.firePropertyChange(name, o, n);
    }

    public Dimension getPreferredSize() {
        Dimension superPref = super.getPreferredSize();
        return new Dimension(Math.max(400, superPref.width), Math.max(600, superPref.height));
    }

    public void requestFocus() {
        if (this.browserComponent != null) {
            boolean ownerFound = false;
            if (this.browserComponent instanceof JComponent) {
                ownerFound = ((JComponent)this.browserComponent).requestDefaultFocus();
            }
            if (!ownerFound) {
                this.browserComponent.requestFocus();
            }
        } else {
            super.requestFocus();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleHtmlBrowser();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        homePage = null;
    }

    private class AccessibleHtmlBrowser
    extends JPanel.AccessibleJPanel {
        private AccessibleHtmlBrowser() {
            super(HtmlBrowser.this);
        }

        public void setAccessibleName(String name) {
            super.setAccessibleName(name);
            if (HtmlBrowser.this.browserComponent instanceof Accessible) {
                HtmlBrowser.this.browserComponent.getAccessibleContext().setAccessibleName(name);
            }
        }

        public void setAccessibleDescription(String desc) {
            super.setAccessibleDescription(desc);
            if (HtmlBrowser.this.browserComponent instanceof Accessible) {
                HtmlBrowser.this.browserComponent.getAccessibleContext().setAccessibleDescription(desc);
            }
        }
    }

    public static interface Factory {
        public Impl createHtmlBrowserImpl();
    }

    public static abstract class Impl {
        static final long serialVersionUID = 2912844785502962114L;
        public static final String PROP_STATUS_MESSAGE = "statusMessage";
        public static final String PROP_URL = "url";
        public static final String PROP_TITLE = "title";
        public static final String PROP_FORWARD = "forward";
        public static final String PROP_BACKWARD = "backward";
        public static final String PROP_HISTORY = "history";

        public abstract Component getComponent();

        public abstract void reloadDocument();

        public abstract void stopLoading();

        public abstract void setURL(URL var1);

        public abstract URL getURL();

        public abstract String getStatusMessage();

        public abstract String getTitle();

        public abstract boolean isForward();

        public abstract void forward();

        public abstract boolean isBackward();

        public abstract void backward();

        public abstract boolean isHistory();

        public abstract void showHistory();

        public abstract void addPropertyChangeListener(PropertyChangeListener var1);

        public abstract void removePropertyChangeListener(PropertyChangeListener var1);
    }

    private static class BrowserReplacer
    implements Externalizable {
        static final long serialVersionUID = 5915713034827048413L;
        private transient BrowserComponent bComp = null;
        transient boolean statLine;
        transient boolean toolbar;
        transient URL url;

        public BrowserReplacer() {
        }

        public BrowserReplacer(BrowserComponent comp) {
            this.bComp = comp;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeBoolean(this.bComp.isStatusLineVisible());
            out.writeBoolean(this.bComp.isToolbarVisible());
            out.writeObject(this.bComp.getDocumentURL());
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.statLine = in.readBoolean();
            this.toolbar = in.readBoolean();
            this.url = (URL)in.readObject();
        }

        private Object readResolve() throws ObjectStreamException {
            try {
                if (this.url.getProtocol().equals("http") && InetAddress.getByName(this.url.getHost()).equals(InetAddress.getLocalHost())) {
                    this.url.openStream();
                }
            }
            catch (UnknownHostException exc) {
            }
            catch (SecurityException exc) {
            }
            catch (NullPointerException exc) {
            }
            catch (IOException exc) {
                return null;
            }
            catch (Exception exc) {
                ErrorManager.getDefault().notify(1, exc);
            }
            this.bComp = new BrowserComponent(this.statLine, this.toolbar);
            this.bComp.setURL(this.url);
            return this.bComp;
        }
    }

    public static class BrowserComponent
    extends CloneableTopComponent {
        static final long serialVersionUID = 2912844785502987960L;
        public static final String MODE_NAME = "webbrowser";
        private HtmlBrowser browserComponent;
        static /* synthetic */ Class class$org$openide$awt$HtmlBrowser;
        static /* synthetic */ Class class$org$openide$awt$HtmlBrowser$BrowserComponent;

        public BrowserComponent() {
            this(true, true);
        }

        public BrowserComponent(boolean toolbar, boolean statusLine) {
            this(null, toolbar, statusLine);
        }

        public BrowserComponent(Factory fact, boolean toolbar, boolean statusLine) {
            this.setName("");
            this.setLayout(new BorderLayout());
            this.browserComponent = new HtmlBrowser(fact, toolbar, statusLine);
            this.add((Component)this.browserComponent, "Center");
            this.browserComponent.browserImpl.addPropertyChangeListener(new PropertyChangeListener(this){
                private final /* synthetic */ BrowserComponent this$0;
                {
                    this.this$0 = this$0;
                }

                public void propertyChange(PropertyChangeEvent e) {
                    if (!e.getPropertyName().equals("title")) {
                        return;
                    }
                    String title = HtmlBrowser.access$100(BrowserComponent.access$1500(this.this$0)).getTitle();
                    if (title == null || title.length() < 1) {
                        return;
                    }
                    this.this$0.setName(title);
                }
            });
            this.putClientProperty("PersistenceType", "OnlyOpened");
            if (this.browserComponent.browserComponent != null) {
                this.putClientProperty("InternalBrowser", Boolean.TRUE);
            }
            this.setToolTipText(NbBundle.getBundle(class$org$openide$awt$HtmlBrowser == null ? (class$org$openide$awt$HtmlBrowser = BrowserComponent.class$("org.openide.awt.HtmlBrowser")) : class$org$openide$awt$HtmlBrowser).getString("HINT_WebBrowser"));
        }

        public void open(Workspace workspace) {
            Mode tcMode;
            if (this.browserComponent.browserComponent == null) {
                return;
            }
            Workspace realWorkspace = workspace == null ? WindowManager.getDefault().getCurrentWorkspace() : workspace;
            Mode mode = realWorkspace.findMode(MODE_NAME);
            if (mode == null) {
                mode = realWorkspace.createMode(MODE_NAME, NbBundle.getBundle(class$org$openide$awt$HtmlBrowser == null ? (class$org$openide$awt$HtmlBrowser = BrowserComponent.class$("org.openide.awt.HtmlBrowser")) : class$org$openide$awt$HtmlBrowser).getString("CTL_WebBrowser"), (class$org$openide$awt$HtmlBrowser == null ? (class$org$openide$awt$HtmlBrowser = BrowserComponent.class$("org.openide.awt.HtmlBrowser")) : class$org$openide$awt$HtmlBrowser).getResource("/org/openide/resources/html/htmlView.gif"));
            }
            if ((tcMode = realWorkspace.findMode(this)) == null) {
                mode.dockInto(this);
            }
            super.open(workspace);
        }

        protected Object writeReplace() throws ObjectStreamException {
            return new BrowserReplacer(this);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.setStatusLineVisible(in.readBoolean());
            this.setToolbarVisible(in.readBoolean());
            this.browserComponent.setURL((URL)in.readObject());
        }

        protected CloneableTopComponent createClonedObject() {
            BrowserComponent bc = new BrowserComponent();
            bc.setURL(this.getDocumentURL());
            return bc;
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$openide$awt$HtmlBrowser$BrowserComponent == null ? (class$org$openide$awt$HtmlBrowser$BrowserComponent = BrowserComponent.class$("org.openide.awt.HtmlBrowser$BrowserComponent")) : class$org$openide$awt$HtmlBrowser$BrowserComponent);
        }

        protected void componentActivated() {
            this.browserComponent.browserImpl.getComponent().requestFocus();
            super.componentActivated();
        }

        public Image getIcon() {
            return new ImageIcon((class$org$openide$awt$HtmlBrowser == null ? (class$org$openide$awt$HtmlBrowser = BrowserComponent.class$("org.openide.awt.HtmlBrowser")) : class$org$openide$awt$HtmlBrowser).getResource("/org/openide/resources/html/htmlView.gif")).getImage();
        }

        public void setURL(String str) {
            this.browserComponent.setURL(str);
        }

        public void setURL(URL url) {
            this.browserComponent.setURL(url);
        }

        public final URL getDocumentURL() {
            return this.browserComponent.getDocumentURL();
        }

        public final void setEnableHome(boolean b) {
            this.browserComponent.setEnableHome(b);
        }

        public final void setEnableLocation(boolean b) {
            this.browserComponent.setEnableLocation(b);
        }

        public boolean isStatusLineVisible() {
            return this.browserComponent.isStatusLineVisible();
        }

        public void setStatusLineVisible(boolean v) {
            this.browserComponent.setStatusLineVisible(v);
        }

        public boolean isToolbarVisible() {
            return this.browserComponent.isToolbarVisible();
        }

        public void setToolbarVisible(boolean v) {
            this.browserComponent.setToolbarVisible(v);
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.browserComponent.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.browserComponent.removePropertyChangeListener(l);
        }

        static /* synthetic */ HtmlBrowser access$1500(BrowserComponent x0) {
            return x0.browserComponent;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class BrowserListener
    implements ActionListener,
    PropertyChangeListener {
        private BrowserListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String property = evt.getPropertyName();
            if (property == null) {
                return;
            }
            if (property.equals("url") || property.equals("title")) {
                HtmlBrowser.super.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
            if (property.equals("url")) {
                if (HtmlBrowser.this.toolbarVisible) {
                    HtmlBrowser.this.everythinkIListenInCheckBoxIsUnimportant = true;
                    String url = HtmlBrowser.this.browserImpl.getURL().toString();
                    HtmlBrowser.this.cbLocation.setSelectedItem(url);
                    HtmlBrowser.this.everythinkIListenInCheckBoxIsUnimportant = false;
                }
            } else if (property.equals("statusMessage")) {
                String s = HtmlBrowser.this.browserImpl.getStatusMessage();
                if (s == null || s.length() < 1) {
                    s = resourceBundle.getString("CTL_Document_done");
                }
                if (HtmlBrowser.this.lStatusLine != null) {
                    HtmlBrowser.this.lStatusLine.setText(s);
                }
            } else if (property.equals("forward") && HtmlBrowser.this.bForward != null) {
                HtmlBrowser.this.bForward.setEnabled(HtmlBrowser.this.browserImpl.isForward());
            } else if (property.equals("backward") && HtmlBrowser.this.bBack != null) {
                HtmlBrowser.this.bBack.setEnabled(HtmlBrowser.this.browserImpl.isBackward());
            } else if (property.equals("history") && HtmlBrowser.this.bHistory != null) {
                HtmlBrowser.this.bHistory.setEnabled(HtmlBrowser.this.browserImpl.isHistory());
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == HtmlBrowser.this.cbLocation) {
                if (HtmlBrowser.this.everythinkIListenInCheckBoxIsUnimportant) {
                    return;
                }
                JComboBox cb = (JComboBox)e.getSource();
                Object o = cb.getSelectedItem();
                if (o == null) {
                    return;
                }
                HtmlBrowser.this.setURL((String)o);
                ComboBoxModel lm = cb.getModel();
                int k = lm.getSize();
                int i = 0;
                while (i < k) {
                    if (o.equals(lm.getElementAt(i))) break;
                    ++i;
                }
                if (i != k) {
                    return;
                }
                if (k == 20) {
                    cb.removeItem(lm.getElementAt(k - 1));
                }
                cb.insertItemAt(o, 0);
            } else if (e.getSource() == HtmlBrowser.this.bHistory) {
                HtmlBrowser.this.browserImpl.showHistory();
            } else if (e.getSource() == HtmlBrowser.this.bBack) {
                HtmlBrowser.this.browserImpl.backward();
            } else if (e.getSource() == HtmlBrowser.this.bForward) {
                HtmlBrowser.this.browserImpl.forward();
            } else if (e.getSource() == HtmlBrowser.this.bReload) {
                HtmlBrowser.this.browserImpl.reloadDocument();
            } else if (e.getSource() == HtmlBrowser.this.bHome) {
                HtmlBrowser.this.setURL(homePage);
            } else if (e.getSource() == HtmlBrowser.this.bStop) {
                HtmlBrowser.this.browserImpl.stopLoading();
            }
        }
    }
}

