/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.awt.AWTTask;
import org.openide.awt.Actions;
import org.openide.awt.ExecBridge;
import org.openide.awt.JMenuPlus;
import org.openide.cookies.InstanceCookie;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderInstance;
import org.openide.loaders.InstanceSupport;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.WeakListener;
import org.openide.util.actions.Presenter;

public class MenuBar
extends JMenuBar
implements Externalizable {
    private MenuBarFolder menuBarFolder;
    private ArrayList normalMenus = new ArrayList();
    static final long serialVersionUID = -4721949937356581268L;

    public MenuBar() {
    }

    public MenuBar(DataFolder folder) {
        this.startLoading(folder == null ? TopManager.getDefault().getPlaces().folders().menus() : folder);
        if (folder != null) {
            this.getAccessibleContext().setAccessibleDescription(folder.getName());
        }
    }

    public void waitFinished() {
        this.menuBarFolder.instanceFinished();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.menuBarFolder.getFolder());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.startLoading((DataFolder)in.readObject());
    }

    void removeMenus() {
        int i = 0;
        while (i < this.normalMenus.size()) {
            this.remove((Component)this.normalMenus.get(i));
            ++i;
        }
        this.normalMenus.clear();
    }

    void addNormalMenu(JMenu menu) {
        this.add((Component)menu, this.normalMenus.size());
        this.normalMenus.add(menu);
    }

    void startLoading(DataFolder folder) {
        this.menuBarFolder = new MenuBarFolder(folder);
    }

    static void allInstances(InstanceCookie[] arr, List list) {
        ErrorManager err = ErrorManager.getDefault();
        Exception ex = null;
        int i = 0;
        while (i < arr.length) {
            Exception newEx = null;
            try {
                Object o = arr[i].instanceCreate();
                list.add(o);
            }
            catch (ClassNotFoundException e) {
                newEx = e;
            }
            catch (IOException e) {
                newEx = e;
            }
            if (newEx != null) {
                if (err.findAnnotations(newEx) == null) {
                    err.annotate(newEx, 1, null, null, null, null);
                }
                err.copyAnnotation(newEx, ex);
                ex = newEx;
            }
            ++i;
        }
        if (ex != null) {
            err.notify(ex);
        }
    }

    private static class LazyMenu
    extends JMenuPlus
    implements NodeListener {
        DataFolder master;
        boolean icon;
        MenuFolder slave;

        public LazyMenu(DataFolder df, boolean icon) {
            this.master = df;
            this.icon = icon;
            Node n = this.master.getNodeDelegate();
            n.addNodeListener(WeakListener.node(this, n));
            this.updateProps();
        }

        private void updateProps() {
            Node n = this.master.getNodeDelegate();
            Actions.setMenuText(this, n.getDisplayName(), true);
            if (this.icon) {
                this.setIcon(new ImageIcon(n.getIcon(1)));
            }
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if ("displayName".equals(ev.getPropertyName()) || "name".equals(ev.getPropertyName()) || "icon".equals(ev.getPropertyName())) {
                this.updateProps();
            }
        }

        public void childrenAdded(NodeMemberEvent ev) {
        }

        public void childrenRemoved(NodeMemberEvent ev) {
        }

        public void childrenReordered(NodeReorderEvent ev) {
        }

        public void nodeDestroyed(NodeEvent ev) {
        }

        public JPopupMenu getPopupMenu() {
            this.doInitialize();
            return super.getPopupMenu();
        }

        private void doInitialize() {
            if (this.slave == null) {
                this.slave = new MenuFolder();
                this.slave.waitFinished();
            }
        }

        private class MenuFolder
        extends FolderInstance {
            static /* synthetic */ Class class$org$openide$awt$MenuBar$LazyMenu;
            static /* synthetic */ Class class$javax$swing$JMenu;
            static /* synthetic */ Class class$org$openide$util$actions$Presenter$Menu;
            static /* synthetic */ Class class$javax$swing$JMenuItem;
            static /* synthetic */ Class class$javax$swing$JSeparator;
            static /* synthetic */ Class class$javax$swing$Action;
            static /* synthetic */ Class class$org$openide$awt$MenuBar;

            public MenuFolder() {
                super(LazyMenu.this.master);
                this.recreate();
            }

            public String instanceName() {
                return (class$org$openide$awt$MenuBar$LazyMenu == null ? (class$org$openide$awt$MenuBar$LazyMenu = MenuFolder.class$("org.openide.awt.MenuBar$LazyMenu")) : class$org$openide$awt$MenuBar$LazyMenu).getName();
            }

            public Class instanceClass() {
                return class$javax$swing$JMenu == null ? (class$javax$swing$JMenu = MenuFolder.class$("javax.swing.JMenu")) : class$javax$swing$JMenu;
            }

            protected InstanceCookie acceptDataObject(DataObject dob) {
                InstanceCookie ic = super.acceptDataObject(dob);
                if (ic == null) {
                    JMenuItem item = ExecBridge.createMenuItem(dob);
                    return item != null ? new InstanceSupport.Instance(item) : null;
                }
                return ic;
            }

            protected InstanceCookie acceptCookie(InstanceCookie cookie) throws IOException, ClassNotFoundException {
                Class c;
                boolean is = (class$org$openide$util$actions$Presenter$Menu == null ? (class$org$openide$util$actions$Presenter$Menu = MenuFolder.class$("org.openide.util.actions.Presenter$Menu")) : class$org$openide$util$actions$Presenter$Menu).isAssignableFrom(c = cookie.instanceClass()) || (class$javax$swing$JMenuItem == null ? (class$javax$swing$JMenuItem = MenuFolder.class$("javax.swing.JMenuItem")) : class$javax$swing$JMenuItem).isAssignableFrom(c) || (class$javax$swing$JSeparator == null ? (class$javax$swing$JSeparator = MenuFolder.class$("javax.swing.JSeparator")) : class$javax$swing$JSeparator).isAssignableFrom(c) || (class$javax$swing$Action == null ? (class$javax$swing$Action = MenuFolder.class$("javax.swing.Action")) : class$javax$swing$Action).isAssignableFrom(c);
                return is ? cookie : null;
            }

            protected InstanceCookie acceptFolder(DataFolder df) {
                return new InstanceSupport.Instance(new LazyMenu(df, true));
            }

            protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
                LazyMenu m = LazyMenu.this;
                LinkedList cInstances = new LinkedList();
                MenuBar.allInstances(cookies, cInstances);
                m.removeAll();
                if (cInstances.isEmpty()) {
                    JMenuItem item = new JMenuItem(NbBundle.getMessage(class$org$openide$awt$MenuBar == null ? (class$org$openide$awt$MenuBar = MenuFolder.class$("org.openide.awt.MenuBar")) : class$org$openide$awt$MenuBar, "CTL_EmptyMenu"));
                    item.setEnabled(false);
                    m.add(item);
                }
                boolean addSeparator = false;
                Iterator it = cInstances.iterator();
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (obj instanceof Presenter.Menu) {
                        obj = ((Presenter.Menu)obj).getMenuPresenter();
                    }
                    if (obj instanceof JMenuItem) {
                        if (addSeparator) {
                            m.addSeparator();
                            addSeparator = false;
                        }
                        m.add((JMenuItem)obj);
                        continue;
                    }
                    if (obj instanceof JSeparator) {
                        addSeparator = LazyMenu.this.getMenuComponentCount() > 0;
                        continue;
                    }
                    if (!(obj instanceof Action)) continue;
                    Action a = (Action)obj;
                    JMenuItem item = new JMenuItem();
                    Actions.connect(item, a, false);
                    m.add(item);
                }
                return m;
            }

            protected Task postCreationTask(Runnable run) {
                return new AWTTask(run);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }
    }

    private final class MenuBarFolder
    extends FolderInstance {
        static /* synthetic */ Class class$org$openide$awt$MenuBar;
        static /* synthetic */ Class class$javax$swing$JMenu;

        public MenuBarFolder(DataFolder folder) {
            super(folder);
            this.recreate();
        }

        public String instanceName() {
            return (class$org$openide$awt$MenuBar == null ? (class$org$openide$awt$MenuBar = MenuBarFolder.class$("org.openide.awt.MenuBar")) : class$org$openide$awt$MenuBar).getName();
        }

        public Class instanceClass() {
            return class$org$openide$awt$MenuBar == null ? (class$org$openide$awt$MenuBar = MenuBarFolder.class$("org.openide.awt.MenuBar")) : class$org$openide$awt$MenuBar;
        }

        protected InstanceCookie acceptCookie(InstanceCookie cookie) throws IOException, ClassNotFoundException {
            return (class$javax$swing$JMenu == null ? (class$javax$swing$JMenu = MenuBarFolder.class$("javax.swing.JMenu")) : class$javax$swing$JMenu).isAssignableFrom(cookie.instanceClass()) ? cookie : null;
        }

        protected InstanceCookie acceptFolder(DataFolder df) {
            return new InstanceSupport.Instance(new LazyMenu(df, false));
        }

        protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
            LinkedList ll = new LinkedList();
            MenuBar.allInstances(cookies, ll);
            MenuBar mb = MenuBar.this;
            mb.removeMenus();
            Iterator it = ll.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (!(obj instanceof JMenu)) continue;
                mb.addNormalMenu((JMenu)obj);
            }
            mb.validate();
            mb.repaint();
            return mb;
        }

        DataFolder getFolder() {
            return this.folder;
        }

        protected Task postCreationTask(Runnable run) {
            return new AWTTask(run);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

