/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class MouseUtils {
    private static int DOUBLE_CLICK_DELTA = 300;
    private static int tempx = 0;
    private static int tempy = 0;
    private static long temph = 0L;
    private static int tempm = 0;

    public static boolean isRightMouseButton(MouseEvent e) {
        return SwingUtilities.isRightMouseButton(e);
    }

    public static boolean isLeftMouseButton(MouseEvent e) {
        return SwingUtilities.isLeftMouseButton(e);
    }

    public static boolean isDoubleClick(MouseEvent e) {
        return e.getClickCount() % 2 == 0 || MouseUtils.isDoubleClickImpl(e);
    }

    private static boolean isDoubleClickImpl(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        long h = e.getWhen();
        int m = e.getModifiers();
        if (tempx == x && tempy == y && h - temph < (long)DOUBLE_CLICK_DELTA && m == tempm) {
            tempx = 0;
            tempy = 0;
            temph = 0L;
            tempm = 0;
            return true;
        }
        tempx = x;
        tempy = y;
        temph = h;
        tempm = m;
        return false;
    }

    public static abstract class PopupMouseAdapter
    extends MouseAdapter {
        public static final int DEFAULT_THRESHOLD = 5;
        int threshold;
        Point pressedPos;

        public PopupMouseAdapter() {
            this(5);
        }

        public PopupMouseAdapter(int threshold) {
            this.threshold = threshold;
        }

        public void mousePressed(MouseEvent e) {
            if (this.pressedPos != null) {
                this.pressedPos = null;
                return;
            }
            int m = e.getModifiers();
            if ((m & 8) != 0 || (m & 4) != 0) {
                this.pressedPos = e.getPoint();
            }
        }

        public void mouseReleased(MouseEvent e) {
            int m = e.getModifiers();
            if (((m & 8) != 0 || (m & 4) != 0) && this.pressedPos != null) {
                Point pos = e.getPoint();
                if (Math.abs(this.pressedPos.x - pos.x) < this.threshold && Math.abs(this.pressedPos.y - pos.y) < this.threshold) {
                    this.showPopup(e);
                }
                this.pressedPos = null;
            }
        }

        protected abstract void showPopup(MouseEvent var1);
    }
}

