/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import org.openide.awt.JPopupMenuPlus;
import org.openide.util.NbBundle;

public class SplittedPanel
extends JComponent
implements Accessible {
    static final long serialVersionUID = 5058424218525927233L;
    public static final int NONE = 0;
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 2;
    public static final Object ADD_SPLITTER = new Integer(0);
    public static final Object ADD_FIRST = new Integer(1);
    public static final Object ADD_SECOND = new Integer(2);
    public static final Object ADD_LEFT = ADD_FIRST;
    public static final Object ADD_TOP = ADD_FIRST;
    public static final Object ADD_RIGHT = ADD_SECOND;
    public static final Object ADD_BOTTOM = ADD_SECOND;
    public static final int FIRST_PREFERRED = -1;
    public static final int SECOND_PREFERRED = -2;
    public static final int RAISED_SPLITTER = 0;
    public static final int EMPTY_SPLITTER = 1;
    public static final int DEFAULT_SPLITTER = 0;
    private int resetPosition = -1;
    private Boolean popupMenuEnabled;
    private static MessageFormat nameFormat = null;
    private static MessageFormat descriptionFormat = null;
    private Component firstComponent = null;
    private Component secondComponent = null;
    private Component splitter = new DefaultSplitter(3);
    private int splitterType = 0;
    private transient MouseListenerAdapter mouseAdapter;
    private int splitType = 0;
    private int splitPosition = 50;
    private boolean absolute = false;
    private boolean dragable = true;
    private boolean continuousLayout = true;
    private boolean splitTypeChangeEnabled = true;
    private boolean swapPanesEnabled = true;
    private boolean keepSecondSame = false;
    private boolean keepFirstSame = false;
    private transient boolean splitIsChanging = false;
    private int dragPos = -1;
    private boolean dragging = false;
    private boolean panesSwapped = false;
    private static final int DEFAULT_SPLIT_TYPE = 2;
    private static final int DEFAULT_SPLITTER_SIZE = 7;
    private transient JPopupMenu popupMenu;
    private transient JCheckBoxMenuItem verticalCMI;
    private transient JCheckBoxMenuItem horizontalCMI;
    private transient JMenuItem swapCMI;
    private transient JMenuItem splitterCMI;
    private transient Vector listeners;
    private AccessibleContext accessibleContext = null;
    static /* synthetic */ Class class$org$openide$awt$SplittedPanel;

    public SplittedPanel() {
        this.setLayout(new SplitLayout());
        this.add(this.splitter, ADD_SPLITTER);
        this.init();
    }

    private void init() {
        this.setSplitterCursor();
        this.mouseAdapter = new MouseListenerAdapter();
        if (this.dragable) {
            this.splitter.addMouseMotionListener(this.mouseAdapter);
            this.splitter.addMouseListener(this.mouseAdapter);
            this.addSplitChangeListener(this.mouseAdapter);
        }
        this.initAccessible();
    }

    public void updateUI() {
        super.updateUI();
        this.updateSplitting();
    }

    protected void updateSplitting() {
        if (this.firstComponent != null && this.secondComponent != null) {
            this.invalidate();
            this.firstComponent.invalidate();
            this.splitter.invalidate();
            this.secondComponent.invalidate();
            this.validate();
        }
    }

    protected void computeSizesAfterFlip() {
        if (this.firstComponent == null || this.secondComponent == null) {
            return;
        }
        Dimension ourSize = this.getSize();
        switch (this.splitType) {
            case 1: {
                if (ourSize.width == 0) break;
                int splitterSize = this.splitter.getPreferredSize().height;
                int newHeight = (ourSize.height - splitterSize) * this.firstComponent.getSize().width / ourSize.width;
                this.firstComponent.setSize(new Dimension(ourSize.width, newHeight));
                this.secondComponent.setSize(new Dimension(ourSize.width, ourSize.height - newHeight - splitterSize));
                break;
            }
            case 2: {
                if (ourSize.height == 0) break;
                int splitterSize = this.splitter.getPreferredSize().width;
                int newWidth = (ourSize.width - splitterSize) * this.firstComponent.getSize().height / ourSize.height;
                this.firstComponent.setSize(new Dimension(newWidth, ourSize.height));
                this.secondComponent.setSize(new Dimension(ourSize.width - newWidth - splitterSize, ourSize.height));
            }
        }
    }

    protected void setSplitterCursor() {
        if (this.dragable) {
            if (this.splitType == 1) {
                this.splitter.setCursor(Cursor.getPredefinedCursor(8));
            } else {
                this.splitter.setCursor(Cursor.getPredefinedCursor(10));
            }
        } else {
            this.splitter.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private boolean isPopupMenuEnabled() {
        if (this.popupMenuEnabled == null) {
            Object o = this.getClientProperty("popupMenuEnabled");
            this.popupMenuEnabled = o instanceof Boolean ? (Boolean)o : Boolean.TRUE;
        }
        return this.popupMenuEnabled;
    }

    protected void updatePopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenuPlus();
            ResourceBundle awtBundle = NbBundle.getBundle(class$org$openide$awt$SplittedPanel == null ? (class$org$openide$awt$SplittedPanel = SplittedPanel.class$("org.openide.awt.SplittedPanel")) : class$org$openide$awt$SplittedPanel);
            this.verticalCMI = new JCheckBoxMenuItem(awtBundle.getString("SplittedPanelVertical"));
            this.popupMenu.add(this.verticalCMI);
            this.horizontalCMI = new JCheckBoxMenuItem(awtBundle.getString("SplittedPanelHorizontal"));
            this.popupMenu.add(this.horizontalCMI);
            this.popupMenu.add(new JSeparator());
            this.swapCMI = new JMenuItem(awtBundle.getString("SplittedPanelSwap"));
            this.popupMenu.add(this.swapCMI);
            this.popupMenu.add(new JSeparator());
            this.splitterCMI = new JMenuItem(awtBundle.getString("ResetSplitter"));
            this.popupMenu.add(this.splitterCMI);
            ActionListener al = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (SplittedPanel.this.horizontalCMI.equals(e.getSource())) {
                        SplittedPanel.this.setSplitType(2);
                    } else {
                        SplittedPanel.this.setSplitType(1);
                    }
                }
            };
            this.verticalCMI.addActionListener(al);
            this.horizontalCMI.addActionListener(al);
            this.swapCMI.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SplittedPanel.this.swapPanes();
                }
            });
            this.splitterCMI.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SplittedPanel.this.resetSplitter();
                }
            });
        }
        if (this.splitType == 1) {
            this.verticalCMI.setState(true);
            this.horizontalCMI.setState(false);
        } else {
            this.verticalCMI.setState(false);
            this.horizontalCMI.setState(true);
        }
        if (this.splitTypeChangeEnabled) {
            this.verticalCMI.setEnabled(true);
            this.horizontalCMI.setEnabled(true);
        } else {
            this.verticalCMI.setEnabled(false);
            this.horizontalCMI.setEnabled(false);
        }
        if (this.swapPanesEnabled) {
            this.swapCMI.setEnabled(true);
        } else {
            this.swapCMI.setEnabled(false);
        }
        this.splitterCMI.setEnabled(this.getSplitPosition() != -1 && this.getSplitPosition() != -2);
    }

    private void resetSplitter() {
        if (this.getSplitPosition() != -1 && this.getSplitPosition() != -2) {
            this.setSplitPosition(this.resetPosition);
            if (this.splitterCMI != null) {
                this.splitterCMI.setEnabled(false);
            }
        }
    }

    public void swapPanes() {
        if (!this.swapPanesEnabled) {
            return;
        }
        if (this.firstComponent == null || this.secondComponent == null) {
            return;
        }
        this.splitIsChanging = true;
        boolean bl = this.panesSwapped = !this.panesSwapped;
        if (this.keepSecondSame) {
            this.keepSecondSame = false;
            this.keepFirstSame = true;
        } else if (this.keepFirstSame) {
            this.keepSecondSame = true;
            this.keepFirstSame = false;
        }
        Component aFirstComponent = this.firstComponent;
        Component aSecondComponent = this.secondComponent;
        this.remove(aFirstComponent);
        this.remove(aSecondComponent);
        this.add(aSecondComponent, ADD_FIRST);
        this.add(aFirstComponent, ADD_SECOND);
        this.updateSplitting();
        this.splitIsChanging = false;
    }

    public boolean getPanesSwapped() {
        return this.panesSwapped;
    }

    public int getSplitType() {
        return this.splitType;
    }

    public void setSplitType(int value) {
        if (this.splitType == value) {
            return;
        }
        int oldSplitType = this.splitType;
        this.splitType = value;
        if (oldSplitType != 0 && this.splitType != 0) {
            this.computeSizesAfterFlip();
        }
        this.setSplitterCursor();
        this.updateSplitting();
        this.updatePopupMenu();
        this.initAccessible();
    }

    public int getSplitPosition() {
        return this.splitPosition;
    }

    public void setSplitPosition(int value) {
        if (this.splitPosition == value) {
            return;
        }
        int oldValue = this.splitPosition;
        this.splitPosition = value;
        this.splitIsChanging = true;
        this.updateSplitting();
        this.fireSplitChange(oldValue, this.splitPosition);
        this.splitIsChanging = false;
    }

    public int getSplitterType() {
        return this.splitterType;
    }

    public void setSplitterType(int type) {
        if (this.splitterType == type) {
            return;
        }
        this.splitterType = type;
        switch (this.splitterType) {
            case 1: {
                this.splitter = new EmptySplitter();
                break;
            }
            default: {
                this.splitter = new DefaultSplitter(3);
            }
        }
        this.add(this.splitter, ADD_SPLITTER);
        this.updateSplitting();
    }

    public Component getSplitterComponent() {
        return this.splitter;
    }

    public void setSplitterComponent(Component comp) {
        if (this.splitter == comp) {
            return;
        }
        if (this.dragable) {
            this.splitter.removeMouseMotionListener(this.mouseAdapter);
            this.splitter.removeMouseListener(this.mouseAdapter);
        }
        this.remove(this.splitter);
        this.splitter = comp;
        this.add(this.splitter, ADD_SPLITTER);
        if (this.dragable) {
            this.splitter.addMouseMotionListener(this.mouseAdapter);
            this.splitter.addMouseListener(this.mouseAdapter);
        }
        this.setSplitterCursor();
        this.updateSplitting();
    }

    public boolean isSplitAbsolute() {
        return this.absolute;
    }

    public void setSplitAbsolute(boolean value) {
        if (this.absolute == value) {
            return;
        }
        this.absolute = value;
        this.updateSplitting();
    }

    public boolean isSplitDragable() {
        return this.dragable;
    }

    public void setSplitDragable(boolean value) {
        if (this.dragable == value) {
            return;
        }
        this.dragable = value;
        if (this.dragable) {
            this.splitter.addMouseMotionListener(this.mouseAdapter);
            this.splitter.addMouseListener(this.mouseAdapter);
        } else {
            this.splitter.removeMouseMotionListener(this.mouseAdapter);
            this.splitter.removeMouseListener(this.mouseAdapter);
        }
        this.setSplitterCursor();
    }

    public boolean isContinuousLayout() {
        return this.continuousLayout;
    }

    public void setContinuousLayout(boolean value) {
        this.continuousLayout = value;
    }

    public boolean getKeepFirstSame() {
        return this.keepFirstSame;
    }

    public void setKeepFirstSame(boolean value) {
        this.keepFirstSame = value;
    }

    public boolean getKeepSecondSame() {
        return this.keepSecondSame;
    }

    public void setKeepSecondSame(boolean value) {
        this.keepSecondSame = value;
    }

    public boolean isSplitTypeChangeEnabled() {
        return this.splitTypeChangeEnabled;
    }

    public void setSplitTypeChangeEnabled(boolean value) {
        if (this.splitTypeChangeEnabled == value) {
            return;
        }
        this.splitTypeChangeEnabled = value;
        this.updatePopupMenu();
    }

    public boolean isSwapPanesEnabled() {
        return this.swapPanesEnabled;
    }

    public void setSwapPanesEnabled(boolean value) {
        if (this.swapPanesEnabled == value) {
            return;
        }
        this.swapPanesEnabled = value;
        this.updatePopupMenu();
    }

    public void addSplitChangeListener(SplitChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(l);
    }

    public void removeSplitChangeListener(SplitChangeListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(l);
    }

    protected void fireSplitChange(int oldValue, int newValue) {
        Vector l;
        if (this.listeners == null) {
            return;
        }
        SplittedPanel splittedPanel = this;
        synchronized (splittedPanel) {
            l = (Vector)this.listeners.clone();
        }
        Enumeration en = l.elements();
        SplitChangeEvent evt = new SplitChangeEvent(this, oldValue, newValue);
        while (en.hasMoreElements()) {
            SplitChangeListener scl = (SplitChangeListener)en.nextElement();
            scl.splitChanged(evt);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.SPLIT_PANE;
                }
            };
            this.initAccessible();
        }
        return this.accessibleContext;
    }

    private void initAccessible() {
        ResourceBundle bundle;
        if (nameFormat == null) {
            bundle = NbBundle.getBundle(class$org$openide$awt$SplittedPanel == null ? (class$org$openide$awt$SplittedPanel = SplittedPanel.class$("org.openide.awt.SplittedPanel")) : class$org$openide$awt$SplittedPanel);
            nameFormat = new MessageFormat(bundle.getString("ACS_SplittedPanel_Name"));
        }
        this.getAccessibleContext().setAccessibleName(nameFormat.format(new Object[]{this.firstComponent == null || !(this.firstComponent instanceof Accessible) ? null : this.firstComponent.getAccessibleContext().getAccessibleName(), this.secondComponent == null || !(this.secondComponent instanceof Accessible) ? null : this.secondComponent.getAccessibleContext().getAccessibleName()}));
        if (descriptionFormat == null) {
            bundle = NbBundle.getBundle(class$org$openide$awt$SplittedPanel == null ? (class$org$openide$awt$SplittedPanel = SplittedPanel.class$("org.openide.awt.SplittedPanel")) : class$org$openide$awt$SplittedPanel);
            descriptionFormat = new MessageFormat(bundle.getString("ACS_SplittedPanel_Description"));
        }
        this.getAccessibleContext().setAccessibleDescription(descriptionFormat.format(new Object[]{this.firstComponent == null || !(this.firstComponent instanceof Accessible) ? null : this.firstComponent.getAccessibleContext().getAccessibleDescription(), this.secondComponent == null || !(this.secondComponent instanceof Accessible) ? null : this.secondComponent.getAccessibleContext().getAccessibleDescription()}));
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.init();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SplitLayout
    implements LayoutManager2,
    Serializable {
        static final long serialVersionUID = 2034500275182524789L;

        SplitLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
            throw new IllegalArgumentException("You must use the add(Component, Object) method for adding");
        }

        public void addLayoutComponent(Component comp, Object constraints) {
            if (constraints == ADD_SPLITTER) {
                SplittedPanel.this.splitter = comp;
            } else if (constraints == ADD_FIRST) {
                if (SplittedPanel.this.firstComponent != null && SplittedPanel.this.secondComponent == null) {
                    SplittedPanel.this.secondComponent = SplittedPanel.this.firstComponent;
                }
                SplittedPanel.this.firstComponent = comp;
                if (SplittedPanel.this.secondComponent != null && SplittedPanel.this.splitType == 0) {
                    SplittedPanel.this.splitType = 2;
                }
            } else if (constraints == ADD_SECOND) {
                if (SplittedPanel.this.firstComponent == null) {
                    SplittedPanel.this.firstComponent = comp;
                } else {
                    SplittedPanel.this.secondComponent = comp;
                    if (SplittedPanel.this.splitType == 0) {
                        SplittedPanel.this.splitType = 2;
                    }
                }
            } else {
                throw new IllegalArgumentException("You must use one of the SplittedPanel.ADD_XXX constraints Objects");
            }
            SplittedPanel.this.initAccessible();
        }

        public void removeLayoutComponent(Component comp) {
            if (comp.equals(SplittedPanel.this.secondComponent)) {
                SplittedPanel.this.secondComponent = null;
            } else if (comp.equals(SplittedPanel.this.firstComponent)) {
                SplittedPanel.this.firstComponent = null;
                if (SplittedPanel.this.secondComponent != null) {
                    SplittedPanel.this.firstComponent = SplittedPanel.this.secondComponent;
                    SplittedPanel.this.secondComponent = null;
                }
            }
            SplittedPanel.this.initAccessible();
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension d;
            int width = 0;
            int height = 0;
            if (SplittedPanel.this.firstComponent != null) {
                d = SplittedPanel.this.firstComponent.getPreferredSize();
                width = d.width;
                height = d.height;
            }
            if (SplittedPanel.this.secondComponent != null) {
                d = SplittedPanel.this.secondComponent.getPreferredSize();
                if (SplittedPanel.this.splitType == 1) {
                    int splitterSize = ((SplittedPanel)SplittedPanel.this).splitter.getPreferredSize().height;
                    if (width < d.width) {
                        width = d.width;
                    }
                    height += splitterSize + d.height;
                } else {
                    int splitterSize = ((SplittedPanel)SplittedPanel.this).splitter.getPreferredSize().width;
                    if (height < d.height) {
                        height = d.height;
                    }
                    width += splitterSize + d.width;
                }
            }
            return new Dimension(width, height);
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension d;
            int width = 0;
            int height = 0;
            if (SplittedPanel.this.firstComponent != null) {
                d = SplittedPanel.this.firstComponent.getMinimumSize();
                width = d.width;
                height = d.height;
            }
            if (SplittedPanel.this.secondComponent != null) {
                d = SplittedPanel.this.secondComponent.getMinimumSize();
                if (SplittedPanel.this.splitType == 1) {
                    int splitterSize = ((SplittedPanel)SplittedPanel.this).splitter.getMinimumSize().height;
                    if (width < d.width) {
                        width = d.width;
                    }
                    height += splitterSize + d.height;
                } else {
                    int splitterSize = ((SplittedPanel)SplittedPanel.this).splitter.getMinimumSize().width;
                    if (height < d.height) {
                        height = d.height;
                    }
                    width += splitterSize + d.width;
                }
            }
            return new Dimension(width, height);
        }

        public void layoutContainer(Container parent) {
            Dimension d = parent.getSize();
            int sPosition = SplittedPanel.this.splitPosition;
            if (SplittedPanel.this.splitPosition == -1) {
                sPosition = SplittedPanel.this.splitType == 1 ? ((SplittedPanel)SplittedPanel.this).firstComponent.getPreferredSize().height : ((SplittedPanel)SplittedPanel.this).firstComponent.getPreferredSize().width;
            } else if (SplittedPanel.this.splitPosition == -2) {
                sPosition = SplittedPanel.this.splitType == 1 ? d.height - ((SplittedPanel)SplittedPanel.this).splitter.getPreferredSize().width - ((SplittedPanel)SplittedPanel.this).secondComponent.getPreferredSize().height : d.width - ((SplittedPanel)SplittedPanel.this).splitter.getPreferredSize().height - ((SplittedPanel)SplittedPanel.this).secondComponent.getPreferredSize().width;
            } else if (!SplittedPanel.this.absolute) {
                int sp = SplittedPanel.this.splitPosition;
                if (sp > 100) {
                    sp = 100;
                }
                sPosition = SplittedPanel.this.splitType == 1 ? d.height * sp / 100 : d.width * sp / 100;
            }
            if (SplittedPanel.this.splitType != 0 && SplittedPanel.this.firstComponent != null && SplittedPanel.this.secondComponent != null) {
                int splitterSize;
                if (SplittedPanel.this.splitType == 1) {
                    splitterSize = ((SplittedPanel)SplittedPanel.this).splitter.getPreferredSize().height;
                    if (SplittedPanel.this.keepSecondSame && !SplittedPanel.this.splitIsChanging) {
                        Dimension secondSize = SplittedPanel.this.secondComponent.getSize();
                        if (secondSize.height != 0) {
                            sPosition = d.height - secondSize.height - splitterSize;
                        }
                    }
                    if (sPosition + splitterSize > d.height) {
                        sPosition = d.height - splitterSize;
                    }
                    if (sPosition < 0) {
                        sPosition = 0;
                    }
                    SplittedPanel.this.firstComponent.setBounds(new Rectangle(0, 0, d.width, sPosition));
                    SplittedPanel.this.splitter.setBounds(new Rectangle(0, sPosition, d.width, splitterSize));
                    SplittedPanel.this.secondComponent.setBounds(new Rectangle(0, sPosition + splitterSize, d.width, d.height - sPosition - splitterSize));
                } else {
                    splitterSize = ((SplittedPanel)SplittedPanel.this).splitter.getPreferredSize().width;
                    if (SplittedPanel.this.keepSecondSame && !SplittedPanel.this.splitIsChanging) {
                        Dimension secondSize = SplittedPanel.this.secondComponent.getSize();
                        if (secondSize.width != 0) {
                            sPosition = d.width - secondSize.width - splitterSize;
                        }
                    }
                    if (sPosition + splitterSize > d.width) {
                        sPosition = d.width - splitterSize;
                    }
                    if (sPosition < 0) {
                        sPosition = 0;
                    }
                    SplittedPanel.this.firstComponent.setBounds(new Rectangle(0, 0, sPosition, d.height));
                    SplittedPanel.this.splitter.setBounds(new Rectangle(sPosition, 0, splitterSize, d.height));
                    SplittedPanel.this.secondComponent.setBounds(new Rectangle(sPosition + splitterSize, 0, d.width - sPosition - splitterSize, d.height));
                }
            } else if (SplittedPanel.this.firstComponent != null) {
                SplittedPanel.this.firstComponent.setBounds(new Rectangle(0, 0, d.width - 1, d.height - 1));
                if (SplittedPanel.this.splitter != null) {
                    SplittedPanel.this.splitter.setBounds(0, 0, 0, 0);
                }
            }
        }

        public Dimension maximumLayoutSize(Container target) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        public void invalidateLayout(Container target) {
        }
    }

    class MouseListenerAdapter
    extends MouseAdapter
    implements MouseListener,
    MouseMotionListener,
    SplitChangeListener {
        MouseListenerAdapter() {
        }

        public void mousePressed(MouseEvent e) {
            if ((e.getModifiers() & 4) != 0) {
                SplittedPanel.this.updatePopupMenu();
                if (SplittedPanel.this.isPopupMenuEnabled()) {
                    SplittedPanel.this.popupMenu.show(SplittedPanel.this.splitter, e.getX(), e.getY());
                }
            } else {
                SplittedPanel.this.dragging = true;
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (SplittedPanel.this.dragging && !SplittedPanel.this.continuousLayout) {
                SplittedPanel.this.dragging = false;
                if (SplittedPanel.this.dragPos == -1) {
                    return;
                }
                if (!SplittedPanel.this.absolute) {
                    Dimension d = SplittedPanel.this.getSize();
                    if (SplittedPanel.this.splitType == 1) {
                        SplittedPanel.this.dragPos = 100 * SplittedPanel.this.dragPos / d.height;
                    } else {
                        SplittedPanel.this.dragPos = 100 * SplittedPanel.this.dragPos / d.width;
                    }
                }
                SplittedPanel.this.setSplitPosition(SplittedPanel.this.dragPos);
                SplittedPanel.this.dragPos = -1;
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (SplittedPanel.this.dragging && SplittedPanel.this.continuousLayout) {
                Dimension d = SplittedPanel.this.getSize();
                Point splitterPos = SplittedPanel.this.splitter.getLocation();
                e.translatePoint(splitterPos.x, splitterPos.y);
                if (SplittedPanel.this.splitType == 1) {
                    SplittedPanel.this.dragPos = e.getY();
                    if (SplittedPanel.this.dragPos > d.height) {
                        SplittedPanel.this.dragPos = d.height;
                    }
                } else {
                    SplittedPanel.this.dragPos = e.getX();
                    if (SplittedPanel.this.dragPos > d.width) {
                        SplittedPanel.this.dragPos = d.width;
                    }
                }
                if (SplittedPanel.this.dragPos < 0) {
                    SplittedPanel.this.dragPos = 0;
                }
                if (SplittedPanel.this.continuousLayout) {
                    if (SplittedPanel.this.dragPos == -1) {
                        return;
                    }
                    int newDragPos = SplittedPanel.this.dragPos;
                    if (!SplittedPanel.this.absolute) {
                        newDragPos = SplittedPanel.this.splitType == 1 ? 100 * SplittedPanel.this.dragPos / d.height : 100 * SplittedPanel.this.dragPos / d.width;
                    }
                    SplittedPanel.this.setSplitPosition(newDragPos);
                }
            }
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && SplittedPanel.this.isPopupMenuEnabled()) {
                SplittedPanel.this.resetSplitter();
            }
        }

        public void splitChanged(SplitChangeEvent evt) {
            if (evt.getNewValue() == -1 || evt.getNewValue() == -2) {
                SplittedPanel.this.resetPosition = evt.getNewValue();
                if (SplittedPanel.this.splitterCMI != null) {
                    SplittedPanel.this.splitterCMI.setEnabled(true);
                }
            }
        }
    }

    class DefaultSplitter
    extends JComponent
    implements Accessible {
        private int splitterSize;
        static final long serialVersionUID = -4223135481223014719L;

        public DefaultSplitter(int aSplitterSize) {
            this.splitterSize = aSplitterSize;
            if (this.splitterSize < 2) {
                this.splitterSize = 2;
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.splitterSize, this.splitterSize);
        }

        public void paint(Graphics g) {
            Dimension size = this.getSize();
            if (SplittedPanel.this.splitType == 2) {
                int pos = (size.width - this.splitterSize) / 2;
                g.setColor(UIManager.getColor("controlLtHighlight"));
                g.drawLine(pos, 0, pos, size.height - 1);
                g.setColor(UIManager.getColor("control"));
                int i = 1;
                while (i < this.splitterSize - 2) {
                    g.drawLine(pos + i, 0, pos + i, size.height - 1);
                    ++i;
                }
                g.setColor(UIManager.getColor("controlDkShadow"));
                g.drawLine(pos + this.splitterSize - 1, 0, pos + this.splitterSize - 1, size.height - 1);
            } else if (SplittedPanel.this.splitType == 1) {
                int pos = (size.height - this.splitterSize) / 2;
                g.setColor(UIManager.getColor("controlLtHighlight"));
                g.drawLine(0, pos, size.width - 1, pos);
                g.setColor(UIManager.getColor("control"));
                int i = 1;
                while (i < this.splitterSize - 2) {
                    g.drawLine(0, pos + i, size.width - 1, pos + i);
                    ++i;
                }
                g.setColor(UIManager.getColor("controlDkShadow"));
                g.drawLine(0, pos + this.splitterSize - 1, size.width - 1, pos + this.splitterSize - 1);
            }
        }

        public AccessibleContext getAccessibleContext() {
            return SplittedPanel.this.getAccessibleContext();
        }
    }

    public static class EmptySplitter
    extends JComponent
    implements Accessible {
        static final long serialVersionUID = 929648193440460693L;
        private int width;
        private AccessibleContext accessibleContext;
        static /* synthetic */ Class class$org$openide$awt$SplittedPanel;

        public EmptySplitter() {
            this(0);
        }

        public EmptySplitter(int width) {
            ResourceBundle bundle = NbBundle.getBundle(class$org$openide$awt$SplittedPanel == null ? (class$org$openide$awt$SplittedPanel = EmptySplitter.class$("org.openide.awt.SplittedPanel")) : class$org$openide$awt$SplittedPanel);
            this.accessibleContext = null;
            this.width = width;
            this.getAccessibleContext().setAccessibleName(bundle.getString("ACS_SplittedPanel_EmptySplitter"));
            this.getAccessibleContext().setAccessibleName(bundle.getString("ACSD_SplittedPanel_EmptySplitter"));
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.width, this.width);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new JComponent.AccessibleJComponent(this){
                    private final /* synthetic */ EmptySplitter this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public AccessibleRole getAccessibleRole() {
                        return AccessibleRole.SPLIT_PANE;
                    }
                };
            }
            return this.accessibleContext;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class SplitChangeEvent
    extends EventObject {
        static final long serialVersionUID = 6748966611210836878L;
        private int oldValue;
        private int newValue;

        public SplitChangeEvent(SplittedPanel splittedPanel, int oldValue, int newValue) {
            super(splittedPanel);
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public int getOldValue() {
            return this.oldValue;
        }

        public int getNewValue() {
            return this.newValue;
        }
    }

    public static interface SplitChangeListener {
        public void splitChanged(SplitChangeEvent var1);
    }
}

