/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import com.sun.java.swing.plaf.windows.WindowsButtonUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.openide.awt.DisabledIcon;

class ToolbarButtonUI
extends WindowsButtonUI {
    static final long serialVersionUID = 5306796614639723529L;
    private static ImageIcon brush;
    Icon oldDisabledIcon;
    boolean oldFocusPainted;
    boolean oldBorderPainted;
    boolean oldRolloverEnabled;
    protected static final Insets defaultMargin;
    private static final ToolbarButtonUI toolbarButtonUI;

    ToolbarButtonUI() {
    }

    private ImageIcon getBrush() {
        if (brush != null) {
            return brush;
        }
        brush = new ImageIcon(((Object)((Object)this)).getClass().getResource("/org/netbeans/core/resources/plaf/crosshatch.gif"));
        return brush;
    }

    public static ComponentUI createUI(JComponent c) {
        return toolbarButtonUI;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        AbstractButton button = (AbstractButton)c;
        this.oldFocusPainted = button.isFocusPainted();
        this.oldBorderPainted = button.isBorderPainted();
        this.oldRolloverEnabled = button.isRolloverEnabled();
        button.setFocusPainted(false);
        button.setBorderPainted(false);
        button.setRolloverEnabled(true);
        ImageIcon icon = (ImageIcon)button.getDisabledIcon();
        if (icon instanceof DisabledIcon) {
            ((DisabledIcon)icon).setBorderPainted(true);
        } else if (icon instanceof ImageIcon) {
            button.setDisabledIcon(new DisabledIcon(icon.getImage()));
        }
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        AbstractButton button = (AbstractButton)c;
        button.setFocusPainted(this.oldFocusPainted);
        button.setBorderPainted(this.oldBorderPainted);
        button.setRolloverEnabled(this.oldRolloverEnabled);
        ImageIcon icon = (ImageIcon)button.getDisabledIcon();
        if (icon instanceof DisabledIcon) {
            ((DisabledIcon)icon).setBorderPainted(false);
        }
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton button = (AbstractButton)c;
        ButtonModel model = button.getModel();
        if (model.isSelected() && !model.isRollover()) {
            g.setClip(2, 2, button.getWidth() - 4, button.getHeight() - 4);
            this.getBrush().paintIcon(c, g, 0, 0);
            g.setClip(0, 0, button.getWidth(), button.getHeight());
        }
        super.paint(g, c);
        if (model.isEnabled()) {
            if (model.isSelected()) {
                this.draw3DRect(g, 1, 1, button.getWidth() - 2, button.getHeight() - 2, UIManager.getDefaults().getColor("controlShadow"), UIManager.getDefaults().getColor("controlLtHighlight"));
            } else if (model.isRollover()) {
                Color color1 = UIManager.getDefaults().getColor("controlLtHighlight");
                Color color2 = UIManager.getDefaults().getColor("controlShadow");
                if (model.isArmed() && model.isPressed()) {
                    color1 = UIManager.getDefaults().getColor("controlShadow");
                    color2 = UIManager.getDefaults().getColor("controlLtHighlight");
                }
                this.draw3DRect(g, 1, 1, button.getWidth() - 2, button.getHeight() - 2, color1, color2);
            }
        }
    }

    private void draw3DRect(Graphics g, int left, int top, int width, int height, Color topColor, Color bottomColor) {
        int right = left + width - 1;
        int bottom = top + height - 1;
        g.setColor(topColor);
        g.drawLine(right - 1, top, left, top);
        g.drawLine(left, top + 1, left, bottom - 1);
        g.setColor(bottomColor);
        g.drawLine(left, bottom, right, bottom);
        g.drawLine(right, bottom - 1, right, top);
    }

    public Insets getDefaultMargin(AbstractButton button) {
        return defaultMargin;
    }

    static {
        defaultMargin = new Insets(2, 1, 0, 1);
        toolbarButtonUI = new ToolbarButtonUI();
    }
}

