/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.awt.AWTTask;
import org.openide.awt.MouseUtils;
import org.openide.awt.Toolbar;
import org.openide.cookies.InstanceCookie;
import org.openide.loaders.DataFolder;
import org.openide.loaders.FolderInstance;
import org.openide.loaders.InstanceSupport;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public final class ToolbarPool
extends JComponent
implements Accessible {
    private static ToolbarPool defaultPool;
    private Folder instance;
    private DataFolder folder;
    private Map toolbars;
    private Map toolbarConfigs;
    private String name = "";
    private Component center;
    private PopupListener listener;
    private AccessibleContext accessibleContext = null;
    public static final String DEFAULT_CONFIGURATION = "Standard";
    private TPTaskListener taskListener;
    static final long serialVersionUID = 3420915387298484008L;

    public static synchronized ToolbarPool getDefault() {
        if (defaultPool == null) {
            defaultPool = new ToolbarPool(TopManager.getDefault().getPlaces().folders().toolbars());
            ToolbarPool.defaultPool.instance.recreate();
        }
        return defaultPool;
    }

    public ToolbarPool(DataFolder df) {
        this.folder = df;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(0, 0, 2, 0));
        this.listener = new PopupListener();
        this.toolbars = new TreeMap();
        this.toolbarConfigs = new TreeMap();
        this.instance = new Folder(df);
        this.getAccessibleContext().setAccessibleName(this.instance.instanceName());
        this.getAccessibleContext().setAccessibleDescription(this.instance.instanceName());
    }

    public final void waitFinished() {
        this.instance.instanceFinished();
    }

    void update(Map toolbars, Map conf) {
        this.toolbars = toolbars;
        this.toolbarConfigs = conf;
        if (!"".equals(this.name)) {
            this.setConfiguration(this.name);
        }
    }

    private synchronized void updateDefault() {
        JPanel tp = new JPanel(new FlowLayout(0));
        Toolbar[] list = this.getToolbars();
        int i = 0;
        while (i < list.length) {
            tp.add(list[i]);
            ++i;
        }
        this.name = "";
        this.revalidate(tp);
    }

    private synchronized void activate(Configuration c) {
        Component comp = c.activate();
        this.name = c.getName();
        this.revalidate(comp);
    }

    public void setToolbarsListener(Toolbar.DnDListener l) {
        Iterator it = this.toolbars.values().iterator();
        while (it.hasNext()) {
            ((Toolbar)it.next()).setDnDListener(l);
        }
    }

    private void revalidate(Component c) {
        if (c != this.center) {
            if (this.center != null) {
                this.remove(this.center);
                this.center.removeMouseListener(this.listener);
            }
            this.center = c;
            this.add(this.center, "Center");
            this.center.addMouseListener(this.listener);
            Window w = SwingUtilities.windowForComponent(this);
            if (w != null) {
                w.validate();
            }
        }
    }

    public final Toolbar findToolbar(String name) {
        return (Toolbar)this.toolbars.get(name);
    }

    public final String getConfiguration() {
        return this.name;
    }

    public final void setConfiguration(String n) {
        String old = this.name;
        if (!this.instance.isFinished()) {
            if (this.taskListener == null) {
                this.taskListener = new TPTaskListener();
                this.instance.addTaskListener(this.taskListener);
            }
            this.taskListener.setConfiguration(n);
            return;
        }
        if (this.taskListener != null) {
            this.instance.removeTaskListener(this.taskListener);
            this.taskListener = null;
        }
        Configuration config = null;
        if (n != null) {
            config = (Configuration)this.toolbarConfigs.get(n);
        }
        if (config != null) {
            this.activate(config);
        } else if (this.toolbarConfigs.isEmpty()) {
            this.updateDefault();
        } else {
            config = (Configuration)this.toolbarConfigs.get(DEFAULT_CONFIGURATION);
            if (config == null) {
                config = (Configuration)this.toolbarConfigs.values().iterator().next();
            }
            this.activate(config);
        }
        this.firePropertyChange("configuration", old, this.name);
    }

    public final DataFolder getFolder() {
        return this.folder;
    }

    public final synchronized Toolbar[] getToolbars() {
        Toolbar[] arr = new Toolbar[this.toolbars.size()];
        return this.toolbars.values().toArray(arr);
    }

    public final synchronized String[] getConfigurations() {
        String[] arr = new String[this.toolbarConfigs.size()];
        return this.toolbarConfigs.keySet().toArray(arr);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.TOOL_BAR;
                }
            };
        }
        return this.accessibleContext;
    }

    private static final class ComponentConfiguration
    extends JPopupMenu
    implements Configuration,
    ActionListener {
        private Component comp;
        static final long serialVersionUID = -409474484612485719L;

        ComponentConfiguration() {
        }

        public ComponentConfiguration(Component comp) {
            this.comp = comp;
        }

        public Component activate() {
            return this.comp;
        }

        public String getName() {
            return this.comp.getName();
        }

        public JPopupMenu getContextMenu() {
            this.removeAll();
            Iterator<String> it = Arrays.asList(ToolbarPool.getDefault().getConfigurations()).iterator();
            ButtonGroup bg = new ButtonGroup();
            String current = ToolbarPool.getDefault().getConfiguration();
            while (it.hasNext()) {
                String name;
                JRadioButtonMenuItem mi = new JRadioButtonMenuItem(name, (name = it.next()).compareTo(current) == 0);
                mi.addActionListener(this);
                bg.add(mi);
                this.add(mi);
            }
            return this;
        }

        public void actionPerformed(ActionEvent evt) {
            ToolbarPool.getDefault().setConfiguration(evt.getActionCommand());
        }
    }

    public static interface Configuration {
        public Component activate();

        public String getName();

        public JPopupMenu getContextMenu();
    }

    private class PopupListener
    extends MouseUtils.PopupMouseAdapter {
        PopupListener() {
        }

        protected void showPopup(MouseEvent e) {
            Configuration conf = (Configuration)ToolbarPool.this.toolbarConfigs.get(ToolbarPool.this.name);
            if (conf != null) {
                JPopupMenu pop = conf.getContextMenu();
                pop.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class Folder
    extends FolderInstance {
        private WeakHashMap foldersCache = new WeakHashMap(15);
        private ToolbarPool toolbarPool;
        static /* synthetic */ Class class$org$openide$awt$ToolbarPool;
        static /* synthetic */ Class class$org$openide$awt$ToolbarPool$Configuration;
        static /* synthetic */ Class class$java$awt$Component;

        public Folder(DataFolder f) {
            super(f);
        }

        public String instanceName() {
            return this.instanceClass().getName();
        }

        public Class instanceClass() {
            return class$org$openide$awt$ToolbarPool == null ? (class$org$openide$awt$ToolbarPool = Folder.class$("org.openide.awt.ToolbarPool")) : class$org$openide$awt$ToolbarPool;
        }

        protected InstanceCookie acceptCookie(InstanceCookie cookie) throws IOException, ClassNotFoundException {
            Class cls;
            if ((class$org$openide$awt$ToolbarPool$Configuration == null ? (class$org$openide$awt$ToolbarPool$Configuration = Folder.class$("org.openide.awt.ToolbarPool$Configuration")) : class$org$openide$awt$ToolbarPool$Configuration).isAssignableFrom(cls = cookie.instanceClass())) {
                return cookie;
            }
            if ((class$java$awt$Component == null ? (class$java$awt$Component = Folder.class$("java.awt.Component")) : class$java$awt$Component).isAssignableFrom(cls)) {
                return cookie;
            }
            return null;
        }

        protected InstanceCookie acceptFolder(DataFolder df) {
            InstanceCookie ic = (InstanceCookie)this.foldersCache.get(df);
            if (ic == null) {
                ic = new InstanceSupport.Instance(new Toolbar(df, true));
                this.foldersCache.put(df, ic);
            }
            return ic;
        }

        protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
            int length = cookies.length;
            TreeMap<String, Toolbar> toolbars = new TreeMap<String, Toolbar>();
            TreeMap<String, Configuration> conf = new TreeMap<String, Configuration>();
            int i = 0;
            while (i < length) {
                try {
                    String name;
                    Object obj = cookies[i].instanceCreate();
                    if (obj instanceof Toolbar) {
                        Toolbar toolbar = (Toolbar)obj;
                        toolbar.removeMouseListener(ToolbarPool.this.listener);
                        toolbar.addMouseListener(ToolbarPool.this.listener);
                        toolbars.put(toolbar.getName(), toolbar);
                    } else if (obj instanceof Configuration) {
                        Configuration config = (Configuration)obj;
                        name = config.getName();
                        if (name == null) {
                            name = cookies[i].instanceName();
                        }
                        conf.put(name, config);
                    } else if (obj instanceof Component) {
                        Component comp = (Component)obj;
                        name = comp.getName();
                        if (name == null) {
                            name = cookies[i].instanceName();
                        }
                        conf.put(name, new ComponentConfiguration(comp));
                    }
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(ex);
                }
                catch (ClassNotFoundException ex) {
                    ErrorManager.getDefault().notify(ex);
                }
                ++i;
            }
            ToolbarPool.this.update(toolbars, conf);
            return ToolbarPool.this;
        }

        protected Task postCreationTask(Runnable run) {
            return new AWTTask(run);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class TPTaskListener
    implements TaskListener {
        private String conf;

        private TPTaskListener() {
        }

        public void taskFinished(Task task) {
            ToolbarPool.this.setConfiguration(this.conf);
            this.conf = null;
        }

        void setConfiguration(String conf) {
            if (this.conf == null) {
                this.conf = conf;
            }
        }
    }
}

