/*
 * Decompiled with CFR 0.152.
 */
package org.openide.compiler;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.WeakHashMap;
import org.openide.compiler.Compilable;
import org.openide.compiler.CompilerJob;
import org.openide.compiler.IdSet;

public abstract class Compiler
implements Compilable {
    public static final Depth DEPTH_ZERO = new Depth();
    public static final Depth DEPTH_ONE = new Depth();
    public static final Depth DEPTH_INFINITE = new Depth();
    private IdSet dependsOn;
    private Collection nomodDependsOn;
    private static Map jobTable = new WeakHashMap(101);

    public Compiler() {
    }

    public Compiler(CompilerJob job) {
        job.add(this);
        this.registerInJob(job);
    }

    public Compiler(Compiler c) {
        this.dependsOn(c);
        this.registerInJob(c);
    }

    public Compiler(Compiler[] dep) {
        this.dependsOn(Arrays.asList(dep));
        this.registerInJob(dep[0]);
    }

    protected abstract boolean isUpToDate();

    protected Date getTimeStamp() {
        return null;
    }

    public abstract Class compilerGroupClass();

    public Object compilerGroupKey() {
        return this.compilerGroupClass();
    }

    public final void dependsOn(Compilable compilable) {
        this.dependsOn(Collections.singleton(compilable));
    }

    public void dependsOn(final Collection compilables) {
        Compilable.MUTEX.readAccess(new Runnable(){

            public void run() {
                Compiler compiler = Compiler.this;
                synchronized (compiler) {
                    if (Compiler.this.dependsOn == null) {
                        Compiler.this.dependsOn = new IdSet();
                    }
                    Compiler.this.dependsOn.addAll(compilables);
                }
            }
        });
    }

    public final Collection compilers() {
        return Collections.singleton(this);
    }

    public final synchronized Collection dependsOn() {
        if (this.dependsOn == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.nomodDependsOn == null) {
            this.nomodDependsOn = this.dependsOn.asImmutableCollection();
        }
        return this.nomodDependsOn;
    }

    final void registerInJob(CompilerJob job) {
        jobTable.put(this, new WeakReference<CompilerJob>(job));
    }

    final void registerInJob(Compiler comp) {
        CompilerJob job;
        Reference ref = (Reference)jobTable.get(comp);
        CompilerJob compilerJob = job = ref == null ? null : (CompilerJob)ref.get();
        if (job == null) {
            throw new IllegalStateException("Argument Compiler is not in any job");
        }
        jobTable.put(this, ref);
        job.add(this);
    }

    public static final class Depth {
        Depth() {
        }

        public boolean isLastDepth() {
            return this == DEPTH_ZERO;
        }

        public Depth nextDepth() {
            if (this == DEPTH_INFINITE) {
                return this;
            }
            return DEPTH_ZERO;
        }
    }
}

