/*
 * Decompiled with CFR 0.152.
 */
package org.openide.compiler;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.openide.TopManager;
import org.openide.compiler.CompilerSysProcess;
import org.openide.compiler.ExternalCompiler;
import org.openide.compiler.ExternalCompilerGroup;
import org.openide.execution.ExecInfo;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.execution.NbProcessDescriptor;
import org.openide.execution.ProcessExecutor;
import org.openide.util.NbBundle;
import org.openide.util.io.FoldingIOException;
import org.openide.windows.InputOutput;

final class CompilerExecutor
extends ProcessExecutor {
    static final long serialVersionUID = -2611259508166125914L;
    private List files = new LinkedList();
    private ExternalCompilerGroup eCompiler;
    private NbProcessDescriptor nbDescriptor;
    private ExternalCompiler.ErrorExpression errorExpression;
    private Object compilerType;
    static /* synthetic */ Class class$org$openide$compiler$CompilerExecutor;

    CompilerExecutor(ExternalCompilerGroup ecg, NbProcessDescriptor nbDescriptor, ExternalCompiler.ErrorExpression err, Object compilerType) {
        this.eCompiler = ecg;
        this.nbDescriptor = nbDescriptor;
        this.errorExpression = err;
        this.compilerType = compilerType;
    }

    public void addFile(String file) {
        this.files.add(file);
    }

    private static InputOutput getCompilerIO() {
        String outName = NbBundle.getBundle("org.openide.compiler.Bundle").getString("CTL_CompileTab");
        return TopManager.getDefault().getIO(outName, false);
    }

    public ExecutorTask execute(ExecInfo info) throws IOException {
        CERunnable run;
        CERunnable cERunnable = run = new CERunnable(info, this.eCompiler, this.errorExpression, this.nbDescriptor, this.files, this.compilerType);
        synchronized (cERunnable) {
            ExecutorTask et = ExecutionEngine.getDefault().execute(NbBundle.getBundle(class$org$openide$compiler$CompilerExecutor == null ? (class$org$openide$compiler$CompilerExecutor = CompilerExecutor.class$("org.openide.compiler.CompilerExecutor")) : class$org$openide$compiler$CompilerExecutor).getString("CTL_CompilationTask"), run, CompilerExecutor.getCompilerIO());
            try {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                run.wait();
                Throwable e = run.getException();
                if (e != null) {
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new FoldingIOException(e);
                }
                CompilerSysProcess csp = run.getCompilerSysProcess();
                csp.setExecutorTask(et);
                CompilerSysProcess compilerSysProcess = csp;
                return compilerSysProcess;
            }
            catch (InterruptedException e) {
                CompilerSysProcess.InterruptedProcess interruptedProcess = new CompilerSysProcess.InterruptedProcess();
                return interruptedProcess;
            }
        }
    }

    ExternalCompiler.ErrorExpression getErrorExpression() {
        return this.errorExpression;
    }

    NbProcessDescriptor getDescriptor() {
        return this.nbDescriptor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class CERunnable
    implements Runnable {
        private ExecInfo info;
        private ExternalCompilerGroup eeg;
        private ExternalCompiler.ErrorExpression errorExpression;
        private NbProcessDescriptor nbDescriptor;
        private Throwable t;
        private CompilerSysProcess csp;
        private List files;
        private Object compilerType;

        CERunnable(ExecInfo info, ExternalCompilerGroup eeg, ExternalCompiler.ErrorExpression errorExpression, NbProcessDescriptor nbDescriptor, List files, Object compilerType) {
            this.info = info;
            this.eeg = eeg;
            this.errorExpression = errorExpression;
            this.nbDescriptor = nbDescriptor;
            this.files = files;
            this.compilerType = compilerType;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            CERunnable cERunnable;
            try {
                try {
                    TopManager.getDefault().saveAll();
                    String msg = this.eeg.getStatusLineText();
                    TopManager.getDefault().setStatusText(msg);
                    this.csp = new CompilerSysProcess(this, this.eeg, this.eeg.createProcess(this.nbDescriptor, this.files.toArray(new String[0]), this.compilerType), this.errorExpression);
                }
                catch (Exception e) {
                    this.t = e;
                    Object var3_4 = null;
                    CERunnable cERunnable3 = this;
                    synchronized (cERunnable3) {
                        this.notifyAll();
                        return;
                    }
                }
                Object var3_3 = null;
                cERunnable = this;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                CERunnable cERunnable2 = this;
                synchronized (cERunnable2) {
                    this.notifyAll();
                    throw throwable;
                }
            }
            synchronized (cERunnable) {
                this.notifyAll();
                return;
            }
        }

        public Throwable getException() {
            return this.t;
        }

        public CompilerSysProcess getCompilerSysProcess() {
            return this.csp;
        }
    }
}

