/*
 * Decompiled with CFR 0.152.
 */
package org.openide.compiler;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.openide.compiler.Compilable;
import org.openide.compiler.CompilationEngine;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerTask;
import org.openide.compiler.DependencyException;
import org.openide.compiler.Graph;
import org.openide.compiler.IdSet;
import org.openide.util.Mutex;

public final class CompilerJob
implements Compilable {
    private IdSet compilers = new IdSet();
    private Collection noModCompilers;
    private String name = "";
    private Compiler.Depth depth;
    private Graph graph;
    private IdSet dependsOn;
    private Collection noModDependsOn = Collections.EMPTY_LIST;

    public CompilerJob(Compiler.Depth depth) {
        this.depth = depth;
    }

    public Compiler.Depth getInitialDepth() {
        return this.depth;
    }

    public CompilerTask start() {
        return CompilationEngine.getDefault().start(this);
    }

    public final boolean isUpToDate() {
        return this.getGraph().isUpToDate(null);
    }

    public final boolean isUpToDate(Date date) {
        return this.getGraph().isUpToDate(date);
    }

    public void setDisplayName(String s) {
        this.name = s;
    }

    public String getDisplayName() {
        return this.name;
    }

    public void add(Compiler comp) {
        this.add(Collections.singleton(comp));
    }

    public void add(final Collection comps) {
        Compilable.MUTEX.readAccess(new Runnable(){

            public void run() {
                CompilerJob compilerJob = CompilerJob.this;
                synchronized (compilerJob) {
                    CompilerJob.this.graph = null;
                    CompilerJob.this.compilers.addAll(comps);
                }
            }
        });
    }

    public void dependsOn(Compilable c) {
        this.dependsOn(Collections.singleton(c));
    }

    public void dependsOn(final Collection arr) {
        Compilable.MUTEX.readAccess(new Runnable(){

            public void run() {
                CompilerJob compilerJob = CompilerJob.this;
                synchronized (compilerJob) {
                    CompilerJob.this.graph = null;
                    if (CompilerJob.this.dependsOn == null) {
                        CompilerJob.this.dependsOn = new IdSet();
                        CompilerJob.this.noModDependsOn = CompilerJob.this.dependsOn.asImmutableCollection();
                    }
                    CompilerJob.this.dependsOn.addAll(arr);
                }
            }
        });
    }

    final List computationLevels() throws DependencyException {
        return this.getGraph().getLevels();
    }

    private Graph getGraph() {
        Graph g = this.graph;
        if (g != null) {
            return g;
        }
        this.graph = (Graph)Compilable.MUTEX.writeAccess(new Mutex.Action(){

            public Object run() {
                return new Graph(CompilerJob.this);
            }
        });
        return this.graph;
    }

    public final synchronized Collection compilers() {
        if (this.noModCompilers == null) {
            this.noModCompilers = this.compilers.asImmutableCollection();
        }
        return this.noModCompilers;
    }

    public final Collection dependsOn() {
        return this.noModDependsOn;
    }

    public String toString() {
        return this.getDisplayName();
    }
}

