/*
 * Decompiled with CFR 0.152.
 */
package org.openide.compiler;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Iterator;
import org.openide.compiler.Compilable;
import org.openide.compiler.Compiler;

public final class DependencyException
extends Exception {
    private final Compilable[] array;

    DependencyException(Compilable[] comp) {
        super(comp.length + " compilers formed a cycle");
        this.array = comp;
    }

    public Compilable[] getCompilables() {
        return this.array;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream ps) {
        super.printStackTrace(ps);
        ps.println("Compiler cycle:");
        int i = 0;
        while (i < this.array.length) {
            Compilable c;
            ps.println("\t" + DependencyException.info(this.array[i]));
            ps.println("\t\tIncludes:\n");
            Iterator it = this.array[i].compilers().iterator();
            while (it.hasNext()) {
                c = (Compiler)it.next();
                ps.println("\t\t\t" + DependencyException.info(c));
            }
            ps.println("\t\tDepends on:\n");
            it = this.array[i].dependsOn().iterator();
            while (it.hasNext()) {
                c = (Compilable)it.next();
                ps.println("\t\t\t" + DependencyException.info(c));
            }
            ++i;
        }
    }

    public void printStackTrace(PrintWriter pw) {
        super.printStackTrace(pw);
        pw.println("Compiler cycle:");
        int i = 0;
        while (i < this.array.length) {
            Compilable c;
            pw.println("\t" + DependencyException.info(this.array[i]));
            pw.println("\t\tIncludes:\n");
            Iterator it = this.array[i].compilers().iterator();
            while (it.hasNext()) {
                c = (Compiler)it.next();
                pw.println("\t\t\t" + DependencyException.info(c));
            }
            pw.println("\t\tDepends on:\n");
            it = this.array[i].dependsOn().iterator();
            while (it.hasNext()) {
                c = (Compilable)it.next();
                pw.println("\t\t\t" + DependencyException.info(c));
            }
            ++i;
        }
    }

    private static String info(Object o) {
        return o.toString() + " [class=" + o.getClass().getName() + ",id=" + System.identityHashCode(o) + ",hash=" + o.hashCode() + "]";
    }
}

