/*
 * Decompiled with CFR 0.152.
 */
package org.openide.execution;

import org.openide.execution.NbClassLoader;

class ExecutorClassLoader
extends NbClassLoader {
    private boolean accessBitEnabled = true;

    ExecutorClassLoader() {
    }

    protected Class defineFromData(String name, byte[] data) throws ClassFormatError, NoClassDefFoundError {
        if (this.accessBitEnabled) {
            this.accessBitEnabled = false;
            ExecutorClassLoader.setAccessBit(data);
        }
        return this.defineClass(name, data, 0, data.length);
    }

    private static void setAccessBit(byte[] classdata) {
        if (classdata == null || classdata.length < 14) {
            return;
        }
        int magic = (0xFF & classdata[0]) << 24 | (0xFF & classdata[1]) << 16 | (0xFF & classdata[2]) << 8 | 0xFF & classdata[3];
        int minor = (0xFF & classdata[4]) << 8 | 0xFF & classdata[5];
        int major = (0xFF & classdata[6]) << 8 | 0xFF & classdata[7];
        if (magic != -889275714 || major != 45 || minor > 3) {
            return;
        }
        int poolcount = (0xFF & classdata[8]) << 8 | 0xFF & classdata[9];
        int i = 10;
        --poolcount;
        while (poolcount > 0) {
            switch (classdata[i] & 0xFF) {
                case 7: 
                case 8: {
                    i += 3;
                    break;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    i += 5;
                    break;
                }
                case 5: 
                case 6: {
                    --poolcount;
                    i += 9;
                    break;
                }
                case 1: {
                    int utflength = (0xFF & classdata[++i]) << 8 | 0xFF & classdata[i + 1];
                    i += utflength + 2;
                    break;
                }
                default: {
                    return;
                }
            }
            --poolcount;
        }
        int n = ++i;
        classdata[n] = (byte)(classdata[n] | 1);
    }
}

