/*
 * Decompiled with CFR 0.152.
 */
package org.openide.execution;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.openide.ServiceType;
import org.openide.TopManager;

final class ExecutorType {
    ExecutorType() {
    }

    static final class Handle
    implements Serializable {
        static final long serialVersionUID = 7233109534462148872L;
        private String name;
        private String className;

        Handle() {
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            this.name = (String)ois.readObject();
            this.className = (String)ois.readObject();
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.writeObject(this.name);
            oos.writeObject(this.className);
        }

        private Object readResolve() {
            ServiceType exc = null;
            TopManager tm = TopManager.getDefault();
            ServiceType.Registry r = tm.getServices();
            exc = r.find(this.name);
            if (exc == null) {
                try {
                    exc = r.find(Class.forName(this.className, true, tm.systemClassLoader()));
                }
                catch (ClassNotFoundException ex) {
                    // empty catch block
                }
            }
            return exc == null ? null : new ServiceType.Handle(exc);
        }
    }
}

