/*
 * Decompiled with CFR 0.152.
 */
package org.openide.execution;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.Manifest;
import org.openide.ErrorManager;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.NbfsStreamHandlerFactory;
import org.openide.execution.NbfsURLConnection;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.util.Lookup;
import org.openide.windows.InputOutput;

public class NbClassLoader
extends URLClassLoader {
    protected InputOutput inout;
    private HashMap permissionCollections;
    private PermissionCollection defaultPermissions;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    private static ClassLoader systemClassLoader() {
        return (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = NbClassLoader.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
    }

    public NbClassLoader() {
        super(NbClassLoader.createRootURLs(FileSystemCapability.EXECUTE.fileSystems()), NbClassLoader.systemClassLoader());
    }

    public NbClassLoader(InputOutput io) {
        this();
        this.inout = io;
    }

    public NbClassLoader(FileSystem[] fileSystems) {
        this(fileSystems, NbClassLoader.systemClassLoader());
    }

    public NbClassLoader(FileSystem[] fileSystems, ClassLoader parent) {
        super(NbClassLoader.createRootURLs(Collections.enumeration(Arrays.asList(fileSystems))), parent);
    }

    public URL getResource(String name) {
        return super.getResource(name.startsWith("/") ? name.substring(1) : name);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        String pkg;
        if (name.indexOf(46) != -1 && this.getPackage(pkg = name.substring(0, name.lastIndexOf(46))) == null) {
            String resource = name.replace('.', '/') + ".class";
            URL[] urls = this.getURLs();
            int i = 0;
            while (i < urls.length) {
                block8: {
                    FileObject root = NbfsURLConnection.decodeURL(urls[i]);
                    if (root != null && root.isRoot()) {
                        try {
                            FileSystem fs = root.getFileSystem();
                            FileObject fo = fs.findResource(resource);
                            if (fo == null) break block8;
                            FileObject manifo = fs.findResource("META-INF/MANIFEST.MF");
                            if (manifo == null) {
                                manifo = fs.findResource("meta-inf/manifest.mf");
                            }
                            if (manifo == null) break;
                            Manifest mani = new Manifest();
                            InputStream is = manifo.getInputStream();
                            try {
                                mani.read(is);
                                Object var13_13 = null;
                            }
                            catch (Throwable throwable) {
                                Object var13_14 = null;
                                is.close();
                                throw throwable;
                            }
                            is.close();
                            this.definePackage(pkg, mani, urls[i]);
                            break;
                        }
                        catch (IOException ioe) {
                            ErrorManager err = ErrorManager.getDefault();
                            err.annotate((Throwable)ioe, urls[i].toString());
                            err.notify(1, ioe);
                        }
                    }
                }
                ++i;
            }
        }
        return super.findClass(name);
    }

    public void setDefaultPermissions(PermissionCollection defaultPerms) {
        if (defaultPerms != null && !defaultPerms.isReadOnly()) {
            defaultPerms.setReadOnly();
        }
        this.defaultPermissions = defaultPerms;
    }

    protected final synchronized PermissionCollection getPermissions(CodeSource cs) {
        PermissionCollection pc;
        if (this.permissionCollections != null && (pc = (PermissionCollection)this.permissionCollections.get(cs)) != null) {
            return pc;
        }
        return this.createPermissions(cs, this.inout);
    }

    private PermissionCollection createPermissions(CodeSource cs, InputOutput inout) {
        PermissionCollection pc;
        if (inout == null) {
            pc = this.defaultPermissions != null ? this.defaultPermissions : super.getPermissions(cs);
        } else {
            ExecutionEngine engine = ExecutionEngine.getDefault();
            pc = engine.createPermissions(cs, inout);
            if (this.defaultPermissions != null) {
                NbClassLoader.addAllPermissions(pc, this.defaultPermissions);
            } else {
                pc.add(new AllPermission());
            }
        }
        if (this.permissionCollections == null) {
            this.permissionCollections = new HashMap(7);
        }
        this.permissionCollections.put(cs, pc);
        return pc;
    }

    private static void addAllPermissions(PermissionCollection target, PermissionCollection src) {
        Enumeration<Permission> enumeration = src.elements();
        while (enumeration.hasMoreElements()) {
            target.add(enumeration.nextElement());
        }
    }

    private static URL[] createRootURLs(Enumeration en) {
        ArrayList<URL> list = new ArrayList<URL>();
        while (en.hasMoreElements()) {
            FileSystem fs = (FileSystem)en.nextElement();
            try {
                list.add(fs.getRoot().getURL());
            }
            catch (FileStateInvalidException ex) {
                ErrorManager.getDefault().notify(1, ex);
            }
        }
        return list.toArray(new URL[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        URL.setURLStreamHandlerFactory(NbfsStreamHandlerFactory.getDefault());
    }
}

