/*
 * Decompiled with CFR 0.152.
 */
package org.openide.execution;

import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import java.security.Permission;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.Lookup;

public final class NbfsURLConnection
extends URLConnection {
    public static final String PROTOCOL = "nbfs";
    private static final char SEPARATOR = '/';
    private URLConnection del;
    static /* synthetic */ Class class$org$openide$filesystems$Repository;

    public NbfsURLConnection(URL u) {
        super(u);
    }

    public static URL encodeFileObject(FileObject fo) throws FileStateInvalidException {
        return fo.getURL();
    }

    public static FileObject decodeURL(URL u) {
        int first;
        if (!u.getProtocol().equals(PROTOCOL)) {
            return null;
        }
        String resourceName = u.getFile();
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        }
        if ((first = resourceName.indexOf(47)) == -1) {
            return null;
        }
        String fileSystemName = NbfsURLConnection.decodeFileSystemName(resourceName.substring(0, first));
        if ((resourceName = NbfsURLConnection.normalizePath(resourceName.substring(first))) == null) {
            return null;
        }
        Repository repo = (Repository)Lookup.getDefault().lookup(class$org$openide$filesystems$Repository == null ? (class$org$openide$filesystems$Repository = NbfsURLConnection.class$("org.openide.filesystems.Repository")) : class$org$openide$filesystems$Repository);
        if (repo == null) {
            return null;
        }
        FileSystem fsys = repo.findFileSystem(fileSystemName);
        return fsys == null ? null : fsys.findResource(resourceName);
    }

    private static String normalizePath(String s) {
        if (s == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(s, "/");
        LinkedList<String> ll = new LinkedList<String>();
        while (tok.hasMoreTokens()) {
            String t = tok.nextToken();
            if (".".equals(t)) continue;
            if ("..".equals(t)) {
                try {
                    ll.removeLast();
                    continue;
                }
                catch (NoSuchElementException x) {
                    return null;
                }
            }
            ll.add(t);
        }
        StringBuffer sb = new StringBuffer(s.length());
        Iterator i = ll.iterator();
        while (i.hasNext()) {
            sb.append('/');
            sb.append(i.next());
        }
        return sb.toString();
    }

    public void connect() throws IOException {
        if (this.del != null) {
            return;
        }
        NbfsURLConnection nbfsURLConnection = this;
        synchronized (nbfsURLConnection) {
            if (this.del != null) {
                return;
            }
            FileObject fo = NbfsURLConnection.decodeURL(this.url);
            if (fo == null) {
                throw new IOException("Cannot find: " + this.url);
            }
            this.del = fo.getURL().openConnection();
        }
    }

    public InputStream getInputStream() throws IOException, UnknownServiceException {
        this.connect();
        return this.del.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException, UnknownServiceException {
        this.connect();
        return this.del.getOutputStream();
    }

    public int getContentLength() {
        try {
            this.connect();
            return this.del.getContentLength();
        }
        catch (IOException ex) {
            return 0;
        }
    }

    public String getHeaderField(String name) {
        try {
            this.connect();
            return this.del.getHeaderField(name);
        }
        catch (IOException ex) {
            return super.getHeaderField(name);
        }
    }

    private static String decodeFileSystemName(String name) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int len = name.length();
        while (i < len) {
            char ch;
            if ((ch = name.charAt(i++)) == 'Q' && i < len) {
                switch (name.charAt(i++)) {
                    case 'B': {
                        sb.append('/');
                        break;
                    }
                    case 'C': {
                        sb.append(':');
                        break;
                    }
                    case 'D': {
                        sb.append('\\');
                        break;
                    }
                    case 'E': {
                        sb.append('#');
                        break;
                    }
                    default: {
                        sb.append('Q');
                        break;
                    }
                }
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public Permission getPermission() throws IOException {
        if (this.del != null) {
            return this.del.getPermission();
        }
        return new FilePermission("<<ALL FILES>>", "read");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

