/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.PasteAction;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ClipboardEvent;
import org.openide.util.datatransfer.ClipboardListener;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.PasteType;

public class ExplorerActions {
    private ActionPerformer copyActionPerformer;
    private ActionPerformer cutActionPerformer;
    private ActionPerformer deleteActionPerformer;
    private ActionStateUpdater actionStateUpdater;
    private ExplorerManager manager;
    private boolean confirmDelete = true;
    private static CopyAction copy = null;
    private static CutAction cut = null;
    private static DeleteAction delete = null;
    private static PasteAction paste = null;
    private static boolean isConfirmed;
    private static String title;
    private static String message;
    private static ThreadLocal destroyRunnable;
    private static ThreadLocal selectedNodes;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$java$awt$datatransfer$Clipboard;

    public synchronized void attach(ExplorerManager m) {
        if (this.manager != null) {
            this.detach();
        }
        this.manager = m;
        if (this.actionStateUpdater == null) {
            this.actionStateUpdater = new ActionStateUpdater();
        }
        this.manager.addPropertyChangeListener(this.actionStateUpdater);
        Clipboard c = ExplorerActions.getClipboard();
        if (c instanceof ExClipboard) {
            ExClipboard clip = (ExClipboard)c;
            clip.addClipboardListener(this.actionStateUpdater);
        }
        this.updateActions();
    }

    public synchronized void detach() {
        if (this.manager == null) {
            return;
        }
        this.manager.removePropertyChangeListener(this.actionStateUpdater);
        Clipboard c = ExplorerActions.getClipboard();
        if (c instanceof ExClipboard) {
            ExClipboard clip = (ExClipboard)c;
            clip.removeClipboardListener(this.actionStateUpdater);
        }
        this.stopActions();
        this.manager = null;
    }

    ExplorerManager getAttachedManager() {
        return this.manager;
    }

    public final void setConfirmDelete(boolean yes) {
        this.confirmDelete = yes;
    }

    public final boolean isConfirmDelete() {
        return this.confirmDelete;
    }

    private void stopActions() {
        if (this.copyActionPerformer != null) {
            if (copy.getActionPerformer() instanceof CopyCutActionPerformer) {
                copy.setActionPerformer(null);
            }
            if (cut.getActionPerformer() instanceof CopyCutActionPerformer) {
                cut.setActionPerformer(null);
            }
            paste.setPasteTypes(null);
            if (delete.getActionPerformer() instanceof DeleteActionPerformer) {
                delete.setActionPerformer(null);
            }
        }
    }

    private void updateActions() {
        int k;
        if (this.manager == null) {
            return;
        }
        Node[] path = this.manager.getSelectedNodes();
        if (this.copyActionPerformer == null) {
            this.copyActionPerformer = new CopyCutActionPerformer(true);
            this.cutActionPerformer = new CopyCutActionPerformer(false);
            this.deleteActionPerformer = new DeleteActionPerformer();
            copy = (CopyAction)SharedClassObject.findObject(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = ExplorerActions.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction, true);
            cut = (CutAction)SharedClassObject.findObject(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = ExplorerActions.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction, true);
            paste = (PasteAction)SharedClassObject.findObject(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = ExplorerActions.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction, true);
            delete = (DeleteAction)SharedClassObject.findObject(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = ExplorerActions.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction, true);
        }
        int n = k = path != null ? path.length : 0;
        if (k > 0) {
            int i;
            boolean incest = false;
            if (k > 1) {
                HashMap allNodes = new HashMap(101);
                i = 0;
                while (i < k) {
                    if (!this.checkParents(path[i], allNodes)) {
                        incest = true;
                        break;
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < k) {
                if (incest || !path[i].canCopy()) {
                    copy.setActionPerformer(null);
                    break;
                }
                ++i;
            }
            if (i == k) {
                copy.setActionPerformer(this.copyActionPerformer);
            }
            i = 0;
            while (i < k) {
                if (incest || !path[i].canCut()) {
                    cut.setActionPerformer(null);
                    break;
                }
                ++i;
            }
            if (i == k) {
                cut.setActionPerformer(this.cutActionPerformer);
            }
            i = 0;
            while (i < k) {
                if (incest || !path[i].canDestroy()) {
                    delete.setActionPerformer(null);
                    break;
                }
                ++i;
            }
            if (i == k) {
                delete.setActionPerformer(this.deleteActionPerformer);
            }
        } else {
            copy.setActionPerformer(null);
            cut.setActionPerformer(null);
            delete.setActionPerformer(null);
        }
        this.updatePasteAction(path);
    }

    private boolean checkParents(Node node, HashMap set) {
        if (set.get(node) != null) {
            return false;
        }
        set.put(node, this);
        do {
            if ((node = node.getParentNode()) != null) continue;
            return true;
        } while (set.put(node, node) != this);
        return false;
    }

    private void updatePasteAction(Node[] path) {
        ExplorerManager man = this.manager;
        if (man == null) {
            paste.setPasteTypes(null);
            return;
        }
        if (path != null && path.length > 1) {
            paste.setPasteTypes(null);
            return;
        }
        Node pan = man.getExploredContext();
        Node[] selectedNodes = man.getSelectedNodes();
        if (selectedNodes != null && selectedNodes.length == 1) {
            pan = selectedNodes[0];
        }
        final Node p = pan;
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                Clipboard clipboard = ExplorerActions.getClipboard();
                Transferable trans = clipboard.getContents(this);
                SwingUtilities.invokeLater(new Runnable(this, trans){
                    private final /* synthetic */ Transferable val$trans;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$trans = val$trans;
                    }

                    public void run() {
                        ExplorerActions.access$400(1.access$300(this.this$1), this.val$trans, 1.access$200(this.this$1));
                    }
                });
            }

            static /* synthetic */ Node access$200(1 x0) {
                return x0.p;
            }

            static /* synthetic */ ExplorerActions access$300(1 x0) {
                return x0.ExplorerActions.this;
            }
        });
    }

    private void updatePasteTypes(Transferable trans, Node pan) {
        if (trans != null) {
            PasteType[] pasteTypes;
            PasteType[] pasteTypeArray = pasteTypes = pan == null ? new PasteType[]{} : pan.getPasteTypes(trans);
            if (pasteTypes.length != 0) {
                paste.setPasteTypes(pasteTypes);
                return;
            }
            boolean flavorSupported = false;
            try {
                flavorSupported = trans.isDataFlavorSupported(ExTransferable.multiFlavor);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (flavorSupported) {
                try {
                    MultiTransferObject obj = (MultiTransferObject)trans.getTransferData(ExTransferable.multiFlavor);
                    int count = obj.getCount();
                    boolean ok = true;
                    Transferable[] t = new Transferable[count];
                    PasteType[] p = new PasteType[count];
                    int i = 0;
                    while (i < count) {
                        t[i] = obj.getTransferableAt(i);
                        PasteType[] pasteTypeArray2 = pasteTypes = pan == null ? new PasteType[]{} : pan.getPasteTypes(t[i]);
                        if (pasteTypes.length == 0) {
                            ok = false;
                            break;
                        }
                        p[i] = pasteTypes[0];
                        ++i;
                    }
                    if (ok) {
                        paste.setPasteTypes(new PasteType[]{new MultiPasteType(t, p)});
                        return;
                    }
                }
                catch (UnsupportedFlavorException e) {
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if (paste != null) {
            paste.setPasteTypes(null);
        }
    }

    private static Clipboard getClipboard() {
        Clipboard c = (Clipboard)Lookup.getDefault().lookup(class$java$awt$datatransfer$Clipboard == null ? (class$java$awt$datatransfer$Clipboard = ExplorerActions.class$("java.awt.datatransfer.Clipboard")) : class$java$awt$datatransfer$Clipboard);
        if (c == null) {
            c = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return c;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ void access$400(ExplorerActions x0, Transferable x1, Node x2) {
        x0.updatePasteTypes(x1, x2);
    }

    static {
        destroyRunnable = new ThreadLocal();
        selectedNodes = new ThreadLocal();
    }

    private class ActionStateUpdater
    implements PropertyChangeListener,
    ClipboardListener,
    ActionListener {
        private Timer timer = new Timer(150, this);

        ActionStateUpdater() {
            this.timer.setCoalesce(true);
            this.timer.setRepeats(false);
        }

        public void propertyChange(PropertyChangeEvent e) {
            this.timer.start();
        }

        public void clipboardChanged(ClipboardEvent ev) {
            if (!ev.isConsumed()) {
                ExplorerActions.this.updatePasteAction(ExplorerActions.this.manager.getSelectedNodes());
            }
        }

        public void actionPerformed(ActionEvent evt) {
            ExplorerActions.this.updateActions();
            this.timer.stop();
        }
    }

    static class ConfirmationInvoker
    implements Runnable {
        static /* synthetic */ Class class$org$openide$loaders$DataShadow;
        static /* synthetic */ Class class$org$openide$explorer$ExplorerActions;
        static /* synthetic */ Class class$org$openide$loaders$DataFolder;

        ConfirmationInvoker() {
        }

        public void run() {
            Node[] sel = (Node[])selectedNodes.get();
            selectedNodes.set(null);
            if (sel == null) {
                throw new IllegalStateException("ConfirmationInvoker didn't get parameter sel.");
            }
            if (sel.length == 1) {
                if (sel[0].getCookie(class$org$openide$loaders$DataShadow == null ? (class$org$openide$loaders$DataShadow = ConfirmationInvoker.class$("org.openide.loaders.DataShadow")) : class$org$openide$loaders$DataShadow) != null) {
                    title = NbBundle.getMessage(ConfirmationInvoker.class$org$openide$explorer$ExplorerActions == null ? (ConfirmationInvoker.class$org$openide$explorer$ExplorerActions = ConfirmationInvoker.class$("org.openide.explorer.ExplorerActions")) : ConfirmationInvoker.class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteShadowTitle");
                    DataShadow obj = (DataShadow)sel[0].getCookie(class$org$openide$loaders$DataShadow == null ? (class$org$openide$loaders$DataShadow = ConfirmationInvoker.class$("org.openide.loaders.DataShadow")) : class$org$openide$loaders$DataShadow);
                    message = NbBundle.getMessage(ConfirmationInvoker.class$org$openide$explorer$ExplorerActions == null ? (ConfirmationInvoker.class$org$openide$explorer$ExplorerActions = ConfirmationInvoker.class$("org.openide.explorer.ExplorerActions")) : ConfirmationInvoker.class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteShadow", new Object[]{obj.getName(), sel[0].getDisplayName(), this.fullName(obj), this.fullName(obj.getOriginal())});
                } else if (sel[0].getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = ConfirmationInvoker.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder) != null) {
                    message = NbBundle.getMessage(ConfirmationInvoker.class$org$openide$explorer$ExplorerActions == null ? (ConfirmationInvoker.class$org$openide$explorer$ExplorerActions = ConfirmationInvoker.class$("org.openide.explorer.ExplorerActions")) : ConfirmationInvoker.class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteFolder", sel[0].getDisplayName());
                    title = NbBundle.getMessage(ConfirmationInvoker.class$org$openide$explorer$ExplorerActions == null ? (ConfirmationInvoker.class$org$openide$explorer$ExplorerActions = ConfirmationInvoker.class$("org.openide.explorer.ExplorerActions")) : ConfirmationInvoker.class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteFolderTitle");
                } else {
                    message = NbBundle.getMessage(ConfirmationInvoker.class$org$openide$explorer$ExplorerActions == null ? (ConfirmationInvoker.class$org$openide$explorer$ExplorerActions = ConfirmationInvoker.class$("org.openide.explorer.ExplorerActions")) : ConfirmationInvoker.class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteObject", sel[0].getDisplayName());
                    title = NbBundle.getMessage(ConfirmationInvoker.class$org$openide$explorer$ExplorerActions == null ? (ConfirmationInvoker.class$org$openide$explorer$ExplorerActions = ConfirmationInvoker.class$("org.openide.explorer.ExplorerActions")) : ConfirmationInvoker.class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteObjectTitle");
                }
            } else {
                message = NbBundle.getMessage(ConfirmationInvoker.class$org$openide$explorer$ExplorerActions == null ? (ConfirmationInvoker.class$org$openide$explorer$ExplorerActions = ConfirmationInvoker.class$("org.openide.explorer.ExplorerActions")) : ConfirmationInvoker.class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteObjects", new Integer(sel.length));
                title = NbBundle.getMessage(ConfirmationInvoker.class$org$openide$explorer$ExplorerActions == null ? (ConfirmationInvoker.class$org$openide$explorer$ExplorerActions = ConfirmationInvoker.class$("org.openide.explorer.ExplorerActions")) : ConfirmationInvoker.class$org$openide$explorer$ExplorerActions, "MSG_ConfirmDeleteObjectsTitle");
            }
            NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)message, title, 0);
            isConfirmed = NotifyDescriptor.YES_OPTION.equals(TopManager.getDefault().notify(desc));
        }

        private String fullName(DataObject obj) {
            FileObject f = obj.getPrimaryFile();
            if (f.isRoot()) {
                try {
                    return f.getFileSystem().getDisplayName();
                }
                catch (FileStateInvalidException e) {
                    return "";
                }
            }
            return f.toString();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    static class DestroyInvoker
    implements Runnable {
        static /* synthetic */ Class class$org$openide$filesystems$FileSystem$AtomicAction;

        DestroyInvoker() {
        }

        public void run() {
            Object dr = destroyRunnable.get();
            destroyRunnable.set(null);
            if (dr == null) {
                throw new IllegalStateException("DestroyInvoker didn't get parameter dr.");
            }
            try {
                FileSystem.AtomicAction faa = (FileSystem.AtomicAction)Proxy.newProxyInstance((class$org$openide$filesystems$FileSystem$AtomicAction == null ? (class$org$openide$filesystems$FileSystem$AtomicAction = DestroyInvoker.class$("org.openide.filesystems.FileSystem$AtomicAction")) : class$org$openide$filesystems$FileSystem$AtomicAction).getClassLoader(), new Class[]{class$org$openide$filesystems$FileSystem$AtomicAction == null ? (class$org$openide$filesystems$FileSystem$AtomicAction = DestroyInvoker.class$("org.openide.filesystems.FileSystem$AtomicAction")) : class$org$openide$filesystems$FileSystem$AtomicAction}, (InvocationHandler)dr);
                TopManager.getDefault().getRepository().getDefaultFileSystem().runAtomicAction(faa);
                return;
            }
            catch (IOException ioe) {
                IllegalStateException ise = new IllegalStateException();
                ErrorManager.getDefault().annotate((Throwable)ise, ioe);
                throw ise;
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class DeleteActionPerformer
    implements ActionPerformer {
        private DeleteActionPerformer() {
        }

        public void performAction(SystemAction action) {
            Node[] sel = ExplorerActions.this.manager.getSelectedNodes();
            if (sel == null || sel.length == 0) {
                return;
            }
            isConfirmed = !ExplorerActions.this.confirmDelete;
            if (!isConfirmed) {
                selectedNodes.set(sel);
                this.doConfirm();
            }
            if (isConfirmed) {
                try {
                    if (ExplorerActions.this.manager != null) {
                        ExplorerActions.this.manager.setSelectedNodes(new Node[0]);
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                this.doDestroy(sel);
                delete.setActionPerformer(null);
            }
        }

        private void doConfirm() {
            try {
                Class<?> c = Class.forName("org.openide.explorer.ExplorerActions$ConfirmationInvoker");
                Runnable r = (Runnable)c.newInstance();
                r.run();
                return;
            }
            catch (Exception e) {
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
            int res = JOptionPane.showConfirmDialog(null, message, title, 0);
            isConfirmed = res == 0;
        }

        private void doDestroy(Node[] sel) {
            DestroyAtomic da = new DestroyAtomic();
            da.sel = sel;
            destroyRunnable.set(da);
            try {
                Class<?> c = Class.forName("org.openide.explorer.ExplorerActions$DestroyInvoker");
                Runnable r = (Runnable)c.newInstance();
                r.run();
                return;
            }
            catch (IllegalStateException ise) {
                throw ise;
            }
            catch (Exception e) {
            }
            catch (LinkageError e) {
                // empty catch block
            }
            try {
                da.invoke(null, null, null);
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(e);
            }
        }

        private class DestroyAtomic
        implements InvocationHandler {
            Node[] sel;

            private DestroyAtomic() {
            }

            public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
                int i = 0;
                while (i < this.sel.length) {
                    try {
                        this.sel[i].destroy();
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify(e);
                    }
                    ++i;
                }
                return null;
            }
        }
    }

    private class CopyCutActionPerformer
    implements ActionPerformer {
        private boolean copyCut;

        public CopyCutActionPerformer(boolean b) {
            this.copyCut = b;
        }

        public void performAction(SystemAction action) {
            Transferable trans = null;
            Node[] sel = ExplorerActions.this.manager.getSelectedNodes();
            if (sel.length != 1) {
                Transferable[] arrayTrans = new Transferable[sel.length];
                int i = 0;
                while (i < sel.length) {
                    arrayTrans[i] = this.getTransferableOwner(sel[i]);
                    if (arrayTrans[i] == null) {
                        return;
                    }
                    ++i;
                }
                trans = new ExTransferable.Multi(arrayTrans);
            } else {
                trans = this.getTransferableOwner(sel[0]);
            }
            if (trans != null) {
                Clipboard clipboard = ExplorerActions.getClipboard();
                clipboard.setContents(trans, new StringSelection(""));
            }
        }

        private Transferable getTransferableOwner(Node node) {
            try {
                return this.copyCut ? node.clipboardCopy() : node.clipboardCut();
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, e);
                return null;
            }
        }
    }

    private static class MultiPasteType
    extends PasteType {
        Transferable[] t;
        PasteType[] p;

        MultiPasteType(Transferable[] t, PasteType[] p) {
            this.t = t;
            this.p = p;
        }

        public Transferable paste() throws IOException {
            int size = this.p.length;
            Transferable[] arr = new Transferable[size];
            int i = 0;
            while (i < size) {
                Transferable newTransferable = this.p[i].paste();
                arr[i] = newTransferable != null ? newTransferable : this.t[i];
                ++i;
            }
            return new ExTransferable.Multi(arr);
        }
    }
}

