/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.io.SafeException;

public final class ExplorerManager
implements Serializable,
Cloneable {
    static final long serialVersionUID = -4330330689803575792L;
    public static final String PROP_ROOT_CONTEXT = "rootContext";
    public static final String PROP_EXPLORED_CONTEXT = "exploredContext";
    public static final String PROP_SELECTED_NODES = "selectedNodes";
    public static final String PROP_NODE_CHANGE = "nodeChange";
    private transient VetoableChangeSupport vetoableSupport;
    private transient PropertyChangeSupport propertySupport;
    private Node rootContext;
    private Node exploredContext;
    private Node[] selectedNodes;
    private transient Listener listener;
    private transient NodeListener weakListener;
    static RequestProcessor selectionProcessor;
    private static final int SELECTION_SYNC_DELAY = 200;
    private RequestProcessor.Task selectionSyncTask;
    private static final ObjectStreamField[] serialPersistentFields;
    static /* synthetic */ Class class$org$openide$nodes$Node$Handle;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$org$openide$explorer$ExplorerManager;

    public ExplorerManager() {
        this.init();
    }

    private void init() {
        this.exploredContext = this.rootContext = Node.EMPTY;
        this.selectedNodes = new Node[0];
        this.listener = new Listener();
        this.weakListener = WeakListener.node(this.listener, null);
    }

    public Object clone() {
        ExplorerManager em = new ExplorerManager();
        em.rootContext = this.rootContext;
        em.exploredContext = this.exploredContext;
        em.selectedNodes = this.selectedNodes;
        return em;
    }

    public Node[] getSelectedNodes() {
        return this.selectedNodes;
    }

    public final void setSelectedNodes(Node[] value) throws PropertyVetoException {
        Node[] oldValue;
        ExplorerManager explorerManager = this;
        synchronized (explorerManager) {
            Node n;
            if (value == null) {
                throw new IllegalArgumentException(ExplorerManager.getString("EXC_NodeCannotBeNull"));
            }
            if (Arrays.equals(value, this.selectedNodes)) {
                return;
            }
            int i = 0;
            while (i < value.length) {
                if (value[i] == null) {
                    throw new IllegalArgumentException(ExplorerManager.getString("EXC_NoElementOfNodeSelectionMayBeNull"));
                }
                if (!this.isUnderRoot(value[i])) {
                    throw new IllegalArgumentException(MessageFormat.format(ExplorerManager.getString("EXC_NodeSelectionCannotContainNodes"), value[i].getDisplayName(), this.rootContext.getDisplayName()));
                }
                ++i;
            }
            if (value.length != 0 && this.vetoableSupport != null) {
                this.vetoableSupport.fireVetoableChange(PROP_SELECTED_NODES, this.selectedNodes, value);
            }
            oldValue = this.selectedNodes;
            LinkedList<Node> newSelection = new LinkedList<Node>();
            List<Node> currentNodes = Arrays.asList(oldValue);
            int i2 = 0;
            while (i2 < value.length) {
                newSelection.add(value[i2]);
                ++i2;
            }
            LinkedList nodesToAdd = new LinkedList(newSelection);
            nodesToAdd.removeAll(currentNodes);
            LinkedList<Node> nodesToRemove = new LinkedList<Node>(currentNodes);
            nodesToRemove.removeAll(newSelection);
            if (newSelection.size() == value.length) {
                this.selectedNodes = value;
            } else {
                this.selectedNodes = new Node[value.length];
                newSelection.toArray(this.selectedNodes);
            }
            Iterator it = nodesToRemove.iterator();
            while (it.hasNext()) {
                n = (Node)it.next();
                n.removeNodeListener(this.weakListener);
            }
            it = nodesToAdd.iterator();
            while (it.hasNext()) {
                n = (Node)it.next();
                n.addNodeListener(this.weakListener);
            }
        }
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_SELECTED_NODES, oldValue, this.selectedNodes);
        }
    }

    public final Node getExploredContext() {
        return this.exploredContext;
    }

    public final void setExploredContext(Node value) {
        this.setExploredContext(value, new Node[0]);
    }

    public final void setExploredContext(Node value, Node[] selection) {
        if (Utilities.compareObjects(value, this.exploredContext)) {
            this.setSelectedNodes0(selection);
            return;
        }
        if (value != null && !this.isUnderRoot(value)) {
            throw new IllegalArgumentException(MessageFormat.format(ExplorerManager.getString("EXC_ContextMustBeWithinRootContext"), value.getDisplayName(), this.rootContext.getDisplayName()));
        }
        this.setSelectedNodes0(selection);
        Node oldValue = this.exploredContext;
        this.exploredContext = value;
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_EXPLORED_CONTEXT, oldValue, this.exploredContext);
        }
    }

    public final void setExploredContextAndSelection(Node value, Node[] selection) throws PropertyVetoException {
        if (Utilities.compareObjects(value, this.exploredContext)) {
            this.setSelectedNodes1(selection);
            return;
        }
        if (value != null && !this.isUnderRoot(value)) {
            throw new IllegalArgumentException(MessageFormat.format(ExplorerManager.getString("EXC_ContextMustBeWithinRootContext"), value.getDisplayName(), this.rootContext.getDisplayName()));
        }
        this.setSelectedNodes1(selection);
        Node oldValue = this.exploredContext;
        this.exploredContext = value;
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_EXPLORED_CONTEXT, oldValue, this.exploredContext);
        }
    }

    final void setSelectedNodes0(Node[] nodes) {
        block2: {
            try {
                this.setSelectedNodes(nodes);
            }
            catch (PropertyVetoException e) {
                if (nodes.length != 0) break block2;
                IllegalStateException err = new IllegalStateException(ExplorerManager.getString("EXC_MustNotVetoEmptySelection"));
                ErrorManager.getDefault().annotate((Throwable)err, e);
                throw err;
            }
        }
    }

    private void setSelectedNodes1(Node[] nodes) throws PropertyVetoException {
        try {
            this.setSelectedNodes(nodes);
        }
        catch (PropertyVetoException e) {
            if (nodes.length == 0) {
                IllegalStateException err = new IllegalStateException(ExplorerManager.getString("EXC_MustNotVetoEmptySelection"));
                ErrorManager.getDefault().annotate((Throwable)err, e);
                throw err;
            }
            throw e;
        }
    }

    public final Node getRootContext() {
        return this.rootContext;
    }

    public final void setRootContext(Node value) {
        Node[] newselection;
        if (value == null) {
            throw new IllegalArgumentException(ExplorerManager.getString("EXC_CannotHaveNullRootContext"));
        }
        if (this.rootContext.equals(value)) {
            return;
        }
        Node oldValue = this.rootContext;
        this.rootContext = value;
        oldValue.removeNodeListener(this.weakListener);
        this.rootContext.addNodeListener(this.weakListener);
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_ROOT_CONTEXT, oldValue, this.rootContext);
        }
        if (!this.areUnderTarget(newselection = this.getSelectedNodes(), this.rootContext)) {
            newselection = new Node[]{};
        }
        this.setExploredContext(this.rootContext, newselection);
    }

    private boolean areUnderTarget(Node[] nodes, Node target) {
        int i = 0;
        while (i < nodes.length) {
            block3: {
                Node node = nodes[i];
                while (node != null) {
                    if (!node.equals(target)) {
                        node = node.getParentNode();
                        continue;
                    }
                    break block3;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.propertySupport == null) {
            this.propertySupport = new PropertyChangeSupport(this);
        }
        this.propertySupport.addPropertyChangeListener(l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propertySupport != null) {
            this.propertySupport.removePropertyChangeListener(l);
        }
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener l) {
        if (this.vetoableSupport == null) {
            this.vetoableSupport = new VetoableChangeSupport(this);
        }
        this.vetoableSupport.addVetoableChangeListener(l);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener l) {
        if (this.vetoableSupport != null) {
            this.vetoableSupport.removeVetoableChangeListener(l);
        }
    }

    private boolean isUnderRoot(Node node) {
        while (node != null) {
            if (node.equals(this.rootContext)) {
                return true;
            }
            node = node.getParentNode();
        }
        return false;
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        os.writeObject(this);
        ObjectOutputStream.PutField fields = os.putFields();
        Node.Handle rCH = this.rootContext.getHandle();
        fields.put("root", rCH);
        fields.put("rootName", this.rootContext.getDisplayName());
        if (rCH != null) {
            String[] explored = this.exploredContext == null ? null : (this.isUnderRoot(this.exploredContext) ? NodeOp.createPath(this.exploredContext, this.rootContext) : null);
            fields.put("explored", explored);
            LinkedList<String[]> selected = new LinkedList<String[]>();
            int i = 0;
            while (i < this.selectedNodes.length) {
                if (this.isUnderRoot(this.selectedNodes[i])) {
                    selected.add(NodeOp.createPath(this.selectedNodes[i], this.rootContext));
                }
                ++i;
            }
            fields.put("selected", selected.toArray());
        }
        os.writeFields();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.init();
        Object firstObject = ois.readObject();
        if (firstObject != this) {
            this.readObjectOld((Node.Handle)firstObject, ois);
            return;
        }
        ObjectInputStream.GetField fields = ois.readFields();
        Node.Handle h = (Node.Handle)fields.get("root", null);
        final String rootName = (String)fields.get("rootName", null);
        if (h == null) {
            throw new SafeException(new IOException(NbBundle.getMessage(class$org$openide$explorer$ExplorerManager == null ? (class$org$openide$explorer$ExplorerManager = ExplorerManager.class$("org.openide.explorer.ExplorerManager")) : class$org$openide$explorer$ExplorerManager, "EXC_cannot_deser_null_handle", rootName)));
        }
        String[] exploredCtx = (String[])fields.get("explored", null);
        Object[] selPaths = (Object[])fields.get("selected", null);
        try {
            Node root = h.getNode();
            if (root == null) {
                throw new IOException("Node.Handle.getNode (for " + rootName + ") should not return null");
            }
            this.restoreSelection(root, exploredCtx, Arrays.asList(selPaths));
        }
        catch (IOException ioe) {
            if (!Utilities.compareObjects(ioe.getMessage(), ioe.getLocalizedMessage())) {
                throw new SafeException(ioe);
            }
            throw new SafeException(ioe){
                static /* synthetic */ Class class$org$openide$explorer$ExplorerManager;

                public String getLocalizedMessage() {
                    return NbBundle.getMessage(class$org$openide$explorer$ExplorerManager == null ? (class$org$openide$explorer$ExplorerManager = 1.class$("org.openide.explorer.ExplorerManager")) : class$org$openide$explorer$ExplorerManager, "EXC_handle_failed", rootName);
                }

                static /* synthetic */ Class class$(String x0) {
                    try {
                        return Class.forName(x0);
                    }
                    catch (ClassNotFoundException x1) {
                        throw new NoClassDefFoundError(x1.getMessage());
                    }
                }
            };
        }
    }

    private void readObjectOld(Node.Handle h, ObjectInputStream ois) throws IOException, ClassNotFoundException {
        String[] path;
        if (h == null) {
            return;
        }
        String[] rootCtx = (String[])ois.readObject();
        String[] exploredCtx = (String[])ois.readObject();
        LinkedList<String[]> ll = new LinkedList<String[]>();
        while ((path = (String[])ois.readObject()) != null) {
            ll.add(path);
        }
        Node root = ExplorerManager.findPath(h.getNode(), rootCtx);
        this.restoreSelection(root, exploredCtx, ll);
    }

    private void restoreSelection(final Node root, final String[] exploredCtx, final List selectedPaths) {
        this.setRootContext(root);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                ArrayList<Node> selNodes = new ArrayList<Node>(selectedPaths.size());
                Iterator iter = selectedPaths.iterator();
                while (iter.hasNext()) {
                    String[] path = (String[])iter.next();
                    selNodes.add(ExplorerManager.findPath(root, path));
                }
                try {
                    Node[] newSelection = selNodes.toArray(new Node[selNodes.size()]);
                    if (exploredCtx != null) {
                        ExplorerManager.this.setExploredContext(ExplorerManager.findPath(root, exploredCtx), newSelection);
                    } else {
                        ExplorerManager.this.setSelectedNodes0(newSelection);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
    }

    public static ExplorerManager find(Component comp) {
        do {
            if ((comp = comp.getParent()) != null) continue;
            return new ExplorerManager();
        } while (!(comp instanceof Provider));
        return ((Provider)((Object)comp)).getExplorerManager();
    }

    static Node findPath(Node r, String[] path) {
        try {
            return NodeOp.findPath(r, path);
        }
        catch (NodeNotFoundException ex) {
            return ex.getClosestNode();
        }
    }

    static synchronized RequestProcessor getSelectionProcessor() {
        if (selectionProcessor == null) {
            selectionProcessor = new RequestProcessor("ExplorerManager-selection");
        }
        return selectionProcessor;
    }

    private static String getString(String key) {
        return NbBundle.getMessage(class$org$openide$explorer$ExplorerManager == null ? (class$org$openide$explorer$ExplorerManager = ExplorerManager.class$("org.openide.explorer.ExplorerManager")) : class$org$openide$explorer$ExplorerManager, key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Class.forName("org.openide.util.actions.CallbackSystemAction");
        }
        catch (Exception exception) {
            // empty catch block
        }
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("root", class$org$openide$nodes$Node$Handle == null ? (class$org$openide$nodes$Node$Handle = ExplorerManager.class$("org.openide.nodes.Node$Handle")) : class$org$openide$nodes$Node$Handle), new ObjectStreamField("rootName", class$java$lang$String == null ? (class$java$lang$String = ExplorerManager.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("explored", array$Ljava$lang$String == null ? (array$Ljava$lang$String = ExplorerManager.class$("[Ljava.lang.String;")) : array$Ljava$lang$String), new ObjectStreamField("selected", array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = ExplorerManager.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object)};
    }

    private class Listener
    extends NodeAdapter
    implements Runnable {
        Collection removeList = new HashSet();

        Listener() {
        }

        public void nodeDestroyed(NodeEvent ev) {
            if (ev.getNode().equals(ExplorerManager.this.getRootContext())) {
                ExplorerManager.this.setRootContext(Node.EMPTY);
            } else {
                this.scheduleRemove(ev.getNode());
            }
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if (ExplorerManager.this.propertySupport != null) {
                ExplorerManager.this.propertySupport.firePropertyChange(ExplorerManager.PROP_NODE_CHANGE, null, null);
            }
        }

        private void scheduleRemove(Node n) {
            ExplorerManager explorerManager = ExplorerManager.this;
            synchronized (explorerManager) {
                if (ExplorerManager.this.selectionSyncTask == null) {
                    ExplorerManager.this.selectionSyncTask = ExplorerManager.getSelectionProcessor().create(this);
                } else {
                    ExplorerManager.this.selectionSyncTask.cancel();
                }
            }
            Listener listener = this;
            synchronized (listener) {
                this.removeList.add(n);
            }
            ExplorerManager.this.selectionSyncTask.schedule(200);
        }

        public void run() {
            Collection remove;
            Listener listener = this;
            synchronized (listener) {
                remove = this.removeList;
                this.removeList = new HashSet();
            }
            LinkedList<Node> newSel = new LinkedList<Node>(Arrays.asList(ExplorerManager.this.getSelectedNodes()));
            newSel.removeAll(remove);
            Node[] selNodes = newSel.toArray(new Node[newSel.size()]);
            ExplorerManager.this.setSelectedNodes0(selNodes);
        }
    }

    public static interface Provider {
        public ExplorerManager getExplorerManager();
    }
}

