/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer;

import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.MessageFormat;
import org.openide.explorer.ExplorerActions;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.io.NbMarshalledObject;
import org.openide.util.io.SafeException;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class ExplorerPanel
extends TopComponent
implements ExplorerManager.Provider {
    static final long serialVersionUID = 5522528786650751459L;
    private static MessageFormat formatExplorerTitle;
    private ExplorerManager manager;
    private transient PropertyChangeListener managerListener;
    private static final ExplorerActions actions;
    static /* synthetic */ Class class$org$openide$explorer$ExplorerPanel;

    static ExplorerActions getActions() {
        return actions;
    }

    public ExplorerPanel(ExplorerManager manager) {
        this();
        this.manager = manager;
    }

    public ExplorerPanel() {
        this.setLayout(new BorderLayout());
    }

    public void open() {
        this.open(WindowManager.getDefault().getCurrentWorkspace());
    }

    public void open(Workspace workspace) {
        super.open(workspace);
        if (this.managerListener == null) {
            this.managerListener = new PropL();
            this.getExplorerManager().addPropertyChangeListener(this.managerListener);
        }
        this.setActivatedNodes(this.getExplorerManager().getSelectedNodes());
        this.updateTitle();
    }

    public boolean canClose(Workspace workspace, boolean last) {
        boolean result = super.canClose(workspace, last);
        if (result && last) {
            this.getExplorerManager().removePropertyChangeListener(this.managerListener);
            this.managerListener = null;
        }
        return result;
    }

    public ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            ExplorerPanel explorerPanel = this;
            synchronized (explorerPanel) {
                if (this.manager == null) {
                    this.manager = new ExplorerManager();
                }
            }
        }
        return this.manager;
    }

    protected void componentActivated() {
        actions.attach(this.getExplorerManager());
    }

    protected void componentDeactivated() {
        if (this.getExplorerManager() == actions.getAttachedManager()) {
            actions.detach();
        }
    }

    protected void updateTitle() {
        String nm;
        Node n;
        String name = "";
        ExplorerManager em = this.getExplorerManager();
        if (em != null && (n = em.getExploredContext()) != null && (nm = n.getDisplayName()) != null) {
            name = nm;
        }
        if (formatExplorerTitle == null) {
            formatExplorerTitle = new MessageFormat(NbBundle.getMessage(class$org$openide$explorer$ExplorerPanel == null ? (class$org$openide$explorer$ExplorerPanel = ExplorerPanel.class$("org.openide.explorer.ExplorerPanel")) : class$org$openide$explorer$ExplorerPanel, "explorerTitle"));
        }
        this.setName(formatExplorerTitle.format(new Object[]{name}));
    }

    public HelpCtx getHelpCtx() {
        return ExplorerPanel.getHelpCtx(this.getExplorerManager().getSelectedNodes(), new HelpCtx(class$org$openide$explorer$ExplorerPanel == null ? (class$org$openide$explorer$ExplorerPanel = ExplorerPanel.class$("org.openide.explorer.ExplorerPanel")) : class$org$openide$explorer$ExplorerPanel));
    }

    public static HelpCtx getHelpCtx(Node[] sel, HelpCtx def) {
        HelpCtx result = null;
        int i = 0;
        while (i < sel.length) {
            HelpCtx attempt = sel[i].getHelpCtx();
            if (attempt != null && !attempt.equals(HelpCtx.DEFAULT_HELP)) {
                if (result == null || result.equals(attempt)) {
                    result = attempt;
                } else {
                    result = null;
                    break;
                }
            }
            ++i;
        }
        if (result != null) {
            return result;
        }
        return def;
    }

    public static void setConfirmDelete(boolean confirmDelete) {
        actions.setConfirmDelete(confirmDelete);
    }

    public static boolean isConfirmDelete() {
        return actions.isConfirmDelete();
    }

    public void writeExternal(ObjectOutput oo) throws IOException {
        super.writeExternal(oo);
        oo.writeObject(new NbMarshalledObject(this.manager));
    }

    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        super.readExternal(oi);
        Object anObj = oi.readObject();
        if (anObj instanceof ExplorerManager) {
            this.manager = (ExplorerManager)anObj;
            return;
        }
        NbMarshalledObject obj = (NbMarshalledObject)anObj;
        try {
            this.manager = (ExplorerManager)obj.get();
        }
        catch (SafeException se) {
            throw se;
        }
        catch (IOException ioe) {
            throw new SafeException(ioe);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        actions = new ExplorerActions();
    }

    private final class PropL
    implements PropertyChangeListener {
        PropL() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                ExplorerPanel.this.setActivatedNodes(ExplorerPanel.this.manager.getSelectedNodes());
                return;
            }
            if ("exploredContext".equals(evt.getPropertyName())) {
                ExplorerPanel.this.updateTitle();
                return;
            }
        }
    }
}

