/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import org.openide.explorer.propertysheet.PropertyDialogManager;

public final class PropertyEnv {
    public static final String PROP_STATE = "state";
    public static final Object STATE_VALID = "valid";
    public static final Object STATE_NEEDS_VALIDATION = "needs_validation";
    public static final Object STATE_INVALID = "invalid";
    static final String PROP_CHANGE_IMMEDIATE = "changeImmediate";
    static final FeatureDescriptor dummyDescriptor = new FeatureDescriptor();
    private FeatureDescriptor featureDescriptor = dummyDescriptor;
    private Object[] beans;
    private Object state = STATE_VALID;
    private VetoableChangeSupport support;
    private PropertyChangeSupport change;
    private boolean changeImmediate = true;

    PropertyEnv() {
    }

    public Object[] getBeans() {
        return this.beans;
    }

    void setBeans(Object[] beans) {
        this.beans = beans;
    }

    public FeatureDescriptor getFeatureDescriptor() {
        return this.featureDescriptor;
    }

    void setFeatureDescriptor(FeatureDescriptor desc) {
        Object obj;
        if (desc == null) {
            throw new IllegalArgumentException("Cannot set FeatureDescriptor to null.");
        }
        this.featureDescriptor = desc;
        if (this.featureDescriptor != null && (obj = this.featureDescriptor.getValue(PROP_CHANGE_IMMEDIATE)) instanceof Boolean) {
            this.setChangeImmediate((Boolean)obj);
        }
    }

    public void setState(Object state) {
        Object oldState = this.state;
        this.state = state;
        try {
            this.getSupport().fireVetoableChange(PROP_STATE, oldState, state);
            this.getChange().firePropertyChange(PROP_STATE, null, state);
        }
        catch (PropertyVetoException pve) {
            this.state = oldState;
            PropertyDialogManager.notify(pve);
        }
    }

    public Object getState() {
        return this.state;
    }

    public void addVetoableChangeListener(VetoableChangeListener l) {
        this.getSupport().addVetoableChangeListener(l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getChange().addPropertyChangeListener(l);
    }

    public void removeVetoableChangeListener(VetoableChangeListener l) {
        this.getSupport().removeVetoableChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.getChange().removePropertyChangeListener(l);
    }

    boolean isChangeImmediate() {
        return this.changeImmediate;
    }

    void setChangeImmediate(boolean changeImmediate) {
        this.changeImmediate = changeImmediate;
    }

    private synchronized VetoableChangeSupport getSupport() {
        if (this.support == null) {
            this.support = new VetoableChangeSupport(this);
        }
        return this.support;
    }

    private synchronized PropertyChangeSupport getChange() {
        if (this.change == null) {
            this.change = new PropertyChangeSupport(this);
        }
        return this.change;
    }
}

