/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet.editors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;
import java.util.Collection;
import java.util.HashSet;
import org.openide.compiler.ExternalCompiler;
import org.openide.explorer.propertysheet.editors.ErrorExpressionPanel;

public abstract class ExternalCompiler {
    private ExternalCompiler() {
    }

    public static class ErrorExpressionEditor
    extends PropertyEditorSupport {
        private static Collection sharedList = new HashSet(17);
        private Collection list;
        private ExternalCompiler.ErrorExpression value;

        public ErrorExpressionEditor() {
            this(sharedList);
        }

        public ErrorExpressionEditor(Collection list) {
            this.list = list;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            ErrorExpressionEditor errorExpressionEditor = this;
            synchronized (errorExpressionEditor) {
                this.value = (ExternalCompiler.ErrorExpression)value;
                if (value != null) {
                    this.list.add(value);
                }
            }
            this.firePropertyChange();
        }

        public String getAsText() {
            if (this.value == null) {
                return "null";
            }
            return this.value.getName();
        }

        public void setAsText(String string) {
            ExternalCompiler.ErrorExpression[] exprs = this.getExpressions();
            int i = 0;
            while (i < exprs.length) {
                if (string.equals(exprs[i].getName())) {
                    this.setValue(exprs[i]);
                    break;
                }
                ++i;
            }
        }

        public String getJavaInitializationString() {
            return "new ExternalCompiler.ErrorExpression (" + this.value.getName() + ", " + this.value.getErrorExpression() + ", " + this.value.getFilePos() + ", " + this.value.getLinePos() + ", " + this.value.getColumnPos() + ", " + this.value.getDescriptionPos() + ")";
        }

        public String[] getTags() {
            ExternalCompiler.ErrorExpression[] exprs = this.getExpressions();
            String[] tags = new String[exprs.length];
            int i = 0;
            while (i < exprs.length) {
                tags[i] = exprs[i].getName();
                ++i;
            }
            return tags;
        }

        public boolean isPaintable() {
            return false;
        }

        public void paintValue(Graphics g, Rectangle rectangle) {
        }

        public boolean supportsCustomEditor() {
            return true;
        }

        public Component getCustomEditor() {
            return new ErrorExpressionPanel(this);
        }

        synchronized ExternalCompiler.ErrorExpression[] getExpressions() {
            return this.list.toArray(new ExternalCompiler.ErrorExpression[this.list.size()]);
        }

        Collection getExpressionsVector() {
            return this.list;
        }

        static {
            sharedList.add(org.openide.compiler.ExternalCompiler.JAVAC);
            sharedList.add(org.openide.compiler.ExternalCompiler.JIKES);
            sharedList.add(org.openide.compiler.ExternalCompiler.JVC);
        }
    }
}

