/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet.editors;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.explorer.propertysheet.editors.MethodParameterPanel;
import org.openide.explorer.propertysheet.editors.ObjectArrayPanel;
import org.openide.src.MethodParameter;
import org.openide.src.Type;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class MethodParameterArrayEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    MethodParameterArrayPanel panel;
    boolean ignoreEditor = false;
    boolean ignorePanel = false;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$editors$MethodParameterArrayEditor;

    public String getAsText() {
        MethodParameter[] params = (MethodParameter[])this.getValue();
        StringBuffer buf = new StringBuffer();
        if (params != null) {
            int i = 0;
            while (i < params.length) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(params[i].getSourceString());
                ++i;
            }
        }
        return buf.toString();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        StringTokenizer tok = new StringTokenizer(text, ",", false);
        ArrayList<MethodParameter> list = new ArrayList<MethodParameter>();
        while (tok.hasMoreTokens()) {
            MethodParameter par;
            String token = tok.nextToken();
            try {
                par = MethodParameter.parse(token);
            }
            catch (IllegalArgumentException ex) {
                String msg = MessageFormat.format(MethodParameterArrayEditor.getString("MSG_IllegalMethodParameter"), token);
                ErrorManager.getDefault().annotate(ex, 256, null, msg, null, null);
                throw ex;
            }
            Iterator it = ((AbstractList)list).iterator();
            while (it.hasNext()) {
                if (!par.getName().equals(((MethodParameter)it.next()).getName())) continue;
                String msg = MessageFormat.format(MethodParameterArrayEditor.getString("MSG_DuplicateName2"), par.getName());
                IllegalArgumentException ex = new IllegalArgumentException("Ambiguous name");
                ErrorManager.getDefault().annotate(ex, 256, null, msg, null, null);
                throw ex;
            }
            list.add(par);
        }
        MethodParameter[] params = new MethodParameter[list.size()];
        list.toArray(params);
        this.setValue(params);
    }

    public void setValue(Object o) {
        this.ignoreEditor = true;
        boolean saveIgnorePanel = this.ignorePanel;
        this.ignorePanel = false;
        super.setValue(o);
        if (this.panel != null & !saveIgnorePanel) {
            this.panel.setMethodParameters((MethodParameter[])o);
        }
        this.ignoreEditor = false;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        if (this.panel == null) {
            this.panel = new MethodParameterArrayPanel();
            this.panel.setMethodParameters((MethodParameter[])this.getValue());
            this.panel.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (!MethodParameterArrayEditor.this.ignoreEditor && "methodParameters".equals(evt.getPropertyName())) {
                        MethodParameterArrayEditor.this.ignorePanel = true;
                        MethodParameterArrayEditor.this.setValue(evt.getNewValue());
                        MethodParameterArrayEditor.this.ignorePanel = false;
                    }
                }
            });
        }
        return this.panel;
    }

    public void attachEnv(PropertyEnv env) {
    }

    private static String getString(String key) {
        return NbBundle.getBundle(class$org$openide$explorer$propertysheet$editors$MethodParameterArrayEditor == null ? (class$org$openide$explorer$propertysheet$editors$MethodParameterArrayEditor = MethodParameterArrayEditor.class$("org.openide.explorer.propertysheet.editors.MethodParameterArrayEditor")) : class$org$openide$explorer$propertysheet$editors$MethodParameterArrayEditor).getString(key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class MethodParameterArrayPanel
    extends ObjectArrayPanel
    implements EnhancedCustomPropertyEditor {
        public static final String PROP_METHOD_PARAMETERS = "methodParameters";
        MethodParameter[] prevValue = new MethodParameter[0];

        public MethodParameterArrayPanel() {
            this.getListComponent().setCellRenderer(new DefaultListCellRenderer(this){
                private final /* synthetic */ MethodParameterArrayPanel this$0;
                {
                    this.this$0 = this$0;
                }

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (comp == this) {
                        this.setText(((MethodParameter)value).toString());
                    }
                    return comp;
                }
            });
        }

        public MethodParameter[] getMethodParameters() {
            Object[] ret = new MethodParameter[this.model.size()];
            this.model.copyInto(ret);
            return ret;
        }

        public void setMethodParameters(MethodParameter[] data) {
            this.model = new DefaultListModel();
            if (data != null) {
                int i = 0;
                while (i < data.length) {
                    this.model.addElement(data[i]);
                    ++i;
                }
            }
            this.getListComponent().setModel(this.model);
            this.modelChanged();
        }

        protected void modelChanged() {
            super.modelChanged();
            MethodParameter[] newValue = this.getMethodParameters();
            this.firePropertyChange(PROP_METHOD_PARAMETERS, this.prevValue, newValue);
            this.prevValue = newValue;
        }

        protected Object insertNewValue() {
            return this.openInputDialog(null);
        }

        protected Object editValue(Object oldValue) {
            return this.openInputDialog((MethodParameter)oldValue);
        }

        protected MethodParameter openInputDialog(MethodParameter origValue) {
            Object ret;
            MethodParameterPanel panel = new MethodParameterPanel();
            NotifyDescriptor desriptor = new NotifyDescriptor(panel, MethodParameterArrayEditor.getString("LAB_EnterParameter"), 2, -1, null, null);
            if (origValue != null) {
                panel.nameTextField.setText(origValue.getName().toString());
                panel.typeCombo.setSelectedItem(origValue.getType().toString());
                panel.finalCheckBox.setSelected(origValue.isFinal());
            }
            while ((ret = TopManager.getDefault().notify(desriptor)) == NotifyDescriptor.OK_OPTION) {
                String errMsg = null;
                String name = panel.nameTextField.getText();
                if (!Utilities.isJavaIdentifier(name)) {
                    errMsg = "MSG_NotValidID";
                } else {
                    try {
                        Type type = Type.parse(panel.typeCombo.getSelectedItem().toString());
                        boolean isFinal = panel.finalCheckBox.isSelected();
                        Enumeration methodEnum = this.model.elements();
                        while (methodEnum.hasMoreElements()) {
                            MethodParameter oldPar = (MethodParameter)methodEnum.nextElement();
                            if (origValue != null && oldPar.equals(origValue) || !name.equals(oldPar.getName())) continue;
                            errMsg = "MSG_DuplicateName";
                            break;
                        }
                        if (errMsg == null) {
                            return new MethodParameter(name, type, isFinal);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        errMsg = "MSG_NotValidType";
                    }
                }
                TopManager.getDefault().notify(new NotifyDescriptor.Message(MethodParameterArrayEditor.getString(errMsg)));
            }
            return null;
        }

        public Object getPropertyValue() throws IllegalStateException {
            return this.getMethodParameters();
        }
    }
}

