/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.openide.explorer.propertysheet.editors.ModifierEditor;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;

class ModifierPanel
extends JPanel {
    public static final String PROP_MASK = "mask";
    public static final String PROP_MODIFIER = "modifier";
    private static final int CHECK_ABSTRACT = 0;
    private static final int CHECK_FINAL = 1;
    private static final int CHECK_STATIC = 2;
    private static final int CHECK_SYNCHRONIZED = 3;
    private static final int CHECK_TRANSIENT = 4;
    private static final int CHECK_VOLATILE = 5;
    private static final int CHECK_NATIVE = 6;
    static final String[] MODIFIER_NAMES = new String[]{"abstract", "final", "static", "synchronized", "transient", "volatile", "native"};
    private static final String[] MODIFIER_DESCRIPTION_KEYS = new String[]{"ACSD_ModifierPanel_Modifier_Abstract", "ACSD_ModifierPanel_Modifier_Final", "ACSD_ModifierPanel_Modifier_Static", "ACSD_ModifierPanel_Modifier_Synchronized", "ACSD_ModifierPanel_Modifier_Transient", "ACSD_ModifierPanel_Modifier_Volatile", "ACSD_ModifierPanel_Modifier_Native"};
    private static final String[] MODIFIER_MNEMONICS_KEYS = new String[]{"ModifierPanel_Modifier_Abstract_Mnemonic", "ModifierPanel_Modifier_Final_Mnemonic", "ModifierPanel_Modifier_Static_Mnemonic", "ModifierPanel_Modifier_Synchronized_Mnemonic", "ModifierPanel_Modifier_Transient_Mnemonic", "ModifierPanel_Modifier_Volatile_Mnemonic", "ModifierPanel_Modifier_Native_Mnemonic"};
    static final int[] MODIFIER_VALUES = new int[]{1024, 16, 8, 32, 128, 64, 256};
    static final int MODIFIER_COUNT = MODIFIER_VALUES.length;
    static final String[] ACCESS_NAMES = new String[]{"<default>", "private", "protected", "public"};
    static final int[] ACCESS_VALUES = new int[]{0, 2, 4, 1};
    static final int ACCESS_MASK = 7;
    static final int EDITABLE_MASK = 1535;
    private ModifierEditor myEditor;
    private int[] currentAccessValues;
    private String[] currentAccessNames;
    private JCheckBox[] checks;
    private ActionListener listener;
    private boolean ignored = false;
    private PropertyChangeSupport propertyChangeSupport;
    static final long serialVersionUID = 6884758007403225916L;
    private JComboBox accessCombo;
    private JPanel modifPanel;
    private JLabel jLabel1;
    private JPanel jPanel2;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$editors$ModifierPanel;

    public ModifierPanel(ModifierEditor ed) {
        this.myEditor = ed;
        this.currentAccessValues = ACCESS_VALUES;
        this.currentAccessNames = ACCESS_NAMES;
        this.myEditor.addPropertyChangeListener(WeakListener.propertyChange(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (ModifierPanel.PROP_MODIFIER.equals(evt.getPropertyName()) || ModifierPanel.PROP_MASK.equals(evt.getPropertyName())) {
                    ModifierPanel.this.updateAccess();
                    ModifierPanel.this.ignored = true;
                    ModifierPanel.this.updateComponents();
                    ModifierPanel.this.ignored = false;
                }
            }
        }, this.myEditor));
        this.listener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                int selIndex = ModifierPanel.this.accessCombo.getSelectedIndex();
                if (evt.getSource() == ModifierPanel.this.accessCombo && selIndex < 0) {
                    return;
                }
                if (ModifierPanel.this.checks[0].isSelected() && (ModifierPanel.this.myEditor.getModifier() & MODIFIER_VALUES[0]) == 0 && (ModifierPanel.this.myEditor.getModifier() & 2) > 0) {
                    ModifierPanel.this.checks[0].setSelected(false);
                }
                if (selIndex >= 0 && (ModifierPanel.this.currentAccessValues[ModifierPanel.this.accessCombo.getSelectedIndex()] & 2) > 0 && (ModifierPanel.this.myEditor.getModifier() & 2) == 0) {
                    ModifierPanel.this.checks[0].setSelected(false);
                }
                ModifierPanel.this.excludeChecks(0, 1);
                ModifierPanel.this.excludeChecks(0, 6);
                ModifierPanel.this.excludeChecks(0, 2);
                ModifierPanel.this.excludeChecks(0, 3);
                ModifierPanel.this.excludeChecks(5, 1);
                if (!ModifierPanel.this.ignored) {
                    ModifierPanel.this.updateValue();
                }
            }
        };
        this.ignored = true;
        this.initComponents();
        this.modifPanel.setBorder(new CompoundBorder(new TitledBorder(ModifierPanel.getString("LAB_Modifiers")), new EmptyBorder(new Insets(3, 3, 3, 3))));
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.updateAccess();
        this.updateModifiers();
        this.updateComponents();
        this.ignored = false;
        this.jLabel1.setDisplayedMnemonic(ModifierPanel.getString("LAB_AccessRights_Mnemonic").charAt(0));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(ModifierPanel.getString("ACSD_AccessRights"));
    }

    private void excludeChecks(int check1, int check2) {
        if (this.checks[check1].isSelected() && (this.myEditor.getModifier() & MODIFIER_VALUES[check1]) == 0) {
            this.checks[check2].setSelected(false);
        } else if (this.checks[check2].isSelected() && (this.myEditor.getModifier() & MODIFIER_VALUES[check2]) == 0) {
            this.checks[check1].setSelected(false);
        }
    }

    private void initComponents() {
        this.modifPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.accessCombo = new JComboBox();
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(new Insets(6, 7, 6, 7)));
        this.modifPanel.setLayout(new GridLayout(4, 2, 4, 4));
        this.checks = new JCheckBox[MODIFIER_COUNT];
        int i = 0;
        while (i < MODIFIER_COUNT) {
            this.checks[i] = new JCheckBox(MODIFIER_NAMES[i]);
            this.checks[i].setMnemonic(ModifierPanel.getModifierMnemonics(i));
            this.checks[i].getAccessibleContext().setAccessibleDescription(ModifierPanel.getModifierDescription(i));
            this.modifPanel.add(this.checks[i]);
            this.checks[i].setEnabled((this.myEditor.getMask() & MODIFIER_VALUES[i]) != 0);
            this.checks[i].addActionListener(this.listener);
            ++i;
        }
        this.add((Component)this.modifPanel, "Center");
        this.jPanel2.setLayout(new BorderLayout(8, 8));
        this.jPanel2.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.jLabel1.setText(ModifierPanel.getString("LAB_AccessRights"));
        this.jLabel1.setLabelFor(this.accessCombo);
        this.jPanel2.add((Component)this.jLabel1, "West");
        this.accessCombo.addActionListener(this.listener);
        this.jPanel2.add((Component)this.accessCombo, "Center");
        this.add((Component)this.jPanel2, "North");
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    private void updateAccess() {
        int selValue = this.myEditor.getModifier() & 7;
        int selIndex = -1;
        int counter = 1;
        int i = 1;
        while (i < ACCESS_VALUES.length) {
            if ((ACCESS_VALUES[i] & this.myEditor.getMask()) != 0) {
                ++counter;
            }
            ++i;
        }
        this.currentAccessValues = new int[counter];
        this.currentAccessNames = new String[counter];
        this.currentAccessValues[0] = ACCESS_VALUES[0];
        this.currentAccessNames[0] = ACCESS_NAMES[0];
        counter = 1;
        int i2 = 1;
        while (i2 < ACCESS_VALUES.length) {
            if ((ACCESS_VALUES[i2] & this.myEditor.getMask()) != 0) {
                this.currentAccessValues[counter] = ACCESS_VALUES[i2];
                this.currentAccessNames[counter] = ACCESS_NAMES[i2];
                if (ACCESS_VALUES[i2] == selValue) {
                    selIndex = counter;
                }
                ++counter;
            }
            ++i2;
        }
        if (selIndex == -1 && selValue == 0) {
            selIndex = 0;
        }
        this.ignored = true;
        this.accessCombo.setModel(new DefaultComboBoxModel<String>(this.currentAccessNames));
        this.accessCombo.setSelectedIndex(selIndex);
        this.ignored = false;
    }

    private void updateModifiers() {
        int i = 0;
        while (i < MODIFIER_COUNT) {
            this.checks[i].setEnabled((this.myEditor.getMask() & MODIFIER_VALUES[i]) != 0);
            ++i;
        }
    }

    private void updateComponents() {
        this.updateAccessCombo();
        this.updateModifiers();
        int i = 0;
        while (i < MODIFIER_COUNT) {
            this.checks[i].setSelected((this.myEditor.getModifier() & MODIFIER_VALUES[i]) != 0);
            ++i;
        }
    }

    private void updateAccessCombo() {
        int selIndex = -1;
        int i = 1;
        while (i < this.currentAccessValues.length) {
            if ((this.currentAccessValues[i] & this.myEditor.getModifier()) != 0) {
                if (selIndex != -1) {
                    selIndex = -1;
                    break;
                }
                selIndex = i;
            }
            ++i;
        }
        if (this.accessCombo.getSelectedIndex() != selIndex) {
            this.accessCombo.setSelectedIndex(selIndex);
        }
    }

    private void updateValue() {
        int newValue = 0;
        int comboIndex = this.accessCombo.getSelectedIndex();
        newValue = comboIndex == -1 ? this.myEditor.getModifier() & 7 : (newValue |= this.currentAccessValues[comboIndex]);
        int i = 0;
        while (i < MODIFIER_COUNT) {
            if (this.checks[i].isSelected() & this.checks[i].isEnabled()) {
                newValue |= MODIFIER_VALUES[i];
            }
            ++i;
        }
        if (this.myEditor.getModifier() != newValue) {
            this.myEditor.setModifier(newValue);
        }
    }

    private static String getString(String key) {
        return NbBundle.getBundle(class$org$openide$explorer$propertysheet$editors$ModifierPanel == null ? (class$org$openide$explorer$propertysheet$editors$ModifierPanel = ModifierPanel.class$("org.openide.explorer.propertysheet.editors.ModifierPanel")) : class$org$openide$explorer$propertysheet$editors$ModifierPanel).getString(key);
    }

    static String getModifierDescription(int i) {
        return ModifierPanel.getString(MODIFIER_DESCRIPTION_KEYS[i]);
    }

    static char getModifierMnemonics(int i) {
        return ModifierPanel.getString(MODIFIER_MNEMONICS_KEYS[i]).charAt(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

