/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.datatransfer.Transferable;
import org.openide.nodes.Node;

final class ExplorerDnDManager {
    private static ExplorerDnDManager defaultDnDManager;
    private Node[] draggedNodes;
    private Transferable draggedTransForCut;
    private Transferable draggedTransForCopy;
    private boolean isDnDActive = false;
    private int allowedActions = 0;
    private int supportedActions = 0x40000003;

    private ExplorerDnDManager() {
    }

    static synchronized ExplorerDnDManager getDefault() {
        if (defaultDnDManager == null) {
            defaultDnDManager = new ExplorerDnDManager();
        }
        return defaultDnDManager;
    }

    void setDraggedNodes(Node[] n) {
        this.draggedNodes = n;
    }

    Node[] getDraggedNodes() {
        return this.draggedNodes;
    }

    void setDraggedTransferable(Transferable trans, boolean isCut) {
        if (isCut) {
            this.draggedTransForCut = trans;
        } else {
            this.draggedTransForCopy = trans;
        }
    }

    Transferable getDraggedTransferable(boolean isCut) {
        if (isCut) {
            return this.draggedTransForCut;
        }
        return this.draggedTransForCopy;
    }

    void setAllowedDragActions(int actions) {
        this.allowedActions = actions;
    }

    int getAllowedDragActions() {
        if (this.allowedActions == 0) {
            return 0;
        }
        return this.allowedActions;
    }

    void setSupportedDragActions(int actions) {
        this.supportedActions = actions;
    }

    int getSupportedDragActions() {
        if (this.supportedActions == 0) {
            return 0;
        }
        return this.supportedActions;
    }

    void setDnDActive(boolean state) {
        this.isDnDActive = state;
    }

    boolean isDnDActive() {
        return this.isDnDActive;
    }
}

