/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Dialog;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.IOException;
import java.util.TooManyListenersException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.openide.ErrorManager;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.ExplorerDnDManager;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

abstract class ExplorerDragSupport
implements DragSourceListener,
DragGestureListener {
    boolean active = false;
    DragGestureRecognizer defaultGesture;
    protected JComponent comp;
    ExplorerDnDManager exDnD = ExplorerDnDManager.getDefault();
    static /* synthetic */ Class class$java$awt$Dialog;

    ExplorerDragSupport() {
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        Node[] nodes = this.obtainNodes(dge);
        if (nodes == null || nodes.length == 0) {
            return;
        }
        int possibleAction = 2;
        int i = 0;
        while (i < nodes.length) {
            if (possibleAction == 2 && !nodes[i].canCut()) {
                possibleAction = 1;
            }
            if (possibleAction == 1 && !nodes[i].canCopy()) {
                possibleAction = 0;
            }
            ++i;
        }
        this.exDnD = ExplorerDnDManager.getDefault();
        this.exDnD.setAllowedDragActions(possibleAction);
        int dragAction = dge.getDragAction();
        boolean dragStatus = this.canDrag(dragAction, possibleAction);
        try {
            Transferable transferable;
            if (possibleAction == 2) {
                transferable = DragDropUtilities.getNodeTransferable(nodes, 2);
                this.exDnD.setDraggedTransferable(transferable, true);
                transferable = DragDropUtilities.getNodeTransferable(nodes, 1);
                this.exDnD.setDraggedTransferable(transferable, false);
            } else {
                transferable = DragDropUtilities.getNodeTransferable(nodes, 1);
                this.exDnD.setDraggedTransferable(transferable, false);
            }
            this.exDnD.setDraggedNodes(nodes);
            Dialog d = (Dialog)SwingUtilities.getAncestorOfClass(class$java$awt$Dialog == null ? (class$java$awt$Dialog = ExplorerDragSupport.class$("java.awt.Dialog")) : class$java$awt$Dialog, this.comp);
            if (d != null && d.isModal()) {
                this.exDnD.setDnDActive(false);
                return;
            }
            dge.startDrag(DragDropUtilities.chooseCursor(dragAction, dragStatus), Utilities.loadImage("org/openide/resources/cursorscopysingle.gif"), new Point(16, 16), transferable, this);
            this.exDnD.setDnDActive(true);
        }
        catch (InvalidDnDOperationException exc) {
            ErrorManager em = ErrorManager.getDefault();
            Throwable t = em.annotate(new Throwable(exc.getMessage()), "JDK bug #4656769. You have to restart window manager.");
            em.notify(16, t);
            this.exDnD.setDnDActive(false);
        }
        catch (IOException exc) {
            ErrorManager.getDefault().notify(exc);
            this.exDnD.setDnDActive(false);
        }
    }

    private boolean canDrag(int targetAction, int possibleAction) {
        switch (possibleAction) {
            case 2: {
                return true;
            }
            case 1: 
            case 3: 
            case 0x40000000: {
                return targetAction != 2;
            }
        }
        return targetAction == 0;
    }

    public void dragEnter(DragSourceDragEvent dsde) {
        dsde.getDragSourceContext().setCursor(DragDropUtilities.chooseCursor(dsde.getDropAction(), this.canDrag(dsde.getUserAction(), this.exDnD.getAllowedDragActions())));
    }

    public void dragOver(DragSourceDragEvent dsde) {
        dsde.getDragSourceContext().setCursor(DragDropUtilities.chooseCursor(dsde.getDropAction(), this.canDrag(dsde.getUserAction(), this.exDnD.getAllowedDragActions())));
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    public void dragExit(DragSourceEvent dse) {
        dse.getDragSourceContext().setCursor(DragDropUtilities.chooseCursor(dse.getDragSourceContext().getSourceActions(), false));
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
        this.exDnD.setDraggedTransferable(null, true);
        this.exDnD.setDraggedTransferable(null, false);
        this.exDnD.setDraggedNodes(null);
    }

    public void activate(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        DragGestureRecognizer dgr = this.getDefaultGestureRecognizer();
        if (active) {
            dgr.setSourceActions(this.exDnD.getSupportedDragActions());
            try {
                dgr.removeDragGestureListener(this);
                dgr.addDragGestureListener(this);
            }
            catch (TooManyListenersException exc) {
                throw new IllegalStateException("Too many listeners for drag gesture.");
            }
        } else {
            dgr.removeDragGestureListener(this);
        }
    }

    DragGestureRecognizer getDefaultGestureRecognizer() {
        if (this.defaultGesture == null) {
            DragSource ds = DragSource.getDefaultDragSource();
            this.defaultGesture = ds.createDefaultDragGestureRecognizer(this.comp, this.exDnD.getSupportedDragActions(), this);
        }
        return this.defaultGesture;
    }

    abstract Node[] obtainNodes(DragGestureEvent var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

