/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.ErrorManager;
import org.openide.awt.MouseUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.AutoscrollSupport;
import org.openide.explorer.view.ListViewDragSupport;
import org.openide.explorer.view.ListViewDropSupport;
import org.openide.explorer.view.NodeListModel;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;

public class ListView
extends JScrollPane
implements Externalizable {
    static final long serialVersionUID = -7540940974042262975L;
    private transient ExplorerManager manager;
    protected transient JList list;
    protected transient NodeListModel model;
    transient Listener managerListener;
    transient PropertyChangeListener wlpc;
    transient VetoableChangeListener wlvc;
    transient PopupSupport popupSupport;
    private boolean popupAllowed = true;
    private boolean traversalAllowed = true;
    private ActionListener defaultProcessor;
    transient boolean dragActive = false;
    transient boolean dropActive = false;
    transient ListViewDragSupport dragSupport;
    transient ListViewDropSupport dropSupport;
    transient boolean listenerActive;

    public ListView() {
        this.initializeList();
    }

    private void initializeList() {
        this.model = this.createModel();
        this.list = this.createList();
        this.list.setModel(this.model);
        this.setViewportView(this.list);
        AbstractAction action = new GoUpAction();
        KeyStroke key = KeyStroke.getKeyStroke(8, 0);
        this.list.registerKeyboardAction(action, key, 0);
        action = new EnterAction();
        key = KeyStroke.getKeyStroke(10, 0);
        this.list.registerKeyboardAction(action, key, 0);
        this.managerListener = new Listener();
        this.popupSupport = new PopupSupport();
        this.list.getSelectionModel().setSelectionMode(2);
        ToolTipManager.sharedInstance().registerComponent(this.list);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(new Boolean(this.popupAllowed));
        out.writeObject(new Boolean(this.traversalAllowed));
        out.writeObject(new Integer(this.getSelectionMode()));
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.popupAllowed = (Boolean)in.readObject();
        this.traversalAllowed = (Boolean)in.readObject();
        this.setSelectionMode((Integer)in.readObject());
    }

    public boolean isPopupAllowed() {
        return this.popupAllowed;
    }

    public void setPopupAllowed(boolean value) {
        this.popupAllowed = value;
    }

    public boolean isTraversalAllowed() {
        return this.traversalAllowed;
    }

    public void setTraversalAllowed(boolean value) {
        this.traversalAllowed = value;
    }

    public ActionListener getDefaultProcessor() {
        return this.defaultProcessor;
    }

    public void setDefaultProcessor(ActionListener value) {
        this.defaultProcessor = value;
    }

    public void setSelectionMode(int selectionMode) {
        this.list.setSelectionMode(selectionMode);
    }

    public int getSelectionMode() {
        return this.list.getSelectionMode();
    }

    public boolean isDragSource() {
        return this.dragActive;
    }

    public void setDragSource(boolean state) {
        if (state == this.dragActive) {
            return;
        }
        this.dragActive = state;
        if (this.dragActive && this.dragSupport == null) {
            this.dragSupport = new ListViewDragSupport(this, this.list);
        }
        this.dragSupport.activate(this.dragActive);
    }

    public boolean isDropTarget() {
        return this.dropActive;
    }

    public void setDropTarget(boolean state) {
        if (state == this.dropActive) {
            return;
        }
        this.dropActive = state;
        if (this.dropActive && this.dropSupport == null) {
            this.dropSupport = new ListViewDropSupport(this, this.list);
        }
        this.dropSupport.activate(this.dropActive);
    }

    public int getAllowedDragActions() {
        return 0x40000003;
    }

    public void setAllowedDragActions(int actions) {
    }

    public int getAllowedDropActions() {
        return 0x40000003;
    }

    public void setAllowedDropActions(int actions) {
    }

    protected JList createList() {
        NbList list = new NbList();
        list.setCellRenderer(NodeRenderer.sharedInstance());
        return list;
    }

    protected NodeListModel createModel() {
        return new NodeListModel();
    }

    protected void selectionChanged(Node[] nodes, ExplorerManager em) throws PropertyVetoException {
        em.setSelectedNodes(nodes);
    }

    protected boolean selectionAccept(Node[] nodes) {
        if (nodes.length == 1 && this.manager.getRootContext().equals(nodes[0])) {
            return true;
        }
        Node cntx = this.manager.getExploredContext();
        int i = 0;
        while (i < nodes.length) {
            VisualizerNode v = VisualizerNode.getVisualizer(null, nodes[i]);
            if (this.model.getIndex(v) == -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void showSelection(int[] indexes) {
        this.list.setSelectedIndices(indexes);
    }

    public void addNotify() {
        super.addNotify();
        ExplorerManager em = ExplorerManager.find(this);
        if (em != this.manager) {
            if (this.manager != null) {
                this.manager.removeVetoableChangeListener(this.wlvc);
                this.manager.removePropertyChangeListener(this.wlpc);
            }
            this.manager = em;
            this.wlvc = WeakListener.vetoableChange(this.managerListener, this.manager);
            this.manager.addVetoableChangeListener(this.wlvc);
            this.wlpc = WeakListener.propertyChange(this.managerListener, this.manager);
            this.manager.addPropertyChangeListener(this.wlpc);
            this.model.setNode(this.manager.getExploredContext());
            this.updateSelection();
        } else if (!this.listenerActive && this.manager != null) {
            this.wlvc = WeakListener.vetoableChange(this.managerListener, this.manager);
            this.manager.addVetoableChangeListener(this.wlvc);
            this.wlpc = WeakListener.propertyChange(this.managerListener, this.manager);
            this.manager.addPropertyChangeListener(this.wlpc);
        }
        if (!this.listenerActive) {
            this.listenerActive = true;
            this.list.getSelectionModel().addListSelectionListener(this.managerListener);
            this.model.addListDataListener(this.managerListener);
            this.model.setNode(this.manager.getExploredContext());
            this.list.addFocusListener(this.popupSupport);
            this.list.addMouseListener(this.popupSupport);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.listenerActive = false;
        this.list.getSelectionModel().removeListSelectionListener(this.managerListener);
        if (this.manager != null) {
            this.manager.removeVetoableChangeListener(this.wlvc);
            this.manager.removePropertyChangeListener(this.wlpc);
        }
        this.model.removeListDataListener(this.managerListener);
        this.list.removeFocusListener(this.popupSupport);
        this.list.removeMouseListener(this.popupSupport);
    }

    public void requestFocus() {
        this.list.requestFocus();
    }

    final void performObjectAt(int index, int modifiers) {
        if (index < 0 || index >= this.model.getSize()) {
            return;
        }
        VisualizerNode v = (VisualizerNode)this.model.getElementAt(index);
        Node node = v.node;
        if (this.defaultProcessor != null) {
            this.defaultProcessor.actionPerformed(new ActionEvent(node, 0, null, modifiers));
            return;
        }
        SystemAction sa = node.getDefaultAction();
        if (sa != null && (modifiers & 2) == 0) {
            TreeView.invokeAction(sa, new ActionEvent(node, 1001, ""));
        } else if (this.traversalAllowed && !node.isLeaf()) {
            this.manager.setExploredContext(node, this.manager.getSelectedNodes());
        }
    }

    private void updateSelection() {
        Node[] sel = this.manager.getSelectedNodes();
        int[] indices = new int[sel.length];
        int i = 0;
        while (i < sel.length) {
            VisualizerNode v = VisualizerNode.getVisualizer(null, sel[i]);
            indices[i] = this.model.getIndex(v);
            ++i;
        }
        if (this.listenerActive) {
            this.list.getSelectionModel().removeListSelectionListener(this.managerListener);
        }
        try {
            this.showSelection(indices);
            Object var6_5 = null;
            if (this.listenerActive) {
                this.list.getSelectionModel().addListSelectionListener(this.managerListener);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (this.listenerActive) {
                this.list.getSelectionModel().addListSelectionListener(this.managerListener);
            }
            throw throwable;
        }
    }

    void createPopup(int xpos, int ypos) {
        if (this.manager == null) {
            return;
        }
        if (!this.popupAllowed) {
            return;
        }
        JPopupMenu popup = NodeOp.findContextMenu(this.manager.getSelectedNodes());
        if (popup != null && popup.getSubElements().length > 0 && TreeView.shouldPopupBeDisplayed(this)) {
            Point p = this.getViewport().getViewPosition();
            p.x = xpos - p.x;
            p.y = ypos - p.y;
            SwingUtilities.convertPointToScreen(p, this);
            Dimension popupSize = popup.getPreferredSize();
            Rectangle screenBounds = Utilities.getUsableScreenBounds(this.getGraphicsConfiguration());
            if (p.x + popupSize.width > screenBounds.x + screenBounds.width) {
                p.x = screenBounds.x + screenBounds.width - popupSize.width;
            }
            if (p.y + popupSize.height > screenBounds.y + screenBounds.height) {
                p.y = screenBounds.y + screenBounds.height - popupSize.height;
            }
            SwingUtilities.convertPointFromScreen(p, this);
            popup.show(this, p.x, p.y);
        }
    }

    private final class EnterAction
    extends AbstractAction {
        static final long serialVersionUID = -239805141416294016L;

        public EnterAction() {
            super("Enter");
        }

        public void actionPerformed(ActionEvent e) {
            int index = ListView.this.list.getSelectedIndex();
            ListView.this.performObjectAt(index, e.getModifiers());
        }

        public boolean isEnabled() {
            return true;
        }
    }

    private final class GoUpAction
    extends AbstractAction {
        static final long serialVersionUID = 1599999335583246715L;

        public GoUpAction() {
            super("GoUpAction");
        }

        public void actionPerformed(ActionEvent e) {
            if (ListView.this.traversalAllowed) {
                Node pan = ListView.this.manager.getExploredContext();
                if ((pan = pan.getParentNode()) != null) {
                    ListView.this.manager.setExploredContext(pan, ListView.this.manager.getSelectedNodes());
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    private final class Listener
    implements ListDataListener,
    ListSelectionListener,
    PropertyChangeListener,
    VetoableChangeListener {
        Listener() {
        }

        public void intervalAdded(ListDataEvent evt) {
            ListView.this.updateSelection();
        }

        public void intervalRemoved(ListDataEvent evt) {
            ListView.this.updateSelection();
        }

        public void contentsChanged(ListDataEvent evt) {
            ListView.this.updateSelection();
        }

        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            Node[] newNodes;
            ListView.this.manager;
            if ("selectedNodes".equals(evt.getPropertyName()) && !ListView.this.selectionAccept(newNodes = (Node[])evt.getNewValue())) {
                throw new PropertyVetoException("", evt);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ListView.this.manager;
            if ("selectedNodes".equals(evt.getPropertyName())) {
                ListView.this.updateSelection();
                return;
            }
            if ("exploredContext".equals(evt.getPropertyName())) {
                ListView.this.model.setNode(ListView.this.manager.getExploredContext());
                return;
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            int curSize = ListView.this.model.getSize();
            int[] indices = ListView.this.list.getSelectedIndices();
            ArrayList<Node> ll = new ArrayList<Node>(indices.length);
            int i = 0;
            while (i < indices.length) {
                if (indices[i] < curSize) {
                    Node n = Visualizer.findNode(ListView.this.model.getElementAt(indices[i]));
                    if (n == ListView.this.manager.getRootContext() || n.getParentNode() != null) {
                        ll.add(n);
                    }
                } else {
                    ListView.this.updateSelection();
                    return;
                }
                ++i;
            }
            Node[] nodes = ll.toArray(new Node[ll.size()]);
            ListView.this.manager.removePropertyChangeListener(ListView.this.wlpc);
            ListView.this.manager.removeVetoableChangeListener(ListView.this.wlvc);
            try {
                try {
                    ListView.this.selectionChanged(nodes, ListView.this.manager);
                }
                catch (PropertyVetoException ex) {
                    ListView.this.updateSelection();
                    Object var9_8 = null;
                    ListView.this.manager.addPropertyChangeListener(ListView.this.wlpc);
                    ListView.this.manager.addVetoableChangeListener(ListView.this.wlvc);
                }
                Object var9_7 = null;
                ListView.this.manager.addPropertyChangeListener(ListView.this.wlpc);
                ListView.this.manager.addVetoableChangeListener(ListView.this.wlvc);
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                ListView.this.manager.addPropertyChangeListener(ListView.this.wlpc);
                ListView.this.manager.addVetoableChangeListener(ListView.this.wlvc);
                throw throwable;
            }
        }
    }

    final class PopupSupport
    extends MouseUtils.PopupMouseAdapter
    implements ActionPerformer,
    Runnable,
    FocusListener {
        CallbackSystemAction csa;

        PopupSupport() {
        }

        public void mouseClicked(MouseEvent e) {
            if (MouseUtils.isDoubleClick(e)) {
                int index = ListView.this.list.locationToIndex(e.getPoint());
                ListView.this.performObjectAt(index, e.getModifiers());
            }
        }

        protected void showPopup(MouseEvent e) {
            int i = ListView.this.list.locationToIndex(new Point(e.getX(), e.getY()));
            if (!ListView.this.list.isSelectedIndex(i)) {
                ListView.this.list.setSelectedIndex(i);
            }
            ListView.this.createPopup(e.getX(), e.getY());
        }

        public void performAction(SystemAction act) {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            int i;
            boolean multisel = ListView.this.list.getSelectionMode() != 0;
            int n = i = multisel ? ListView.this.list.getLeadSelectionIndex() : ListView.this.list.getSelectedIndex();
            if (i < 0) {
                return;
            }
            Point p = ListView.this.list.indexToLocation(i);
            if (p == null) {
                return;
            }
            ListView.this.createPopup(p.x, p.y);
        }

        public void focusGained(FocusEvent ev) {
            if (this.csa == null) {
                try {
                    Class<?> popup = Class.forName("org.openide.actions.PopupAction");
                    this.csa = (CallbackSystemAction)SystemAction.get(popup);
                }
                catch (ClassNotFoundException e) {
                    NoClassDefFoundError err = new NoClassDefFoundError();
                    ErrorManager.getDefault().annotate((Throwable)err, e);
                    throw err;
                }
            }
            this.csa.setActionPerformer(this);
        }

        public void focusLost(FocusEvent ev) {
            if (this.csa != null && this.csa.getActionPerformer() instanceof PopupSupport) {
                this.csa.setActionPerformer(null);
            }
        }
    }

    final class NbList
    extends JList
    implements Autoscroll {
        static final long serialVersionUID = -7571829536335024077L;
        AutoscrollSupport support;

        NbList() {
            if (System.getProperty("java.version").startsWith("1.4")) {
                this.getInputMap().put(KeyStroke.getKeyStroke("control C"), "none");
                this.getInputMap().put(KeyStroke.getKeyStroke("control V"), "none");
                this.getInputMap().put(KeyStroke.getKeyStroke("control X"), "none");
            }
        }

        public String getToolTipText(MouseEvent event) {
            Point p;
            int row;
            if (event != null && (row = this.locationToIndex(p = event.getPoint())) >= 0) {
                VisualizerNode v = (VisualizerNode)ListView.this.model.getElementAt(row);
                String tooltip = v.getShortDescription();
                String displayName = v.displayName;
                if (tooltip != null && !tooltip.equals(displayName)) {
                    return tooltip;
                }
            }
            return null;
        }

        public void autoscroll(Point cursorLoc) {
            this.getSupport().autoscroll(cursorLoc);
        }

        public Insets getAutoscrollInsets() {
            return this.getSupport().getAutoscrollInsets();
        }

        AutoscrollSupport getSupport() {
            if (this.support == null) {
                this.support = new AutoscrollSupport(this, new Insets(15, 10, 15, 10));
            }
            return this.support;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleExplorerList();
            }
            return this.accessibleContext;
        }

        private class AccessibleExplorerList
        extends JList.AccessibleJList {
            AccessibleExplorerList() {
                super(NbList.this);
            }

            public String getAccessibleName() {
                return ListView.this.getAccessibleContext().getAccessibleName();
            }

            public String getAccessibleDescription() {
                return ListView.this.getAccessibleContext().getAccessibleDescription();
            }
        }
    }
}

