/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Component;
import java.awt.Image;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.NodeListModel;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

public class NodeRenderer
implements TreeCellRenderer,
ListCellRenderer {
    private static NodeRenderer sharedInstance;
    private boolean bigIcons;
    static Border emptyBorder;
    private static VisualizerNode draggedOver;
    private static final String DEFAULT_ICON = "org/openide/resources/defaultNode.gif";
    private static ImageIcon defaultIcon;
    private static final WeakHashMap map;
    private static Tree tree;
    private static Pane pane;
    private static List list;

    public NodeRenderer() {
    }

    public NodeRenderer(boolean bigIcons) {
        this.bigIcons = bigIcons;
    }

    public static NodeRenderer sharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new NodeRenderer();
        }
        return sharedInstance;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        VisualizerNode vis = value instanceof Node ? VisualizerNode.getVisualizer(null, (Node)value) : (VisualizerNode)value;
        return NodeRenderer.getTree().getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        VisualizerNode vis;
        VisualizerNode visualizerNode = vis = value instanceof Node ? VisualizerNode.getVisualizer(null, (Node)value) : (VisualizerNode)value;
        if (vis == null) {
            vis = VisualizerNode.EMPTY;
        }
        JLabel r = this.bigIcons ? NodeRenderer.getPane() : NodeRenderer.getList();
        return r.getListCellRendererComponent(list, vis, index, isSelected, cellHasFocus);
    }

    static void dragEnter(Object dragged) {
        draggedOver = (VisualizerNode)dragged;
    }

    static void dragExit() {
        draggedOver = null;
    }

    static ImageIcon getDefaultIcon() {
        if (defaultIcon == null) {
            defaultIcon = new ImageIcon(Utilities.loadImage(DEFAULT_ICON));
        }
        return defaultIcon;
    }

    static ImageIcon getIcon(Image image) {
        ImageIcon icon;
        Reference ref = (Reference)map.get(image);
        ImageIcon imageIcon = icon = ref == null ? null : (ImageIcon)ref.get();
        if (icon != null) {
            return icon;
        }
        icon = new ImageIcon(image);
        map.put(image, new WeakReference<ImageIcon>(icon));
        return icon;
    }

    private static synchronized Tree getTree() {
        if (tree == null) {
            tree = new Tree();
        }
        return tree;
    }

    private static synchronized Pane getPane() {
        if (pane == null) {
            pane = new Pane();
        }
        return pane;
    }

    private static synchronized List getList() {
        if (list == null) {
            list = new List();
        }
        return list;
    }

    static {
        emptyBorder = new EmptyBorder(1, 1, 1, 1);
        map = new WeakHashMap();
        tree = null;
        pane = null;
        list = null;
    }

    static final class Pane
    extends JLabel
    implements ListCellRenderer {
        static final long serialVersionUID = -5100925551665387243L;
        static Border focusBorder = LineBorder.createBlackLineBorder();

        public Pane() {
            this.setOpaque(true);
            this.setVerticalTextPosition(3);
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            VisualizerNode vis = (VisualizerNode)value;
            this.setIcon(NodeRenderer.getIcon(vis.node.getIcon(2)));
            this.setText(vis.displayName);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setBorder(cellHasFocus ? focusBorder : emptyBorder);
            return this;
        }
    }

    static final class List
    extends JLabel
    implements ListCellRenderer {
        static final long serialVersionUID = -8387317362588264203L;
        protected static Border focusBorder = new LineBorder(UIManager.getColor("List.focusCellHighlight"));

        public List() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Border border;
            VisualizerNode vis = (VisualizerNode)value;
            ImageIcon nodeicon = NodeRenderer.getIcon(vis.node.getIcon(1));
            this.setIcon(nodeicon);
            this.setText(vis.displayName);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setIconTextGap(4 - nodeicon.getIconWidth() + (nodeicon.getIconWidth() > 24 ? nodeicon.getIconWidth() : 24));
            int delta = NodeListModel.findVisualizerDepth(list.getModel(), vis);
            Border border2 = border = cellHasFocus || value == draggedOver ? focusBorder : emptyBorder;
            if (delta > 0) {
                border = new CompoundBorder(new EmptyBorder(0, nodeicon.getIconWidth() * delta, 0, 0), border);
            }
            this.setBorder(border);
            return this;
        }
    }

    static final class Tree
    extends DefaultTreeCellRenderer {
        static final long serialVersionUID = -183570483117501696L;
        static Border activeBorder = new LineBorder(UIManager.getColor("List.focusCellHighlight"));
        static Border inactiveBorder;

        Tree() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.setEnabled(tree.isEnabled());
            VisualizerNode vis = (VisualizerNode)value;
            ImageIcon nodeicon = expanded ? NodeRenderer.getIcon(vis.node.getOpenedIcon(1)) : NodeRenderer.getIcon(vis.node.getIcon(1));
            this.setIconTextGap(4 - nodeicon.getIconWidth() + (nodeicon.getIconWidth() > 24 ? nodeicon.getIconWidth() : 24));
            this.setIcon(nodeicon);
            this.setText(vis.displayName);
            if (vis == draggedOver) {
                sel = true;
            }
            this.hasFocus = hasFocus;
            this.selected = sel;
            if (sel) {
                this.setForeground(this.getTextSelectionColor());
            } else {
                this.setForeground(this.getTextNonSelectionColor());
            }
            return this;
        }

        static {
            int width = DragDropUtilities.dragAndDropEnabled ? 1 : 0;
            inactiveBorder = new EmptyBorder(width, width, width, width);
        }
    }
}

