/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class NodeTableModel
extends AbstractTableModel {
    private static final String ATTR_INVISIBLE = "InvisibleInTreeTableView";
    static final String ATTR_COMPARABLE_COLUMN = "ComparableColumnTTV";
    static final String ATTR_SORTING_COLUMN = "SortingColumnTTV";
    static final String ATTR_DESCENDING_ORDER = "DescendingOrderTTV";
    private static final String ATTR_ORDER_NUMBER = "OrderNumberTTV";
    private static final String ATTR_TREE_COLUMN = "TreeColumnTTV";
    private ArrayColumn[] allPropertyColumns = new ArrayColumn[0];
    private int[] propertyColumns = new int[0];
    private Node[] nodeRows = new Node[0];
    private int sortColumn = -1;
    private boolean existsComparableColumn = false;
    private Node.Property treeColumnProperty = null;
    private PropertyChangeListener pcl = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            int row = NodeTableModel.this.rowForNode((Node)evt.getSource());
            if (row == -1) {
                return;
            }
            int column = NodeTableModel.this.columnForProperty(evt.getPropertyName());
            if (column == -1) {
                NodeTableModel.this.fireTableRowsUpdated(row, row);
            } else {
                NodeTableModel.this.fireTableCellUpdated(row, column);
            }
        }
    };
    static /* synthetic */ Class class$org$openide$nodes$Node$Property;
    static /* synthetic */ Class class$org$openide$explorer$view$NodeTableModel;

    public void setNodes(Node[] nodes) {
        int i = 0;
        while (i < this.nodeRows.length) {
            this.nodeRows[i].removePropertyChangeListener(this.pcl);
            ++i;
        }
        this.nodeRows = nodes;
        int i2 = 0;
        while (i2 < this.nodeRows.length) {
            this.nodeRows[i2].addPropertyChangeListener(this.pcl);
            ++i2;
        }
        this.fireTableDataChanged();
    }

    public void setProperties(Node.Property[] props) {
        int size = props.length;
        int treePosition = -1;
        int i = 0;
        while (i < props.length) {
            Object o = props[i].getValue(ATTR_TREE_COLUMN);
            if (o != null && o instanceof Boolean && ((Boolean)o).booleanValue()) {
                this.treeColumnProperty = props[i];
                --size;
                treePosition = i;
            }
            ++i;
        }
        this.allPropertyColumns = new ArrayColumn[size];
        int visibleCount = 0;
        this.existsComparableColumn = false;
        TreeMap<Double, Integer> sort = new TreeMap<Double, Integer>();
        int i2 = 0;
        int ia = 0;
        while (i2 < props.length) {
            if (i2 != treePosition) {
                Object o;
                this.allPropertyColumns[ia] = new ArrayColumn();
                this.allPropertyColumns[ia].setProperty(props[i2]);
                if (this.isVisible(props[i2])) {
                    ++visibleCount;
                    o = props[i2].getValue(ATTR_ORDER_NUMBER);
                    if (o != null && o instanceof Integer) {
                        sort.put(new Double(((Integer)o).doubleValue()), new Integer(ia));
                    } else {
                        sort.put(new Double((double)ia + 0.1), new Integer(ia));
                    }
                } else {
                    this.allPropertyColumns[ia].setVisibleIndex(-1);
                    o = props[i2].getValue(ATTR_SORTING_COLUMN);
                    if (o != null && o instanceof Boolean) {
                        props[i2].setValue(ATTR_SORTING_COLUMN, Boolean.FALSE);
                    }
                }
                if (!this.existsComparableColumn && (o = props[i2].getValue(ATTR_COMPARABLE_COLUMN)) != null && o instanceof Boolean) {
                    this.existsComparableColumn = (Boolean)o;
                }
                ++ia;
            }
            ++i2;
        }
        this.propertyColumns = new int[visibleCount];
        int j = 0;
        Iterator it = sort.values().iterator();
        while (it.hasNext()) {
            i2 = (Integer)it.next();
            this.allPropertyColumns[i2].setVisibleIndex(j);
            this.propertyColumns[j] = i2;
            ++j;
        }
        this.fireTableStructureChanged();
    }

    private void computeVisiblePorperties(int visCount) {
        this.propertyColumns = new int[visCount];
        TreeMap<Double, Integer> sort = new TreeMap<Double, Integer>();
        int i = 0;
        while (i < this.allPropertyColumns.length) {
            int vi = this.allPropertyColumns[i].getVisibleIndex();
            if (vi == -1) {
                sort.put(new Double((double)i - 0.1), new Integer(i));
            } else {
                sort.put(new Double(vi), new Integer(i));
            }
            ++i;
        }
        int j = 0;
        Iterator it = sort.values().iterator();
        while (it.hasNext()) {
            int i2 = (Integer)it.next();
            Node.Property p = this.allPropertyColumns[i2].getProperty();
            if (this.isVisible(p)) {
                this.propertyColumns[j] = i2;
                this.allPropertyColumns[i2].setVisibleIndex(j);
                ++j;
                continue;
            }
            this.allPropertyColumns[i2].setVisibleIndex(-1);
            Object o = p.getValue(ATTR_SORTING_COLUMN);
            if (o == null || !(o instanceof Boolean) || !((Boolean)o).booleanValue()) continue;
            p.setValue(ATTR_SORTING_COLUMN, Boolean.FALSE);
            p.setValue(ATTR_DESCENDING_ORDER, Boolean.FALSE);
        }
        this.fireTableStructureChanged();
    }

    int getVisibleColumnWidth(int column) {
        return this.allPropertyColumns[this.propertyColumns[column]].getWidth();
    }

    int getArrayColumnWidth(int column) {
        return this.allPropertyColumns[column].getWidth();
    }

    void setVisibleColumnWidth(int column, int width) {
        this.allPropertyColumns[this.propertyColumns[column]].setWidth(width);
    }

    void setArrayColumnWidth(int column, int width) {
        this.allPropertyColumns[column].setWidth(width);
    }

    int getVisibleIndex(int arrayIndex) {
        return this.allPropertyColumns[arrayIndex].getVisibleIndex();
    }

    int getArrayIndex(int visibleIndex) {
        int i = 0;
        while (i < this.allPropertyColumns.length) {
            if (this.allPropertyColumns[i].getVisibleIndex() == visibleIndex) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    boolean isComparableColumn(int column) {
        Node.Property p = this.allPropertyColumns[this.propertyColumns[column]].getProperty();
        Object o = p.getValue(ATTR_COMPARABLE_COLUMN);
        if (o != null && o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    boolean existsComparableColumn() {
        return this.existsComparableColumn;
    }

    boolean isSortingColumn(int column) {
        Node.Property p = this.allPropertyColumns[this.propertyColumns[column]].getProperty();
        Object o = p.getValue(ATTR_SORTING_COLUMN);
        if (o != null && o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    void setSortingColumn(int column) {
        Node.Property p;
        if (this.sortColumn != -1) {
            p = this.allPropertyColumns[this.sortColumn].getProperty();
            p.setValue(ATTR_SORTING_COLUMN, Boolean.FALSE);
            p.setValue(ATTR_DESCENDING_ORDER, Boolean.FALSE);
        }
        if (column != -1) {
            this.sortColumn = this.propertyColumns[column];
            p = this.allPropertyColumns[this.sortColumn].getProperty();
            p.setValue(ATTR_SORTING_COLUMN, Boolean.TRUE);
        } else {
            this.sortColumn = -1;
        }
    }

    int getVisibleSortingColumn() {
        if (this.sortColumn == -1) {
            int i = 0;
            while (i < this.propertyColumns.length) {
                if (this.isSortingColumn(i)) {
                    this.sortColumn = this.propertyColumns[i];
                    return i;
                }
                ++i;
            }
        } else {
            if (this.isVisible(this.allPropertyColumns[this.sortColumn].getProperty())) {
                return this.getVisibleIndex(this.sortColumn);
            }
            this.sortColumn = -1;
        }
        return -1;
    }

    boolean isSortOrderDescending() {
        if (this.sortColumn == -1) {
            return false;
        }
        Node.Property p = this.allPropertyColumns[this.sortColumn].getProperty();
        Object o = p.getValue(ATTR_DESCENDING_ORDER);
        if (o != null && o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    void setSortOrderDescending(boolean descending) {
        if (this.sortColumn != -1) {
            Node.Property p = this.allPropertyColumns[this.sortColumn].getProperty();
            p.setValue(ATTR_DESCENDING_ORDER, new Boolean(descending));
        }
    }

    protected Node.Property getPropertyFor(Node node, Node.Property prop) {
        Node.PropertySet[] propSets = node.getPropertySets();
        int i = 0;
        while (i < propSets.length) {
            Node.Property[] props = propSets[i].getProperties();
            int j = 0;
            while (j < props.length) {
                if (prop.equals(props[j])) {
                    return props[j];
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    Node nodeForRow(int row) {
        return this.nodeRows[row];
    }

    Node.Property propertyForColumn(int column) {
        if (column == -1) {
            return this.treeColumnProperty;
        }
        return this.allPropertyColumns[this.propertyColumns[column]].getProperty();
    }

    int getArrayColumnCount() {
        return this.allPropertyColumns.length;
    }

    private int rowForNode(Node node) {
        int i = 0;
        while (i < this.nodeRows.length) {
            if (node.equals(this.nodeRows[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int columnForProperty(String propName) {
        int i = 0;
        while (i < this.propertyColumns.length) {
            if (this.allPropertyColumns[this.propertyColumns[i]].getProperty().getName().equals(propName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean isVisible(Node.Property p) {
        Object o = p.getValue(ATTR_INVISIBLE);
        if (o != null && o instanceof Boolean) {
            return (Boolean)o == false;
        }
        return true;
    }

    private void setVisible(Node.Property p, boolean visible) {
        p.setValue(ATTR_INVISIBLE, new Boolean(!visible));
    }

    public int getRowCount() {
        return this.nodeRows.length;
    }

    public int getColumnCount() {
        return this.propertyColumns.length;
    }

    public Object getValueAt(int row, int column) {
        return this.getPropertyFor(this.nodeRows[row], this.allPropertyColumns[this.propertyColumns[column]].getProperty());
    }

    public boolean isCellEditable(int row, int column) {
        return this.getValueAt(row, column) != null;
    }

    public Class getColumnClass(int column) {
        return class$org$openide$nodes$Node$Property == null ? (class$org$openide$nodes$Node$Property = NodeTableModel.class$("org.openide.nodes.Node$Property")) : class$org$openide$nodes$Node$Property;
    }

    public String getColumnName(int column) {
        return this.allPropertyColumns[this.propertyColumns[column]].getProperty().getDisplayName();
    }

    boolean selectVisibleColumns(String viewName, String treeColumnName, String treeColumnDesc) {
        String boxtext;
        boolean changed = false;
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        ArrayList<JCheckBox> boxes = new ArrayList<JCheckBox>(this.allPropertyColumns.length);
        boolean[] oldvalues = new boolean[this.allPropertyColumns.length];
        int[] sortpointer = new int[this.allPropertyColumns.length];
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.gridwidth = 0;
        labelConstraints.anchor = 17;
        labelConstraints.insets = new Insets(12, 12, 0, 12);
        labelConstraints.fill = 2;
        labelConstraints.weightx = 1.0;
        JLabel desc = new JLabel(NbBundle.getBundle(class$org$openide$explorer$view$NodeTableModel == null ? (class$org$openide$explorer$view$NodeTableModel = NodeTableModel.class$("org.openide.explorer.view.NodeTableModel")) : class$org$openide$explorer$view$NodeTableModel).getString("LBL_ColumnDialogDesc"));
        panel.add((Component)desc, labelConstraints);
        GridBagConstraints firstConstraints = new GridBagConstraints();
        firstConstraints.gridwidth = 0;
        firstConstraints.anchor = 17;
        firstConstraints.insets = new Insets(12, 12, 0, 12);
        firstConstraints.fill = 2;
        firstConstraints.weightx = 1.0;
        JCheckBox first = new JCheckBox(treeColumnName + ": " + treeColumnDesc, true);
        first.setEnabled(false);
        panel.add((Component)first, firstConstraints);
        TreeMap<String, Integer> sort = new TreeMap<String, Integer>();
        int i = 0;
        while (i < this.allPropertyColumns.length) {
            oldvalues[i] = this.isVisible(this.allPropertyColumns[i].getProperty());
            boxtext = this.allPropertyColumns[i].getProperty().getDisplayName() + ": " + this.allPropertyColumns[i].getProperty().getShortDescription();
            sort.put(boxtext, new Integer(i));
            ++i;
        }
        Iterator it = sort.keySet().iterator();
        int j = 0;
        while (it.hasNext()) {
            boxtext = (String)it.next();
            int i2 = (Integer)sort.get(boxtext);
            JCheckBox b = new JCheckBox(boxtext, oldvalues[i2]);
            sortpointer[j] = i2;
            panel.add((Component)b, gridBagConstraints);
            boxes.add(b);
            ++j;
        }
        String title = NbBundle.getBundle(class$org$openide$explorer$view$NodeTableModel == null ? (class$org$openide$explorer$view$NodeTableModel = NodeTableModel.class$("org.openide.explorer.view.NodeTableModel")) : class$org$openide$explorer$view$NodeTableModel).getString("LBL_ColumnDialogTitle");
        if (viewName != null && viewName.length() > 0) {
            title = viewName + " - " + title;
        }
        DialogDescriptor dlg = new DialogDescriptor((Object)panel, title, true, 2, NotifyDescriptor.OK_OPTION, 0, null, null);
        Dialog dialog = TopManager.getDefault().createDialog(dlg);
        dialog.show();
        if (dlg.getValue().equals(NotifyDescriptor.OK_OPTION)) {
            int num = boxes.size();
            int nv = 0;
            int i3 = 0;
            while (i3 < num) {
                JCheckBox b = (JCheckBox)boxes.get(i3);
                j = sortpointer[i3];
                if (b.isSelected() != oldvalues[j]) {
                    this.setVisible(this.allPropertyColumns[j].getProperty(), b.isSelected());
                    changed = true;
                }
                if (b.isSelected()) {
                    ++nv;
                }
                ++i3;
            }
            if (changed) {
                this.computeVisiblePorperties(nv);
            }
        }
        return changed;
    }

    void moveColumn(int from, int to) {
        int j;
        int i = this.propertyColumns[from];
        this.propertyColumns[from] = j = this.propertyColumns[to];
        this.propertyColumns[to] = i;
        this.allPropertyColumns[i].setVisibleIndex(to);
        this.allPropertyColumns[j].setVisibleIndex(from);
        this.sortColumn = -1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ArrayColumn {
        private Node.Property property;
        private int width;
        private int visibleIndex;

        private ArrayColumn() {
        }

        public Node.Property getProperty() {
            return this.property;
        }

        public void setProperty(Node.Property property) {
            this.property = property;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getVisibleIndex() {
            return this.visibleIndex;
        }

        public void setVisibleIndex(int visibleIndex) {
            this.visibleIndex = visibleIndex;
            this.property.setValue(NodeTableModel.ATTR_ORDER_NUMBER, new Integer(visibleIndex));
        }
    }
}

