/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.openide.explorer.view.NodeModel;
import org.openide.explorer.view.VisualizerEvent;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;
import org.openide.util.Mutex;

public class NodeTreeModel
extends DefaultTreeModel {
    private transient Listener listener;
    static final long serialVersionUID = 1900670294524747212L;

    public NodeTreeModel() {
        super(VisualizerNode.EMPTY, true);
    }

    public NodeTreeModel(Node root) {
        super(VisualizerNode.EMPTY, true);
        this.setNode(root);
    }

    public void setNode(final Node root) {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                VisualizerNode nr;
                VisualizerNode v = (VisualizerNode)NodeTreeModel.this.getRoot();
                if (v == (nr = VisualizerNode.getVisualizer(null, root))) {
                    return;
                }
                v.removeNodeModel(NodeTreeModel.this.listener());
                nr.addNodeModel(NodeTreeModel.this.listener());
                NodeTreeModel.this.setRoot(nr);
            }
        });
    }

    private Listener listener() {
        if (this.listener == null) {
            this.listener = new Listener(this);
        }
        return this.listener;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        if (path == null) {
            return;
        }
        Object o = path.getLastPathComponent();
        if (o instanceof VisualizerNode) {
            this.nodeChanged((VisualizerNode)o);
            return;
        }
        MutableTreeNode aNode = (MutableTreeNode)o;
        aNode.setUserObject(newValue);
        this.nodeChanged(aNode);
    }

    private static final class Listener
    implements NodeModel {
        private Reference model;

        public Listener(NodeTreeModel m) {
            this.model = new WeakReference<NodeTreeModel>(m);
        }

        private NodeTreeModel get(VisualizerEvent ev) {
            NodeTreeModel m = (NodeTreeModel)this.model.get();
            if (m == null && ev != null) {
                ev.getVisualizer().removeNodeModel(this);
                return null;
            }
            return m;
        }

        public void added(VisualizerEvent.Added ev) {
            NodeTreeModel m = this.get(ev);
            if (m == null) {
                return;
            }
            m.nodesWereInserted(ev.getVisualizer(), ev.getArray());
        }

        public void removed(VisualizerEvent.Removed ev) {
            NodeTreeModel m = this.get(ev);
            if (m == null) {
                return;
            }
            m.nodesWereRemoved(ev.getVisualizer(), ev.getArray(), ev.removed.toArray());
        }

        public void reordered(VisualizerEvent.Reordered ev) {
            NodeTreeModel m = this.get(ev);
            if (m == null) {
                return;
            }
            m.nodeStructureChanged(ev.getVisualizer());
        }

        public void update(VisualizerNode v) {
            NodeTreeModel m = this.get(null);
            if (m == null) {
                return;
            }
            m.nodeChanged(v);
        }
    }
}

