/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.openide.explorer.view.NodeTableModel;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;

class TreeTableModelAdapter
extends NodeTableModel {
    private JTree tree;
    private NodeTableModel nodeTableModel;
    static /* synthetic */ Class class$org$openide$explorer$view$TreeTableModelAdapter;

    public TreeTableModelAdapter(JTree t, NodeTableModel ntm) {
        this.tree = t;
        this.nodeTableModel = ntm;
        Listener listener = new Listener();
        this.tree.addTreeExpansionListener(listener);
        this.tree.getModel().addTreeModelListener(listener);
        this.nodeTableModel.addTableModelListener(listener);
    }

    public void setNodes(Node[] nodes) {
        this.nodeTableModel.setNodes(nodes);
    }

    public void setProperties(Node.Property[] props) {
        this.nodeTableModel.setProperties(props);
    }

    protected Node.Property getPropertyFor(Node node, Node.Property prop) {
        return this.nodeTableModel.getPropertyFor(node, prop);
    }

    Node nodeForRow(int row) {
        return Visualizer.findNode(this.tree.getPathForRow(row).getLastPathComponent());
    }

    Node.Property propertyForColumn(int column) {
        return this.nodeTableModel.propertyForColumn(column - 1);
    }

    public int getColumnCount() {
        return this.nodeTableModel.getColumnCount() + 1;
    }

    public String getColumnName(int column) {
        return column == 0 ? Visualizer.findNode(this.tree.getModel().getRoot()).getDisplayName() : this.nodeTableModel.getColumnName(column - 1);
    }

    public Class getColumnClass(int column) {
        Class clazz = column == 0 ? (class$org$openide$explorer$view$TreeTableModelAdapter == null ? (class$org$openide$explorer$view$TreeTableModelAdapter = TreeTableModelAdapter.class$("org.openide.explorer.view.TreeTableModelAdapter")) : class$org$openide$explorer$view$TreeTableModelAdapter) : this.nodeTableModel.getColumnClass(column - 1);
        return clazz;
    }

    public int getRowCount() {
        return this.tree.getRowCount();
    }

    public Object getValueAt(int row, int column) {
        return column == 0 ? this.tree.getPathForRow(row).getLastPathComponent() : this.nodeTableModel.getPropertyFor(this.nodeForRow(row), this.propertyForColumn(column));
    }

    public boolean isCellEditable(int row, int column) {
        return column == 0 ? true : this.getValueAt(row, column) != null;
    }

    public void setValueAt(Object value, int row, int column) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Listener
    implements TreeExpansionListener,
    TreeModelListener,
    TableModelListener,
    Runnable {
        TreePath[] tps = null;

        Listener() {
        }

        public void treeExpanded(TreeExpansionEvent event) {
            this.updateNodes();
        }

        public void treeCollapsed(TreeExpansionEvent event) {
            this.updateNodes();
        }

        public void treeNodesChanged(TreeModelEvent e) {
            this.delayedUpdateNodes(e);
        }

        public void treeNodesInserted(TreeModelEvent e) {
            this.delayedUpdateNodes(e);
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            this.delayedUpdateNodes(e);
        }

        public void treeStructureChanged(TreeModelEvent e) {
            this.tps = TreeTableModelAdapter.this.tree.getSelectionPaths();
            this.delayedUpdateNodes(e);
        }

        public void tableChanged(TableModelEvent e) {
            int c = e.getColumn();
            int column = c == -1 ? -1 : c + 1;
            TreeTableModelAdapter.this.fireTableChanged(new TableModelEvent(TreeTableModelAdapter.this, e.getFirstRow(), e.getLastRow(), column, e.getType()));
        }

        protected void delayedUpdateNodes(TreeModelEvent e) {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            this.updateNodes();
        }

        private void updateNodes() {
            Node[] nodes = new Node[TreeTableModelAdapter.this.tree.getRowCount()];
            int i = 0;
            while (i < TreeTableModelAdapter.this.tree.getRowCount()) {
                nodes[i] = Visualizer.findNode(TreeTableModelAdapter.this.tree.getPathForRow(i).getLastPathComponent());
                ++i;
            }
            TreeTableModelAdapter.this.setNodes(nodes);
            if (this.tps != null) {
                TreeTableModelAdapter.this.tree.setSelectionPaths(this.tps);
                this.tps = null;
            }
        }
    }
}

