/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openide.ErrorManager;
import org.openide.awt.MouseUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.AutoscrollSupport;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.TreeViewCellEditor;
import org.openide.explorer.view.TreeViewDragSupport;
import org.openide.explorer.view.TreeViewDropSupport;
import org.openide.explorer.view.Visualizer;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;

public abstract class TreeView
extends JScrollPane {
    static final long serialVersionUID = -1639001987693376168L;
    private static final int TIME_TO_COLLAPSE = System.getProperty("netbeans.debug.heap") != null ? 0 : 15000;
    private static final int MIN_TREEVIEW_WIDTH = 400;
    private static final int MIN_TREEVIEW_HEIGHT = 400;
    protected transient JTree tree;
    transient NodeTreeModel treeModel;
    transient ExplorerManager manager;
    transient PopupSupport defaultActionListener;
    transient boolean defaultActionEnabled;
    transient PopupAdapter popupListener;
    transient TreePropertyListener managerListener = null;
    transient PropertyChangeListener wlpc;
    transient VetoableChangeListener wlvc;
    transient boolean dragActive = false;
    transient boolean dropActive = false;
    transient TreeViewDragSupport dragSupport;
    transient TreeViewDropSupport dropSupport;
    transient boolean dropTargetPopupAllowed = true;
    static /* synthetic */ Class class$javax$swing$Action;
    static /* synthetic */ Class class$java$awt$event$ActionEvent;

    public TreeView() {
        this(true, true);
    }

    public TreeView(boolean defaultAction, boolean popupAllowed) {
        this.initializeTree();
        if (DragDropUtilities.dragAndDropEnabled) {
            this.setDragSource(true);
            this.setDropTarget(true);
        }
        this.setPopupAllowed(popupAllowed);
        this.setDefaultActionAllowed(defaultAction);
        Dimension dim = null;
        try {
            dim = this.getPreferredSize();
            if (dim == null) {
                dim = new Dimension(400, 400);
            }
        }
        catch (NullPointerException npe) {
            dim = new Dimension(400, 400);
        }
        if (dim.width < 400) {
            dim.width = 400;
        }
        if (dim.height < 400) {
            dim.height = 400;
        }
        this.setPreferredSize(dim);
    }

    void initializeTree() {
        this.treeModel = this.createModel();
        this.tree = new ExplorerTree(this.treeModel);
        NodeRenderer rend = NodeRenderer.sharedInstance();
        this.tree.setCellRenderer(rend);
        this.tree.setCellEditor(new TreeViewCellEditor(this.tree, new NodeRenderer.Tree()));
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.setEditable(true);
        this.setViewportView(this.tree);
        this.setSelectionMode(4);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.managerListener = new TreePropertyListener();
        this.tree.addTreeExpansionListener(this.managerListener);
        this.setRequestFocusEnabled(false);
        this.defaultActionListener = new PopupSupport();
        this.tree.addFocusListener(this.defaultActionListener);
        this.tree.addMouseListener(this.defaultActionListener);
    }

    public boolean isPopupAllowed() {
        return this.popupListener != null;
    }

    public void setPopupAllowed(boolean value) {
        if (this.popupListener == null && value) {
            this.popupListener = new PopupAdapter();
            this.tree.addMouseListener(this.popupListener);
            return;
        }
        if (this.popupListener != null && !value) {
            this.tree.removeMouseListener(this.popupListener);
            this.popupListener = null;
            return;
        }
    }

    void setDropTargetPopupAllowed(boolean value) {
        this.dropTargetPopupAllowed = value;
        if (this.dropSupport != null) {
            this.dropSupport.setDropTargetPopupAllowed(value);
        }
    }

    boolean isDropTargetPopupAllowed() {
        return this.dropSupport != null ? this.dropSupport.isDropTargetPopupAllowed() : this.dropTargetPopupAllowed;
    }

    public boolean isDefaultActionEnabled() {
        return this.defaultActionEnabled;
    }

    public void requestFocus() {
        this.tree.requestFocus();
    }

    public void setDefaultActionAllowed(boolean value) {
        this.defaultActionEnabled = value;
        if (value) {
            this.tree.registerKeyboardAction(this.defaultActionListener, KeyStroke.getKeyStroke(10, 0, false), 0);
        } else {
            this.tree.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, false));
        }
    }

    public boolean isRootVisible() {
        return this.tree.isRootVisible();
    }

    public void setRootVisible(boolean visible) {
        this.tree.setRootVisible(visible);
        this.tree.setShowsRootHandles(!visible);
    }

    public boolean isDragSource() {
        return this.dragActive;
    }

    public void setDragSource(boolean state) {
        if (state == this.dragActive) {
            return;
        }
        this.dragActive = state;
        if (this.dragActive && this.dragSupport == null) {
            this.dragSupport = new TreeViewDragSupport(this, this.tree);
        }
        this.dragSupport.activate(this.dragActive);
    }

    public boolean isDropTarget() {
        return this.dropActive;
    }

    public void setDropTarget(boolean state) {
        if (state == this.dropActive) {
            return;
        }
        this.dropActive = state;
        if (this.dropActive && this.dropSupport == null) {
            this.dropSupport = new TreeViewDropSupport(this, this.tree, this.dropTargetPopupAllowed);
        }
        this.dropSupport.activate(this.dropActive);
    }

    public int getAllowedDragActions() {
        return 0x40000003;
    }

    public void setAllowedDragActions(int actions) {
    }

    public int getAllowedDropActions() {
        return 0x40000003;
    }

    public void setAllowedDropActions(int actions) {
    }

    public void collapseNode(Node n) {
        TreePath treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, n)));
        this.tree.collapsePath(treePath);
    }

    public void expandNode(Node n) {
        this.lookupExplorerManager();
        TreePath treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, n)));
        this.tree.expandPath(treePath);
    }

    public boolean isExpanded(Node n) {
        TreePath treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, n)));
        return this.tree.isExpanded(treePath);
    }

    public void expandAll() {
        int j;
        int i = 0;
        int k = this.tree.getRowCount();
        do {
            j = this.tree.getRowCount();
            this.tree.expandRow(i);
        } while (j != this.tree.getRowCount() || ++i < this.tree.getRowCount());
    }

    public void addNotify() {
        super.addNotify();
        this.lookupExplorerManager();
    }

    private void lookupExplorerManager() {
        ExplorerManager newManager = ExplorerManager.find(this);
        if (newManager != this.manager) {
            if (this.manager != null) {
                this.manager.removeVetoableChangeListener(this.wlvc);
                this.manager.removePropertyChangeListener(this.wlpc);
            }
            this.manager = newManager;
            this.wlvc = WeakListener.vetoableChange(this.managerListener, this.manager);
            this.manager.addVetoableChangeListener(this.wlvc);
            this.wlpc = WeakListener.propertyChange(this.managerListener, this.manager);
            this.manager.addPropertyChangeListener(this.wlpc);
            this.synchronizeRootContext();
            this.synchronizeExploredContext();
            this.synchronizeSelectedNodes();
        }
        this.tree.getSelectionModel().removeTreeSelectionListener(this.managerListener);
        this.tree.getSelectionModel().addTreeSelectionListener(this.managerListener);
    }

    public void removeNotify() {
        super.removeNotify();
        this.tree.getSelectionModel().removeTreeSelectionListener(this.managerListener);
    }

    protected abstract NodeTreeModel createModel();

    protected abstract void selectionChanged(Node[] var1, ExplorerManager var2) throws PropertyVetoException;

    protected abstract boolean selectionAccept(Node[] var1);

    protected abstract void showPath(TreePath var1);

    protected abstract void showSelection(TreePath[] var1);

    protected boolean useExploredContextMenu() {
        return false;
    }

    private boolean isSelectionModeBroken(Node[] nodes) {
        if (nodes.length <= 1 || this.getSelectionMode() == 4) {
            return false;
        }
        if (this.getSelectionMode() == 1) {
            return true;
        }
        TreePath[] paths = new TreePath[nodes.length];
        RowMapper rowMapper = this.tree.getSelectionModel().getRowMapper();
        if (rowMapper == null) {
            return false;
        }
        ArrayList<Node> toBeExpaned = new ArrayList<Node>(3);
        int i = 0;
        while (i < nodes.length) {
            TreePath treePath;
            toBeExpaned.clear();
            Node n = nodes[i];
            while (n.getParentNode() != null) {
                if (!this.isExpanded(n)) {
                    toBeExpaned.add(n);
                }
                n = n.getParentNode();
            }
            int j = toBeExpaned.size() - 1;
            while (j >= 0) {
                this.expandNode((Node)toBeExpaned.get(j));
                --j;
            }
            paths[i] = treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, nodes[i])));
            ++i;
        }
        int[] rows = rowMapper.getRowsForPaths(paths);
        Arrays.sort(rows);
        int i2 = 1;
        while (i2 < rows.length) {
            if (rows[i2] != rows[i2 - 1] + 1) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    final void callSelectionChanged(Node[] nodes) {
        this.manager.removePropertyChangeListener(this.wlpc);
        this.manager.removeVetoableChangeListener(this.wlvc);
        try {
            try {
                this.selectionChanged(nodes, this.manager);
            }
            catch (PropertyVetoException e) {
                this.synchronizeSelectedNodes();
                Object var4_3 = null;
                this.manager.addPropertyChangeListener(this.wlpc);
                this.manager.addVetoableChangeListener(this.wlvc);
            }
            Object var4_2 = null;
            this.manager.addPropertyChangeListener(this.wlpc);
            this.manager.addVetoableChangeListener(this.wlvc);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.manager.addPropertyChangeListener(this.wlpc);
            this.manager.addVetoableChangeListener(this.wlvc);
            throw throwable;
        }
    }

    final void synchronizeRootContext() {
        this.treeModel.setNode(this.manager.getRootContext());
    }

    final void synchronizeExploredContext() {
        Node n = this.manager.getExploredContext();
        if (n != null) {
            TreePath treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, n)));
            this.showPath(treePath);
        }
    }

    public void setSelectionMode(int mode) {
        this.tree.getSelectionModel().setSelectionMode(mode);
    }

    public int getSelectionMode() {
        return this.tree.getSelectionModel().getSelectionMode();
    }

    final void synchronizeSelectedNodes() {
        Node[] arr = this.manager.getSelectedNodes();
        TreePath[] paths = new TreePath[arr.length];
        int i = 0;
        while (i < arr.length) {
            TreePath treePath;
            paths[i] = treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, arr[i])));
            ++i;
        }
        this.tree.getSelectionModel().removeTreeSelectionListener(this.managerListener);
        this.showSelection(paths);
        this.tree.getSelectionModel().addTreeSelectionListener(this.managerListener);
    }

    void scrollTreeToVisible(TreePath path, TreeNode child) {
        Rectangle base = this.tree.getVisibleRect();
        Rectangle b1 = this.tree.getPathBounds(path);
        Rectangle b2 = this.tree.getPathBounds(new TreePath(this.treeModel.getPathToRoot(child)));
        if (base != null && b1 != null && b2 != null) {
            this.tree.scrollRectToVisible(new Rectangle(base.x, b1.y, 1, b2.y - b1.y + b2.height));
        }
    }

    static boolean shouldPopupBeDisplayed(Component comp) {
        try {
            Class<?> c = Class.forName("org.openide.windows.TopComponent$Registry");
            Object registry = Lookup.getDefault().lookup(c);
            if (registry == null) {
                return true;
            }
            Method m = c.getMethod("getActivated", new Class[0]);
            Object activated = m.invoke(registry, new Object[0]);
            boolean fromActivated = SwingUtilities.isDescendingFrom(comp, (Component)activated);
            if (fromActivated) {
                return true;
            }
            Window w = SwingUtilities.getWindowAncestor(comp);
            return w instanceof Dialog;
        }
        catch (Exception x) {
            ErrorManager.getDefault().notify(1, x);
            return true;
        }
    }

    private void createPopup(int xpos, int ypos, JPopupMenu popup) {
        if (popup != null && popup.getSubElements().length > 0 && TreeView.shouldPopupBeDisplayed(this)) {
            Point p = new Point(xpos, ypos);
            JViewport treeViewport = this.getViewport();
            Container treeParent = this.tree.getParent();
            if (treeParent != treeViewport && treeParent instanceof JViewport) {
                treeViewport = (JViewport)treeParent;
                Point treeViewLocation = this.getLocationOnScreen();
                Point viewportLocation = treeViewport.getLocationOnScreen();
                p.x += viewportLocation.x - treeViewLocation.x;
                p.y += viewportLocation.y - treeViewLocation.y;
            }
            Point viewpos = treeViewport.getViewPosition();
            p.x -= viewpos.x;
            p.y -= viewpos.y;
            popup.show(this, p.x, p.y);
        }
    }

    void createPopup(int xpos, int ypos) {
        if (this.isPopupAllowed()) {
            this.createPopup(xpos, ypos, NodeOp.findContextMenu(this.manager.getSelectedNodes()));
        }
    }

    void createExtendedPopup(int xpos, int ypos, JMenu newMenu) {
        JPopupMenu popup = NodeOp.findContextMenu(this.manager.getSelectedNodes());
        int cnt = 0;
        if (popup != null && (cnt = popup.getComponentCount()) > 1) {
            popup.insert(newMenu, cnt - 1);
            popup.insert(new JPopupMenu.Separator(), cnt);
        } else {
            if (popup == null) {
                popup = SystemAction.createPopupMenu(new SystemAction[0]);
            }
            popup.add(newMenu);
        }
        this.createPopup(xpos, ypos, popup);
    }

    static void invokeAction(SystemAction sa, ActionEvent ev) {
        Exception t = null;
        try {
            Class<?> c = Class.forName("org.openide.actions.ActionManager");
            Object o = Lookup.getDefault().lookup(c);
            if (o != null) {
                Method m = c.getMethod("invokeAction", class$javax$swing$Action == null ? (class$javax$swing$Action = TreeView.class$("javax.swing.Action")) : class$javax$swing$Action, class$java$awt$event$ActionEvent == null ? (class$java$awt$event$ActionEvent = TreeView.class$("java.awt.event.ActionEvent")) : class$java$awt$event$ActionEvent);
                m.invoke(o, sa, ev);
                return;
            }
        }
        catch (ClassNotFoundException x) {
        }
        catch (ExceptionInInitializerError x) {
        }
        catch (LinkageError x) {
        }
        catch (SecurityException x) {
            t = x;
        }
        catch (NoSuchMethodException x) {
            t = x;
        }
        catch (IllegalAccessException x) {
            t = x;
        }
        catch (IllegalArgumentException x) {
            t = x;
        }
        catch (InvocationTargetException x) {
            t = x;
        }
        if (t != null) {
            ErrorManager.getDefault().notify(1, t);
        }
        sa.actionPerformed(ev);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class ExplorerTree
    extends JTree
    implements Autoscroll {
        AutoscrollSupport support;

        ExplorerTree(TreeModel model) {
            super(model);
            this.toggleClickCount = 0;
            if (System.getProperty("java.version").startsWith("1.4")) {
                this.getInputMap().put(KeyStroke.getKeyStroke("control C"), "none");
                this.getInputMap().put(KeyStroke.getKeyStroke("control V"), "none");
                this.getInputMap().put(KeyStroke.getKeyStroke("control X"), "none");
                this.getInputMap().put(KeyStroke.getKeyStroke("COPY"), "none");
                this.getInputMap().put(KeyStroke.getKeyStroke("PASTE"), "none");
                this.getInputMap().put(KeyStroke.getKeyStroke("CUT"), "none");
            } else {
                this.getActionMap().put("cancel", new OurTreeCancelEditingAction());
            }
        }

        public void autoscroll(Point cursorLoc) {
            this.getSupport().autoscroll(cursorLoc);
        }

        public Insets getAutoscrollInsets() {
            return this.getSupport().getAutoscrollInsets();
        }

        AutoscrollSupport getSupport() {
            if (this.support == null) {
                this.support = new AutoscrollSupport(this, new Insets(15, 10, 15, 10));
            }
            return this.support;
        }

        public String getToolTipText(MouseEvent event) {
            if (event != null) {
                Point p = event.getPoint();
                int selRow = this.getRowForLocation(p.x, p.y);
                if (selRow != -1) {
                    TreePath path = this.getPathForRow(selRow);
                    VisualizerNode v = (VisualizerNode)path.getLastPathComponent();
                    String tooltip = v.getShortDescription();
                    String displayName = v.displayName;
                    if (tooltip != null && !tooltip.equals(displayName)) {
                        return tooltip;
                    }
                }
            }
            return null;
        }

        protected TreeModelListener createTreeModelListener() {
            return new ModelHandler();
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleExplorerTree();
            }
            return this.accessibleContext;
        }

        private class OurTreeCancelEditingAction
        extends AbstractAction {
            private OurTreeCancelEditingAction() {
            }

            public void actionPerformed(ActionEvent e) {
                if (((ExplorerTree)ExplorerTree.this).TreeView.this.tree != null) {
                    ((ExplorerTree)ExplorerTree.this).TreeView.this.tree.cancelEditing();
                }
            }

            public boolean isEnabled() {
                return ((ExplorerTree)ExplorerTree.this).TreeView.this.tree != null && ((ExplorerTree)ExplorerTree.this).TreeView.this.tree.isEnabled() && ExplorerTree.this.getUI().isEditing(((ExplorerTree)ExplorerTree.this).TreeView.this.tree);
            }
        }

        private class ModelHandler
        extends JTree.TreeModelHandler {
            ModelHandler() {
                super(ExplorerTree.this);
            }

            public void treeStructureChanged(TreeModelEvent e) {
                TreePath[] selectionPaths = ExplorerTree.this.getSelectionPaths();
                Enumeration<TreePath> expanded = ExplorerTree.this.getExpandedDescendants(e.getTreePath());
                super.treeStructureChanged(e);
                if (expanded != null) {
                    while (expanded.hasMoreElements()) {
                        ExplorerTree.this.expandPath(expanded.nextElement());
                    }
                }
                if (selectionPaths != null && selectionPaths.length > 0) {
                    boolean wasSelected = ExplorerTree.this.isPathSelected(selectionPaths[0]);
                    ExplorerTree.this.setSelectionPaths(selectionPaths);
                    if (!wasSelected) {
                        ExplorerTree.this.scrollPathToVisible(selectionPaths[0]);
                    }
                }
            }
        }

        private class AccessibleExplorerTree
        extends JTree.AccessibleJTree {
            AccessibleExplorerTree() {
                super(ExplorerTree.this);
            }

            public String getAccessibleName() {
                return TreeView.this.getAccessibleContext().getAccessibleName();
            }

            public String getAccessibleDescription() {
                return TreeView.this.getAccessibleContext().getAccessibleDescription();
            }
        }
    }

    final class PopupSupport
    extends MouseAdapter
    implements ActionPerformer,
    Runnable,
    FocusListener,
    ActionListener {
        CallbackSystemAction csa;
        static /* synthetic */ Class class$org$openide$actions$PopupAction;

        PopupSupport() {
        }

        public void performAction(SystemAction act) {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            int i = TreeView.this.tree.getLeadSelectionRow();
            if (i < 0) {
                return;
            }
            Rectangle rect = TreeView.this.tree.getRowBounds(i);
            if (rect == null) {
                return;
            }
            TreeView.this.createPopup(rect.x, rect.y);
        }

        public void focusGained(FocusEvent ev) {
            if (this.csa == null) {
                this.csa = (CallbackSystemAction)SystemAction.get(class$org$openide$actions$PopupAction == null ? (class$org$openide$actions$PopupAction = PopupSupport.class$("org.openide.actions.PopupAction")) : class$org$openide$actions$PopupAction);
            }
            this.csa.setActionPerformer(this);
        }

        public void focusLost(FocusEvent ev) {
            if (this.csa != null && this.csa.getActionPerformer() instanceof PopupSupport) {
                this.csa.setActionPerformer(null);
            }
        }

        public void mouseClicked(MouseEvent e) {
            int selRow = TreeView.this.tree.getRowForLocation(e.getX(), e.getY());
            if (selRow != -1 && SwingUtilities.isLeftMouseButton(e) && MouseUtils.isDoubleClick(e)) {
                TreePath selPath;
                Node node;
                SystemAction sa;
                if (TreeView.this.defaultActionEnabled && (sa = (node = Visualizer.findNode((selPath = TreeView.this.tree.getPathForLocation(e.getX(), e.getY())).getLastPathComponent())).getDefaultAction()) != null) {
                    TreeView.invokeAction(sa, new ActionEvent(node, 1001, ""));
                    e.consume();
                    return;
                }
                if (TreeView.this.tree.isExpanded(selRow)) {
                    TreeView.this.tree.collapseRow(selRow);
                } else {
                    TreeView.this.tree.expandRow(selRow);
                }
            }
        }

        public void actionPerformed(ActionEvent evt) {
            SystemAction sa;
            Node[] nodes = TreeView.this.manager.getSelectedNodes();
            if (nodes.length == 1 && (sa = nodes[0].getDefaultAction()) != null) {
                TreeView.invokeAction(sa, new ActionEvent(nodes[0], 1001, ""));
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    class PopupAdapter
    extends MouseUtils.PopupMouseAdapter {
        PopupAdapter() {
        }

        protected void showPopup(MouseEvent e) {
            int selRow = TreeView.this.tree.getRowForLocation(e.getX(), e.getY());
            if (!TreeView.this.tree.isRowSelected(selRow)) {
                TreeView.this.tree.setSelectionRow(selRow);
            }
            if (selRow != -1) {
                TreeView.this.createPopup(e.getX(), e.getY());
            }
        }
    }

    class TreePropertyListener
    implements VetoableChangeListener,
    PropertyChangeListener,
    TreeExpansionListener,
    TreeSelectionListener,
    Runnable {
        private RequestProcessor.Task scheduled;
        private TreePath[] readAccessPaths;

        TreePropertyListener() {
        }

        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if (evt.getPropertyName().equals("selectedNodes")) {
                if (TreeView.this.isSelectionModeBroken((Node[])evt.getNewValue())) {
                    throw new PropertyVetoException("", evt);
                }
                if (!TreeView.this.selectionAccept((Node[])evt.getNewValue())) {
                    throw new PropertyVetoException("", evt);
                }
            }
        }

        public final void propertyChange(PropertyChangeEvent evt) {
            if (TreeView.this.manager == null) {
                return;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                this.react2VisualPropChange(evt);
            } else {
                SwingUtilities.invokeLater(new Runnable(this, evt){
                    private final /* synthetic */ PropertyChangeEvent val$evt;
                    private final /* synthetic */ TreePropertyListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$evt = val$evt;
                    }

                    public void run() {
                        TreePropertyListener.access$100(this.this$1, this.val$evt);
                    }
                });
            }
        }

        private void react2VisualPropChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("rootContext")) {
                TreeView.this.synchronizeRootContext();
            }
            if (evt.getPropertyName().equals("exploredContext")) {
                TreeView.this.synchronizeExploredContext();
            }
            if (evt.getPropertyName().equals("selectedNodes")) {
                TreeView.this.synchronizeSelectedNodes();
            }
        }

        public synchronized void treeExpanded(TreeExpansionEvent ev) {
            TreePath path = ev.getPath();
            RequestProcessor.Task t = this.scheduled;
            if (t != null) {
                t.cancel();
            }
            this.scheduled = RequestProcessor.getDefault().post(new Runnable(this, path){
                private final /* synthetic */ TreePath val$path;
                private final /* synthetic */ TreePropertyListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$path = val$path;
                }

                public void run() {
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(this);
                        return;
                    }
                    if (!TreePropertyListener.access$200((TreePropertyListener)this.this$1).tree.isVisible(this.val$path)) {
                        return;
                    }
                    if (TreePropertyListener.access$200((TreePropertyListener)this.this$1).treeModel == null) {
                        return;
                    }
                    TreeNode myNode = (TreeNode)this.val$path.getLastPathComponent();
                    if (TreePropertyListener.access$200((TreePropertyListener)this.this$1).treeModel.getPathToRoot(myNode)[0] != TreePropertyListener.access$200((TreePropertyListener)this.this$1).treeModel.getRoot()) {
                        return;
                    }
                    int lastChildIndex = myNode.getChildCount() - 1;
                    if (lastChildIndex >= 0) {
                        TreeNode lastChild = myNode.getChildAt(lastChildIndex);
                        Rectangle base = TreePropertyListener.access$200((TreePropertyListener)this.this$1).tree.getVisibleRect();
                        Rectangle b1 = TreePropertyListener.access$200((TreePropertyListener)this.this$1).tree.getPathBounds(this.val$path);
                        Rectangle b2 = TreePropertyListener.access$200((TreePropertyListener)this.this$1).tree.getPathBounds(new TreePath(TreePropertyListener.access$200((TreePropertyListener)this.this$1).treeModel.getPathToRoot(lastChild)));
                        if (base != null && b1 != null && b2 != null) {
                            TreePropertyListener.access$200((TreePropertyListener)this.this$1).tree.scrollRectToVisible(new Rectangle(base.x, b1.y, 1, b2.y - b1.y + b2.height));
                        }
                    }
                }
            }, 250);
        }

        public synchronized void treeCollapsed(TreeExpansionEvent ev) {
            TreePath path = ev.getPath();
            RequestProcessor.Task t = this.scheduled;
            if (t != null) {
                t.cancel();
            }
            this.scheduled = RequestProcessor.getDefault().post(new Runnable(this, path){
                private final /* synthetic */ TreePath val$path;
                private final /* synthetic */ TreePropertyListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$path = val$path;
                }

                public void run() {
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(this);
                        return;
                    }
                    if (TreePropertyListener.access$200((TreePropertyListener)this.this$1).tree.isExpanded(this.val$path)) {
                        return;
                    }
                    if (!TreePropertyListener.access$200((TreePropertyListener)this.this$1).tree.isVisible(this.val$path)) {
                        return;
                    }
                    if (TreePropertyListener.access$200((TreePropertyListener)this.this$1).treeModel == null) {
                        return;
                    }
                    TreeNode myNode = (TreeNode)this.val$path.getLastPathComponent();
                    if (TreePropertyListener.access$200((TreePropertyListener)this.this$1).treeModel.getPathToRoot(myNode)[0] != TreePropertyListener.access$200((TreePropertyListener)this.this$1).treeModel.getRoot()) {
                        return;
                    }
                    TreePropertyListener.access$200((TreePropertyListener)this.this$1).treeModel.nodeStructureChanged(myNode);
                }
            }, TIME_TO_COLLAPSE);
        }

        public void valueChanged(TreeSelectionEvent ev) {
            TreePath[] paths = TreeView.this.tree.getSelectionPaths();
            if (paths == null) {
                TreeView.this.callSelectionChanged(new Node[0]);
            } else {
                this.readAccessPaths = paths;
                Children.MUTEX.postReadRequest(this);
            }
        }

        public void run() {
            if (this.readAccessPaths == null) {
                return;
            }
            TreePath[] paths = this.readAccessPaths;
            this.readAccessPaths = null;
            ArrayList<Node> ll = new ArrayList<Node>(paths.length);
            int i = 0;
            while (i < paths.length) {
                Node n = Visualizer.findNode(paths[i].getLastPathComponent());
                if (n == TreeView.this.manager.getRootContext() || n.getParentNode() != null) {
                    ll.add(n);
                }
                ++i;
            }
            TreeView.this.callSelectionChanged(ll.toArray(new Node[ll.size()]));
        }

        static /* synthetic */ void access$100(TreePropertyListener x0, PropertyChangeEvent x1) {
            x0.react2VisualPropChange(x1);
        }

        static /* synthetic */ TreeView access$200(TreePropertyListener x0) {
            return x0.TreeView.this;
        }
    }
}

